<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewAssociationResponseBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewAssociationResponseBase
 * @subpackage Structs
 */
class TicketViewAssociationResponseBase extends ExtensibleDataContract
{
    /**
     * The ApplicationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationLevel;
    /**
     * The ApplicationObjectIdentifier
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationObjectIdentifier;
    /**
     * The AssociationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AssociationId;
    /**
     * The ComponentResponse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GetTicketViewComponentById_Response
     */
    public $ComponentResponse;
    /**
     * The CreationDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTimeUtc;
    /**
     * The Criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketViewAssociationCriteria_Response
     */
    public $Criteria;
    /**
     * The GeneratedBy
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GeneratedBy;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsHidden;
    /**
     * The LastUpdateDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdateDateTimeUtc;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The StaffTesterOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $StaffTesterOnly;
    /**
     * Constructor method for TicketViewAssociationResponseBase
     * @uses TicketViewAssociationResponseBase::setApplicationLevel()
     * @uses TicketViewAssociationResponseBase::setApplicationObjectIdentifier()
     * @uses TicketViewAssociationResponseBase::setAssociationId()
     * @uses TicketViewAssociationResponseBase::setComponentResponse()
     * @uses TicketViewAssociationResponseBase::setCreationDateTimeUtc()
     * @uses TicketViewAssociationResponseBase::setCriteria()
     * @uses TicketViewAssociationResponseBase::setGeneratedBy()
     * @uses TicketViewAssociationResponseBase::setIsActive()
     * @uses TicketViewAssociationResponseBase::setIsHidden()
     * @uses TicketViewAssociationResponseBase::setLastUpdateDateTimeUtc()
     * @uses TicketViewAssociationResponseBase::setName()
     * @uses TicketViewAssociationResponseBase::setPriority()
     * @uses TicketViewAssociationResponseBase::setStaffTesterOnly()
     * @param string $applicationLevel
     * @param string $applicationObjectIdentifier
     * @param string $associationId
     * @param \patest\StructType\GetTicketViewComponentById_Response $componentResponse
     * @param string $creationDateTimeUtc
     * @param \patest\ArrayType\ArrayOfTicketViewAssociationCriteria_Response $criteria
     * @param string $generatedBy
     * @param bool $isActive
     * @param bool $isHidden
     * @param string $lastUpdateDateTimeUtc
     * @param string $name
     * @param int $priority
     * @param bool $staffTesterOnly
     */
    public function __construct($applicationLevel = null, $applicationObjectIdentifier = null, $associationId = null, \patest\StructType\GetTicketViewComponentById_Response $componentResponse = null, $creationDateTimeUtc = null, \patest\ArrayType\ArrayOfTicketViewAssociationCriteria_Response $criteria = null, $generatedBy = null, $isActive = null, $isHidden = null, $lastUpdateDateTimeUtc = null, $name = null, $priority = null, $staffTesterOnly = null)
    {
        $this
            ->setApplicationLevel($applicationLevel)
            ->setApplicationObjectIdentifier($applicationObjectIdentifier)
            ->setAssociationId($associationId)
            ->setComponentResponse($componentResponse)
            ->setCreationDateTimeUtc($creationDateTimeUtc)
            ->setCriteria($criteria)
            ->setGeneratedBy($generatedBy)
            ->setIsActive($isActive)
            ->setIsHidden($isHidden)
            ->setLastUpdateDateTimeUtc($lastUpdateDateTimeUtc)
            ->setName($name)
            ->setPriority($priority)
            ->setStaffTesterOnly($staffTesterOnly);
    }
    /**
     * Get ApplicationLevel value
     * @return string|null
     */
    public function getApplicationLevel()
    {
        return $this->ApplicationLevel;
    }
    /**
     * Set ApplicationLevel value
     * @uses \patest\EnumType\TicketConfigurationApplicationLevel::valueIsValid()
     * @uses \patest\EnumType\TicketConfigurationApplicationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicationLevel
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setApplicationLevel($applicationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketConfigurationApplicationLevel::valueIsValid($applicationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketConfigurationApplicationLevel', is_array($applicationLevel) ? implode(', ', $applicationLevel) : var_export($applicationLevel, true), implode(', ', \patest\EnumType\TicketConfigurationApplicationLevel::getValidValues())), __LINE__);
        }
        $this->ApplicationLevel = $applicationLevel;
        return $this;
    }
    /**
     * Get ApplicationObjectIdentifier value
     * @return string|null
     */
    public function getApplicationObjectIdentifier()
    {
        return $this->ApplicationObjectIdentifier;
    }
    /**
     * Set ApplicationObjectIdentifier value
     * @param string $applicationObjectIdentifier
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setApplicationObjectIdentifier($applicationObjectIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($applicationObjectIdentifier) && !is_string($applicationObjectIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationObjectIdentifier, true), gettype($applicationObjectIdentifier)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationObjectIdentifier) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationObjectIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationObjectIdentifier, true)), __LINE__);
        }
        $this->ApplicationObjectIdentifier = $applicationObjectIdentifier;
        return $this;
    }
    /**
     * Get AssociationId value
     * @return string|null
     */
    public function getAssociationId()
    {
        return $this->AssociationId;
    }
    /**
     * Set AssociationId value
     * @param string $associationId
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setAssociationId($associationId = null)
    {
        // validation for constraint: string
        if (!is_null($associationId) && !is_string($associationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associationId, true), gettype($associationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($associationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $associationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($associationId, true)), __LINE__);
        }
        $this->AssociationId = $associationId;
        return $this;
    }
    /**
     * Get ComponentResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GetTicketViewComponentById_Response|null
     */
    public function getComponentResponse()
    {
        return isset($this->ComponentResponse) ? $this->ComponentResponse : null;
    }
    /**
     * Set ComponentResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GetTicketViewComponentById_Response $componentResponse
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setComponentResponse(\patest\StructType\GetTicketViewComponentById_Response $componentResponse = null)
    {
        if (is_null($componentResponse) || (is_array($componentResponse) && empty($componentResponse))) {
            unset($this->ComponentResponse);
        } else {
            $this->ComponentResponse = $componentResponse;
        }
        return $this;
    }
    /**
     * Get CreationDateTimeUtc value
     * @return string|null
     */
    public function getCreationDateTimeUtc()
    {
        return $this->CreationDateTimeUtc;
    }
    /**
     * Set CreationDateTimeUtc value
     * @param string $creationDateTimeUtc
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setCreationDateTimeUtc($creationDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTimeUtc) && !is_string($creationDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTimeUtc, true), gettype($creationDateTimeUtc)), __LINE__);
        }
        $this->CreationDateTimeUtc = $creationDateTimeUtc;
        return $this;
    }
    /**
     * Get Criteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketViewAssociationCriteria_Response|null
     */
    public function getCriteria()
    {
        return isset($this->Criteria) ? $this->Criteria : null;
    }
    /**
     * Set Criteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketViewAssociationCriteria_Response $criteria
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setCriteria(\patest\ArrayType\ArrayOfTicketViewAssociationCriteria_Response $criteria = null)
    {
        if (is_null($criteria) || (is_array($criteria) && empty($criteria))) {
            unset($this->Criteria);
        } else {
            $this->Criteria = $criteria;
        }
        return $this;
    }
    /**
     * Get GeneratedBy value
     * @return string|null
     */
    public function getGeneratedBy()
    {
        return $this->GeneratedBy;
    }
    /**
     * Set GeneratedBy value
     * @param string $generatedBy
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setGeneratedBy($generatedBy = null)
    {
        // validation for constraint: string
        if (!is_null($generatedBy) && !is_string($generatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedBy, true), gettype($generatedBy)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($generatedBy) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $generatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($generatedBy, true)), __LINE__);
        }
        $this->GeneratedBy = $generatedBy;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsHidden value
     * @return bool|null
     */
    public function getIsHidden()
    {
        return $this->IsHidden;
    }
    /**
     * Set IsHidden value
     * @param bool $isHidden
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        $this->IsHidden = $isHidden;
        return $this;
    }
    /**
     * Get LastUpdateDateTimeUtc value
     * @return string|null
     */
    public function getLastUpdateDateTimeUtc()
    {
        return $this->LastUpdateDateTimeUtc;
    }
    /**
     * Set LastUpdateDateTimeUtc value
     * @param string $lastUpdateDateTimeUtc
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setLastUpdateDateTimeUtc($lastUpdateDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTimeUtc) && !is_string($lastUpdateDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTimeUtc, true), gettype($lastUpdateDateTimeUtc)), __LINE__);
        }
        $this->LastUpdateDateTimeUtc = $lastUpdateDateTimeUtc;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get StaffTesterOnly value
     * @return bool|null
     */
    public function getStaffTesterOnly()
    {
        return $this->StaffTesterOnly;
    }
    /**
     * Set StaffTesterOnly value
     * @param bool $staffTesterOnly
     * @return \patest\StructType\TicketViewAssociationResponseBase
     */
    public function setStaffTesterOnly($staffTesterOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($staffTesterOnly) && !is_bool($staffTesterOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($staffTesterOnly, true), gettype($staffTesterOnly)), __LINE__);
        }
        $this->StaffTesterOnly = $staffTesterOnly;
        return $this;
    }
}
