<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketPrintStatus StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketPrintStatus
 * @subpackage Structs
 */
class TicketPrintStatus extends AbstractStructBase
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IsPrintable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrintable;
    /**
     * The NotPrintableReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotPrintableReasonCode;
    /**
     * The NotPrintableReasonDescr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotPrintableReasonDescr;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PrintCount;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for TicketPrintStatus
     * @uses TicketPrintStatus::setEventId()
     * @uses TicketPrintStatus::setIsPrintable()
     * @uses TicketPrintStatus::setNotPrintableReasonCode()
     * @uses TicketPrintStatus::setNotPrintableReasonDescr()
     * @uses TicketPrintStatus::setPriceTypeId()
     * @uses TicketPrintStatus::setPrintCount()
     * @uses TicketPrintStatus::setTicketId()
     * @param string $eventId
     * @param bool $isPrintable
     * @param string $notPrintableReasonCode
     * @param string $notPrintableReasonDescr
     * @param string $priceTypeId
     * @param int $printCount
     * @param string $ticketId
     */
    public function __construct($eventId = null, $isPrintable = null, $notPrintableReasonCode = null, $notPrintableReasonDescr = null, $priceTypeId = null, $printCount = null, $ticketId = null)
    {
        $this
            ->setEventId($eventId)
            ->setIsPrintable($isPrintable)
            ->setNotPrintableReasonCode($notPrintableReasonCode)
            ->setNotPrintableReasonDescr($notPrintableReasonDescr)
            ->setPriceTypeId($priceTypeId)
            ->setPrintCount($printCount)
            ->setTicketId($ticketId);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\TicketPrintStatus
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get IsPrintable value
     * @return bool|null
     */
    public function getIsPrintable()
    {
        return $this->IsPrintable;
    }
    /**
     * Set IsPrintable value
     * @param bool $isPrintable
     * @return \patest\StructType\TicketPrintStatus
     */
    public function setIsPrintable($isPrintable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrintable) && !is_bool($isPrintable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrintable, true), gettype($isPrintable)), __LINE__);
        }
        $this->IsPrintable = $isPrintable;
        return $this;
    }
    /**
     * Get NotPrintableReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotPrintableReasonCode()
    {
        return isset($this->NotPrintableReasonCode) ? $this->NotPrintableReasonCode : null;
    }
    /**
     * Set NotPrintableReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notPrintableReasonCode
     * @return \patest\StructType\TicketPrintStatus
     */
    public function setNotPrintableReasonCode($notPrintableReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($notPrintableReasonCode) && !is_string($notPrintableReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notPrintableReasonCode, true), gettype($notPrintableReasonCode)), __LINE__);
        }
        if (is_null($notPrintableReasonCode) || (is_array($notPrintableReasonCode) && empty($notPrintableReasonCode))) {
            unset($this->NotPrintableReasonCode);
        } else {
            $this->NotPrintableReasonCode = $notPrintableReasonCode;
        }
        return $this;
    }
    /**
     * Get NotPrintableReasonDescr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotPrintableReasonDescr()
    {
        return isset($this->NotPrintableReasonDescr) ? $this->NotPrintableReasonDescr : null;
    }
    /**
     * Set NotPrintableReasonDescr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notPrintableReasonDescr
     * @return \patest\StructType\TicketPrintStatus
     */
    public function setNotPrintableReasonDescr($notPrintableReasonDescr = null)
    {
        // validation for constraint: string
        if (!is_null($notPrintableReasonDescr) && !is_string($notPrintableReasonDescr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notPrintableReasonDescr, true), gettype($notPrintableReasonDescr)), __LINE__);
        }
        if (is_null($notPrintableReasonDescr) || (is_array($notPrintableReasonDescr) && empty($notPrintableReasonDescr))) {
            unset($this->NotPrintableReasonDescr);
        } else {
            $this->NotPrintableReasonDescr = $notPrintableReasonDescr;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return $this->PriceTypeId;
    }
    /**
     * Set PriceTypeId value
     * @param string $priceTypeId
     * @return \patest\StructType\TicketPrintStatus
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        $this->PriceTypeId = $priceTypeId;
        return $this;
    }
    /**
     * Get PrintCount value
     * @return int|null
     */
    public function getPrintCount()
    {
        return $this->PrintCount;
    }
    /**
     * Set PrintCount value
     * @param int $printCount
     * @return \patest\StructType\TicketPrintStatus
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        $this->PrintCount = $printCount;
        return $this;
    }
    /**
     * Get TicketId value
     * @return string|null
     */
    public function getTicketId()
    {
        return $this->TicketId;
    }
    /**
     * Set TicketId value
     * @param string $ticketId
     * @return \patest\StructType\TicketPrintStatus
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        $this->TicketId = $ticketId;
        return $this;
    }
}
