<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SysInfo.RuleEngine._ActionTypeInfo StructType
 * @subpackage Structs
 */
class SysInfo_RuleEngine__ActionTypeInfo extends AnyEntity
{
    /**
     * The AuxData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuxData;
    /**
     * The ContractClrTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractClrTypeName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The LegacyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LegacyId;
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceName;
    /**
     * Constructor method for SysInfo.RuleEngine._ActionTypeInfo
     * @uses SysInfo_RuleEngine__ActionTypeInfo::setAuxData()
     * @uses SysInfo_RuleEngine__ActionTypeInfo::setContractClrTypeName()
     * @uses SysInfo_RuleEngine__ActionTypeInfo::setDescription()
     * @uses SysInfo_RuleEngine__ActionTypeInfo::setDisplayName()
     * @uses SysInfo_RuleEngine__ActionTypeInfo::setId()
     * @uses SysInfo_RuleEngine__ActionTypeInfo::setLegacyId()
     * @uses SysInfo_RuleEngine__ActionTypeInfo::setServiceName()
     * @param string $auxData
     * @param string $contractClrTypeName
     * @param string $description
     * @param string $displayName
     * @param string $id
     * @param string $legacyId
     * @param string $serviceName
     */
    public function __construct($auxData = null, $contractClrTypeName = null, $description = null, $displayName = null, $id = null, $legacyId = null, $serviceName = null)
    {
        $this
            ->setAuxData($auxData)
            ->setContractClrTypeName($contractClrTypeName)
            ->setDescription($description)
            ->setDisplayName($displayName)
            ->setId($id)
            ->setLegacyId($legacyId)
            ->setServiceName($serviceName);
    }
    /**
     * Get AuxData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuxData()
    {
        return isset($this->AuxData) ? $this->AuxData : null;
    }
    /**
     * Set AuxData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auxData
     * @return \patest\StructType\SysInfo_RuleEngine__ActionTypeInfo
     */
    public function setAuxData($auxData = null)
    {
        // validation for constraint: string
        if (!is_null($auxData) && !is_string($auxData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auxData, true), gettype($auxData)), __LINE__);
        }
        if (is_null($auxData) || (is_array($auxData) && empty($auxData))) {
            unset($this->AuxData);
        } else {
            $this->AuxData = $auxData;
        }
        return $this;
    }
    /**
     * Get ContractClrTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractClrTypeName()
    {
        return isset($this->ContractClrTypeName) ? $this->ContractClrTypeName : null;
    }
    /**
     * Set ContractClrTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractClrTypeName
     * @return \patest\StructType\SysInfo_RuleEngine__ActionTypeInfo
     */
    public function setContractClrTypeName($contractClrTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($contractClrTypeName) && !is_string($contractClrTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractClrTypeName, true), gettype($contractClrTypeName)), __LINE__);
        }
        if (is_null($contractClrTypeName) || (is_array($contractClrTypeName) && empty($contractClrTypeName))) {
            unset($this->ContractClrTypeName);
        } else {
            $this->ContractClrTypeName = $contractClrTypeName;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\SysInfo_RuleEngine__ActionTypeInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\SysInfo_RuleEngine__ActionTypeInfo
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\SysInfo_RuleEngine__ActionTypeInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get LegacyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegacyId()
    {
        return isset($this->LegacyId) ? $this->LegacyId : null;
    }
    /**
     * Set LegacyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $legacyId
     * @return \patest\StructType\SysInfo_RuleEngine__ActionTypeInfo
     */
    public function setLegacyId($legacyId = null)
    {
        // validation for constraint: string
        if (!is_null($legacyId) && !is_string($legacyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legacyId, true), gettype($legacyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($legacyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $legacyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($legacyId, true)), __LINE__);
        }
        if (is_null($legacyId) || (is_array($legacyId) && empty($legacyId))) {
            unset($this->LegacyId);
        } else {
            $this->LegacyId = $legacyId;
        }
        return $this;
    }
    /**
     * Get ServiceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceName()
    {
        return isset($this->ServiceName) ? $this->ServiceName : null;
    }
    /**
     * Set ServiceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceName
     * @return \patest\StructType\SysInfo_RuleEngine__ActionTypeInfo
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->ServiceName);
        } else {
            $this->ServiceName = $serviceName;
        }
        return $this;
    }
}
