<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SysInfo.CacheItemInfo StructType
 * @subpackage Structs
 */
class SysInfo_CacheItemInfo extends SysInfoObject
{
    /**
     * The CachePath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CachePath;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The ItemKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemKey;
    /**
     * The SizeBytes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SizeBytes;
    /**
     * Constructor method for SysInfo.CacheItemInfo
     * @uses SysInfo_CacheItemInfo::setCachePath()
     * @uses SysInfo_CacheItemInfo::setDescription()
     * @uses SysInfo_CacheItemInfo::setId()
     * @uses SysInfo_CacheItemInfo::setItemKey()
     * @uses SysInfo_CacheItemInfo::setSizeBytes()
     * @param string $cachePath
     * @param string $description
     * @param string $id
     * @param string $itemKey
     * @param int $sizeBytes
     */
    public function __construct($cachePath = null, $description = null, $id = null, $itemKey = null, $sizeBytes = null)
    {
        $this
            ->setCachePath($cachePath)
            ->setDescription($description)
            ->setId($id)
            ->setItemKey($itemKey)
            ->setSizeBytes($sizeBytes);
    }
    /**
     * Get CachePath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCachePath()
    {
        return isset($this->CachePath) ? $this->CachePath : null;
    }
    /**
     * Set CachePath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cachePath
     * @return \patest\StructType\SysInfo_CacheItemInfo
     */
    public function setCachePath($cachePath = null)
    {
        // validation for constraint: string
        if (!is_null($cachePath) && !is_string($cachePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cachePath, true), gettype($cachePath)), __LINE__);
        }
        if (is_null($cachePath) || (is_array($cachePath) && empty($cachePath))) {
            unset($this->CachePath);
        } else {
            $this->CachePath = $cachePath;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\SysInfo_CacheItemInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\SysInfo_CacheItemInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get ItemKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemKey()
    {
        return isset($this->ItemKey) ? $this->ItemKey : null;
    }
    /**
     * Set ItemKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemKey
     * @return \patest\StructType\SysInfo_CacheItemInfo
     */
    public function setItemKey($itemKey = null)
    {
        // validation for constraint: string
        if (!is_null($itemKey) && !is_string($itemKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemKey, true), gettype($itemKey)), __LINE__);
        }
        if (is_null($itemKey) || (is_array($itemKey) && empty($itemKey))) {
            unset($this->ItemKey);
        } else {
            $this->ItemKey = $itemKey;
        }
        return $this;
    }
    /**
     * Get SizeBytes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSizeBytes()
    {
        return isset($this->SizeBytes) ? $this->SizeBytes : null;
    }
    /**
     * Set SizeBytes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sizeBytes
     * @return \patest\StructType\SysInfo_CacheItemInfo
     */
    public function setSizeBytes($sizeBytes = null)
    {
        // validation for constraint: int
        if (!is_null($sizeBytes) && !(is_int($sizeBytes) || ctype_digit($sizeBytes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeBytes, true), gettype($sizeBytes)), __LINE__);
        }
        if (is_null($sizeBytes) || (is_array($sizeBytes) && empty($sizeBytes))) {
            unset($this->SizeBytes);
        } else {
            $this->SizeBytes = $sizeBytes;
        }
        return $this;
    }
}
