<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscription.TicketSchemeSelectionInfo StructType
 * @subpackage Structs
 */
class Subscription_TicketSchemeSelectionInfo extends AnyEntity
{
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The CategoryDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CategoryDescription;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CategoryName;
    /**
     * The CategoryOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CategoryOrdinal;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IsSelected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelected;
    /**
     * The ItemIdInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemIdInTransaction;
    /**
     * The ItemsIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemsIds;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NumberOfMatchingSubscriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfMatchingSubscriptions;
    /**
     * The OwnerClientCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerClientCrmId;
    /**
     * The OwnerClientDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerClientDisplayName;
    /**
     * The OwnerClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerClientId;
    /**
     * The RequiresPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RequiresPayment;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesInfo;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesName;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * Constructor method for Subscription.TicketSchemeSelectionInfo
     * @uses Subscription_TicketSchemeSelectionInfo::setAreaName()
     * @uses Subscription_TicketSchemeSelectionInfo::setCategoryDescription()
     * @uses Subscription_TicketSchemeSelectionInfo::setCategoryId()
     * @uses Subscription_TicketSchemeSelectionInfo::setCategoryName()
     * @uses Subscription_TicketSchemeSelectionInfo::setCategoryOrdinal()
     * @uses Subscription_TicketSchemeSelectionInfo::setDescription()
     * @uses Subscription_TicketSchemeSelectionInfo::setIsSelected()
     * @uses Subscription_TicketSchemeSelectionInfo::setItemIdInTransaction()
     * @uses Subscription_TicketSchemeSelectionInfo::setItemsIds()
     * @uses Subscription_TicketSchemeSelectionInfo::setName()
     * @uses Subscription_TicketSchemeSelectionInfo::setNumberOfMatchingSubscriptions()
     * @uses Subscription_TicketSchemeSelectionInfo::setOwnerClientCrmId()
     * @uses Subscription_TicketSchemeSelectionInfo::setOwnerClientDisplayName()
     * @uses Subscription_TicketSchemeSelectionInfo::setOwnerClientId()
     * @uses Subscription_TicketSchemeSelectionInfo::setRequiresPayment()
     * @uses Subscription_TicketSchemeSelectionInfo::setRowName()
     * @uses Subscription_TicketSchemeSelectionInfo::setSeatName()
     * @uses Subscription_TicketSchemeSelectionInfo::setSeriesId()
     * @uses Subscription_TicketSchemeSelectionInfo::setSeriesInfo()
     * @uses Subscription_TicketSchemeSelectionInfo::setSeriesName()
     * @uses Subscription_TicketSchemeSelectionInfo::setTicketSchemeId()
     * @param string $areaName
     * @param string $categoryDescription
     * @param string $categoryId
     * @param string $categoryName
     * @param int $categoryOrdinal
     * @param string $description
     * @param bool $isSelected
     * @param int $itemIdInTransaction
     * @param string $itemsIds
     * @param string $name
     * @param int $numberOfMatchingSubscriptions
     * @param string $ownerClientCrmId
     * @param string $ownerClientDisplayName
     * @param string $ownerClientId
     * @param bool $requiresPayment
     * @param string $rowName
     * @param string $seatName
     * @param string $seriesId
     * @param string $seriesInfo
     * @param string $seriesName
     * @param string $ticketSchemeId
     */
    public function __construct($areaName = null, $categoryDescription = null, $categoryId = null, $categoryName = null, $categoryOrdinal = null, $description = null, $isSelected = null, $itemIdInTransaction = null, $itemsIds = null, $name = null, $numberOfMatchingSubscriptions = null, $ownerClientCrmId = null, $ownerClientDisplayName = null, $ownerClientId = null, $requiresPayment = null, $rowName = null, $seatName = null, $seriesId = null, $seriesInfo = null, $seriesName = null, $ticketSchemeId = null)
    {
        $this
            ->setAreaName($areaName)
            ->setCategoryDescription($categoryDescription)
            ->setCategoryId($categoryId)
            ->setCategoryName($categoryName)
            ->setCategoryOrdinal($categoryOrdinal)
            ->setDescription($description)
            ->setIsSelected($isSelected)
            ->setItemIdInTransaction($itemIdInTransaction)
            ->setItemsIds($itemsIds)
            ->setName($name)
            ->setNumberOfMatchingSubscriptions($numberOfMatchingSubscriptions)
            ->setOwnerClientCrmId($ownerClientCrmId)
            ->setOwnerClientDisplayName($ownerClientDisplayName)
            ->setOwnerClientId($ownerClientId)
            ->setRequiresPayment($requiresPayment)
            ->setRowName($rowName)
            ->setSeatName($seatName)
            ->setSeriesId($seriesId)
            ->setSeriesInfo($seriesInfo)
            ->setSeriesName($seriesName)
            ->setTicketSchemeId($ticketSchemeId);
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get CategoryDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryDescription()
    {
        return isset($this->CategoryDescription) ? $this->CategoryDescription : null;
    }
    /**
     * Set CategoryDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryDescription
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setCategoryDescription($categoryDescription = null)
    {
        // validation for constraint: string
        if (!is_null($categoryDescription) && !is_string($categoryDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryDescription, true), gettype($categoryDescription)), __LINE__);
        }
        if (is_null($categoryDescription) || (is_array($categoryDescription) && empty($categoryDescription))) {
            unset($this->CategoryDescription);
        } else {
            $this->CategoryDescription = $categoryDescription;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryName()
    {
        return isset($this->CategoryName) ? $this->CategoryName : null;
    }
    /**
     * Set CategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryName
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryName, true), gettype($categoryName)), __LINE__);
        }
        if (is_null($categoryName) || (is_array($categoryName) && empty($categoryName))) {
            unset($this->CategoryName);
        } else {
            $this->CategoryName = $categoryName;
        }
        return $this;
    }
    /**
     * Get CategoryOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCategoryOrdinal()
    {
        return isset($this->CategoryOrdinal) ? $this->CategoryOrdinal : null;
    }
    /**
     * Set CategoryOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $categoryOrdinal
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setCategoryOrdinal($categoryOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($categoryOrdinal) && !(is_int($categoryOrdinal) || ctype_digit($categoryOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryOrdinal, true), gettype($categoryOrdinal)), __LINE__);
        }
        if (is_null($categoryOrdinal) || (is_array($categoryOrdinal) && empty($categoryOrdinal))) {
            unset($this->CategoryOrdinal);
        } else {
            $this->CategoryOrdinal = $categoryOrdinal;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelected()
    {
        return isset($this->IsSelected) ? $this->IsSelected : null;
    }
    /**
     * Set IsSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelected
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelected, true), gettype($isSelected)), __LINE__);
        }
        if (is_null($isSelected) || (is_array($isSelected) && empty($isSelected))) {
            unset($this->IsSelected);
        } else {
            $this->IsSelected = $isSelected;
        }
        return $this;
    }
    /**
     * Get ItemIdInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemIdInTransaction()
    {
        return isset($this->ItemIdInTransaction) ? $this->ItemIdInTransaction : null;
    }
    /**
     * Set ItemIdInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemIdInTransaction
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setItemIdInTransaction($itemIdInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($itemIdInTransaction) && !(is_int($itemIdInTransaction) || ctype_digit($itemIdInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemIdInTransaction, true), gettype($itemIdInTransaction)), __LINE__);
        }
        if (is_null($itemIdInTransaction) || (is_array($itemIdInTransaction) && empty($itemIdInTransaction))) {
            unset($this->ItemIdInTransaction);
        } else {
            $this->ItemIdInTransaction = $itemIdInTransaction;
        }
        return $this;
    }
    /**
     * Get ItemsIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemsIds()
    {
        return isset($this->ItemsIds) ? $this->ItemsIds : null;
    }
    /**
     * Set ItemsIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemsIds
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setItemsIds($itemsIds = null)
    {
        // validation for constraint: string
        if (!is_null($itemsIds) && !is_string($itemsIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemsIds, true), gettype($itemsIds)), __LINE__);
        }
        if (is_null($itemsIds) || (is_array($itemsIds) && empty($itemsIds))) {
            unset($this->ItemsIds);
        } else {
            $this->ItemsIds = $itemsIds;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumberOfMatchingSubscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfMatchingSubscriptions()
    {
        return isset($this->NumberOfMatchingSubscriptions) ? $this->NumberOfMatchingSubscriptions : null;
    }
    /**
     * Set NumberOfMatchingSubscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfMatchingSubscriptions
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setNumberOfMatchingSubscriptions($numberOfMatchingSubscriptions = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfMatchingSubscriptions) && !(is_int($numberOfMatchingSubscriptions) || ctype_digit($numberOfMatchingSubscriptions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfMatchingSubscriptions, true), gettype($numberOfMatchingSubscriptions)), __LINE__);
        }
        if (is_null($numberOfMatchingSubscriptions) || (is_array($numberOfMatchingSubscriptions) && empty($numberOfMatchingSubscriptions))) {
            unset($this->NumberOfMatchingSubscriptions);
        } else {
            $this->NumberOfMatchingSubscriptions = $numberOfMatchingSubscriptions;
        }
        return $this;
    }
    /**
     * Get OwnerClientCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerClientCrmId()
    {
        return isset($this->OwnerClientCrmId) ? $this->OwnerClientCrmId : null;
    }
    /**
     * Set OwnerClientCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerClientCrmId
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setOwnerClientCrmId($ownerClientCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerClientCrmId) && !is_string($ownerClientCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerClientCrmId, true), gettype($ownerClientCrmId)), __LINE__);
        }
        if (is_null($ownerClientCrmId) || (is_array($ownerClientCrmId) && empty($ownerClientCrmId))) {
            unset($this->OwnerClientCrmId);
        } else {
            $this->OwnerClientCrmId = $ownerClientCrmId;
        }
        return $this;
    }
    /**
     * Get OwnerClientDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerClientDisplayName()
    {
        return isset($this->OwnerClientDisplayName) ? $this->OwnerClientDisplayName : null;
    }
    /**
     * Set OwnerClientDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerClientDisplayName
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setOwnerClientDisplayName($ownerClientDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerClientDisplayName) && !is_string($ownerClientDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerClientDisplayName, true), gettype($ownerClientDisplayName)), __LINE__);
        }
        if (is_null($ownerClientDisplayName) || (is_array($ownerClientDisplayName) && empty($ownerClientDisplayName))) {
            unset($this->OwnerClientDisplayName);
        } else {
            $this->OwnerClientDisplayName = $ownerClientDisplayName;
        }
        return $this;
    }
    /**
     * Get OwnerClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerClientId()
    {
        return isset($this->OwnerClientId) ? $this->OwnerClientId : null;
    }
    /**
     * Set OwnerClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerClientId
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setOwnerClientId($ownerClientId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerClientId) && !is_string($ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerClientId, true), gettype($ownerClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerClientId, true)), __LINE__);
        }
        if (is_null($ownerClientId) || (is_array($ownerClientId) && empty($ownerClientId))) {
            unset($this->OwnerClientId);
        } else {
            $this->OwnerClientId = $ownerClientId;
        }
        return $this;
    }
    /**
     * Get RequiresPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRequiresPayment()
    {
        return isset($this->RequiresPayment) ? $this->RequiresPayment : null;
    }
    /**
     * Set RequiresPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $requiresPayment
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setRequiresPayment($requiresPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiresPayment) && !is_bool($requiresPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiresPayment, true), gettype($requiresPayment)), __LINE__);
        }
        if (is_null($requiresPayment) || (is_array($requiresPayment) && empty($requiresPayment))) {
            unset($this->RequiresPayment);
        } else {
            $this->RequiresPayment = $requiresPayment;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesInfo()
    {
        return isset($this->SeriesInfo) ? $this->SeriesInfo : null;
    }
    /**
     * Set SeriesInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesInfo
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setSeriesInfo($seriesInfo = null)
    {
        // validation for constraint: string
        if (!is_null($seriesInfo) && !is_string($seriesInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesInfo, true), gettype($seriesInfo)), __LINE__);
        }
        if (is_null($seriesInfo) || (is_array($seriesInfo) && empty($seriesInfo))) {
            unset($this->SeriesInfo);
        } else {
            $this->SeriesInfo = $seriesInfo;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesName
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setSeriesName($seriesName = null)
    {
        // validation for constraint: string
        if (!is_null($seriesName) && !is_string($seriesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesName, true), gettype($seriesName)), __LINE__);
        }
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return isset($this->TicketSchemeId) ? $this->TicketSchemeId : null;
    }
    /**
     * Set TicketSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeId
     * @return \patest\StructType\Subscription_TicketSchemeSelectionInfo
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        if (is_null($ticketSchemeId) || (is_array($ticketSchemeId) && empty($ticketSchemeId))) {
            unset($this->TicketSchemeId);
        } else {
            $this->TicketSchemeId = $ticketSchemeId;
        }
        return $this;
    }
}
