<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscription.EventRelatedToSubscription StructType
 * @subpackage Structs
 */
class Subscription_EventRelatedToSubscription extends AnyEntity
{
    /**
     * The AlreadyAdded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AlreadyAdded;
    /**
     * The AvailableCapacity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailableCapacity;
    /**
     * The Bucket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_BucketInSeries
     */
    public $Bucket;
    /**
     * The EnableAddEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnableAddEvent;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The LockedSeats
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LockedSeats;
    /**
     * The Recommended
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Recommended;
    /**
     * The ReservedTickets
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReservedTickets;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ShowName;
    /**
     * The SoldTickets
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SoldTickets;
    /**
     * Constructor method for Subscription.EventRelatedToSubscription
     * @uses Subscription_EventRelatedToSubscription::setAlreadyAdded()
     * @uses Subscription_EventRelatedToSubscription::setAvailableCapacity()
     * @uses Subscription_EventRelatedToSubscription::setBucket()
     * @uses Subscription_EventRelatedToSubscription::setEnableAddEvent()
     * @uses Subscription_EventRelatedToSubscription::setEventDate()
     * @uses Subscription_EventRelatedToSubscription::setEventId()
     * @uses Subscription_EventRelatedToSubscription::setHallId()
     * @uses Subscription_EventRelatedToSubscription::setHallName()
     * @uses Subscription_EventRelatedToSubscription::setLockedSeats()
     * @uses Subscription_EventRelatedToSubscription::setRecommended()
     * @uses Subscription_EventRelatedToSubscription::setReservedTickets()
     * @uses Subscription_EventRelatedToSubscription::setShowName()
     * @uses Subscription_EventRelatedToSubscription::setSoldTickets()
     * @param bool $alreadyAdded
     * @param int $availableCapacity
     * @param \patest\StructType\Ticketing_BucketInSeries $bucket
     * @param bool $enableAddEvent
     * @param string $eventDate
     * @param string $eventId
     * @param string $hallId
     * @param \patest\StructType\GlobalString $hallName
     * @param int $lockedSeats
     * @param bool $recommended
     * @param int $reservedTickets
     * @param \patest\StructType\GlobalString $showName
     * @param int $soldTickets
     */
    public function __construct($alreadyAdded = null, $availableCapacity = null, \patest\StructType\Ticketing_BucketInSeries $bucket = null, $enableAddEvent = null, $eventDate = null, $eventId = null, $hallId = null, \patest\StructType\GlobalString $hallName = null, $lockedSeats = null, $recommended = null, $reservedTickets = null, \patest\StructType\GlobalString $showName = null, $soldTickets = null)
    {
        $this
            ->setAlreadyAdded($alreadyAdded)
            ->setAvailableCapacity($availableCapacity)
            ->setBucket($bucket)
            ->setEnableAddEvent($enableAddEvent)
            ->setEventDate($eventDate)
            ->setEventId($eventId)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setLockedSeats($lockedSeats)
            ->setRecommended($recommended)
            ->setReservedTickets($reservedTickets)
            ->setShowName($showName)
            ->setSoldTickets($soldTickets);
    }
    /**
     * Get AlreadyAdded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAlreadyAdded()
    {
        return isset($this->AlreadyAdded) ? $this->AlreadyAdded : null;
    }
    /**
     * Set AlreadyAdded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $alreadyAdded
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setAlreadyAdded($alreadyAdded = null)
    {
        // validation for constraint: boolean
        if (!is_null($alreadyAdded) && !is_bool($alreadyAdded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alreadyAdded, true), gettype($alreadyAdded)), __LINE__);
        }
        if (is_null($alreadyAdded) || (is_array($alreadyAdded) && empty($alreadyAdded))) {
            unset($this->AlreadyAdded);
        } else {
            $this->AlreadyAdded = $alreadyAdded;
        }
        return $this;
    }
    /**
     * Get AvailableCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailableCapacity()
    {
        return isset($this->AvailableCapacity) ? $this->AvailableCapacity : null;
    }
    /**
     * Set AvailableCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availableCapacity
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setAvailableCapacity($availableCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($availableCapacity) && !(is_int($availableCapacity) || ctype_digit($availableCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableCapacity, true), gettype($availableCapacity)), __LINE__);
        }
        if (is_null($availableCapacity) || (is_array($availableCapacity) && empty($availableCapacity))) {
            unset($this->AvailableCapacity);
        } else {
            $this->AvailableCapacity = $availableCapacity;
        }
        return $this;
    }
    /**
     * Get Bucket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_BucketInSeries|null
     */
    public function getBucket()
    {
        return isset($this->Bucket) ? $this->Bucket : null;
    }
    /**
     * Set Bucket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_BucketInSeries $bucket
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setBucket(\patest\StructType\Ticketing_BucketInSeries $bucket = null)
    {
        if (is_null($bucket) || (is_array($bucket) && empty($bucket))) {
            unset($this->Bucket);
        } else {
            $this->Bucket = $bucket;
        }
        return $this;
    }
    /**
     * Get EnableAddEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnableAddEvent()
    {
        return isset($this->EnableAddEvent) ? $this->EnableAddEvent : null;
    }
    /**
     * Set EnableAddEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enableAddEvent
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setEnableAddEvent($enableAddEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableAddEvent) && !is_bool($enableAddEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableAddEvent, true), gettype($enableAddEvent)), __LINE__);
        }
        if (is_null($enableAddEvent) || (is_array($enableAddEvent) && empty($enableAddEvent))) {
            unset($this->EnableAddEvent);
        } else {
            $this->EnableAddEvent = $enableAddEvent;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get LockedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLockedSeats()
    {
        return isset($this->LockedSeats) ? $this->LockedSeats : null;
    }
    /**
     * Set LockedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lockedSeats
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setLockedSeats($lockedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($lockedSeats) && !(is_int($lockedSeats) || ctype_digit($lockedSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lockedSeats, true), gettype($lockedSeats)), __LINE__);
        }
        if (is_null($lockedSeats) || (is_array($lockedSeats) && empty($lockedSeats))) {
            unset($this->LockedSeats);
        } else {
            $this->LockedSeats = $lockedSeats;
        }
        return $this;
    }
    /**
     * Get Recommended value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRecommended()
    {
        return isset($this->Recommended) ? $this->Recommended : null;
    }
    /**
     * Set Recommended value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $recommended
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setRecommended($recommended = null)
    {
        // validation for constraint: boolean
        if (!is_null($recommended) && !is_bool($recommended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recommended, true), gettype($recommended)), __LINE__);
        }
        if (is_null($recommended) || (is_array($recommended) && empty($recommended))) {
            unset($this->Recommended);
        } else {
            $this->Recommended = $recommended;
        }
        return $this;
    }
    /**
     * Get ReservedTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReservedTickets()
    {
        return isset($this->ReservedTickets) ? $this->ReservedTickets : null;
    }
    /**
     * Set ReservedTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reservedTickets
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setReservedTickets($reservedTickets = null)
    {
        // validation for constraint: int
        if (!is_null($reservedTickets) && !(is_int($reservedTickets) || ctype_digit($reservedTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservedTickets, true), gettype($reservedTickets)), __LINE__);
        }
        if (is_null($reservedTickets) || (is_array($reservedTickets) && empty($reservedTickets))) {
            unset($this->ReservedTickets);
        } else {
            $this->ReservedTickets = $reservedTickets;
        }
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $showName
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setShowName(\patest\StructType\GlobalString $showName = null)
    {
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
    /**
     * Get SoldTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSoldTickets()
    {
        return isset($this->SoldTickets) ? $this->SoldTickets : null;
    }
    /**
     * Set SoldTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $soldTickets
     * @return \patest\StructType\Subscription_EventRelatedToSubscription
     */
    public function setSoldTickets($soldTickets = null)
    {
        // validation for constraint: int
        if (!is_null($soldTickets) && !(is_int($soldTickets) || ctype_digit($soldTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldTickets, true), gettype($soldTickets)), __LINE__);
        }
        if (is_null($soldTickets) || (is_array($soldTickets) && empty($soldTickets))) {
            unset($this->SoldTickets);
        } else {
            $this->SoldTickets = $soldTickets;
        }
        return $this;
    }
}
