<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscribeForTraceResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SubscribeForTraceResponse
 * @subpackage Structs
 */
class SubscribeForTraceResponse extends AbstractStructBase
{
    /**
     * The SubscriptionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionId;
    /**
     * The PubSubEventToListen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PubSubEventToListen;
    /**
     * Constructor method for SubscribeForTraceResponse
     * @uses SubscribeForTraceResponse::setSubscriptionId()
     * @uses SubscribeForTraceResponse::setPubSubEventToListen()
     * @param string $subscriptionId
     * @param string $pubSubEventToListen
     */
    public function __construct($subscriptionId = null, $pubSubEventToListen = null)
    {
        $this
            ->setSubscriptionId($subscriptionId)
            ->setPubSubEventToListen($pubSubEventToListen);
    }
    /**
     * Get SubscriptionId value
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return $this->SubscriptionId;
    }
    /**
     * Set SubscriptionId value
     * @param string $subscriptionId
     * @return \patest\StructType\SubscribeForTraceResponse
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionId, true)), __LINE__);
        }
        $this->SubscriptionId = $subscriptionId;
        return $this;
    }
    /**
     * Get PubSubEventToListen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPubSubEventToListen()
    {
        return isset($this->PubSubEventToListen) ? $this->PubSubEventToListen : null;
    }
    /**
     * Set PubSubEventToListen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pubSubEventToListen
     * @return \patest\StructType\SubscribeForTraceResponse
     */
    public function setPubSubEventToListen($pubSubEventToListen = null)
    {
        // validation for constraint: string
        if (!is_null($pubSubEventToListen) && !is_string($pubSubEventToListen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pubSubEventToListen, true), gettype($pubSubEventToListen)), __LINE__);
        }
        if (is_null($pubSubEventToListen) || (is_array($pubSubEventToListen) && empty($pubSubEventToListen))) {
            unset($this->PubSubEventToListen);
        } else {
            $this->PubSubEventToListen = $pubSubEventToListen;
        }
        return $this;
    }
}
