<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreManuallyEnteredBarcodesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StoreManuallyEnteredBarcodesRequest
 * @subpackage Structs
 */
class StoreManuallyEnteredBarcodesRequest extends ExtensibleDataContract
{
    /**
     * The Barcodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfintstring
     */
    public $Barcodes;
    /**
     * The PrintingScenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingScenario;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for StoreManuallyEnteredBarcodesRequest
     * @uses StoreManuallyEnteredBarcodesRequest::setBarcodes()
     * @uses StoreManuallyEnteredBarcodesRequest::setPrintingScenario()
     * @uses StoreManuallyEnteredBarcodesRequest::setTransactionId()
     * @param \patest\ArrayType\ArrayOfKeyValueOfintstring $barcodes
     * @param string $printingScenario
     * @param string $transactionId
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfintstring $barcodes = null, $printingScenario = null, $transactionId = null)
    {
        $this
            ->setBarcodes($barcodes)
            ->setPrintingScenario($printingScenario)
            ->setTransactionId($transactionId);
    }
    /**
     * Get Barcodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfintstring|null
     */
    public function getBarcodes()
    {
        return isset($this->Barcodes) ? $this->Barcodes : null;
    }
    /**
     * Set Barcodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfintstring $barcodes
     * @return \patest\StructType\StoreManuallyEnteredBarcodesRequest
     */
    public function setBarcodes(\patest\ArrayType\ArrayOfKeyValueOfintstring $barcodes = null)
    {
        if (is_null($barcodes) || (is_array($barcodes) && empty($barcodes))) {
            unset($this->Barcodes);
        } else {
            $this->Barcodes = $barcodes;
        }
        return $this;
    }
    /**
     * Get PrintingScenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingScenario()
    {
        return isset($this->PrintingScenario) ? $this->PrintingScenario : null;
    }
    /**
     * Set PrintingScenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printingScenario
     * @return \patest\StructType\StoreManuallyEnteredBarcodesRequest
     */
    public function setPrintingScenario($printingScenario = null)
    {
        // validation for constraint: string
        if (!is_null($printingScenario) && !is_string($printingScenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printingScenario, true), gettype($printingScenario)), __LINE__);
        }
        if (is_null($printingScenario) || (is_array($printingScenario) && empty($printingScenario))) {
            unset($this->PrintingScenario);
        } else {
            $this->PrintingScenario = $printingScenario;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \patest\StructType\StoreManuallyEnteredBarcodesRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
}
