<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreHallVersionDesign-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StoreHallVersionDesign-Request
 * @subpackage Structs
 */
class StoreHallVersionDesign_Request extends ExtensibleDataContract
{
    /**
     * The DeletedAreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $DeletedAreaIds;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The ModifiedAreaMaps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAreaMapDesign
     */
    public $ModifiedAreaMaps;
    /**
     * The ModifiedVersionAreaConnectors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfVersionAreaDesign
     */
    public $ModifiedVersionAreaConnectors;
    /**
     * The ModifiedVersionDesign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\VersionDesign
     */
    public $ModifiedVersionDesign;
    /**
     * The NewOldIdsMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidguid
     */
    public $NewOldIdsMapping;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The ApplyToAllRelatedHallVersions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ApplyToAllRelatedHallVersions;
    /**
     * Constructor method for StoreHallVersionDesign-Request
     * @uses StoreHallVersionDesign_Request::setDeletedAreaIds()
     * @uses StoreHallVersionDesign_Request::setHallVersionId()
     * @uses StoreHallVersionDesign_Request::setModifiedAreaMaps()
     * @uses StoreHallVersionDesign_Request::setModifiedVersionAreaConnectors()
     * @uses StoreHallVersionDesign_Request::setModifiedVersionDesign()
     * @uses StoreHallVersionDesign_Request::setNewOldIdsMapping()
     * @uses StoreHallVersionDesign_Request::setSeatingPlanId()
     * @uses StoreHallVersionDesign_Request::setApplyToAllRelatedHallVersions()
     * @param \patest\ArrayType\ArrayOfguid $deletedAreaIds
     * @param string $hallVersionId
     * @param \patest\ArrayType\ArrayOfAreaMapDesign $modifiedAreaMaps
     * @param \patest\ArrayType\ArrayOfVersionAreaDesign $modifiedVersionAreaConnectors
     * @param \patest\StructType\VersionDesign $modifiedVersionDesign
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidguid $newOldIdsMapping
     * @param string $seatingPlanId
     * @param bool $applyToAllRelatedHallVersions
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $deletedAreaIds = null, $hallVersionId = null, \patest\ArrayType\ArrayOfAreaMapDesign $modifiedAreaMaps = null, \patest\ArrayType\ArrayOfVersionAreaDesign $modifiedVersionAreaConnectors = null, \patest\StructType\VersionDesign $modifiedVersionDesign = null, \patest\ArrayType\ArrayOfKeyValueOfguidguid $newOldIdsMapping = null, $seatingPlanId = null, $applyToAllRelatedHallVersions = null)
    {
        $this
            ->setDeletedAreaIds($deletedAreaIds)
            ->setHallVersionId($hallVersionId)
            ->setModifiedAreaMaps($modifiedAreaMaps)
            ->setModifiedVersionAreaConnectors($modifiedVersionAreaConnectors)
            ->setModifiedVersionDesign($modifiedVersionDesign)
            ->setNewOldIdsMapping($newOldIdsMapping)
            ->setSeatingPlanId($seatingPlanId)
            ->setApplyToAllRelatedHallVersions($applyToAllRelatedHallVersions);
    }
    /**
     * Get DeletedAreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getDeletedAreaIds()
    {
        return isset($this->DeletedAreaIds) ? $this->DeletedAreaIds : null;
    }
    /**
     * Set DeletedAreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $deletedAreaIds
     * @return \patest\StructType\StoreHallVersionDesign_Request
     */
    public function setDeletedAreaIds(\patest\ArrayType\ArrayOfguid $deletedAreaIds = null)
    {
        if (is_null($deletedAreaIds) || (is_array($deletedAreaIds) && empty($deletedAreaIds))) {
            unset($this->DeletedAreaIds);
        } else {
            $this->DeletedAreaIds = $deletedAreaIds;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * @return string|null
     */
    public function getHallVersionId()
    {
        return $this->HallVersionId;
    }
    /**
     * Set HallVersionId value
     * @param string $hallVersionId
     * @return \patest\StructType\StoreHallVersionDesign_Request
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        $this->HallVersionId = $hallVersionId;
        return $this;
    }
    /**
     * Get ModifiedAreaMaps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAreaMapDesign|null
     */
    public function getModifiedAreaMaps()
    {
        return isset($this->ModifiedAreaMaps) ? $this->ModifiedAreaMaps : null;
    }
    /**
     * Set ModifiedAreaMaps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAreaMapDesign $modifiedAreaMaps
     * @return \patest\StructType\StoreHallVersionDesign_Request
     */
    public function setModifiedAreaMaps(\patest\ArrayType\ArrayOfAreaMapDesign $modifiedAreaMaps = null)
    {
        if (is_null($modifiedAreaMaps) || (is_array($modifiedAreaMaps) && empty($modifiedAreaMaps))) {
            unset($this->ModifiedAreaMaps);
        } else {
            $this->ModifiedAreaMaps = $modifiedAreaMaps;
        }
        return $this;
    }
    /**
     * Get ModifiedVersionAreaConnectors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfVersionAreaDesign|null
     */
    public function getModifiedVersionAreaConnectors()
    {
        return isset($this->ModifiedVersionAreaConnectors) ? $this->ModifiedVersionAreaConnectors : null;
    }
    /**
     * Set ModifiedVersionAreaConnectors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfVersionAreaDesign $modifiedVersionAreaConnectors
     * @return \patest\StructType\StoreHallVersionDesign_Request
     */
    public function setModifiedVersionAreaConnectors(\patest\ArrayType\ArrayOfVersionAreaDesign $modifiedVersionAreaConnectors = null)
    {
        if (is_null($modifiedVersionAreaConnectors) || (is_array($modifiedVersionAreaConnectors) && empty($modifiedVersionAreaConnectors))) {
            unset($this->ModifiedVersionAreaConnectors);
        } else {
            $this->ModifiedVersionAreaConnectors = $modifiedVersionAreaConnectors;
        }
        return $this;
    }
    /**
     * Get ModifiedVersionDesign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\VersionDesign|null
     */
    public function getModifiedVersionDesign()
    {
        return isset($this->ModifiedVersionDesign) ? $this->ModifiedVersionDesign : null;
    }
    /**
     * Set ModifiedVersionDesign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\VersionDesign $modifiedVersionDesign
     * @return \patest\StructType\StoreHallVersionDesign_Request
     */
    public function setModifiedVersionDesign(\patest\StructType\VersionDesign $modifiedVersionDesign = null)
    {
        if (is_null($modifiedVersionDesign) || (is_array($modifiedVersionDesign) && empty($modifiedVersionDesign))) {
            unset($this->ModifiedVersionDesign);
        } else {
            $this->ModifiedVersionDesign = $modifiedVersionDesign;
        }
        return $this;
    }
    /**
     * Get NewOldIdsMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidguid|null
     */
    public function getNewOldIdsMapping()
    {
        return isset($this->NewOldIdsMapping) ? $this->NewOldIdsMapping : null;
    }
    /**
     * Set NewOldIdsMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidguid $newOldIdsMapping
     * @return \patest\StructType\StoreHallVersionDesign_Request
     */
    public function setNewOldIdsMapping(\patest\ArrayType\ArrayOfKeyValueOfguidguid $newOldIdsMapping = null)
    {
        if (is_null($newOldIdsMapping) || (is_array($newOldIdsMapping) && empty($newOldIdsMapping))) {
            unset($this->NewOldIdsMapping);
        } else {
            $this->NewOldIdsMapping = $newOldIdsMapping;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return isset($this->SeatingPlanId) ? $this->SeatingPlanId : null;
    }
    /**
     * Set SeatingPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanId
     * @return \patest\StructType\StoreHallVersionDesign_Request
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        if (is_null($seatingPlanId) || (is_array($seatingPlanId) && empty($seatingPlanId))) {
            unset($this->SeatingPlanId);
        } else {
            $this->SeatingPlanId = $seatingPlanId;
        }
        return $this;
    }
    /**
     * Get ApplyToAllRelatedHallVersions value
     * @return bool|null
     */
    public function getApplyToAllRelatedHallVersions()
    {
        return $this->ApplyToAllRelatedHallVersions;
    }
    /**
     * Set ApplyToAllRelatedHallVersions value
     * @param bool $applyToAllRelatedHallVersions
     * @return \patest\StructType\StoreHallVersionDesign_Request
     */
    public function setApplyToAllRelatedHallVersions($applyToAllRelatedHallVersions = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyToAllRelatedHallVersions) && !is_bool($applyToAllRelatedHallVersions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyToAllRelatedHallVersions, true), gettype($applyToAllRelatedHallVersions)), __LINE__);
        }
        $this->ApplyToAllRelatedHallVersions = $applyToAllRelatedHallVersions;
        return $this;
    }
}
