<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartStopPrinter-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StartStopPrinter-Request
 * @subpackage Structs
 */
class StartStopPrinter_Request extends ExtensibleDataContract
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The Explanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Explanation;
    /**
     * The PrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrinterId;
    /**
     * Constructor method for StartStopPrinter-Request
     * @uses StartStopPrinter_Request::setAction()
     * @uses StartStopPrinter_Request::setExplanation()
     * @uses StartStopPrinter_Request::setPrinterId()
     * @param string $action
     * @param string $explanation
     * @param string $printerId
     */
    public function __construct($action = null, $explanation = null, $printerId = null)
    {
        $this
            ->setAction($action)
            ->setExplanation($explanation)
            ->setPrinterId($printerId);
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \patest\EnumType\StartStop::valueIsValid()
     * @uses \patest\EnumType\StartStop::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\StartStopPrinter_Request
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StartStop::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StartStop', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\StartStop::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get Explanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExplanation()
    {
        return isset($this->Explanation) ? $this->Explanation : null;
    }
    /**
     * Set Explanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $explanation
     * @return \patest\StructType\StartStopPrinter_Request
     */
    public function setExplanation($explanation = null)
    {
        // validation for constraint: string
        if (!is_null($explanation) && !is_string($explanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($explanation, true), gettype($explanation)), __LINE__);
        }
        if (is_null($explanation) || (is_array($explanation) && empty($explanation))) {
            unset($this->Explanation);
        } else {
            $this->Explanation = $explanation;
        }
        return $this;
    }
    /**
     * Get PrinterId value
     * @return string|null
     */
    public function getPrinterId()
    {
        return $this->PrinterId;
    }
    /**
     * Set PrinterId value
     * @param string $printerId
     * @return \patest\StructType\StartStopPrinter_Request
     */
    public function setPrinterId($printerId = null)
    {
        // validation for constraint: string
        if (!is_null($printerId) && !is_string($printerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerId, true), gettype($printerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($printerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $printerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($printerId, true)), __LINE__);
        }
        $this->PrinterId = $printerId;
        return $this;
    }
}
