<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SroBusinessFlow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SroBusinessFlow
 * @subpackage Structs
 */
class SroBusinessFlow extends AbstractStructBase
{
    /**
     * The BusinessFlow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessFlow;
    /**
     * The ContextEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextEntityName;
    /**
     * The ClientGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientGuid;
    /**
     * The SaleModeGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeGuid;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The WorkflowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkflowType;
    /**
     * Constructor method for SroBusinessFlow
     * @uses SroBusinessFlow::setBusinessFlow()
     * @uses SroBusinessFlow::setContextEntityName()
     * @uses SroBusinessFlow::setClientGuid()
     * @uses SroBusinessFlow::setSaleModeGuid()
     * @uses SroBusinessFlow::setTransactionGuid()
     * @uses SroBusinessFlow::setWorkflowType()
     * @param string $businessFlow
     * @param string $contextEntityName
     * @param string $clientGuid
     * @param string $saleModeGuid
     * @param string $transactionGuid
     * @param string $workflowType
     */
    public function __construct($businessFlow = null, $contextEntityName = null, $clientGuid = null, $saleModeGuid = null, $transactionGuid = null, $workflowType = null)
    {
        $this
            ->setBusinessFlow($businessFlow)
            ->setContextEntityName($contextEntityName)
            ->setClientGuid($clientGuid)
            ->setSaleModeGuid($saleModeGuid)
            ->setTransactionGuid($transactionGuid)
            ->setWorkflowType($workflowType);
    }
    /**
     * Get BusinessFlow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessFlow()
    {
        return isset($this->BusinessFlow) ? $this->BusinessFlow : null;
    }
    /**
     * Set BusinessFlow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessFlow
     * @return \patest\StructType\SroBusinessFlow
     */
    public function setBusinessFlow($businessFlow = null)
    {
        // validation for constraint: string
        if (!is_null($businessFlow) && !is_string($businessFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessFlow, true), gettype($businessFlow)), __LINE__);
        }
        if (is_null($businessFlow) || (is_array($businessFlow) && empty($businessFlow))) {
            unset($this->BusinessFlow);
        } else {
            $this->BusinessFlow = $businessFlow;
        }
        return $this;
    }
    /**
     * Get ContextEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextEntityName()
    {
        return isset($this->ContextEntityName) ? $this->ContextEntityName : null;
    }
    /**
     * Set ContextEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextEntityName
     * @return \patest\StructType\SroBusinessFlow
     */
    public function setContextEntityName($contextEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($contextEntityName) && !is_string($contextEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextEntityName, true), gettype($contextEntityName)), __LINE__);
        }
        if (is_null($contextEntityName) || (is_array($contextEntityName) && empty($contextEntityName))) {
            unset($this->ContextEntityName);
        } else {
            $this->ContextEntityName = $contextEntityName;
        }
        return $this;
    }
    /**
     * Get ClientGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientGuid()
    {
        return isset($this->ClientGuid) ? $this->ClientGuid : null;
    }
    /**
     * Set ClientGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientGuid
     * @return \patest\StructType\SroBusinessFlow
     */
    public function setClientGuid($clientGuid = null)
    {
        // validation for constraint: string
        if (!is_null($clientGuid) && !is_string($clientGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientGuid, true), gettype($clientGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientGuid, true)), __LINE__);
        }
        if (is_null($clientGuid) || (is_array($clientGuid) && empty($clientGuid))) {
            unset($this->ClientGuid);
        } else {
            $this->ClientGuid = $clientGuid;
        }
        return $this;
    }
    /**
     * Get SaleModeGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeGuid()
    {
        return isset($this->SaleModeGuid) ? $this->SaleModeGuid : null;
    }
    /**
     * Set SaleModeGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeGuid
     * @return \patest\StructType\SroBusinessFlow
     */
    public function setSaleModeGuid($saleModeGuid = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeGuid) && !is_string($saleModeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeGuid, true), gettype($saleModeGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeGuid, true)), __LINE__);
        }
        if (is_null($saleModeGuid) || (is_array($saleModeGuid) && empty($saleModeGuid))) {
            unset($this->SaleModeGuid);
        } else {
            $this->SaleModeGuid = $saleModeGuid;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\SroBusinessFlow
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get WorkflowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkflowType()
    {
        return isset($this->WorkflowType) ? $this->WorkflowType : null;
    }
    /**
     * Set WorkflowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WorkflowType::valueIsValid()
     * @uses \patest\EnumType\WorkflowType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $workflowType
     * @return \patest\StructType\SroBusinessFlow
     */
    public function setWorkflowType($workflowType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WorkflowType::valueIsValid($workflowType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WorkflowType', is_array($workflowType) ? implode(', ', $workflowType) : var_export($workflowType, true), implode(', ', \patest\EnumType\WorkflowType::getValidValues())), __LINE__);
        }
        if (is_null($workflowType) || (is_array($workflowType) && empty($workflowType))) {
            unset($this->WorkflowType);
        } else {
            $this->WorkflowType = $workflowType;
        }
        return $this;
    }
}
