<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpendingPointsByClient StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SpendingPointsByClient
 * @subpackage Structs
 */
class SpendingPointsByClient extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The PointsBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PointsBalance;
    /**
     * The PointsValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PointsValue;
    /**
     * The RedeemedPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RedeemedPoints;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Remark;
    /**
     * Constructor method for SpendingPointsByClient
     * @uses SpendingPointsByClient::setClientId()
     * @uses SpendingPointsByClient::setPointsBalance()
     * @uses SpendingPointsByClient::setPointsValue()
     * @uses SpendingPointsByClient::setRedeemedPoints()
     * @uses SpendingPointsByClient::setRemark()
     * @param string $clientId
     * @param float $pointsBalance
     * @param float $pointsValue
     * @param float $redeemedPoints
     * @param \patest\StructType\GlobalString $remark
     */
    public function __construct($clientId = null, $pointsBalance = null, $pointsValue = null, $redeemedPoints = null, \patest\StructType\GlobalString $remark = null)
    {
        $this
            ->setClientId($clientId)
            ->setPointsBalance($pointsBalance)
            ->setPointsValue($pointsValue)
            ->setRedeemedPoints($redeemedPoints)
            ->setRemark($remark);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\SpendingPointsByClient
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get PointsBalance value
     * @return float|null
     */
    public function getPointsBalance()
    {
        return $this->PointsBalance;
    }
    /**
     * Set PointsBalance value
     * @param float $pointsBalance
     * @return \patest\StructType\SpendingPointsByClient
     */
    public function setPointsBalance($pointsBalance = null)
    {
        // validation for constraint: float
        if (!is_null($pointsBalance) && !(is_float($pointsBalance) || is_numeric($pointsBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pointsBalance, true), gettype($pointsBalance)), __LINE__);
        }
        $this->PointsBalance = $pointsBalance;
        return $this;
    }
    /**
     * Get PointsValue value
     * @return float|null
     */
    public function getPointsValue()
    {
        return $this->PointsValue;
    }
    /**
     * Set PointsValue value
     * @param float $pointsValue
     * @return \patest\StructType\SpendingPointsByClient
     */
    public function setPointsValue($pointsValue = null)
    {
        // validation for constraint: float
        if (!is_null($pointsValue) && !(is_float($pointsValue) || is_numeric($pointsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pointsValue, true), gettype($pointsValue)), __LINE__);
        }
        $this->PointsValue = $pointsValue;
        return $this;
    }
    /**
     * Get RedeemedPoints value
     * @return float|null
     */
    public function getRedeemedPoints()
    {
        return $this->RedeemedPoints;
    }
    /**
     * Set RedeemedPoints value
     * @param float $redeemedPoints
     * @return \patest\StructType\SpendingPointsByClient
     */
    public function setRedeemedPoints($redeemedPoints = null)
    {
        // validation for constraint: float
        if (!is_null($redeemedPoints) && !(is_float($redeemedPoints) || is_numeric($redeemedPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($redeemedPoints, true), gettype($redeemedPoints)), __LINE__);
        }
        $this->RedeemedPoints = $redeemedPoints;
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $remark
     * @return \patest\StructType\SpendingPointsByClient
     */
    public function setRemark(\patest\StructType\GlobalString $remark = null)
    {
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
}
