<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpOrm.AllowedStoredProcedure StructType
 * @subpackage Structs
 */
class SpOrm_AllowedStoredProcedure extends PersistableEntity
{
    /**
     * The CommandTimeout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CommandTimeout;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The RunWithoutParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RunWithoutParameters;
    /**
     * The SpName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpName;
    /**
     * Constructor method for SpOrm.AllowedStoredProcedure
     * @uses SpOrm_AllowedStoredProcedure::setCommandTimeout()
     * @uses SpOrm_AllowedStoredProcedure::setName()
     * @uses SpOrm_AllowedStoredProcedure::setRunWithoutParameters()
     * @uses SpOrm_AllowedStoredProcedure::setSpName()
     * @param int $commandTimeout
     * @param string $name
     * @param bool $runWithoutParameters
     * @param string $spName
     */
    public function __construct($commandTimeout = null, $name = null, $runWithoutParameters = null, $spName = null)
    {
        $this
            ->setCommandTimeout($commandTimeout)
            ->setName($name)
            ->setRunWithoutParameters($runWithoutParameters)
            ->setSpName($spName);
    }
    /**
     * Get CommandTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCommandTimeout()
    {
        return isset($this->CommandTimeout) ? $this->CommandTimeout : null;
    }
    /**
     * Set CommandTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $commandTimeout
     * @return \patest\StructType\SpOrm_AllowedStoredProcedure
     */
    public function setCommandTimeout($commandTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($commandTimeout) && !(is_int($commandTimeout) || ctype_digit($commandTimeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commandTimeout, true), gettype($commandTimeout)), __LINE__);
        }
        if (is_null($commandTimeout) || (is_array($commandTimeout) && empty($commandTimeout))) {
            unset($this->CommandTimeout);
        } else {
            $this->CommandTimeout = $commandTimeout;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\SpOrm_AllowedStoredProcedure
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get RunWithoutParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRunWithoutParameters()
    {
        return isset($this->RunWithoutParameters) ? $this->RunWithoutParameters : null;
    }
    /**
     * Set RunWithoutParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $runWithoutParameters
     * @return \patest\StructType\SpOrm_AllowedStoredProcedure
     */
    public function setRunWithoutParameters($runWithoutParameters = null)
    {
        // validation for constraint: boolean
        if (!is_null($runWithoutParameters) && !is_bool($runWithoutParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($runWithoutParameters, true), gettype($runWithoutParameters)), __LINE__);
        }
        if (is_null($runWithoutParameters) || (is_array($runWithoutParameters) && empty($runWithoutParameters))) {
            unset($this->RunWithoutParameters);
        } else {
            $this->RunWithoutParameters = $runWithoutParameters;
        }
        return $this;
    }
    /**
     * Get SpName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpName()
    {
        return isset($this->SpName) ? $this->SpName : null;
    }
    /**
     * Set SpName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spName
     * @return \patest\StructType\SpOrm_AllowedStoredProcedure
     */
    public function setSpName($spName = null)
    {
        // validation for constraint: string
        if (!is_null($spName) && !is_string($spName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spName, true), gettype($spName)), __LINE__);
        }
        if (is_null($spName) || (is_array($spName) && empty($spName))) {
            unset($this->SpName);
        } else {
            $this->SpName = $spName;
        }
        return $this;
    }
}
