<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SortKeyData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SortKeyData
 * @subpackage Structs
 */
class SortKeyData extends AbstractStructBase
{
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Direction;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * Constructor method for SortKeyData
     * @uses SortKeyData::setDirection()
     * @uses SortKeyData::setKey()
     * @param string $direction
     * @param string $key
     */
    public function __construct($direction = null, $key = null)
    {
        $this
            ->setDirection($direction)
            ->setKey($key);
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \patest\EnumType\ListSortDirection::valueIsValid()
     * @uses \patest\EnumType\ListSortDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \patest\StructType\SortKeyData
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ListSortDirection::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ListSortDirection', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \patest\EnumType\ListSortDirection::getValidValues())), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \patest\StructType\SortKeyData
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
}
