<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShowGenreItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShowGenreItem
 * @subpackage Structs
 */
class ShowGenreItem extends AbstractStructBase
{
    /**
     * The GenreId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GenreId;
    /**
     * The IsRecommended
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRecommended;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * Constructor method for ShowGenreItem
     * @uses ShowGenreItem::setGenreId()
     * @uses ShowGenreItem::setIsRecommended()
     * @uses ShowGenreItem::setShowId()
     * @param string $genreId
     * @param bool $isRecommended
     * @param string $showId
     */
    public function __construct($genreId = null, $isRecommended = null, $showId = null)
    {
        $this
            ->setGenreId($genreId)
            ->setIsRecommended($isRecommended)
            ->setShowId($showId);
    }
    /**
     * Get GenreId value
     * @return string|null
     */
    public function getGenreId()
    {
        return $this->GenreId;
    }
    /**
     * Set GenreId value
     * @param string $genreId
     * @return \patest\StructType\ShowGenreItem
     */
    public function setGenreId($genreId = null)
    {
        // validation for constraint: string
        if (!is_null($genreId) && !is_string($genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genreId, true), gettype($genreId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($genreId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($genreId, true)), __LINE__);
        }
        $this->GenreId = $genreId;
        return $this;
    }
    /**
     * Get IsRecommended value
     * @return bool|null
     */
    public function getIsRecommended()
    {
        return $this->IsRecommended;
    }
    /**
     * Set IsRecommended value
     * @param bool $isRecommended
     * @return \patest\StructType\ShowGenreItem
     */
    public function setIsRecommended($isRecommended = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRecommended) && !is_bool($isRecommended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRecommended, true), gettype($isRecommended)), __LINE__);
        }
        $this->IsRecommended = $isRecommended;
        return $this;
    }
    /**
     * Get ShowId value
     * @return string|null
     */
    public function getShowId()
    {
        return $this->ShowId;
    }
    /**
     * Set ShowId value
     * @param string $showId
     * @return \patest\StructType\ShowGenreItem
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        $this->ShowId = $showId;
        return $this;
    }
}
