<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShowDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShowDescription
 * @subpackage Structs
 */
class ShowDescription extends AbstractStructBase
{
    /**
     * The ActiveFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActiveFrom;
    /**
     * The ActiveTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActiveTo;
    /**
     * The BreakMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BreakMinutes;
    /**
     * The BriefText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BriefText;
    /**
     * The Culture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Culture;
    /**
     * The DescriptionLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DescriptionLevel;
    /**
     * The DetailText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DetailText;
    /**
     * The ExtraProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ExtraProperties;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The LargeImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LargeImageUrl;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocalId;
    /**
     * The LongMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LongMinutes;
    /**
     * The MediumImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MediumImageUrl;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OnlineDateFormatAdditionalText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OnlineDateFormatAdditionalText;
    /**
     * The OnlineHeroImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineHeroImageUrl;
    /**
     * The OnlineThumbnailImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineThumbnailImageUrl;
    /**
     * The ReviewUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReviewUrl;
    /**
     * The ShowTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowTypeId;
    /**
     * The SmallImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SmallImageUrl;
    /**
     * The SummarySaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $SummarySaleStatus;
    /**
     * The TrailerUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrailerUrl;
    /**
     * The Genres
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfGenreDescription
     */
    public $Genres;
    /**
     * The DisplayInSlideShow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DisplayInSlideShow;
    /**
     * The RecommendedForSlideShowInGenres
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $RecommendedForSlideShowInGenres;
    /**
     * The SlideShowImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SlideShowImageUrl;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The IsAvailableInSeriesAsBonus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableInSeriesAsBonus;
    /**
     * The IsAvailableInSeriesAsRegular
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableInSeriesAsRegular;
    /**
     * The RequestType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestType;
    /**
     * The AllowedBookingRequestTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AllowedBookingRequestTypes;
    /**
     * The FirstEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\FirstEventDetails
     */
    public $FirstEvent;
    /**
     * The AvailableEventsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AvailableEventsCount;
    /**
     * The HospitalityMedia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ProductMedia
     */
    public $HospitalityMedia;
    /**
     * The SocialNetworkImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SocialNetworkImageUrl;
    /**
     * The IsGroupTour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupTour;
    /**
     * The IsTour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTour;
    /**
     * Constructor method for ShowDescription
     * @uses ShowDescription::setActiveFrom()
     * @uses ShowDescription::setActiveTo()
     * @uses ShowDescription::setBreakMinutes()
     * @uses ShowDescription::setBriefText()
     * @uses ShowDescription::setCulture()
     * @uses ShowDescription::setDescriptionLevel()
     * @uses ShowDescription::setDetailText()
     * @uses ShowDescription::setExtraProperties()
     * @uses ShowDescription::setId()
     * @uses ShowDescription::setLargeImageUrl()
     * @uses ShowDescription::setLocalId()
     * @uses ShowDescription::setLongMinutes()
     * @uses ShowDescription::setMediumImageUrl()
     * @uses ShowDescription::setName()
     * @uses ShowDescription::setOnlineDateFormatAdditionalText()
     * @uses ShowDescription::setOnlineHeroImageUrl()
     * @uses ShowDescription::setOnlineThumbnailImageUrl()
     * @uses ShowDescription::setReviewUrl()
     * @uses ShowDescription::setShowTypeId()
     * @uses ShowDescription::setSmallImageUrl()
     * @uses ShowDescription::setSummarySaleStatus()
     * @uses ShowDescription::setTrailerUrl()
     * @uses ShowDescription::setGenres()
     * @uses ShowDescription::setDisplayInSlideShow()
     * @uses ShowDescription::setRecommendedForSlideShowInGenres()
     * @uses ShowDescription::setSlideShowImageUrl()
     * @uses ShowDescription::setExternalReference()
     * @uses ShowDescription::setOwnerId()
     * @uses ShowDescription::setOwnerName()
     * @uses ShowDescription::setMessage()
     * @uses ShowDescription::setNotes()
     * @uses ShowDescription::setIsAvailableInSeriesAsBonus()
     * @uses ShowDescription::setIsAvailableInSeriesAsRegular()
     * @uses ShowDescription::setRequestType()
     * @uses ShowDescription::setAllowedBookingRequestTypes()
     * @uses ShowDescription::setFirstEvent()
     * @uses ShowDescription::setAvailableEventsCount()
     * @uses ShowDescription::setHospitalityMedia()
     * @uses ShowDescription::setSocialNetworkImageUrl()
     * @uses ShowDescription::setIsGroupTour()
     * @uses ShowDescription::setIsTour()
     * @param string $activeFrom
     * @param string $activeTo
     * @param int $breakMinutes
     * @param string $briefText
     * @param int $culture
     * @param string $descriptionLevel
     * @param string $detailText
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraProperties
     * @param string $id
     * @param string $largeImageUrl
     * @param int $localId
     * @param int $longMinutes
     * @param string $mediumImageUrl
     * @param string $name
     * @param \patest\StructType\GlobalString $onlineDateFormatAdditionalText
     * @param string $onlineHeroImageUrl
     * @param string $onlineThumbnailImageUrl
     * @param string $reviewUrl
     * @param string $showTypeId
     * @param string $smallImageUrl
     * @param string[] $summarySaleStatus
     * @param string $trailerUrl
     * @param \patest\ArrayType\ArrayOfGenreDescription $genres
     * @param bool $displayInSlideShow
     * @param \patest\ArrayType\ArrayOfguid $recommendedForSlideShowInGenres
     * @param string $slideShowImageUrl
     * @param string $externalReference
     * @param string $ownerId
     * @param string $ownerName
     * @param string $message
     * @param string $notes
     * @param bool $isAvailableInSeriesAsBonus
     * @param bool $isAvailableInSeriesAsRegular
     * @param string $requestType
     * @param \patest\ArrayType\ArrayOfguid $allowedBookingRequestTypes
     * @param \patest\StructType\FirstEventDetails $firstEvent
     * @param int $availableEventsCount
     * @param \patest\StructType\ProductMedia $hospitalityMedia
     * @param string $socialNetworkImageUrl
     * @param bool $isGroupTour
     * @param bool $isTour
     */
    public function __construct($activeFrom = null, $activeTo = null, $breakMinutes = null, $briefText = null, $culture = null, $descriptionLevel = null, $detailText = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraProperties = null, $id = null, $largeImageUrl = null, $localId = null, $longMinutes = null, $mediumImageUrl = null, $name = null, \patest\StructType\GlobalString $onlineDateFormatAdditionalText = null, $onlineHeroImageUrl = null, $onlineThumbnailImageUrl = null, $reviewUrl = null, $showTypeId = null, $smallImageUrl = null, array $summarySaleStatus = array(), $trailerUrl = null, \patest\ArrayType\ArrayOfGenreDescription $genres = null, $displayInSlideShow = null, \patest\ArrayType\ArrayOfguid $recommendedForSlideShowInGenres = null, $slideShowImageUrl = null, $externalReference = null, $ownerId = null, $ownerName = null, $message = null, $notes = null, $isAvailableInSeriesAsBonus = null, $isAvailableInSeriesAsRegular = null, $requestType = null, \patest\ArrayType\ArrayOfguid $allowedBookingRequestTypes = null, \patest\StructType\FirstEventDetails $firstEvent = null, $availableEventsCount = null, \patest\StructType\ProductMedia $hospitalityMedia = null, $socialNetworkImageUrl = null, $isGroupTour = null, $isTour = null)
    {
        $this
            ->setActiveFrom($activeFrom)
            ->setActiveTo($activeTo)
            ->setBreakMinutes($breakMinutes)
            ->setBriefText($briefText)
            ->setCulture($culture)
            ->setDescriptionLevel($descriptionLevel)
            ->setDetailText($detailText)
            ->setExtraProperties($extraProperties)
            ->setId($id)
            ->setLargeImageUrl($largeImageUrl)
            ->setLocalId($localId)
            ->setLongMinutes($longMinutes)
            ->setMediumImageUrl($mediumImageUrl)
            ->setName($name)
            ->setOnlineDateFormatAdditionalText($onlineDateFormatAdditionalText)
            ->setOnlineHeroImageUrl($onlineHeroImageUrl)
            ->setOnlineThumbnailImageUrl($onlineThumbnailImageUrl)
            ->setReviewUrl($reviewUrl)
            ->setShowTypeId($showTypeId)
            ->setSmallImageUrl($smallImageUrl)
            ->setSummarySaleStatus($summarySaleStatus)
            ->setTrailerUrl($trailerUrl)
            ->setGenres($genres)
            ->setDisplayInSlideShow($displayInSlideShow)
            ->setRecommendedForSlideShowInGenres($recommendedForSlideShowInGenres)
            ->setSlideShowImageUrl($slideShowImageUrl)
            ->setExternalReference($externalReference)
            ->setOwnerId($ownerId)
            ->setOwnerName($ownerName)
            ->setMessage($message)
            ->setNotes($notes)
            ->setIsAvailableInSeriesAsBonus($isAvailableInSeriesAsBonus)
            ->setIsAvailableInSeriesAsRegular($isAvailableInSeriesAsRegular)
            ->setRequestType($requestType)
            ->setAllowedBookingRequestTypes($allowedBookingRequestTypes)
            ->setFirstEvent($firstEvent)
            ->setAvailableEventsCount($availableEventsCount)
            ->setHospitalityMedia($hospitalityMedia)
            ->setSocialNetworkImageUrl($socialNetworkImageUrl)
            ->setIsGroupTour($isGroupTour)
            ->setIsTour($isTour);
    }
    /**
     * Get ActiveFrom value
     * @return string|null
     */
    public function getActiveFrom()
    {
        return $this->ActiveFrom;
    }
    /**
     * Set ActiveFrom value
     * @param string $activeFrom
     * @return \patest\StructType\ShowDescription
     */
    public function setActiveFrom($activeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($activeFrom) && !is_string($activeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeFrom, true), gettype($activeFrom)), __LINE__);
        }
        $this->ActiveFrom = $activeFrom;
        return $this;
    }
    /**
     * Get ActiveTo value
     * @return string|null
     */
    public function getActiveTo()
    {
        return $this->ActiveTo;
    }
    /**
     * Set ActiveTo value
     * @param string $activeTo
     * @return \patest\StructType\ShowDescription
     */
    public function setActiveTo($activeTo = null)
    {
        // validation for constraint: string
        if (!is_null($activeTo) && !is_string($activeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeTo, true), gettype($activeTo)), __LINE__);
        }
        $this->ActiveTo = $activeTo;
        return $this;
    }
    /**
     * Get BreakMinutes value
     * @return int|null
     */
    public function getBreakMinutes()
    {
        return $this->BreakMinutes;
    }
    /**
     * Set BreakMinutes value
     * @param int $breakMinutes
     * @return \patest\StructType\ShowDescription
     */
    public function setBreakMinutes($breakMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($breakMinutes) && !(is_int($breakMinutes) || ctype_digit($breakMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($breakMinutes, true), gettype($breakMinutes)), __LINE__);
        }
        $this->BreakMinutes = $breakMinutes;
        return $this;
    }
    /**
     * Get BriefText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBriefText()
    {
        return isset($this->BriefText) ? $this->BriefText : null;
    }
    /**
     * Set BriefText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $briefText
     * @return \patest\StructType\ShowDescription
     */
    public function setBriefText($briefText = null)
    {
        // validation for constraint: string
        if (!is_null($briefText) && !is_string($briefText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($briefText, true), gettype($briefText)), __LINE__);
        }
        if (is_null($briefText) || (is_array($briefText) && empty($briefText))) {
            unset($this->BriefText);
        } else {
            $this->BriefText = $briefText;
        }
        return $this;
    }
    /**
     * Get Culture value
     * @return int|null
     */
    public function getCulture()
    {
        return $this->Culture;
    }
    /**
     * Set Culture value
     * @param int $culture
     * @return \patest\StructType\ShowDescription
     */
    public function setCulture($culture = null)
    {
        // validation for constraint: int
        if (!is_null($culture) && !(is_int($culture) || ctype_digit($culture))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($culture, true), gettype($culture)), __LINE__);
        }
        $this->Culture = $culture;
        return $this;
    }
    /**
     * Get DescriptionLevel value
     * @return string|null
     */
    public function getDescriptionLevel()
    {
        return $this->DescriptionLevel;
    }
    /**
     * Set DescriptionLevel value
     * @uses \patest\EnumType\DescriptionLevel::valueIsValid()
     * @uses \patest\EnumType\DescriptionLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $descriptionLevel
     * @return \patest\StructType\ShowDescription
     */
    public function setDescriptionLevel($descriptionLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DescriptionLevel::valueIsValid($descriptionLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DescriptionLevel', is_array($descriptionLevel) ? implode(', ', $descriptionLevel) : var_export($descriptionLevel, true), implode(', ', \patest\EnumType\DescriptionLevel::getValidValues())), __LINE__);
        }
        $this->DescriptionLevel = $descriptionLevel;
        return $this;
    }
    /**
     * Get DetailText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetailText()
    {
        return isset($this->DetailText) ? $this->DetailText : null;
    }
    /**
     * Set DetailText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detailText
     * @return \patest\StructType\ShowDescription
     */
    public function setDetailText($detailText = null)
    {
        // validation for constraint: string
        if (!is_null($detailText) && !is_string($detailText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailText, true), gettype($detailText)), __LINE__);
        }
        if (is_null($detailText) || (is_array($detailText) && empty($detailText))) {
            unset($this->DetailText);
        } else {
            $this->DetailText = $detailText;
        }
        return $this;
    }
    /**
     * Get ExtraProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getExtraProperties()
    {
        return isset($this->ExtraProperties) ? $this->ExtraProperties : null;
    }
    /**
     * Set ExtraProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraProperties
     * @return \patest\StructType\ShowDescription
     */
    public function setExtraProperties(\patest\ArrayType\ArrayOfKeyValueOfstringstring $extraProperties = null)
    {
        if (is_null($extraProperties) || (is_array($extraProperties) && empty($extraProperties))) {
            unset($this->ExtraProperties);
        } else {
            $this->ExtraProperties = $extraProperties;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\ShowDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get LargeImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLargeImageUrl()
    {
        return isset($this->LargeImageUrl) ? $this->LargeImageUrl : null;
    }
    /**
     * Set LargeImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $largeImageUrl
     * @return \patest\StructType\ShowDescription
     */
    public function setLargeImageUrl($largeImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($largeImageUrl) && !is_string($largeImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($largeImageUrl, true), gettype($largeImageUrl)), __LINE__);
        }
        if (is_null($largeImageUrl) || (is_array($largeImageUrl) && empty($largeImageUrl))) {
            unset($this->LargeImageUrl);
        } else {
            $this->LargeImageUrl = $largeImageUrl;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * @return int|null
     */
    public function getLocalId()
    {
        return $this->LocalId;
    }
    /**
     * Set LocalId value
     * @param int $localId
     * @return \patest\StructType\ShowDescription
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        $this->LocalId = $localId;
        return $this;
    }
    /**
     * Get LongMinutes value
     * @return int|null
     */
    public function getLongMinutes()
    {
        return $this->LongMinutes;
    }
    /**
     * Set LongMinutes value
     * @param int $longMinutes
     * @return \patest\StructType\ShowDescription
     */
    public function setLongMinutes($longMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($longMinutes) && !(is_int($longMinutes) || ctype_digit($longMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($longMinutes, true), gettype($longMinutes)), __LINE__);
        }
        $this->LongMinutes = $longMinutes;
        return $this;
    }
    /**
     * Get MediumImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMediumImageUrl()
    {
        return isset($this->MediumImageUrl) ? $this->MediumImageUrl : null;
    }
    /**
     * Set MediumImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mediumImageUrl
     * @return \patest\StructType\ShowDescription
     */
    public function setMediumImageUrl($mediumImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($mediumImageUrl) && !is_string($mediumImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediumImageUrl, true), gettype($mediumImageUrl)), __LINE__);
        }
        if (is_null($mediumImageUrl) || (is_array($mediumImageUrl) && empty($mediumImageUrl))) {
            unset($this->MediumImageUrl);
        } else {
            $this->MediumImageUrl = $mediumImageUrl;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\ShowDescription
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OnlineDateFormatAdditionalText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOnlineDateFormatAdditionalText()
    {
        return isset($this->OnlineDateFormatAdditionalText) ? $this->OnlineDateFormatAdditionalText : null;
    }
    /**
     * Set OnlineDateFormatAdditionalText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $onlineDateFormatAdditionalText
     * @return \patest\StructType\ShowDescription
     */
    public function setOnlineDateFormatAdditionalText(\patest\StructType\GlobalString $onlineDateFormatAdditionalText = null)
    {
        if (is_null($onlineDateFormatAdditionalText) || (is_array($onlineDateFormatAdditionalText) && empty($onlineDateFormatAdditionalText))) {
            unset($this->OnlineDateFormatAdditionalText);
        } else {
            $this->OnlineDateFormatAdditionalText = $onlineDateFormatAdditionalText;
        }
        return $this;
    }
    /**
     * Get OnlineHeroImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineHeroImageUrl()
    {
        return isset($this->OnlineHeroImageUrl) ? $this->OnlineHeroImageUrl : null;
    }
    /**
     * Set OnlineHeroImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineHeroImageUrl
     * @return \patest\StructType\ShowDescription
     */
    public function setOnlineHeroImageUrl($onlineHeroImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($onlineHeroImageUrl) && !is_string($onlineHeroImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineHeroImageUrl, true), gettype($onlineHeroImageUrl)), __LINE__);
        }
        if (is_null($onlineHeroImageUrl) || (is_array($onlineHeroImageUrl) && empty($onlineHeroImageUrl))) {
            unset($this->OnlineHeroImageUrl);
        } else {
            $this->OnlineHeroImageUrl = $onlineHeroImageUrl;
        }
        return $this;
    }
    /**
     * Get OnlineThumbnailImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineThumbnailImageUrl()
    {
        return isset($this->OnlineThumbnailImageUrl) ? $this->OnlineThumbnailImageUrl : null;
    }
    /**
     * Set OnlineThumbnailImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineThumbnailImageUrl
     * @return \patest\StructType\ShowDescription
     */
    public function setOnlineThumbnailImageUrl($onlineThumbnailImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($onlineThumbnailImageUrl) && !is_string($onlineThumbnailImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineThumbnailImageUrl, true), gettype($onlineThumbnailImageUrl)), __LINE__);
        }
        if (is_null($onlineThumbnailImageUrl) || (is_array($onlineThumbnailImageUrl) && empty($onlineThumbnailImageUrl))) {
            unset($this->OnlineThumbnailImageUrl);
        } else {
            $this->OnlineThumbnailImageUrl = $onlineThumbnailImageUrl;
        }
        return $this;
    }
    /**
     * Get ReviewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReviewUrl()
    {
        return isset($this->ReviewUrl) ? $this->ReviewUrl : null;
    }
    /**
     * Set ReviewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reviewUrl
     * @return \patest\StructType\ShowDescription
     */
    public function setReviewUrl($reviewUrl = null)
    {
        // validation for constraint: string
        if (!is_null($reviewUrl) && !is_string($reviewUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reviewUrl, true), gettype($reviewUrl)), __LINE__);
        }
        if (is_null($reviewUrl) || (is_array($reviewUrl) && empty($reviewUrl))) {
            unset($this->ReviewUrl);
        } else {
            $this->ReviewUrl = $reviewUrl;
        }
        return $this;
    }
    /**
     * Get ShowTypeId value
     * @return string|null
     */
    public function getShowTypeId()
    {
        return $this->ShowTypeId;
    }
    /**
     * Set ShowTypeId value
     * @param string $showTypeId
     * @return \patest\StructType\ShowDescription
     */
    public function setShowTypeId($showTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($showTypeId) && !is_string($showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTypeId, true), gettype($showTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showTypeId, true)), __LINE__);
        }
        $this->ShowTypeId = $showTypeId;
        return $this;
    }
    /**
     * Get SmallImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSmallImageUrl()
    {
        return isset($this->SmallImageUrl) ? $this->SmallImageUrl : null;
    }
    /**
     * Set SmallImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $smallImageUrl
     * @return \patest\StructType\ShowDescription
     */
    public function setSmallImageUrl($smallImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($smallImageUrl) && !is_string($smallImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smallImageUrl, true), gettype($smallImageUrl)), __LINE__);
        }
        if (is_null($smallImageUrl) || (is_array($smallImageUrl) && empty($smallImageUrl))) {
            unset($this->SmallImageUrl);
        } else {
            $this->SmallImageUrl = $smallImageUrl;
        }
        return $this;
    }
    /**
     * Get SummarySaleStatus value
     * @return string[]|null
     */
    public function getSummarySaleStatus()
    {
        return $this->SummarySaleStatus;
    }
    /**
     * This method is responsible for validating the values passed to the setSummarySaleStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSummarySaleStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSummarySaleStatusForArrayConstraintsFromSetSummarySaleStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $showDescriptionSummarySaleStatusItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EventSaleStatus::valueIsValid($showDescriptionSummarySaleStatusItem)) {
                $invalidValues[] = is_object($showDescriptionSummarySaleStatusItem) ? get_class($showDescriptionSummarySaleStatusItem) : sprintf('%s(%s)', gettype($showDescriptionSummarySaleStatusItem), var_export($showDescriptionSummarySaleStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EventSaleStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SummarySaleStatus value
     * @uses \patest\EnumType\EventSaleStatus::valueIsValid()
     * @uses \patest\EnumType\EventSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $summarySaleStatus
     * @return \patest\StructType\ShowDescription
     */
    public function setSummarySaleStatus(array $summarySaleStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($summarySaleStatusArrayErrorMessage = self::validateSummarySaleStatusForArrayConstraintsFromSetSummarySaleStatus($summarySaleStatus))) {
            throw new \InvalidArgumentException($summarySaleStatusArrayErrorMessage, __LINE__);
        }
        $this->SummarySaleStatus = is_array($summarySaleStatus) ? implode(' ', $summarySaleStatus) : null;
        return $this;
    }
    /**
     * Get TrailerUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrailerUrl()
    {
        return isset($this->TrailerUrl) ? $this->TrailerUrl : null;
    }
    /**
     * Set TrailerUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trailerUrl
     * @return \patest\StructType\ShowDescription
     */
    public function setTrailerUrl($trailerUrl = null)
    {
        // validation for constraint: string
        if (!is_null($trailerUrl) && !is_string($trailerUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailerUrl, true), gettype($trailerUrl)), __LINE__);
        }
        if (is_null($trailerUrl) || (is_array($trailerUrl) && empty($trailerUrl))) {
            unset($this->TrailerUrl);
        } else {
            $this->TrailerUrl = $trailerUrl;
        }
        return $this;
    }
    /**
     * Get Genres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfGenreDescription|null
     */
    public function getGenres()
    {
        return isset($this->Genres) ? $this->Genres : null;
    }
    /**
     * Set Genres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfGenreDescription $genres
     * @return \patest\StructType\ShowDescription
     */
    public function setGenres(\patest\ArrayType\ArrayOfGenreDescription $genres = null)
    {
        if (is_null($genres) || (is_array($genres) && empty($genres))) {
            unset($this->Genres);
        } else {
            $this->Genres = $genres;
        }
        return $this;
    }
    /**
     * Get DisplayInSlideShow value
     * @return bool|null
     */
    public function getDisplayInSlideShow()
    {
        return $this->DisplayInSlideShow;
    }
    /**
     * Set DisplayInSlideShow value
     * @param bool $displayInSlideShow
     * @return \patest\StructType\ShowDescription
     */
    public function setDisplayInSlideShow($displayInSlideShow = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayInSlideShow) && !is_bool($displayInSlideShow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayInSlideShow, true), gettype($displayInSlideShow)), __LINE__);
        }
        $this->DisplayInSlideShow = $displayInSlideShow;
        return $this;
    }
    /**
     * Get RecommendedForSlideShowInGenres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getRecommendedForSlideShowInGenres()
    {
        return isset($this->RecommendedForSlideShowInGenres) ? $this->RecommendedForSlideShowInGenres : null;
    }
    /**
     * Set RecommendedForSlideShowInGenres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $recommendedForSlideShowInGenres
     * @return \patest\StructType\ShowDescription
     */
    public function setRecommendedForSlideShowInGenres(\patest\ArrayType\ArrayOfguid $recommendedForSlideShowInGenres = null)
    {
        if (is_null($recommendedForSlideShowInGenres) || (is_array($recommendedForSlideShowInGenres) && empty($recommendedForSlideShowInGenres))) {
            unset($this->RecommendedForSlideShowInGenres);
        } else {
            $this->RecommendedForSlideShowInGenres = $recommendedForSlideShowInGenres;
        }
        return $this;
    }
    /**
     * Get SlideShowImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSlideShowImageUrl()
    {
        return isset($this->SlideShowImageUrl) ? $this->SlideShowImageUrl : null;
    }
    /**
     * Set SlideShowImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $slideShowImageUrl
     * @return \patest\StructType\ShowDescription
     */
    public function setSlideShowImageUrl($slideShowImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($slideShowImageUrl) && !is_string($slideShowImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($slideShowImageUrl, true), gettype($slideShowImageUrl)), __LINE__);
        }
        if (is_null($slideShowImageUrl) || (is_array($slideShowImageUrl) && empty($slideShowImageUrl))) {
            unset($this->SlideShowImageUrl);
        } else {
            $this->SlideShowImageUrl = $slideShowImageUrl;
        }
        return $this;
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \patest\StructType\ShowDescription
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\ShowDescription
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\ShowDescription
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\ShowDescription
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\ShowDescription
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get IsAvailableInSeriesAsBonus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableInSeriesAsBonus()
    {
        return isset($this->IsAvailableInSeriesAsBonus) ? $this->IsAvailableInSeriesAsBonus : null;
    }
    /**
     * Set IsAvailableInSeriesAsBonus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableInSeriesAsBonus
     * @return \patest\StructType\ShowDescription
     */
    public function setIsAvailableInSeriesAsBonus($isAvailableInSeriesAsBonus = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableInSeriesAsBonus) && !is_bool($isAvailableInSeriesAsBonus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableInSeriesAsBonus, true), gettype($isAvailableInSeriesAsBonus)), __LINE__);
        }
        if (is_null($isAvailableInSeriesAsBonus) || (is_array($isAvailableInSeriesAsBonus) && empty($isAvailableInSeriesAsBonus))) {
            unset($this->IsAvailableInSeriesAsBonus);
        } else {
            $this->IsAvailableInSeriesAsBonus = $isAvailableInSeriesAsBonus;
        }
        return $this;
    }
    /**
     * Get IsAvailableInSeriesAsRegular value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableInSeriesAsRegular()
    {
        return isset($this->IsAvailableInSeriesAsRegular) ? $this->IsAvailableInSeriesAsRegular : null;
    }
    /**
     * Set IsAvailableInSeriesAsRegular value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableInSeriesAsRegular
     * @return \patest\StructType\ShowDescription
     */
    public function setIsAvailableInSeriesAsRegular($isAvailableInSeriesAsRegular = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableInSeriesAsRegular) && !is_bool($isAvailableInSeriesAsRegular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableInSeriesAsRegular, true), gettype($isAvailableInSeriesAsRegular)), __LINE__);
        }
        if (is_null($isAvailableInSeriesAsRegular) || (is_array($isAvailableInSeriesAsRegular) && empty($isAvailableInSeriesAsRegular))) {
            unset($this->IsAvailableInSeriesAsRegular);
        } else {
            $this->IsAvailableInSeriesAsRegular = $isAvailableInSeriesAsRegular;
        }
        return $this;
    }
    /**
     * Get RequestType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestType()
    {
        return isset($this->RequestType) ? $this->RequestType : null;
    }
    /**
     * Set RequestType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestType
     * @return \patest\StructType\ShowDescription
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestType, true), gettype($requestType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestType, true)), __LINE__);
        }
        if (is_null($requestType) || (is_array($requestType) && empty($requestType))) {
            unset($this->RequestType);
        } else {
            $this->RequestType = $requestType;
        }
        return $this;
    }
    /**
     * Get AllowedBookingRequestTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAllowedBookingRequestTypes()
    {
        return isset($this->AllowedBookingRequestTypes) ? $this->AllowedBookingRequestTypes : null;
    }
    /**
     * Set AllowedBookingRequestTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $allowedBookingRequestTypes
     * @return \patest\StructType\ShowDescription
     */
    public function setAllowedBookingRequestTypes(\patest\ArrayType\ArrayOfguid $allowedBookingRequestTypes = null)
    {
        if (is_null($allowedBookingRequestTypes) || (is_array($allowedBookingRequestTypes) && empty($allowedBookingRequestTypes))) {
            unset($this->AllowedBookingRequestTypes);
        } else {
            $this->AllowedBookingRequestTypes = $allowedBookingRequestTypes;
        }
        return $this;
    }
    /**
     * Get FirstEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\FirstEventDetails|null
     */
    public function getFirstEvent()
    {
        return isset($this->FirstEvent) ? $this->FirstEvent : null;
    }
    /**
     * Set FirstEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\FirstEventDetails $firstEvent
     * @return \patest\StructType\ShowDescription
     */
    public function setFirstEvent(\patest\StructType\FirstEventDetails $firstEvent = null)
    {
        if (is_null($firstEvent) || (is_array($firstEvent) && empty($firstEvent))) {
            unset($this->FirstEvent);
        } else {
            $this->FirstEvent = $firstEvent;
        }
        return $this;
    }
    /**
     * Get AvailableEventsCount value
     * @return int|null
     */
    public function getAvailableEventsCount()
    {
        return $this->AvailableEventsCount;
    }
    /**
     * Set AvailableEventsCount value
     * @param int $availableEventsCount
     * @return \patest\StructType\ShowDescription
     */
    public function setAvailableEventsCount($availableEventsCount = null)
    {
        // validation for constraint: int
        if (!is_null($availableEventsCount) && !(is_int($availableEventsCount) || ctype_digit($availableEventsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableEventsCount, true), gettype($availableEventsCount)), __LINE__);
        }
        $this->AvailableEventsCount = $availableEventsCount;
        return $this;
    }
    /**
     * Get HospitalityMedia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ProductMedia|null
     */
    public function getHospitalityMedia()
    {
        return isset($this->HospitalityMedia) ? $this->HospitalityMedia : null;
    }
    /**
     * Set HospitalityMedia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ProductMedia $hospitalityMedia
     * @return \patest\StructType\ShowDescription
     */
    public function setHospitalityMedia(\patest\StructType\ProductMedia $hospitalityMedia = null)
    {
        if (is_null($hospitalityMedia) || (is_array($hospitalityMedia) && empty($hospitalityMedia))) {
            unset($this->HospitalityMedia);
        } else {
            $this->HospitalityMedia = $hospitalityMedia;
        }
        return $this;
    }
    /**
     * Get SocialNetworkImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSocialNetworkImageUrl()
    {
        return isset($this->SocialNetworkImageUrl) ? $this->SocialNetworkImageUrl : null;
    }
    /**
     * Set SocialNetworkImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $socialNetworkImageUrl
     * @return \patest\StructType\ShowDescription
     */
    public function setSocialNetworkImageUrl($socialNetworkImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($socialNetworkImageUrl) && !is_string($socialNetworkImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialNetworkImageUrl, true), gettype($socialNetworkImageUrl)), __LINE__);
        }
        if (is_null($socialNetworkImageUrl) || (is_array($socialNetworkImageUrl) && empty($socialNetworkImageUrl))) {
            unset($this->SocialNetworkImageUrl);
        } else {
            $this->SocialNetworkImageUrl = $socialNetworkImageUrl;
        }
        return $this;
    }
    /**
     * Get IsGroupTour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupTour()
    {
        return isset($this->IsGroupTour) ? $this->IsGroupTour : null;
    }
    /**
     * Set IsGroupTour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupTour
     * @return \patest\StructType\ShowDescription
     */
    public function setIsGroupTour($isGroupTour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupTour) && !is_bool($isGroupTour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupTour, true), gettype($isGroupTour)), __LINE__);
        }
        if (is_null($isGroupTour) || (is_array($isGroupTour) && empty($isGroupTour))) {
            unset($this->IsGroupTour);
        } else {
            $this->IsGroupTour = $isGroupTour;
        }
        return $this;
    }
    /**
     * Get IsTour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTour()
    {
        return isset($this->IsTour) ? $this->IsTour : null;
    }
    /**
     * Set IsTour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTour
     * @return \patest\StructType\ShowDescription
     */
    public function setIsTour($isTour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTour) && !is_bool($isTour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTour, true), gettype($isTour)), __LINE__);
        }
        if (is_null($isTour) || (is_array($isTour) && empty($isTour))) {
            unset($this->IsTour);
        } else {
            $this->IsTour = $isTour;
        }
        return $this;
    }
}
