<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SgoLinkageInfoResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SgoLinkageInfoResponse
 * @subpackage Structs
 */
class SgoLinkageInfoResponse extends AbstractStructBase
{
    /**
     * The SgoLinkageEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SgoLinkageEmail;
    /**
     * The SgoLinkageScopeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SgoLinkageScopeId;
    /**
     * The SgoLinkageScopeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SgoLinkageScopeName;
    /**
     * The SgoLinkageStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SgoLinkageStatus;
    /**
     * Constructor method for SgoLinkageInfoResponse
     * @uses SgoLinkageInfoResponse::setSgoLinkageEmail()
     * @uses SgoLinkageInfoResponse::setSgoLinkageScopeId()
     * @uses SgoLinkageInfoResponse::setSgoLinkageScopeName()
     * @uses SgoLinkageInfoResponse::setSgoLinkageStatus()
     * @param string $sgoLinkageEmail
     * @param int $sgoLinkageScopeId
     * @param string $sgoLinkageScopeName
     * @param string $sgoLinkageStatus
     */
    public function __construct($sgoLinkageEmail = null, $sgoLinkageScopeId = null, $sgoLinkageScopeName = null, $sgoLinkageStatus = null)
    {
        $this
            ->setSgoLinkageEmail($sgoLinkageEmail)
            ->setSgoLinkageScopeId($sgoLinkageScopeId)
            ->setSgoLinkageScopeName($sgoLinkageScopeName)
            ->setSgoLinkageStatus($sgoLinkageStatus);
    }
    /**
     * Get SgoLinkageEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSgoLinkageEmail()
    {
        return isset($this->SgoLinkageEmail) ? $this->SgoLinkageEmail : null;
    }
    /**
     * Set SgoLinkageEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sgoLinkageEmail
     * @return \patest\StructType\SgoLinkageInfoResponse
     */
    public function setSgoLinkageEmail($sgoLinkageEmail = null)
    {
        // validation for constraint: string
        if (!is_null($sgoLinkageEmail) && !is_string($sgoLinkageEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sgoLinkageEmail, true), gettype($sgoLinkageEmail)), __LINE__);
        }
        if (is_null($sgoLinkageEmail) || (is_array($sgoLinkageEmail) && empty($sgoLinkageEmail))) {
            unset($this->SgoLinkageEmail);
        } else {
            $this->SgoLinkageEmail = $sgoLinkageEmail;
        }
        return $this;
    }
    /**
     * Get SgoLinkageScopeId value
     * @return int|null
     */
    public function getSgoLinkageScopeId()
    {
        return $this->SgoLinkageScopeId;
    }
    /**
     * Set SgoLinkageScopeId value
     * @param int $sgoLinkageScopeId
     * @return \patest\StructType\SgoLinkageInfoResponse
     */
    public function setSgoLinkageScopeId($sgoLinkageScopeId = null)
    {
        // validation for constraint: int
        if (!is_null($sgoLinkageScopeId) && !(is_int($sgoLinkageScopeId) || ctype_digit($sgoLinkageScopeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sgoLinkageScopeId, true), gettype($sgoLinkageScopeId)), __LINE__);
        }
        $this->SgoLinkageScopeId = $sgoLinkageScopeId;
        return $this;
    }
    /**
     * Get SgoLinkageScopeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSgoLinkageScopeName()
    {
        return isset($this->SgoLinkageScopeName) ? $this->SgoLinkageScopeName : null;
    }
    /**
     * Set SgoLinkageScopeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sgoLinkageScopeName
     * @return \patest\StructType\SgoLinkageInfoResponse
     */
    public function setSgoLinkageScopeName($sgoLinkageScopeName = null)
    {
        // validation for constraint: string
        if (!is_null($sgoLinkageScopeName) && !is_string($sgoLinkageScopeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sgoLinkageScopeName, true), gettype($sgoLinkageScopeName)), __LINE__);
        }
        if (is_null($sgoLinkageScopeName) || (is_array($sgoLinkageScopeName) && empty($sgoLinkageScopeName))) {
            unset($this->SgoLinkageScopeName);
        } else {
            $this->SgoLinkageScopeName = $sgoLinkageScopeName;
        }
        return $this;
    }
    /**
     * Get SgoLinkageStatus value
     * @return string|null
     */
    public function getSgoLinkageStatus()
    {
        return $this->SgoLinkageStatus;
    }
    /**
     * Set SgoLinkageStatus value
     * @uses \patest\EnumType\SgoLinkageStatus::valueIsValid()
     * @uses \patest\EnumType\SgoLinkageStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sgoLinkageStatus
     * @return \patest\StructType\SgoLinkageInfoResponse
     */
    public function setSgoLinkageStatus($sgoLinkageStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SgoLinkageStatus::valueIsValid($sgoLinkageStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SgoLinkageStatus', is_array($sgoLinkageStatus) ? implode(', ', $sgoLinkageStatus) : var_export($sgoLinkageStatus, true), implode(', ', \patest\EnumType\SgoLinkageStatus::getValidValues())), __LINE__);
        }
        $this->SgoLinkageStatus = $sgoLinkageStatus;
        return $this;
    }
}
