<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSubscriptionExtraEventsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetSubscriptionExtraEventsRequest
 * @subpackage Structs
 */
class SetSubscriptionExtraEventsRequest extends ExtensibleDataContract
{
    /**
     * The EventIdsToAdd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $EventIdsToAdd;
    /**
     * The EventIdsToRemove
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $EventIdsToRemove;
    /**
     * The SubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $SubscriptionInstanceIds;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for SetSubscriptionExtraEventsRequest
     * @uses SetSubscriptionExtraEventsRequest::setEventIdsToAdd()
     * @uses SetSubscriptionExtraEventsRequest::setEventIdsToRemove()
     * @uses SetSubscriptionExtraEventsRequest::setSubscriptionInstanceIds()
     * @uses SetSubscriptionExtraEventsRequest::setTransactionGuid()
     * @param \patest\ArrayType\ArrayOfguid $eventIdsToAdd
     * @param \patest\ArrayType\ArrayOfguid $eventIdsToRemove
     * @param \patest\ArrayType\ArrayOfguid $subscriptionInstanceIds
     * @param string $transactionGuid
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $eventIdsToAdd = null, \patest\ArrayType\ArrayOfguid $eventIdsToRemove = null, \patest\ArrayType\ArrayOfguid $subscriptionInstanceIds = null, $transactionGuid = null)
    {
        $this
            ->setEventIdsToAdd($eventIdsToAdd)
            ->setEventIdsToRemove($eventIdsToRemove)
            ->setSubscriptionInstanceIds($subscriptionInstanceIds)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get EventIdsToAdd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getEventIdsToAdd()
    {
        return isset($this->EventIdsToAdd) ? $this->EventIdsToAdd : null;
    }
    /**
     * Set EventIdsToAdd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $eventIdsToAdd
     * @return \patest\StructType\SetSubscriptionExtraEventsRequest
     */
    public function setEventIdsToAdd(\patest\ArrayType\ArrayOfguid $eventIdsToAdd = null)
    {
        if (is_null($eventIdsToAdd) || (is_array($eventIdsToAdd) && empty($eventIdsToAdd))) {
            unset($this->EventIdsToAdd);
        } else {
            $this->EventIdsToAdd = $eventIdsToAdd;
        }
        return $this;
    }
    /**
     * Get EventIdsToRemove value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getEventIdsToRemove()
    {
        return isset($this->EventIdsToRemove) ? $this->EventIdsToRemove : null;
    }
    /**
     * Set EventIdsToRemove value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $eventIdsToRemove
     * @return \patest\StructType\SetSubscriptionExtraEventsRequest
     */
    public function setEventIdsToRemove(\patest\ArrayType\ArrayOfguid $eventIdsToRemove = null)
    {
        if (is_null($eventIdsToRemove) || (is_array($eventIdsToRemove) && empty($eventIdsToRemove))) {
            unset($this->EventIdsToRemove);
        } else {
            $this->EventIdsToRemove = $eventIdsToRemove;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getSubscriptionInstanceIds()
    {
        return isset($this->SubscriptionInstanceIds) ? $this->SubscriptionInstanceIds : null;
    }
    /**
     * Set SubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $subscriptionInstanceIds
     * @return \patest\StructType\SetSubscriptionExtraEventsRequest
     */
    public function setSubscriptionInstanceIds(\patest\ArrayType\ArrayOfguid $subscriptionInstanceIds = null)
    {
        if (is_null($subscriptionInstanceIds) || (is_array($subscriptionInstanceIds) && empty($subscriptionInstanceIds))) {
            unset($this->SubscriptionInstanceIds);
        } else {
            $this->SubscriptionInstanceIds = $subscriptionInstanceIds;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\SetSubscriptionExtraEventsRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
