<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSecurityRole-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetSecurityRole-Request
 * @subpackage Structs
 */
class SetSecurityRole_Request extends ExtensibleDataContract
{
    /**
     * The ChangeProfile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ChangeProfile;
    /**
     * The ReturnToDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ReturnToDefault;
    /**
     * The RoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleId;
    /**
     * Constructor method for SetSecurityRole-Request
     * @uses SetSecurityRole_Request::setChangeProfile()
     * @uses SetSecurityRole_Request::setReturnToDefault()
     * @uses SetSecurityRole_Request::setRoleId()
     * @param bool $changeProfile
     * @param bool $returnToDefault
     * @param string $roleId
     */
    public function __construct($changeProfile = null, $returnToDefault = null, $roleId = null)
    {
        $this
            ->setChangeProfile($changeProfile)
            ->setReturnToDefault($returnToDefault)
            ->setRoleId($roleId);
    }
    /**
     * Get ChangeProfile value
     * @return bool|null
     */
    public function getChangeProfile()
    {
        return $this->ChangeProfile;
    }
    /**
     * Set ChangeProfile value
     * @param bool $changeProfile
     * @return \patest\StructType\SetSecurityRole_Request
     */
    public function setChangeProfile($changeProfile = null)
    {
        // validation for constraint: boolean
        if (!is_null($changeProfile) && !is_bool($changeProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($changeProfile, true), gettype($changeProfile)), __LINE__);
        }
        $this->ChangeProfile = $changeProfile;
        return $this;
    }
    /**
     * Get ReturnToDefault value
     * @return bool|null
     */
    public function getReturnToDefault()
    {
        return $this->ReturnToDefault;
    }
    /**
     * Set ReturnToDefault value
     * @param bool $returnToDefault
     * @return \patest\StructType\SetSecurityRole_Request
     */
    public function setReturnToDefault($returnToDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnToDefault) && !is_bool($returnToDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnToDefault, true), gettype($returnToDefault)), __LINE__);
        }
        $this->ReturnToDefault = $returnToDefault;
        return $this;
    }
    /**
     * Get RoleId value
     * @return string|null
     */
    public function getRoleId()
    {
        return $this->RoleId;
    }
    /**
     * Set RoleId value
     * @param string $roleId
     * @return \patest\StructType\SetSecurityRole_Request
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: string
        if (!is_null($roleId) && !is_string($roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleId, true), gettype($roleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roleId, true)), __LINE__);
        }
        $this->RoleId = $roleId;
        return $this;
    }
}
