<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetPrintOptionsBaseResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetPrintOptionsBaseResponse
 * @subpackage Structs
 */
class SetPrintOptionsBaseResponse extends ExtensibleDataContract
{
    /**
     * The AvailablePrintOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAvailablePrintOption
     */
    public $AvailablePrintOptions;
    /**
     * The BasketItemsThatRequireManuallyEnteredBarcodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $BasketItemsThatRequireManuallyEnteredBarcodes;
    /**
     * Constructor method for SetPrintOptionsBaseResponse
     * @uses SetPrintOptionsBaseResponse::setAvailablePrintOptions()
     * @uses SetPrintOptionsBaseResponse::setBasketItemsThatRequireManuallyEnteredBarcodes()
     * @param \patest\ArrayType\ArrayOfAvailablePrintOption $availablePrintOptions
     * @param \patest\ArrayType\ArrayOfint $basketItemsThatRequireManuallyEnteredBarcodes
     */
    public function __construct(\patest\ArrayType\ArrayOfAvailablePrintOption $availablePrintOptions = null, \patest\ArrayType\ArrayOfint $basketItemsThatRequireManuallyEnteredBarcodes = null)
    {
        $this
            ->setAvailablePrintOptions($availablePrintOptions)
            ->setBasketItemsThatRequireManuallyEnteredBarcodes($basketItemsThatRequireManuallyEnteredBarcodes);
    }
    /**
     * Get AvailablePrintOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAvailablePrintOption|null
     */
    public function getAvailablePrintOptions()
    {
        return isset($this->AvailablePrintOptions) ? $this->AvailablePrintOptions : null;
    }
    /**
     * Set AvailablePrintOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAvailablePrintOption $availablePrintOptions
     * @return \patest\StructType\SetPrintOptionsBaseResponse
     */
    public function setAvailablePrintOptions(\patest\ArrayType\ArrayOfAvailablePrintOption $availablePrintOptions = null)
    {
        if (is_null($availablePrintOptions) || (is_array($availablePrintOptions) && empty($availablePrintOptions))) {
            unset($this->AvailablePrintOptions);
        } else {
            $this->AvailablePrintOptions = $availablePrintOptions;
        }
        return $this;
    }
    /**
     * Get BasketItemsThatRequireManuallyEnteredBarcodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getBasketItemsThatRequireManuallyEnteredBarcodes()
    {
        return isset($this->BasketItemsThatRequireManuallyEnteredBarcodes) ? $this->BasketItemsThatRequireManuallyEnteredBarcodes : null;
    }
    /**
     * Set BasketItemsThatRequireManuallyEnteredBarcodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $basketItemsThatRequireManuallyEnteredBarcodes
     * @return \patest\StructType\SetPrintOptionsBaseResponse
     */
    public function setBasketItemsThatRequireManuallyEnteredBarcodes(\patest\ArrayType\ArrayOfint $basketItemsThatRequireManuallyEnteredBarcodes = null)
    {
        if (is_null($basketItemsThatRequireManuallyEnteredBarcodes) || (is_array($basketItemsThatRequireManuallyEnteredBarcodes) && empty($basketItemsThatRequireManuallyEnteredBarcodes))) {
            unset($this->BasketItemsThatRequireManuallyEnteredBarcodes);
        } else {
            $this->BasketItemsThatRequireManuallyEnteredBarcodes = $basketItemsThatRequireManuallyEnteredBarcodes;
        }
        return $this;
    }
}
