<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetHospitalityTickets-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetHospitalityTickets-Request
 * @subpackage Structs
 */
class SetHospitalityTickets_Request extends ExtensibleDataContract
{
    /**
     * The TicketsRequestDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\HospitalityTicketsRequestDetailsBase
     */
    public $TicketsRequestDetails;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for SetHospitalityTickets-Request
     * @uses SetHospitalityTickets_Request::setTicketsRequestDetails()
     * @uses SetHospitalityTickets_Request::setTransactionGuid()
     * @uses SetHospitalityTickets_Request::setTransactionSnapshotType()
     * @param \patest\StructType\HospitalityTicketsRequestDetailsBase $ticketsRequestDetails
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct(\patest\StructType\HospitalityTicketsRequestDetailsBase $ticketsRequestDetails = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setTicketsRequestDetails($ticketsRequestDetails)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get TicketsRequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\HospitalityTicketsRequestDetailsBase|null
     */
    public function getTicketsRequestDetails()
    {
        return isset($this->TicketsRequestDetails) ? $this->TicketsRequestDetails : null;
    }
    /**
     * Set TicketsRequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\HospitalityTicketsRequestDetailsBase $ticketsRequestDetails
     * @return \patest\StructType\SetHospitalityTickets_Request
     */
    public function setTicketsRequestDetails(\patest\StructType\HospitalityTicketsRequestDetailsBase $ticketsRequestDetails = null)
    {
        if (is_null($ticketsRequestDetails) || (is_array($ticketsRequestDetails) && empty($ticketsRequestDetails))) {
            unset($this->TicketsRequestDetails);
        } else {
            $this->TicketsRequestDetails = $ticketsRequestDetails;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\SetHospitalityTickets_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\SetHospitalityTickets_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
