<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceSpecificItemIdentityForReprice StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceSpecificItemIdentityForReprice
 * @subpackage Structs
 */
class ServiceSpecificItemIdentityForReprice extends ServiceSpecificItemIdentity
{
    /**
     * The NewPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $NewPrice;
    /**
     * The NewPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceTypeId;
    /**
     * Constructor method for ServiceSpecificItemIdentityForReprice
     * @uses ServiceSpecificItemIdentityForReprice::setNewPrice()
     * @uses ServiceSpecificItemIdentityForReprice::setNewPriceTypeId()
     * @param \patest\StructType\Money $newPrice
     * @param string $newPriceTypeId
     */
    public function __construct(\patest\StructType\Money $newPrice = null, $newPriceTypeId = null)
    {
        $this
            ->setNewPrice($newPrice)
            ->setNewPriceTypeId($newPriceTypeId);
    }
    /**
     * Get NewPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getNewPrice()
    {
        return isset($this->NewPrice) ? $this->NewPrice : null;
    }
    /**
     * Set NewPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $newPrice
     * @return \patest\StructType\ServiceSpecificItemIdentityForReprice
     */
    public function setNewPrice(\patest\StructType\Money $newPrice = null)
    {
        if (is_null($newPrice) || (is_array($newPrice) && empty($newPrice))) {
            unset($this->NewPrice);
        } else {
            $this->NewPrice = $newPrice;
        }
        return $this;
    }
    /**
     * Get NewPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceTypeId()
    {
        return isset($this->NewPriceTypeId) ? $this->NewPriceTypeId : null;
    }
    /**
     * Set NewPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceTypeId
     * @return \patest\StructType\ServiceSpecificItemIdentityForReprice
     */
    public function setNewPriceTypeId($newPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceTypeId) && !is_string($newPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceTypeId, true), gettype($newPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceTypeId, true)), __LINE__);
        }
        if (is_null($newPriceTypeId) || (is_array($newPriceTypeId) && empty($newPriceTypeId))) {
            unset($this->NewPriceTypeId);
        } else {
            $this->NewPriceTypeId = $newPriceTypeId;
        }
        return $this;
    }
}
