<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeriesPricingRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeriesPricingRequest
 * @subpackage Structs
 */
class SeriesPricingRequest extends ExtensibleDataContract
{
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The IncludeBasketLevelPriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeBasketLevelPriceModifiers;
    /**
     * Constructor method for SeriesPricingRequest
     * @uses SeriesPricingRequest::setCouponIdentity()
     * @uses SeriesPricingRequest::setSeriesId()
     * @uses SeriesPricingRequest::setIncludeBasketLevelPriceModifiers()
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param string $seriesId
     * @param bool $includeBasketLevelPriceModifiers
     */
    public function __construct(\patest\StructType\CouponIdentity $couponIdentity = null, $seriesId = null, $includeBasketLevelPriceModifiers = null)
    {
        $this
            ->setCouponIdentity($couponIdentity)
            ->setSeriesId($seriesId)
            ->setIncludeBasketLevelPriceModifiers($includeBasketLevelPriceModifiers);
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\SeriesPricingRequest
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * @return string|null
     */
    public function getSeriesId()
    {
        return $this->SeriesId;
    }
    /**
     * Set SeriesId value
     * @param string $seriesId
     * @return \patest\StructType\SeriesPricingRequest
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        $this->SeriesId = $seriesId;
        return $this;
    }
    /**
     * Get IncludeBasketLevelPriceModifiers value
     * @return bool|null
     */
    public function getIncludeBasketLevelPriceModifiers()
    {
        return $this->IncludeBasketLevelPriceModifiers;
    }
    /**
     * Set IncludeBasketLevelPriceModifiers value
     * @param bool $includeBasketLevelPriceModifiers
     * @return \patest\StructType\SeriesPricingRequest
     */
    public function setIncludeBasketLevelPriceModifiers($includeBasketLevelPriceModifiers = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeBasketLevelPriceModifiers) && !is_bool($includeBasketLevelPriceModifiers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeBasketLevelPriceModifiers, true), gettype($includeBasketLevelPriceModifiers)), __LINE__);
        }
        $this->IncludeBasketLevelPriceModifiers = $includeBasketLevelPriceModifiers;
        return $this;
    }
}
