<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendRelationshipInvitation-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SendRelationshipInvitation-Response
 * @subpackage Structs
 */
class SendRelationshipInvitation_Response extends AbstractStructBase
{
    /**
     * The IsTemporary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsTemporary;
    /**
     * The RelationshipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipId;
    /**
     * Constructor method for SendRelationshipInvitation-Response
     * @uses SendRelationshipInvitation_Response::setIsTemporary()
     * @uses SendRelationshipInvitation_Response::setRelationshipId()
     * @param bool $isTemporary
     * @param string $relationshipId
     */
    public function __construct($isTemporary = null, $relationshipId = null)
    {
        $this
            ->setIsTemporary($isTemporary)
            ->setRelationshipId($relationshipId);
    }
    /**
     * Get IsTemporary value
     * @return bool|null
     */
    public function getIsTemporary()
    {
        return $this->IsTemporary;
    }
    /**
     * Set IsTemporary value
     * @param bool $isTemporary
     * @return \patest\StructType\SendRelationshipInvitation_Response
     */
    public function setIsTemporary($isTemporary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTemporary) && !is_bool($isTemporary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTemporary, true), gettype($isTemporary)), __LINE__);
        }
        $this->IsTemporary = $isTemporary;
        return $this;
    }
    /**
     * Get RelationshipId value
     * @return string|null
     */
    public function getRelationshipId()
    {
        return $this->RelationshipId;
    }
    /**
     * Set RelationshipId value
     * @param string $relationshipId
     * @return \patest\StructType\SendRelationshipInvitation_Response
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        $this->RelationshipId = $relationshipId;
        return $this;
    }
}
