<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendRelationshipInvitation-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SendRelationshipInvitation-Request
 * @subpackage Structs
 */
class SendRelationshipInvitation_Request extends AbstractStructBase
{
    /**
     * The AcceptUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AcceptUrl;
    /**
     * The InviteeClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InviteeClientId;
    /**
     * The InviteeClientRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InviteeClientRoleId;
    /**
     * The InviteeEmailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InviteeEmailAddress;
    /**
     * The InvitingClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvitingClientId;
    /**
     * The InvitingClientRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvitingClientRoleId;
    /**
     * The RejectUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RejectUrl;
    /**
     * The RelationshipTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipTypeId;
    /**
     * Constructor method for SendRelationshipInvitation-Request
     * @uses SendRelationshipInvitation_Request::setAcceptUrl()
     * @uses SendRelationshipInvitation_Request::setInviteeClientId()
     * @uses SendRelationshipInvitation_Request::setInviteeClientRoleId()
     * @uses SendRelationshipInvitation_Request::setInviteeEmailAddress()
     * @uses SendRelationshipInvitation_Request::setInvitingClientId()
     * @uses SendRelationshipInvitation_Request::setInvitingClientRoleId()
     * @uses SendRelationshipInvitation_Request::setRejectUrl()
     * @uses SendRelationshipInvitation_Request::setRelationshipTypeId()
     * @param string $acceptUrl
     * @param string $inviteeClientId
     * @param string $inviteeClientRoleId
     * @param string $inviteeEmailAddress
     * @param string $invitingClientId
     * @param string $invitingClientRoleId
     * @param string $rejectUrl
     * @param string $relationshipTypeId
     */
    public function __construct($acceptUrl = null, $inviteeClientId = null, $inviteeClientRoleId = null, $inviteeEmailAddress = null, $invitingClientId = null, $invitingClientRoleId = null, $rejectUrl = null, $relationshipTypeId = null)
    {
        $this
            ->setAcceptUrl($acceptUrl)
            ->setInviteeClientId($inviteeClientId)
            ->setInviteeClientRoleId($inviteeClientRoleId)
            ->setInviteeEmailAddress($inviteeEmailAddress)
            ->setInvitingClientId($invitingClientId)
            ->setInvitingClientRoleId($invitingClientRoleId)
            ->setRejectUrl($rejectUrl)
            ->setRelationshipTypeId($relationshipTypeId);
    }
    /**
     * Get AcceptUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcceptUrl()
    {
        return isset($this->AcceptUrl) ? $this->AcceptUrl : null;
    }
    /**
     * Set AcceptUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acceptUrl
     * @return \patest\StructType\SendRelationshipInvitation_Request
     */
    public function setAcceptUrl($acceptUrl = null)
    {
        // validation for constraint: string
        if (!is_null($acceptUrl) && !is_string($acceptUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptUrl, true), gettype($acceptUrl)), __LINE__);
        }
        if (is_null($acceptUrl) || (is_array($acceptUrl) && empty($acceptUrl))) {
            unset($this->AcceptUrl);
        } else {
            $this->AcceptUrl = $acceptUrl;
        }
        return $this;
    }
    /**
     * Get InviteeClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInviteeClientId()
    {
        return isset($this->InviteeClientId) ? $this->InviteeClientId : null;
    }
    /**
     * Set InviteeClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inviteeClientId
     * @return \patest\StructType\SendRelationshipInvitation_Request
     */
    public function setInviteeClientId($inviteeClientId = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeClientId) && !is_string($inviteeClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeClientId, true), gettype($inviteeClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inviteeClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inviteeClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inviteeClientId, true)), __LINE__);
        }
        if (is_null($inviteeClientId) || (is_array($inviteeClientId) && empty($inviteeClientId))) {
            unset($this->InviteeClientId);
        } else {
            $this->InviteeClientId = $inviteeClientId;
        }
        return $this;
    }
    /**
     * Get InviteeClientRoleId value
     * @return string|null
     */
    public function getInviteeClientRoleId()
    {
        return $this->InviteeClientRoleId;
    }
    /**
     * Set InviteeClientRoleId value
     * @param string $inviteeClientRoleId
     * @return \patest\StructType\SendRelationshipInvitation_Request
     */
    public function setInviteeClientRoleId($inviteeClientRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeClientRoleId) && !is_string($inviteeClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeClientRoleId, true), gettype($inviteeClientRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inviteeClientRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inviteeClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inviteeClientRoleId, true)), __LINE__);
        }
        $this->InviteeClientRoleId = $inviteeClientRoleId;
        return $this;
    }
    /**
     * Get InviteeEmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInviteeEmailAddress()
    {
        return isset($this->InviteeEmailAddress) ? $this->InviteeEmailAddress : null;
    }
    /**
     * Set InviteeEmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inviteeEmailAddress
     * @return \patest\StructType\SendRelationshipInvitation_Request
     */
    public function setInviteeEmailAddress($inviteeEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeEmailAddress) && !is_string($inviteeEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeEmailAddress, true), gettype($inviteeEmailAddress)), __LINE__);
        }
        if (is_null($inviteeEmailAddress) || (is_array($inviteeEmailAddress) && empty($inviteeEmailAddress))) {
            unset($this->InviteeEmailAddress);
        } else {
            $this->InviteeEmailAddress = $inviteeEmailAddress;
        }
        return $this;
    }
    /**
     * Get InvitingClientId value
     * @return string|null
     */
    public function getInvitingClientId()
    {
        return $this->InvitingClientId;
    }
    /**
     * Set InvitingClientId value
     * @param string $invitingClientId
     * @return \patest\StructType\SendRelationshipInvitation_Request
     */
    public function setInvitingClientId($invitingClientId = null)
    {
        // validation for constraint: string
        if (!is_null($invitingClientId) && !is_string($invitingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invitingClientId, true), gettype($invitingClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invitingClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invitingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invitingClientId, true)), __LINE__);
        }
        $this->InvitingClientId = $invitingClientId;
        return $this;
    }
    /**
     * Get InvitingClientRoleId value
     * @return string|null
     */
    public function getInvitingClientRoleId()
    {
        return $this->InvitingClientRoleId;
    }
    /**
     * Set InvitingClientRoleId value
     * @param string $invitingClientRoleId
     * @return \patest\StructType\SendRelationshipInvitation_Request
     */
    public function setInvitingClientRoleId($invitingClientRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($invitingClientRoleId) && !is_string($invitingClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invitingClientRoleId, true), gettype($invitingClientRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invitingClientRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invitingClientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invitingClientRoleId, true)), __LINE__);
        }
        $this->InvitingClientRoleId = $invitingClientRoleId;
        return $this;
    }
    /**
     * Get RejectUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRejectUrl()
    {
        return isset($this->RejectUrl) ? $this->RejectUrl : null;
    }
    /**
     * Set RejectUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rejectUrl
     * @return \patest\StructType\SendRelationshipInvitation_Request
     */
    public function setRejectUrl($rejectUrl = null)
    {
        // validation for constraint: string
        if (!is_null($rejectUrl) && !is_string($rejectUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectUrl, true), gettype($rejectUrl)), __LINE__);
        }
        if (is_null($rejectUrl) || (is_array($rejectUrl) && empty($rejectUrl))) {
            unset($this->RejectUrl);
        } else {
            $this->RejectUrl = $rejectUrl;
        }
        return $this;
    }
    /**
     * Get RelationshipTypeId value
     * @return string|null
     */
    public function getRelationshipTypeId()
    {
        return $this->RelationshipTypeId;
    }
    /**
     * Set RelationshipTypeId value
     * @param string $relationshipTypeId
     * @return \patest\StructType\SendRelationshipInvitation_Request
     */
    public function setRelationshipTypeId($relationshipTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipTypeId) && !is_string($relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipTypeId, true), gettype($relationshipTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipTypeId, true)), __LINE__);
        }
        $this->RelationshipTypeId = $relationshipTypeId;
        return $this;
    }
}
