<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendBasketSalesBatchToPrint-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SendBasketSalesBatchToPrint-Request
 * @subpackage Structs
 */
class SendBasketSalesBatchToPrint_Request extends SendToPrintRequestBase
{
    /**
     * The KeepOriginalBarcodesOnReprint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KeepOriginalBarcodesOnReprint;
    /**
     * The Reprint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Reprint;
    /**
     * The Transactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBasketSalesBatchPrintingTransaction
     */
    public $Transactions;
    /**
     * Constructor method for SendBasketSalesBatchToPrint-Request
     * @uses SendBasketSalesBatchToPrint_Request::setKeepOriginalBarcodesOnReprint()
     * @uses SendBasketSalesBatchToPrint_Request::setReprint()
     * @uses SendBasketSalesBatchToPrint_Request::setTransactions()
     * @param bool $keepOriginalBarcodesOnReprint
     * @param bool $reprint
     * @param \patest\ArrayType\ArrayOfBasketSalesBatchPrintingTransaction $transactions
     */
    public function __construct($keepOriginalBarcodesOnReprint = null, $reprint = null, \patest\ArrayType\ArrayOfBasketSalesBatchPrintingTransaction $transactions = null)
    {
        $this
            ->setKeepOriginalBarcodesOnReprint($keepOriginalBarcodesOnReprint)
            ->setReprint($reprint)
            ->setTransactions($transactions);
    }
    /**
     * Get KeepOriginalBarcodesOnReprint value
     * @return bool|null
     */
    public function getKeepOriginalBarcodesOnReprint()
    {
        return $this->KeepOriginalBarcodesOnReprint;
    }
    /**
     * Set KeepOriginalBarcodesOnReprint value
     * @param bool $keepOriginalBarcodesOnReprint
     * @return \patest\StructType\SendBasketSalesBatchToPrint_Request
     */
    public function setKeepOriginalBarcodesOnReprint($keepOriginalBarcodesOnReprint = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepOriginalBarcodesOnReprint) && !is_bool($keepOriginalBarcodesOnReprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepOriginalBarcodesOnReprint, true), gettype($keepOriginalBarcodesOnReprint)), __LINE__);
        }
        $this->KeepOriginalBarcodesOnReprint = $keepOriginalBarcodesOnReprint;
        return $this;
    }
    /**
     * Get Reprint value
     * @return bool|null
     */
    public function getReprint()
    {
        return $this->Reprint;
    }
    /**
     * Set Reprint value
     * @param bool $reprint
     * @return \patest\StructType\SendBasketSalesBatchToPrint_Request
     */
    public function setReprint($reprint = null)
    {
        // validation for constraint: boolean
        if (!is_null($reprint) && !is_bool($reprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reprint, true), gettype($reprint)), __LINE__);
        }
        $this->Reprint = $reprint;
        return $this;
    }
    /**
     * Get Transactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBasketSalesBatchPrintingTransaction|null
     */
    public function getTransactions()
    {
        return isset($this->Transactions) ? $this->Transactions : null;
    }
    /**
     * Set Transactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBasketSalesBatchPrintingTransaction $transactions
     * @return \patest\StructType\SendBasketSalesBatchToPrint_Request
     */
    public function setTransactions(\patest\ArrayType\ArrayOfBasketSalesBatchPrintingTransaction $transactions = null)
    {
        if (is_null($transactions) || (is_array($transactions) && empty($transactions))) {
            unset($this->Transactions);
        } else {
            $this->Transactions = $transactions;
        }
        return $this;
    }
}
