<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.UserJournalEntry StructType
 * @subpackage Structs
 */
class Security_UserJournalEntry extends AnyEntity
{
    /**
     * The AccessPermissions
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccessPermissions;
    /**
     * The ApplicationChannelName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannelName;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The ClientSessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientSessionId;
    /**
     * The ConnectionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConnectionAuditId;
    /**
     * The ContextId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextId;
    /**
     * The CorrelationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CorrelationId;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTime;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $Duration;
    /**
     * The ErrorDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorDescription;
    /**
     * The EventDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDescription;
    /**
     * The EventSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventSystemName;
    /**
     * The EventType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventType;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExtraInfo
     */
    public $ExtraInfo;
    /**
     * The FromCache
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FromCache;
    /**
     * The HitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HitName;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Importance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Importance;
    /**
     * The JournalSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JournalSystemName;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PrimaryEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrimaryEntityId;
    /**
     * The PrimaryEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryEntityName;
    /**
     * The RequestXml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestXml;
    /**
     * The ResponseXml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseXml;
    /**
     * The SalePointName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalePointName;
    /**
     * The SecondaryEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecondaryEntityId;
    /**
     * The SecondaryEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondaryEntityName;
    /**
     * The SecurityTokenName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityTokenName;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteName;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCode;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Success;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for Security.UserJournalEntry
     * @uses Security_UserJournalEntry::setAccessPermissions()
     * @uses Security_UserJournalEntry::setApplicationChannelName()
     * @uses Security_UserJournalEntry::setClientName()
     * @uses Security_UserJournalEntry::setClientSessionId()
     * @uses Security_UserJournalEntry::setConnectionAuditId()
     * @uses Security_UserJournalEntry::setContextId()
     * @uses Security_UserJournalEntry::setCorrelationId()
     * @uses Security_UserJournalEntry::setDateTime()
     * @uses Security_UserJournalEntry::setDuration()
     * @uses Security_UserJournalEntry::setErrorDescription()
     * @uses Security_UserJournalEntry::setEventDescription()
     * @uses Security_UserJournalEntry::setEventSystemName()
     * @uses Security_UserJournalEntry::setEventType()
     * @uses Security_UserJournalEntry::setExtraInfo()
     * @uses Security_UserJournalEntry::setFromCache()
     * @uses Security_UserJournalEntry::setHitName()
     * @uses Security_UserJournalEntry::setHolderTenantId()
     * @uses Security_UserJournalEntry::setId()
     * @uses Security_UserJournalEntry::setImportance()
     * @uses Security_UserJournalEntry::setJournalSystemName()
     * @uses Security_UserJournalEntry::setLocalId()
     * @uses Security_UserJournalEntry::setOrganizationUnitId()
     * @uses Security_UserJournalEntry::setPrimaryEntityId()
     * @uses Security_UserJournalEntry::setPrimaryEntityName()
     * @uses Security_UserJournalEntry::setRequestXml()
     * @uses Security_UserJournalEntry::setResponseXml()
     * @uses Security_UserJournalEntry::setSalePointName()
     * @uses Security_UserJournalEntry::setSecondaryEntityId()
     * @uses Security_UserJournalEntry::setSecondaryEntityName()
     * @uses Security_UserJournalEntry::setSecurityTokenName()
     * @uses Security_UserJournalEntry::setSiteName()
     * @uses Security_UserJournalEntry::setStatusCode()
     * @uses Security_UserJournalEntry::setSuccess()
     * @uses Security_UserJournalEntry::setUserId()
     * @uses Security_UserJournalEntry::setUserName()
     * @param string[] $accessPermissions
     * @param string $applicationChannelName
     * @param string $clientName
     * @param string $clientSessionId
     * @param int $connectionAuditId
     * @param string $contextId
     * @param string $correlationId
     * @param string $dateTime
     * @param string $duration
     * @param string $errorDescription
     * @param string $eventDescription
     * @param string $eventSystemName
     * @param string $eventType
     * @param \patest\StructType\ExtraInfo $extraInfo
     * @param bool $fromCache
     * @param string $hitName
     * @param int $holderTenantId
     * @param string $id
     * @param string $importance
     * @param string $journalSystemName
     * @param int $localId
     * @param string $organizationUnitId
     * @param string $primaryEntityId
     * @param string $primaryEntityName
     * @param string $requestXml
     * @param string $responseXml
     * @param string $salePointName
     * @param string $secondaryEntityId
     * @param string $secondaryEntityName
     * @param string $securityTokenName
     * @param string $siteName
     * @param string $statusCode
     * @param bool $success
     * @param string $userId
     * @param string $userName
     */
    public function __construct(array $accessPermissions = array(), $applicationChannelName = null, $clientName = null, $clientSessionId = null, $connectionAuditId = null, $contextId = null, $correlationId = null, $dateTime = null, $duration = null, $errorDescription = null, $eventDescription = null, $eventSystemName = null, $eventType = null, \patest\StructType\ExtraInfo $extraInfo = null, $fromCache = null, $hitName = null, $holderTenantId = null, $id = null, $importance = null, $journalSystemName = null, $localId = null, $organizationUnitId = null, $primaryEntityId = null, $primaryEntityName = null, $requestXml = null, $responseXml = null, $salePointName = null, $secondaryEntityId = null, $secondaryEntityName = null, $securityTokenName = null, $siteName = null, $statusCode = null, $success = null, $userId = null, $userName = null)
    {
        $this
            ->setAccessPermissions($accessPermissions)
            ->setApplicationChannelName($applicationChannelName)
            ->setClientName($clientName)
            ->setClientSessionId($clientSessionId)
            ->setConnectionAuditId($connectionAuditId)
            ->setContextId($contextId)
            ->setCorrelationId($correlationId)
            ->setDateTime($dateTime)
            ->setDuration($duration)
            ->setErrorDescription($errorDescription)
            ->setEventDescription($eventDescription)
            ->setEventSystemName($eventSystemName)
            ->setEventType($eventType)
            ->setExtraInfo($extraInfo)
            ->setFromCache($fromCache)
            ->setHitName($hitName)
            ->setHolderTenantId($holderTenantId)
            ->setId($id)
            ->setImportance($importance)
            ->setJournalSystemName($journalSystemName)
            ->setLocalId($localId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPrimaryEntityId($primaryEntityId)
            ->setPrimaryEntityName($primaryEntityName)
            ->setRequestXml($requestXml)
            ->setResponseXml($responseXml)
            ->setSalePointName($salePointName)
            ->setSecondaryEntityId($secondaryEntityId)
            ->setSecondaryEntityName($secondaryEntityName)
            ->setSecurityTokenName($securityTokenName)
            ->setSiteName($siteName)
            ->setStatusCode($statusCode)
            ->setSuccess($success)
            ->setUserId($userId)
            ->setUserName($userName);
    }
    /**
     * Get AccessPermissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccessPermissions()
    {
        return isset($this->AccessPermissions) ? $this->AccessPermissions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessPermissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessPermissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $security_UserJournalEntryAccessPermissionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EntityAccessPermission::valueIsValid($security_UserJournalEntryAccessPermissionsItem)) {
                $invalidValues[] = is_object($security_UserJournalEntryAccessPermissionsItem) ? get_class($security_UserJournalEntryAccessPermissionsItem) : sprintf('%s(%s)', gettype($security_UserJournalEntryAccessPermissionsItem), var_export($security_UserJournalEntryAccessPermissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EntityAccessPermission', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EntityAccessPermission::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessPermissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EntityAccessPermission::valueIsValid()
     * @uses \patest\EnumType\EntityAccessPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessPermissions
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setAccessPermissions(array $accessPermissions = array())
    {
        // validation for constraint: list
        if ('' !== ($accessPermissionsArrayErrorMessage = self::validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions($accessPermissions))) {
            throw new \InvalidArgumentException($accessPermissionsArrayErrorMessage, __LINE__);
        }
        if (is_null($accessPermissions) || (is_array($accessPermissions) && empty($accessPermissions))) {
            unset($this->AccessPermissions);
        } else {
            $this->AccessPermissions = is_array($accessPermissions) ? implode(' ', $accessPermissions) : null;
        }
        return $this;
    }
    /**
     * Get ApplicationChannelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannelName()
    {
        return isset($this->ApplicationChannelName) ? $this->ApplicationChannelName : null;
    }
    /**
     * Set ApplicationChannelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannelName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setApplicationChannelName($applicationChannelName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannelName) && !is_string($applicationChannelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannelName, true), gettype($applicationChannelName)), __LINE__);
        }
        if (is_null($applicationChannelName) || (is_array($applicationChannelName) && empty($applicationChannelName))) {
            unset($this->ApplicationChannelName);
        } else {
            $this->ApplicationChannelName = $applicationChannelName;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get ClientSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientSessionId()
    {
        return isset($this->ClientSessionId) ? $this->ClientSessionId : null;
    }
    /**
     * Set ClientSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientSessionId
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setClientSessionId($clientSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($clientSessionId) && !is_string($clientSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientSessionId, true), gettype($clientSessionId)), __LINE__);
        }
        if (is_null($clientSessionId) || (is_array($clientSessionId) && empty($clientSessionId))) {
            unset($this->ClientSessionId);
        } else {
            $this->ClientSessionId = $clientSessionId;
        }
        return $this;
    }
    /**
     * Get ConnectionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConnectionAuditId()
    {
        return isset($this->ConnectionAuditId) ? $this->ConnectionAuditId : null;
    }
    /**
     * Set ConnectionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $connectionAuditId
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setConnectionAuditId($connectionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($connectionAuditId) && !(is_int($connectionAuditId) || ctype_digit($connectionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectionAuditId, true), gettype($connectionAuditId)), __LINE__);
        }
        if (is_null($connectionAuditId) || (is_array($connectionAuditId) && empty($connectionAuditId))) {
            unset($this->ConnectionAuditId);
        } else {
            $this->ConnectionAuditId = $connectionAuditId;
        }
        return $this;
    }
    /**
     * Get ContextId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextId()
    {
        return isset($this->ContextId) ? $this->ContextId : null;
    }
    /**
     * Set ContextId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextId
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setContextId($contextId = null)
    {
        // validation for constraint: string
        if (!is_null($contextId) && !is_string($contextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextId, true), gettype($contextId)), __LINE__);
        }
        if (is_null($contextId) || (is_array($contextId) && empty($contextId))) {
            unset($this->ContextId);
        } else {
            $this->ContextId = $contextId;
        }
        return $this;
    }
    /**
     * Get CorrelationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCorrelationId()
    {
        return isset($this->CorrelationId) ? $this->CorrelationId : null;
    }
    /**
     * Set CorrelationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $correlationId
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setCorrelationId($correlationId = null)
    {
        // validation for constraint: string
        if (!is_null($correlationId) && !is_string($correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationId, true), gettype($correlationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($correlationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($correlationId, true)), __LINE__);
        }
        if (is_null($correlationId) || (is_array($correlationId) && empty($correlationId))) {
            unset($this->CorrelationId);
        } else {
            $this->CorrelationId = $correlationId;
        }
        return $this;
    }
    /**
     * Get DateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTime()
    {
        return isset($this->DateTime) ? $this->DateTime : null;
    }
    /**
     * Set DateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTime
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->DateTime);
        } else {
            $this->DateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $duration
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($duration) && false === mb_strpos($duration, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $duration)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($duration, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($duration) && false !== mb_strpos($duration, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $duration)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($duration, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($duration) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($duration, true)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get ErrorDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorDescription()
    {
        return isset($this->ErrorDescription) ? $this->ErrorDescription : null;
    }
    /**
     * Set ErrorDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorDescription
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setErrorDescription($errorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($errorDescription) && !is_string($errorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorDescription, true), gettype($errorDescription)), __LINE__);
        }
        if (is_null($errorDescription) || (is_array($errorDescription) && empty($errorDescription))) {
            unset($this->ErrorDescription);
        } else {
            $this->ErrorDescription = $errorDescription;
        }
        return $this;
    }
    /**
     * Get EventDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDescription()
    {
        return isset($this->EventDescription) ? $this->EventDescription : null;
    }
    /**
     * Set EventDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDescription
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDescription, true), gettype($eventDescription)), __LINE__);
        }
        if (is_null($eventDescription) || (is_array($eventDescription) && empty($eventDescription))) {
            unset($this->EventDescription);
        } else {
            $this->EventDescription = $eventDescription;
        }
        return $this;
    }
    /**
     * Get EventSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventSystemName()
    {
        return isset($this->EventSystemName) ? $this->EventSystemName : null;
    }
    /**
     * Set EventSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventSystemName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setEventSystemName($eventSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($eventSystemName) && !is_string($eventSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventSystemName, true), gettype($eventSystemName)), __LINE__);
        }
        if (is_null($eventSystemName) || (is_array($eventSystemName) && empty($eventSystemName))) {
            unset($this->EventSystemName);
        } else {
            $this->EventSystemName = $eventSystemName;
        }
        return $this;
    }
    /**
     * Get EventType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType()
    {
        return isset($this->EventType) ? $this->EventType : null;
    }
    /**
     * Set EventType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JournalEventType::valueIsValid()
     * @uses \patest\EnumType\JournalEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventType
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JournalEventType::valueIsValid($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JournalEventType', is_array($eventType) ? implode(', ', $eventType) : var_export($eventType, true), implode(', ', \patest\EnumType\JournalEventType::getValidValues())), __LINE__);
        }
        if (is_null($eventType) || (is_array($eventType) && empty($eventType))) {
            unset($this->EventType);
        } else {
            $this->EventType = $eventType;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExtraInfo|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExtraInfo $extraInfo
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setExtraInfo(\patest\StructType\ExtraInfo $extraInfo = null)
    {
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get FromCache value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFromCache()
    {
        return isset($this->FromCache) ? $this->FromCache : null;
    }
    /**
     * Set FromCache value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fromCache
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setFromCache($fromCache = null)
    {
        // validation for constraint: boolean
        if (!is_null($fromCache) && !is_bool($fromCache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fromCache, true), gettype($fromCache)), __LINE__);
        }
        if (is_null($fromCache) || (is_array($fromCache) && empty($fromCache))) {
            unset($this->FromCache);
        } else {
            $this->FromCache = $fromCache;
        }
        return $this;
    }
    /**
     * Get HitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHitName()
    {
        return isset($this->HitName) ? $this->HitName : null;
    }
    /**
     * Set HitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hitName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setHitName($hitName = null)
    {
        // validation for constraint: string
        if (!is_null($hitName) && !is_string($hitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hitName, true), gettype($hitName)), __LINE__);
        }
        if (is_null($hitName) || (is_array($hitName) && empty($hitName))) {
            unset($this->HitName);
        } else {
            $this->HitName = $hitName;
        }
        return $this;
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Importance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportance()
    {
        return isset($this->Importance) ? $this->Importance : null;
    }
    /**
     * Set Importance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JournalEntryImportance::valueIsValid()
     * @uses \patest\EnumType\JournalEntryImportance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importance
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setImportance($importance = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JournalEntryImportance::valueIsValid($importance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JournalEntryImportance', is_array($importance) ? implode(', ', $importance) : var_export($importance, true), implode(', ', \patest\EnumType\JournalEntryImportance::getValidValues())), __LINE__);
        }
        if (is_null($importance) || (is_array($importance) && empty($importance))) {
            unset($this->Importance);
        } else {
            $this->Importance = $importance;
        }
        return $this;
    }
    /**
     * Get JournalSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJournalSystemName()
    {
        return isset($this->JournalSystemName) ? $this->JournalSystemName : null;
    }
    /**
     * Set JournalSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $journalSystemName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setJournalSystemName($journalSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($journalSystemName) && !is_string($journalSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journalSystemName, true), gettype($journalSystemName)), __LINE__);
        }
        if (is_null($journalSystemName) || (is_array($journalSystemName) && empty($journalSystemName))) {
            unset($this->JournalSystemName);
        } else {
            $this->JournalSystemName = $journalSystemName;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalId()
    {
        return isset($this->LocalId) ? $this->LocalId : null;
    }
    /**
     * Set LocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localId
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        if (is_null($localId) || (is_array($localId) && empty($localId))) {
            unset($this->LocalId);
        } else {
            $this->LocalId = $localId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PrimaryEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryEntityId()
    {
        return isset($this->PrimaryEntityId) ? $this->PrimaryEntityId : null;
    }
    /**
     * Set PrimaryEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryEntityId
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setPrimaryEntityId($primaryEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($primaryEntityId) && !is_string($primaryEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryEntityId, true), gettype($primaryEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($primaryEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $primaryEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($primaryEntityId, true)), __LINE__);
        }
        if (is_null($primaryEntityId) || (is_array($primaryEntityId) && empty($primaryEntityId))) {
            unset($this->PrimaryEntityId);
        } else {
            $this->PrimaryEntityId = $primaryEntityId;
        }
        return $this;
    }
    /**
     * Get PrimaryEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryEntityName()
    {
        return isset($this->PrimaryEntityName) ? $this->PrimaryEntityName : null;
    }
    /**
     * Set PrimaryEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryEntityName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setPrimaryEntityName($primaryEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($primaryEntityName) && !is_string($primaryEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryEntityName, true), gettype($primaryEntityName)), __LINE__);
        }
        if (is_null($primaryEntityName) || (is_array($primaryEntityName) && empty($primaryEntityName))) {
            unset($this->PrimaryEntityName);
        } else {
            $this->PrimaryEntityName = $primaryEntityName;
        }
        return $this;
    }
    /**
     * Get RequestXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestXml()
    {
        return isset($this->RequestXml) ? $this->RequestXml : null;
    }
    /**
     * Set RequestXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestXml
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setRequestXml($requestXml = null)
    {
        // validation for constraint: string
        if (!is_null($requestXml) && !is_string($requestXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestXml, true), gettype($requestXml)), __LINE__);
        }
        if (is_null($requestXml) || (is_array($requestXml) && empty($requestXml))) {
            unset($this->RequestXml);
        } else {
            $this->RequestXml = $requestXml;
        }
        return $this;
    }
    /**
     * Get ResponseXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseXml()
    {
        return isset($this->ResponseXml) ? $this->ResponseXml : null;
    }
    /**
     * Set ResponseXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseXml
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setResponseXml($responseXml = null)
    {
        // validation for constraint: string
        if (!is_null($responseXml) && !is_string($responseXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseXml, true), gettype($responseXml)), __LINE__);
        }
        if (is_null($responseXml) || (is_array($responseXml) && empty($responseXml))) {
            unset($this->ResponseXml);
        } else {
            $this->ResponseXml = $responseXml;
        }
        return $this;
    }
    /**
     * Get SalePointName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointName()
    {
        return isset($this->SalePointName) ? $this->SalePointName : null;
    }
    /**
     * Set SalePointName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setSalePointName($salePointName = null)
    {
        // validation for constraint: string
        if (!is_null($salePointName) && !is_string($salePointName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointName, true), gettype($salePointName)), __LINE__);
        }
        if (is_null($salePointName) || (is_array($salePointName) && empty($salePointName))) {
            unset($this->SalePointName);
        } else {
            $this->SalePointName = $salePointName;
        }
        return $this;
    }
    /**
     * Get SecondaryEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondaryEntityId()
    {
        return isset($this->SecondaryEntityId) ? $this->SecondaryEntityId : null;
    }
    /**
     * Set SecondaryEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondaryEntityId
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setSecondaryEntityId($secondaryEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryEntityId) && !is_string($secondaryEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryEntityId, true), gettype($secondaryEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($secondaryEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $secondaryEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($secondaryEntityId, true)), __LINE__);
        }
        if (is_null($secondaryEntityId) || (is_array($secondaryEntityId) && empty($secondaryEntityId))) {
            unset($this->SecondaryEntityId);
        } else {
            $this->SecondaryEntityId = $secondaryEntityId;
        }
        return $this;
    }
    /**
     * Get SecondaryEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondaryEntityName()
    {
        return isset($this->SecondaryEntityName) ? $this->SecondaryEntityName : null;
    }
    /**
     * Set SecondaryEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondaryEntityName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setSecondaryEntityName($secondaryEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryEntityName) && !is_string($secondaryEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryEntityName, true), gettype($secondaryEntityName)), __LINE__);
        }
        if (is_null($secondaryEntityName) || (is_array($secondaryEntityName) && empty($secondaryEntityName))) {
            unset($this->SecondaryEntityName);
        } else {
            $this->SecondaryEntityName = $secondaryEntityName;
        }
        return $this;
    }
    /**
     * Get SecurityTokenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenName()
    {
        return isset($this->SecurityTokenName) ? $this->SecurityTokenName : null;
    }
    /**
     * Set SecurityTokenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setSecurityTokenName($securityTokenName = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenName) && !is_string($securityTokenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenName, true), gettype($securityTokenName)), __LINE__);
        }
        if (is_null($securityTokenName) || (is_array($securityTokenName) && empty($securityTokenName))) {
            unset($this->SecurityTokenName);
        } else {
            $this->SecurityTokenName = $securityTokenName;
        }
        return $this;
    }
    /**
     * Get SiteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteName()
    {
        return isset($this->SiteName) ? $this->SiteName : null;
    }
    /**
     * Set SiteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setSiteName($siteName = null)
    {
        // validation for constraint: string
        if (!is_null($siteName) && !is_string($siteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteName, true), gettype($siteName)), __LINE__);
        }
        if (is_null($siteName) || (is_array($siteName) && empty($siteName))) {
            unset($this->SiteName);
        } else {
            $this->SiteName = $siteName;
        }
        return $this;
    }
    /**
     * Get StatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCode()
    {
        return isset($this->StatusCode) ? $this->StatusCode : null;
    }
    /**
     * Set StatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCode
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        if (is_null($statusCode) || (is_array($statusCode) && empty($statusCode))) {
            unset($this->StatusCode);
        } else {
            $this->StatusCode = $statusCode;
        }
        return $this;
    }
    /**
     * Get Success value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * Set Success value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $success
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Security_UserJournalEntry
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
}
