<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.UpdateUserAuthenticationData StructType
 * @subpackage Structs
 */
class Security_UpdateUserAuthenticationData extends AnyEntity
{
    /**
     * The ConnectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ConnectorId;
    /**
     * The ConnectorReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConnectorReferenceId;
    /**
     * The ExternalUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalUserId;
    /**
     * The OTPBruteForceAttempts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OTPBruteForceAttempts;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The UserLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserLogin;
    /**
     * Constructor method for Security.UpdateUserAuthenticationData
     * @uses Security_UpdateUserAuthenticationData::setConnectorId()
     * @uses Security_UpdateUserAuthenticationData::setConnectorReferenceId()
     * @uses Security_UpdateUserAuthenticationData::setExternalUserId()
     * @uses Security_UpdateUserAuthenticationData::setOTPBruteForceAttempts()
     * @uses Security_UpdateUserAuthenticationData::setPassword()
     * @uses Security_UpdateUserAuthenticationData::setUserLogin()
     * @param string $connectorId
     * @param string $connectorReferenceId
     * @param string $externalUserId
     * @param int $oTPBruteForceAttempts
     * @param string $password
     * @param string $userLogin
     */
    public function __construct($connectorId = null, $connectorReferenceId = null, $externalUserId = null, $oTPBruteForceAttempts = null, $password = null, $userLogin = null)
    {
        $this
            ->setConnectorId($connectorId)
            ->setConnectorReferenceId($connectorReferenceId)
            ->setExternalUserId($externalUserId)
            ->setOTPBruteForceAttempts($oTPBruteForceAttempts)
            ->setPassword($password)
            ->setUserLogin($userLogin);
    }
    /**
     * Get ConnectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectorId()
    {
        return isset($this->ConnectorId) ? $this->ConnectorId : null;
    }
    /**
     * Set ConnectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectorId
     * @return \patest\StructType\Security_UpdateUserAuthenticationData
     */
    public function setConnectorId($connectorId = null)
    {
        // validation for constraint: string
        if (!is_null($connectorId) && !is_string($connectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectorId, true), gettype($connectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($connectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $connectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($connectorId, true)), __LINE__);
        }
        if (is_null($connectorId) || (is_array($connectorId) && empty($connectorId))) {
            unset($this->ConnectorId);
        } else {
            $this->ConnectorId = $connectorId;
        }
        return $this;
    }
    /**
     * Get ConnectorReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectorReferenceId()
    {
        return isset($this->ConnectorReferenceId) ? $this->ConnectorReferenceId : null;
    }
    /**
     * Set ConnectorReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectorReferenceId
     * @return \patest\StructType\Security_UpdateUserAuthenticationData
     */
    public function setConnectorReferenceId($connectorReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($connectorReferenceId) && !is_string($connectorReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectorReferenceId, true), gettype($connectorReferenceId)), __LINE__);
        }
        if (is_null($connectorReferenceId) || (is_array($connectorReferenceId) && empty($connectorReferenceId))) {
            unset($this->ConnectorReferenceId);
        } else {
            $this->ConnectorReferenceId = $connectorReferenceId;
        }
        return $this;
    }
    /**
     * Get ExternalUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalUserId()
    {
        return isset($this->ExternalUserId) ? $this->ExternalUserId : null;
    }
    /**
     * Set ExternalUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalUserId
     * @return \patest\StructType\Security_UpdateUserAuthenticationData
     */
    public function setExternalUserId($externalUserId = null)
    {
        // validation for constraint: string
        if (!is_null($externalUserId) && !is_string($externalUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalUserId, true), gettype($externalUserId)), __LINE__);
        }
        if (is_null($externalUserId) || (is_array($externalUserId) && empty($externalUserId))) {
            unset($this->ExternalUserId);
        } else {
            $this->ExternalUserId = $externalUserId;
        }
        return $this;
    }
    /**
     * Get OTPBruteForceAttempts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOTPBruteForceAttempts()
    {
        return isset($this->OTPBruteForceAttempts) ? $this->OTPBruteForceAttempts : null;
    }
    /**
     * Set OTPBruteForceAttempts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $oTPBruteForceAttempts
     * @return \patest\StructType\Security_UpdateUserAuthenticationData
     */
    public function setOTPBruteForceAttempts($oTPBruteForceAttempts = null)
    {
        // validation for constraint: int
        if (!is_null($oTPBruteForceAttempts) && !(is_int($oTPBruteForceAttempts) || ctype_digit($oTPBruteForceAttempts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oTPBruteForceAttempts, true), gettype($oTPBruteForceAttempts)), __LINE__);
        }
        if (is_null($oTPBruteForceAttempts) || (is_array($oTPBruteForceAttempts) && empty($oTPBruteForceAttempts))) {
            unset($this->OTPBruteForceAttempts);
        } else {
            $this->OTPBruteForceAttempts = $oTPBruteForceAttempts;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \patest\StructType\Security_UpdateUserAuthenticationData
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get UserLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLogin()
    {
        return isset($this->UserLogin) ? $this->UserLogin : null;
    }
    /**
     * Set UserLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLogin
     * @return \patest\StructType\Security_UpdateUserAuthenticationData
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLogin, true), gettype($userLogin)), __LINE__);
        }
        if (is_null($userLogin) || (is_array($userLogin) && empty($userLogin))) {
            unset($this->UserLogin);
        } else {
            $this->UserLogin = $userLogin;
        }
        return $this;
    }
}
