<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.SecurityToken StructType
 * @subpackage Structs
 */
class Security_SecurityToken extends PersistableEntity
{
    /**
     * The AllowSellNonAllocatedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowSellNonAllocatedSeats;
    /**
     * The BypassSubscriptionPriceLevelEnfrcement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BypassSubscriptionPriceLevelEnfrcement;
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The CustomerAssociationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerAssociationId;
    /**
     * The DefaultAccessRules
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSecurity_SecurityTokenDefaultAccessRules
     */
    public $DefaultAccessRules;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The IsUsedForMakeInventoryAvailableOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUsedForMakeInventoryAvailableOnline;
    /**
     * The LastModifiedAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastModifiedAuditId;
    /**
     * The LastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Security.SecurityToken
     * @uses Security_SecurityToken::setAllowSellNonAllocatedSeats()
     * @uses Security_SecurityToken::setBypassSubscriptionPriceLevelEnfrcement()
     * @uses Security_SecurityToken::setCreationAuditId()
     * @uses Security_SecurityToken::setCreationDate()
     * @uses Security_SecurityToken::setCustomerAssociationId()
     * @uses Security_SecurityToken::setDefaultAccessRules()
     * @uses Security_SecurityToken::setDescription()
     * @uses Security_SecurityToken::setIsActive()
     * @uses Security_SecurityToken::setIsSystem()
     * @uses Security_SecurityToken::setIsUsedForMakeInventoryAvailableOnline()
     * @uses Security_SecurityToken::setLastModifiedAuditId()
     * @uses Security_SecurityToken::setLastModifiedDate()
     * @uses Security_SecurityToken::setName()
     * @uses Security_SecurityToken::setOrganizationUnitId()
     * @uses Security_SecurityToken::setVisibleBySubordinates()
     * @param bool $allowSellNonAllocatedSeats
     * @param bool $bypassSubscriptionPriceLevelEnfrcement
     * @param int $creationAuditId
     * @param string $creationDate
     * @param string $customerAssociationId
     * @param \patest\StructType\RecordSetOfSecurity_SecurityTokenDefaultAccessRules $defaultAccessRules
     * @param string $description
     * @param bool $isActive
     * @param bool $isSystem
     * @param bool $isUsedForMakeInventoryAvailableOnline
     * @param int $lastModifiedAuditId
     * @param string $lastModifiedDate
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param bool $visibleBySubordinates
     */
    public function __construct($allowSellNonAllocatedSeats = null, $bypassSubscriptionPriceLevelEnfrcement = null, $creationAuditId = null, $creationDate = null, $customerAssociationId = null, \patest\StructType\RecordSetOfSecurity_SecurityTokenDefaultAccessRules $defaultAccessRules = null, $description = null, $isActive = null, $isSystem = null, $isUsedForMakeInventoryAvailableOnline = null, $lastModifiedAuditId = null, $lastModifiedDate = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $visibleBySubordinates = null)
    {
        $this
            ->setAllowSellNonAllocatedSeats($allowSellNonAllocatedSeats)
            ->setBypassSubscriptionPriceLevelEnfrcement($bypassSubscriptionPriceLevelEnfrcement)
            ->setCreationAuditId($creationAuditId)
            ->setCreationDate($creationDate)
            ->setCustomerAssociationId($customerAssociationId)
            ->setDefaultAccessRules($defaultAccessRules)
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setIsSystem($isSystem)
            ->setIsUsedForMakeInventoryAvailableOnline($isUsedForMakeInventoryAvailableOnline)
            ->setLastModifiedAuditId($lastModifiedAuditId)
            ->setLastModifiedDate($lastModifiedDate)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AllowSellNonAllocatedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowSellNonAllocatedSeats()
    {
        return isset($this->AllowSellNonAllocatedSeats) ? $this->AllowSellNonAllocatedSeats : null;
    }
    /**
     * Set AllowSellNonAllocatedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowSellNonAllocatedSeats
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setAllowSellNonAllocatedSeats($allowSellNonAllocatedSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSellNonAllocatedSeats) && !is_bool($allowSellNonAllocatedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowSellNonAllocatedSeats, true), gettype($allowSellNonAllocatedSeats)), __LINE__);
        }
        if (is_null($allowSellNonAllocatedSeats) || (is_array($allowSellNonAllocatedSeats) && empty($allowSellNonAllocatedSeats))) {
            unset($this->AllowSellNonAllocatedSeats);
        } else {
            $this->AllowSellNonAllocatedSeats = $allowSellNonAllocatedSeats;
        }
        return $this;
    }
    /**
     * Get BypassSubscriptionPriceLevelEnfrcement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBypassSubscriptionPriceLevelEnfrcement()
    {
        return isset($this->BypassSubscriptionPriceLevelEnfrcement) ? $this->BypassSubscriptionPriceLevelEnfrcement : null;
    }
    /**
     * Set BypassSubscriptionPriceLevelEnfrcement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $bypassSubscriptionPriceLevelEnfrcement
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setBypassSubscriptionPriceLevelEnfrcement($bypassSubscriptionPriceLevelEnfrcement = null)
    {
        // validation for constraint: boolean
        if (!is_null($bypassSubscriptionPriceLevelEnfrcement) && !is_bool($bypassSubscriptionPriceLevelEnfrcement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bypassSubscriptionPriceLevelEnfrcement, true), gettype($bypassSubscriptionPriceLevelEnfrcement)), __LINE__);
        }
        if (is_null($bypassSubscriptionPriceLevelEnfrcement) || (is_array($bypassSubscriptionPriceLevelEnfrcement) && empty($bypassSubscriptionPriceLevelEnfrcement))) {
            unset($this->BypassSubscriptionPriceLevelEnfrcement);
        } else {
            $this->BypassSubscriptionPriceLevelEnfrcement = $bypassSubscriptionPriceLevelEnfrcement;
        }
        return $this;
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get CustomerAssociationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerAssociationId()
    {
        return isset($this->CustomerAssociationId) ? $this->CustomerAssociationId : null;
    }
    /**
     * Set CustomerAssociationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerAssociationId
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setCustomerAssociationId($customerAssociationId = null)
    {
        // validation for constraint: string
        if (!is_null($customerAssociationId) && !is_string($customerAssociationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAssociationId, true), gettype($customerAssociationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerAssociationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerAssociationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerAssociationId, true)), __LINE__);
        }
        if (is_null($customerAssociationId) || (is_array($customerAssociationId) && empty($customerAssociationId))) {
            unset($this->CustomerAssociationId);
        } else {
            $this->CustomerAssociationId = $customerAssociationId;
        }
        return $this;
    }
    /**
     * Get DefaultAccessRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSecurity_SecurityTokenDefaultAccessRules|null
     */
    public function getDefaultAccessRules()
    {
        return isset($this->DefaultAccessRules) ? $this->DefaultAccessRules : null;
    }
    /**
     * Set DefaultAccessRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSecurity_SecurityTokenDefaultAccessRules $defaultAccessRules
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setDefaultAccessRules(\patest\StructType\RecordSetOfSecurity_SecurityTokenDefaultAccessRules $defaultAccessRules = null)
    {
        if (is_null($defaultAccessRules) || (is_array($defaultAccessRules) && empty($defaultAccessRules))) {
            unset($this->DefaultAccessRules);
        } else {
            $this->DefaultAccessRules = $defaultAccessRules;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get IsUsedForMakeInventoryAvailableOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUsedForMakeInventoryAvailableOnline()
    {
        return isset($this->IsUsedForMakeInventoryAvailableOnline) ? $this->IsUsedForMakeInventoryAvailableOnline : null;
    }
    /**
     * Set IsUsedForMakeInventoryAvailableOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUsedForMakeInventoryAvailableOnline
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setIsUsedForMakeInventoryAvailableOnline($isUsedForMakeInventoryAvailableOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUsedForMakeInventoryAvailableOnline) && !is_bool($isUsedForMakeInventoryAvailableOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUsedForMakeInventoryAvailableOnline, true), gettype($isUsedForMakeInventoryAvailableOnline)), __LINE__);
        }
        if (is_null($isUsedForMakeInventoryAvailableOnline) || (is_array($isUsedForMakeInventoryAvailableOnline) && empty($isUsedForMakeInventoryAvailableOnline))) {
            unset($this->IsUsedForMakeInventoryAvailableOnline);
        } else {
            $this->IsUsedForMakeInventoryAvailableOnline = $isUsedForMakeInventoryAvailableOnline;
        }
        return $this;
    }
    /**
     * Get LastModifiedAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastModifiedAuditId()
    {
        return isset($this->LastModifiedAuditId) ? $this->LastModifiedAuditId : null;
    }
    /**
     * Set LastModifiedAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastModifiedAuditId
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setLastModifiedAuditId($lastModifiedAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($lastModifiedAuditId) && !(is_int($lastModifiedAuditId) || ctype_digit($lastModifiedAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastModifiedAuditId, true), gettype($lastModifiedAuditId)), __LINE__);
        }
        if (is_null($lastModifiedAuditId) || (is_array($lastModifiedAuditId) && empty($lastModifiedAuditId))) {
            unset($this->LastModifiedAuditId);
        } else {
            $this->LastModifiedAuditId = $lastModifiedAuditId;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Security_SecurityToken
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
