<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.ReportsCompanyParameters StructType
 * @subpackage Structs
 */
class Security_ReportsCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The DisplayLogoInReports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayLogoInReports;
    /**
     * The ImageHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ImageHeight;
    /**
     * The ImagesSizingFit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ImagesSizingFit;
    /**
     * The ImageWidth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ImageWidth;
    /**
     * The LimitCriteriaListDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LimitCriteriaListDisplay;
    /**
     * The ReportMaxRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReportMaxRecords;
    /**
     * The ReportsCloseTillsViewSubsTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReportsCloseTillsViewSubsTickets;
    /**
     * The ReportsPageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportsPageSize;
    /**
     * The SeasonalTicketsBreakdownInLIAFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeasonalTicketsBreakdownInLIAFrom;
    /**
     * The SeatsInfo_MonthAhead
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatsInfo_MonthAhead;
    /**
     * The SeatsInfo_MonthBack
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatsInfo_MonthBack;
    /**
     * The SuppressZeroValuesInReports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SuppressZeroValuesInReports;
    /**
     * The UsePriceTypeDataSecurity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsePriceTypeDataSecurity;
    /**
     * The WorkInDevMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WorkInDevMode;
    /**
     * Constructor method for Security.ReportsCompanyParameters
     * @uses Security_ReportsCompanyParameters::setDisplayLogoInReports()
     * @uses Security_ReportsCompanyParameters::setImageHeight()
     * @uses Security_ReportsCompanyParameters::setImagesSizingFit()
     * @uses Security_ReportsCompanyParameters::setImageWidth()
     * @uses Security_ReportsCompanyParameters::setLimitCriteriaListDisplay()
     * @uses Security_ReportsCompanyParameters::setReportMaxRecords()
     * @uses Security_ReportsCompanyParameters::setReportsCloseTillsViewSubsTickets()
     * @uses Security_ReportsCompanyParameters::setReportsPageSize()
     * @uses Security_ReportsCompanyParameters::setSeasonalTicketsBreakdownInLIAFrom()
     * @uses Security_ReportsCompanyParameters::setSeatsInfo_MonthAhead()
     * @uses Security_ReportsCompanyParameters::setSeatsInfo_MonthBack()
     * @uses Security_ReportsCompanyParameters::setSuppressZeroValuesInReports()
     * @uses Security_ReportsCompanyParameters::setUsePriceTypeDataSecurity()
     * @uses Security_ReportsCompanyParameters::setWorkInDevMode()
     * @param bool $displayLogoInReports
     * @param int $imageHeight
     * @param bool $imagesSizingFit
     * @param int $imageWidth
     * @param int $limitCriteriaListDisplay
     * @param int $reportMaxRecords
     * @param bool $reportsCloseTillsViewSubsTickets
     * @param string $reportsPageSize
     * @param string $seasonalTicketsBreakdownInLIAFrom
     * @param int $seatsInfo_MonthAhead
     * @param int $seatsInfo_MonthBack
     * @param bool $suppressZeroValuesInReports
     * @param bool $usePriceTypeDataSecurity
     * @param bool $workInDevMode
     */
    public function __construct($displayLogoInReports = null, $imageHeight = null, $imagesSizingFit = null, $imageWidth = null, $limitCriteriaListDisplay = null, $reportMaxRecords = null, $reportsCloseTillsViewSubsTickets = null, $reportsPageSize = null, $seasonalTicketsBreakdownInLIAFrom = null, $seatsInfo_MonthAhead = null, $seatsInfo_MonthBack = null, $suppressZeroValuesInReports = null, $usePriceTypeDataSecurity = null, $workInDevMode = null)
    {
        $this
            ->setDisplayLogoInReports($displayLogoInReports)
            ->setImageHeight($imageHeight)
            ->setImagesSizingFit($imagesSizingFit)
            ->setImageWidth($imageWidth)
            ->setLimitCriteriaListDisplay($limitCriteriaListDisplay)
            ->setReportMaxRecords($reportMaxRecords)
            ->setReportsCloseTillsViewSubsTickets($reportsCloseTillsViewSubsTickets)
            ->setReportsPageSize($reportsPageSize)
            ->setSeasonalTicketsBreakdownInLIAFrom($seasonalTicketsBreakdownInLIAFrom)
            ->setSeatsInfo_MonthAhead($seatsInfo_MonthAhead)
            ->setSeatsInfo_MonthBack($seatsInfo_MonthBack)
            ->setSuppressZeroValuesInReports($suppressZeroValuesInReports)
            ->setUsePriceTypeDataSecurity($usePriceTypeDataSecurity)
            ->setWorkInDevMode($workInDevMode);
    }
    /**
     * Get DisplayLogoInReports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayLogoInReports()
    {
        return isset($this->DisplayLogoInReports) ? $this->DisplayLogoInReports : null;
    }
    /**
     * Set DisplayLogoInReports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayLogoInReports
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setDisplayLogoInReports($displayLogoInReports = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayLogoInReports) && !is_bool($displayLogoInReports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayLogoInReports, true), gettype($displayLogoInReports)), __LINE__);
        }
        if (is_null($displayLogoInReports) || (is_array($displayLogoInReports) && empty($displayLogoInReports))) {
            unset($this->DisplayLogoInReports);
        } else {
            $this->DisplayLogoInReports = $displayLogoInReports;
        }
        return $this;
    }
    /**
     * Get ImageHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getImageHeight()
    {
        return isset($this->ImageHeight) ? $this->ImageHeight : null;
    }
    /**
     * Set ImageHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $imageHeight
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setImageHeight($imageHeight = null)
    {
        // validation for constraint: int
        if (!is_null($imageHeight) && !(is_int($imageHeight) || ctype_digit($imageHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($imageHeight, true), gettype($imageHeight)), __LINE__);
        }
        if (is_null($imageHeight) || (is_array($imageHeight) && empty($imageHeight))) {
            unset($this->ImageHeight);
        } else {
            $this->ImageHeight = $imageHeight;
        }
        return $this;
    }
    /**
     * Get ImagesSizingFit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getImagesSizingFit()
    {
        return isset($this->ImagesSizingFit) ? $this->ImagesSizingFit : null;
    }
    /**
     * Set ImagesSizingFit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $imagesSizingFit
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setImagesSizingFit($imagesSizingFit = null)
    {
        // validation for constraint: boolean
        if (!is_null($imagesSizingFit) && !is_bool($imagesSizingFit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($imagesSizingFit, true), gettype($imagesSizingFit)), __LINE__);
        }
        if (is_null($imagesSizingFit) || (is_array($imagesSizingFit) && empty($imagesSizingFit))) {
            unset($this->ImagesSizingFit);
        } else {
            $this->ImagesSizingFit = $imagesSizingFit;
        }
        return $this;
    }
    /**
     * Get ImageWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getImageWidth()
    {
        return isset($this->ImageWidth) ? $this->ImageWidth : null;
    }
    /**
     * Set ImageWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $imageWidth
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setImageWidth($imageWidth = null)
    {
        // validation for constraint: int
        if (!is_null($imageWidth) && !(is_int($imageWidth) || ctype_digit($imageWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($imageWidth, true), gettype($imageWidth)), __LINE__);
        }
        if (is_null($imageWidth) || (is_array($imageWidth) && empty($imageWidth))) {
            unset($this->ImageWidth);
        } else {
            $this->ImageWidth = $imageWidth;
        }
        return $this;
    }
    /**
     * Get LimitCriteriaListDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLimitCriteriaListDisplay()
    {
        return isset($this->LimitCriteriaListDisplay) ? $this->LimitCriteriaListDisplay : null;
    }
    /**
     * Set LimitCriteriaListDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $limitCriteriaListDisplay
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setLimitCriteriaListDisplay($limitCriteriaListDisplay = null)
    {
        // validation for constraint: int
        if (!is_null($limitCriteriaListDisplay) && !(is_int($limitCriteriaListDisplay) || ctype_digit($limitCriteriaListDisplay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limitCriteriaListDisplay, true), gettype($limitCriteriaListDisplay)), __LINE__);
        }
        if (is_null($limitCriteriaListDisplay) || (is_array($limitCriteriaListDisplay) && empty($limitCriteriaListDisplay))) {
            unset($this->LimitCriteriaListDisplay);
        } else {
            $this->LimitCriteriaListDisplay = $limitCriteriaListDisplay;
        }
        return $this;
    }
    /**
     * Get ReportMaxRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReportMaxRecords()
    {
        return isset($this->ReportMaxRecords) ? $this->ReportMaxRecords : null;
    }
    /**
     * Set ReportMaxRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reportMaxRecords
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setReportMaxRecords($reportMaxRecords = null)
    {
        // validation for constraint: int
        if (!is_null($reportMaxRecords) && !(is_int($reportMaxRecords) || ctype_digit($reportMaxRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reportMaxRecords, true), gettype($reportMaxRecords)), __LINE__);
        }
        if (is_null($reportMaxRecords) || (is_array($reportMaxRecords) && empty($reportMaxRecords))) {
            unset($this->ReportMaxRecords);
        } else {
            $this->ReportMaxRecords = $reportMaxRecords;
        }
        return $this;
    }
    /**
     * Get ReportsCloseTillsViewSubsTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReportsCloseTillsViewSubsTickets()
    {
        return isset($this->ReportsCloseTillsViewSubsTickets) ? $this->ReportsCloseTillsViewSubsTickets : null;
    }
    /**
     * Set ReportsCloseTillsViewSubsTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reportsCloseTillsViewSubsTickets
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setReportsCloseTillsViewSubsTickets($reportsCloseTillsViewSubsTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($reportsCloseTillsViewSubsTickets) && !is_bool($reportsCloseTillsViewSubsTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reportsCloseTillsViewSubsTickets, true), gettype($reportsCloseTillsViewSubsTickets)), __LINE__);
        }
        if (is_null($reportsCloseTillsViewSubsTickets) || (is_array($reportsCloseTillsViewSubsTickets) && empty($reportsCloseTillsViewSubsTickets))) {
            unset($this->ReportsCloseTillsViewSubsTickets);
        } else {
            $this->ReportsCloseTillsViewSubsTickets = $reportsCloseTillsViewSubsTickets;
        }
        return $this;
    }
    /**
     * Get ReportsPageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportsPageSize()
    {
        return isset($this->ReportsPageSize) ? $this->ReportsPageSize : null;
    }
    /**
     * Set ReportsPageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportsPageSize::valueIsValid()
     * @uses \patest\EnumType\ReportsPageSize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reportsPageSize
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setReportsPageSize($reportsPageSize = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportsPageSize::valueIsValid($reportsPageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportsPageSize', is_array($reportsPageSize) ? implode(', ', $reportsPageSize) : var_export($reportsPageSize, true), implode(', ', \patest\EnumType\ReportsPageSize::getValidValues())), __LINE__);
        }
        if (is_null($reportsPageSize) || (is_array($reportsPageSize) && empty($reportsPageSize))) {
            unset($this->ReportsPageSize);
        } else {
            $this->ReportsPageSize = $reportsPageSize;
        }
        return $this;
    }
    /**
     * Get SeasonalTicketsBreakdownInLIAFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonalTicketsBreakdownInLIAFrom()
    {
        return isset($this->SeasonalTicketsBreakdownInLIAFrom) ? $this->SeasonalTicketsBreakdownInLIAFrom : null;
    }
    /**
     * Set SeasonalTicketsBreakdownInLIAFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonalTicketsBreakdownInLIAFrom
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setSeasonalTicketsBreakdownInLIAFrom($seasonalTicketsBreakdownInLIAFrom = null)
    {
        // validation for constraint: string
        if (!is_null($seasonalTicketsBreakdownInLIAFrom) && !is_string($seasonalTicketsBreakdownInLIAFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonalTicketsBreakdownInLIAFrom, true), gettype($seasonalTicketsBreakdownInLIAFrom)), __LINE__);
        }
        if (is_null($seasonalTicketsBreakdownInLIAFrom) || (is_array($seasonalTicketsBreakdownInLIAFrom) && empty($seasonalTicketsBreakdownInLIAFrom))) {
            unset($this->SeasonalTicketsBreakdownInLIAFrom);
        } else {
            $this->SeasonalTicketsBreakdownInLIAFrom = $seasonalTicketsBreakdownInLIAFrom;
        }
        return $this;
    }
    /**
     * Get SeatsInfo_MonthAhead value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatsInfo_MonthAhead()
    {
        return isset($this->SeatsInfo_MonthAhead) ? $this->SeatsInfo_MonthAhead : null;
    }
    /**
     * Set SeatsInfo_MonthAhead value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatsInfo_MonthAhead
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setSeatsInfo_MonthAhead($seatsInfo_MonthAhead = null)
    {
        // validation for constraint: int
        if (!is_null($seatsInfo_MonthAhead) && !(is_int($seatsInfo_MonthAhead) || ctype_digit($seatsInfo_MonthAhead))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatsInfo_MonthAhead, true), gettype($seatsInfo_MonthAhead)), __LINE__);
        }
        if (is_null($seatsInfo_MonthAhead) || (is_array($seatsInfo_MonthAhead) && empty($seatsInfo_MonthAhead))) {
            unset($this->SeatsInfo_MonthAhead);
        } else {
            $this->SeatsInfo_MonthAhead = $seatsInfo_MonthAhead;
        }
        return $this;
    }
    /**
     * Get SeatsInfo_MonthBack value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatsInfo_MonthBack()
    {
        return isset($this->SeatsInfo_MonthBack) ? $this->SeatsInfo_MonthBack : null;
    }
    /**
     * Set SeatsInfo_MonthBack value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatsInfo_MonthBack
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setSeatsInfo_MonthBack($seatsInfo_MonthBack = null)
    {
        // validation for constraint: int
        if (!is_null($seatsInfo_MonthBack) && !(is_int($seatsInfo_MonthBack) || ctype_digit($seatsInfo_MonthBack))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatsInfo_MonthBack, true), gettype($seatsInfo_MonthBack)), __LINE__);
        }
        if (is_null($seatsInfo_MonthBack) || (is_array($seatsInfo_MonthBack) && empty($seatsInfo_MonthBack))) {
            unset($this->SeatsInfo_MonthBack);
        } else {
            $this->SeatsInfo_MonthBack = $seatsInfo_MonthBack;
        }
        return $this;
    }
    /**
     * Get SuppressZeroValuesInReports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSuppressZeroValuesInReports()
    {
        return isset($this->SuppressZeroValuesInReports) ? $this->SuppressZeroValuesInReports : null;
    }
    /**
     * Set SuppressZeroValuesInReports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $suppressZeroValuesInReports
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setSuppressZeroValuesInReports($suppressZeroValuesInReports = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppressZeroValuesInReports) && !is_bool($suppressZeroValuesInReports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($suppressZeroValuesInReports, true), gettype($suppressZeroValuesInReports)), __LINE__);
        }
        if (is_null($suppressZeroValuesInReports) || (is_array($suppressZeroValuesInReports) && empty($suppressZeroValuesInReports))) {
            unset($this->SuppressZeroValuesInReports);
        } else {
            $this->SuppressZeroValuesInReports = $suppressZeroValuesInReports;
        }
        return $this;
    }
    /**
     * Get UsePriceTypeDataSecurity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsePriceTypeDataSecurity()
    {
        return isset($this->UsePriceTypeDataSecurity) ? $this->UsePriceTypeDataSecurity : null;
    }
    /**
     * Set UsePriceTypeDataSecurity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usePriceTypeDataSecurity
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setUsePriceTypeDataSecurity($usePriceTypeDataSecurity = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePriceTypeDataSecurity) && !is_bool($usePriceTypeDataSecurity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePriceTypeDataSecurity, true), gettype($usePriceTypeDataSecurity)), __LINE__);
        }
        if (is_null($usePriceTypeDataSecurity) || (is_array($usePriceTypeDataSecurity) && empty($usePriceTypeDataSecurity))) {
            unset($this->UsePriceTypeDataSecurity);
        } else {
            $this->UsePriceTypeDataSecurity = $usePriceTypeDataSecurity;
        }
        return $this;
    }
    /**
     * Get WorkInDevMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWorkInDevMode()
    {
        return isset($this->WorkInDevMode) ? $this->WorkInDevMode : null;
    }
    /**
     * Set WorkInDevMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $workInDevMode
     * @return \patest\StructType\Security_ReportsCompanyParameters
     */
    public function setWorkInDevMode($workInDevMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($workInDevMode) && !is_bool($workInDevMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($workInDevMode, true), gettype($workInDevMode)), __LINE__);
        }
        if (is_null($workInDevMode) || (is_array($workInDevMode) && empty($workInDevMode))) {
            unset($this->WorkInDevMode);
        } else {
            $this->WorkInDevMode = $workInDevMode;
        }
        return $this;
    }
}
