<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.PeripheralDeviceConfigHintOption StructType
 * @subpackage Structs
 */
class Security_PeripheralDeviceConfigHintOption extends AnyEntity
{
    /**
     * The DeviceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceName;
    /**
     * The OptionTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptionTitle;
    /**
     * The OptionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptionValue;
    /**
     * Constructor method for Security.PeripheralDeviceConfigHintOption
     * @uses Security_PeripheralDeviceConfigHintOption::setDeviceName()
     * @uses Security_PeripheralDeviceConfigHintOption::setOptionTitle()
     * @uses Security_PeripheralDeviceConfigHintOption::setOptionValue()
     * @param string $deviceName
     * @param string $optionTitle
     * @param string $optionValue
     */
    public function __construct($deviceName = null, $optionTitle = null, $optionValue = null)
    {
        $this
            ->setDeviceName($deviceName)
            ->setOptionTitle($optionTitle)
            ->setOptionValue($optionValue);
    }
    /**
     * Get DeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceName()
    {
        return isset($this->DeviceName) ? $this->DeviceName : null;
    }
    /**
     * Set DeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceName
     * @return \patest\StructType\Security_PeripheralDeviceConfigHintOption
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceName, true), gettype($deviceName)), __LINE__);
        }
        if (is_null($deviceName) || (is_array($deviceName) && empty($deviceName))) {
            unset($this->DeviceName);
        } else {
            $this->DeviceName = $deviceName;
        }
        return $this;
    }
    /**
     * Get OptionTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptionTitle()
    {
        return isset($this->OptionTitle) ? $this->OptionTitle : null;
    }
    /**
     * Set OptionTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optionTitle
     * @return \patest\StructType\Security_PeripheralDeviceConfigHintOption
     */
    public function setOptionTitle($optionTitle = null)
    {
        // validation for constraint: string
        if (!is_null($optionTitle) && !is_string($optionTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionTitle, true), gettype($optionTitle)), __LINE__);
        }
        if (is_null($optionTitle) || (is_array($optionTitle) && empty($optionTitle))) {
            unset($this->OptionTitle);
        } else {
            $this->OptionTitle = $optionTitle;
        }
        return $this;
    }
    /**
     * Get OptionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptionValue()
    {
        return isset($this->OptionValue) ? $this->OptionValue : null;
    }
    /**
     * Set OptionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optionValue
     * @return \patest\StructType\Security_PeripheralDeviceConfigHintOption
     */
    public function setOptionValue($optionValue = null)
    {
        // validation for constraint: string
        if (!is_null($optionValue) && !is_string($optionValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionValue, true), gettype($optionValue)), __LINE__);
        }
        if (is_null($optionValue) || (is_array($optionValue) && empty($optionValue))) {
            unset($this->OptionValue);
        } else {
            $this->OptionValue = $optionValue;
        }
        return $this;
    }
}
