<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.OrganizationUnit StructType
 * @subpackage Structs
 */
class Security_OrganizationUnit extends MaintainableNotDistributableEntity
{
    /**
     * The AccountAcquirerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountAcquirerId;
    /**
     * The AccountCrmId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountCrmId;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountId;
    /**
     * The AccountManagerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountManagerId;
    /**
     * The AdminUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Security_NonSystemUser_Internal_ForOrgUnitBasedDataAccessSecurityPolicy
     */
    public $AdminUser;
    /**
     * The AdminUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AdminUserId;
    /**
     * The AncestorIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AncestorIds
     */
    public $AncestorIds;
    /**
     * The Ancestors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ancestors;
    /**
     * The CanHaveSubSellerBranches
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanHaveSubSellerBranches;
    /**
     * The CanHaveSubSellers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanHaveSubSellers;
    /**
     * The CanHaveSubSupplierBranches
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanHaveSubSupplierBranches;
    /**
     * The CanHaveSubSuppliers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanHaveSubSuppliers;
    /**
     * The CanSellParentSupplierProductsOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanSellParentSupplierProductsOnly;
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactId;
    /**
     * The DescendantIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DescendantIds
     */
    public $DescendantIds;
    /**
     * The DistributionPartnerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DistributionPartnerId;
    /**
     * The DomainId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DomainId;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The HasPrivateCompanyParams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasPrivateCompanyParams;
    /**
     * The HasPrivateSeatAttributesDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasPrivateSeatAttributesDisplay;
    /**
     * The HasUnlimitedAccessToSeatingInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasUnlimitedAccessToSeatingInfo;
    /**
     * The HierarchyLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HierarchyLevel;
    /**
     * The InternalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalInfo;
    /**
     * The InternalNodeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InternalNodeId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsBranch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBranch;
    /**
     * The IsInternal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInternal;
    /**
     * The IsMaster
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMaster;
    /**
     * The IsSeller
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSeller;
    /**
     * The IsSupplier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSupplier;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The MainNodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MainNodeId;
    /**
     * The MasterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MasterId;
    /**
     * The ParentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentId;
    /**
     * The PrivateSlug
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrivateSlug;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The UseCompanyIdForPA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseCompanyIdForPA;
    /**
     * The XmlContainer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlContainer;
    /**
     * Constructor method for Security.OrganizationUnit
     * @uses Security_OrganizationUnit::setAccountAcquirerId()
     * @uses Security_OrganizationUnit::setAccountCrmId()
     * @uses Security_OrganizationUnit::setAccountId()
     * @uses Security_OrganizationUnit::setAccountManagerId()
     * @uses Security_OrganizationUnit::setAdminUser()
     * @uses Security_OrganizationUnit::setAdminUserId()
     * @uses Security_OrganizationUnit::setAncestorIds()
     * @uses Security_OrganizationUnit::setAncestors()
     * @uses Security_OrganizationUnit::setCanHaveSubSellerBranches()
     * @uses Security_OrganizationUnit::setCanHaveSubSellers()
     * @uses Security_OrganizationUnit::setCanHaveSubSupplierBranches()
     * @uses Security_OrganizationUnit::setCanHaveSubSuppliers()
     * @uses Security_OrganizationUnit::setCanSellParentSupplierProductsOnly()
     * @uses Security_OrganizationUnit::setContactId()
     * @uses Security_OrganizationUnit::setDescendantIds()
     * @uses Security_OrganizationUnit::setDistributionPartnerId()
     * @uses Security_OrganizationUnit::setDomainId()
     * @uses Security_OrganizationUnit::setExternalId()
     * @uses Security_OrganizationUnit::setHasPrivateCompanyParams()
     * @uses Security_OrganizationUnit::setHasPrivateSeatAttributesDisplay()
     * @uses Security_OrganizationUnit::setHasUnlimitedAccessToSeatingInfo()
     * @uses Security_OrganizationUnit::setHierarchyLevel()
     * @uses Security_OrganizationUnit::setInternalInfo()
     * @uses Security_OrganizationUnit::setInternalNodeId()
     * @uses Security_OrganizationUnit::setIsActive()
     * @uses Security_OrganizationUnit::setIsBranch()
     * @uses Security_OrganizationUnit::setIsInternal()
     * @uses Security_OrganizationUnit::setIsMaster()
     * @uses Security_OrganizationUnit::setIsSeller()
     * @uses Security_OrganizationUnit::setIsSupplier()
     * @uses Security_OrganizationUnit::setIsSystem()
     * @uses Security_OrganizationUnit::setMainNodeId()
     * @uses Security_OrganizationUnit::setMasterId()
     * @uses Security_OrganizationUnit::setParentId()
     * @uses Security_OrganizationUnit::setPrivateSlug()
     * @uses Security_OrganizationUnit::setStatus()
     * @uses Security_OrganizationUnit::setUseCompanyIdForPA()
     * @uses Security_OrganizationUnit::setXmlContainer()
     * @param string $accountAcquirerId
     * @param string $accountCrmId
     * @param string $accountId
     * @param string $accountManagerId
     * @param \patest\StructType\Security_NonSystemUser_Internal_ForOrgUnitBasedDataAccessSecurityPolicy $adminUser
     * @param string $adminUserId
     * @param \patest\StructType\AncestorIds $ancestorIds
     * @param string $ancestors
     * @param bool $canHaveSubSellerBranches
     * @param bool $canHaveSubSellers
     * @param bool $canHaveSubSupplierBranches
     * @param bool $canHaveSubSuppliers
     * @param bool $canSellParentSupplierProductsOnly
     * @param string $contactId
     * @param \patest\StructType\DescendantIds $descendantIds
     * @param int $distributionPartnerId
     * @param int $domainId
     * @param string $externalId
     * @param bool $hasPrivateCompanyParams
     * @param bool $hasPrivateSeatAttributesDisplay
     * @param bool $hasUnlimitedAccessToSeatingInfo
     * @param int $hierarchyLevel
     * @param string $internalInfo
     * @param int $internalNodeId
     * @param bool $isActive
     * @param bool $isBranch
     * @param bool $isInternal
     * @param bool $isMaster
     * @param bool $isSeller
     * @param bool $isSupplier
     * @param bool $isSystem
     * @param string $mainNodeId
     * @param string $masterId
     * @param string $parentId
     * @param string $privateSlug
     * @param string $status
     * @param bool $useCompanyIdForPA
     * @param string $xmlContainer
     */
    public function __construct($accountAcquirerId = null, $accountCrmId = null, $accountId = null, $accountManagerId = null, \patest\StructType\Security_NonSystemUser_Internal_ForOrgUnitBasedDataAccessSecurityPolicy $adminUser = null, $adminUserId = null, \patest\StructType\AncestorIds $ancestorIds = null, $ancestors = null, $canHaveSubSellerBranches = null, $canHaveSubSellers = null, $canHaveSubSupplierBranches = null, $canHaveSubSuppliers = null, $canSellParentSupplierProductsOnly = null, $contactId = null, \patest\StructType\DescendantIds $descendantIds = null, $distributionPartnerId = null, $domainId = null, $externalId = null, $hasPrivateCompanyParams = null, $hasPrivateSeatAttributesDisplay = null, $hasUnlimitedAccessToSeatingInfo = null, $hierarchyLevel = null, $internalInfo = null, $internalNodeId = null, $isActive = null, $isBranch = null, $isInternal = null, $isMaster = null, $isSeller = null, $isSupplier = null, $isSystem = null, $mainNodeId = null, $masterId = null, $parentId = null, $privateSlug = null, $status = null, $useCompanyIdForPA = null, $xmlContainer = null)
    {
        $this
            ->setAccountAcquirerId($accountAcquirerId)
            ->setAccountCrmId($accountCrmId)
            ->setAccountId($accountId)
            ->setAccountManagerId($accountManagerId)
            ->setAdminUser($adminUser)
            ->setAdminUserId($adminUserId)
            ->setAncestorIds($ancestorIds)
            ->setAncestors($ancestors)
            ->setCanHaveSubSellerBranches($canHaveSubSellerBranches)
            ->setCanHaveSubSellers($canHaveSubSellers)
            ->setCanHaveSubSupplierBranches($canHaveSubSupplierBranches)
            ->setCanHaveSubSuppliers($canHaveSubSuppliers)
            ->setCanSellParentSupplierProductsOnly($canSellParentSupplierProductsOnly)
            ->setContactId($contactId)
            ->setDescendantIds($descendantIds)
            ->setDistributionPartnerId($distributionPartnerId)
            ->setDomainId($domainId)
            ->setExternalId($externalId)
            ->setHasPrivateCompanyParams($hasPrivateCompanyParams)
            ->setHasPrivateSeatAttributesDisplay($hasPrivateSeatAttributesDisplay)
            ->setHasUnlimitedAccessToSeatingInfo($hasUnlimitedAccessToSeatingInfo)
            ->setHierarchyLevel($hierarchyLevel)
            ->setInternalInfo($internalInfo)
            ->setInternalNodeId($internalNodeId)
            ->setIsActive($isActive)
            ->setIsBranch($isBranch)
            ->setIsInternal($isInternal)
            ->setIsMaster($isMaster)
            ->setIsSeller($isSeller)
            ->setIsSupplier($isSupplier)
            ->setIsSystem($isSystem)
            ->setMainNodeId($mainNodeId)
            ->setMasterId($masterId)
            ->setParentId($parentId)
            ->setPrivateSlug($privateSlug)
            ->setStatus($status)
            ->setUseCompanyIdForPA($useCompanyIdForPA)
            ->setXmlContainer($xmlContainer);
    }
    /**
     * Get AccountAcquirerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountAcquirerId()
    {
        return isset($this->AccountAcquirerId) ? $this->AccountAcquirerId : null;
    }
    /**
     * Set AccountAcquirerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountAcquirerId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setAccountAcquirerId($accountAcquirerId = null)
    {
        // validation for constraint: string
        if (!is_null($accountAcquirerId) && !is_string($accountAcquirerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountAcquirerId, true), gettype($accountAcquirerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountAcquirerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountAcquirerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountAcquirerId, true)), __LINE__);
        }
        if (is_null($accountAcquirerId) || (is_array($accountAcquirerId) && empty($accountAcquirerId))) {
            unset($this->AccountAcquirerId);
        } else {
            $this->AccountAcquirerId = $accountAcquirerId;
        }
        return $this;
    }
    /**
     * Get AccountCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountCrmId()
    {
        return isset($this->AccountCrmId) ? $this->AccountCrmId : null;
    }
    /**
     * Set AccountCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountCrmId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setAccountCrmId($accountCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($accountCrmId) && !is_string($accountCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCrmId, true), gettype($accountCrmId)), __LINE__);
        }
        if (is_null($accountCrmId) || (is_array($accountCrmId) && empty($accountCrmId))) {
            unset($this->AccountCrmId);
        } else {
            $this->AccountCrmId = $accountCrmId;
        }
        return $this;
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountId, true)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get AccountManagerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountManagerId()
    {
        return isset($this->AccountManagerId) ? $this->AccountManagerId : null;
    }
    /**
     * Set AccountManagerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountManagerId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setAccountManagerId($accountManagerId = null)
    {
        // validation for constraint: string
        if (!is_null($accountManagerId) && !is_string($accountManagerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountManagerId, true), gettype($accountManagerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountManagerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountManagerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountManagerId, true)), __LINE__);
        }
        if (is_null($accountManagerId) || (is_array($accountManagerId) && empty($accountManagerId))) {
            unset($this->AccountManagerId);
        } else {
            $this->AccountManagerId = $accountManagerId;
        }
        return $this;
    }
    /**
     * Get AdminUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Security_NonSystemUser_Internal_ForOrgUnitBasedDataAccessSecurityPolicy|null
     */
    public function getAdminUser()
    {
        return isset($this->AdminUser) ? $this->AdminUser : null;
    }
    /**
     * Set AdminUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Security_NonSystemUser_Internal_ForOrgUnitBasedDataAccessSecurityPolicy $adminUser
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setAdminUser(\patest\StructType\Security_NonSystemUser_Internal_ForOrgUnitBasedDataAccessSecurityPolicy $adminUser = null)
    {
        if (is_null($adminUser) || (is_array($adminUser) && empty($adminUser))) {
            unset($this->AdminUser);
        } else {
            $this->AdminUser = $adminUser;
        }
        return $this;
    }
    /**
     * Get AdminUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdminUserId()
    {
        return isset($this->AdminUserId) ? $this->AdminUserId : null;
    }
    /**
     * Set AdminUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adminUserId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setAdminUserId($adminUserId = null)
    {
        // validation for constraint: string
        if (!is_null($adminUserId) && !is_string($adminUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adminUserId, true), gettype($adminUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($adminUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $adminUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($adminUserId, true)), __LINE__);
        }
        if (is_null($adminUserId) || (is_array($adminUserId) && empty($adminUserId))) {
            unset($this->AdminUserId);
        } else {
            $this->AdminUserId = $adminUserId;
        }
        return $this;
    }
    /**
     * Get AncestorIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AncestorIds|null
     */
    public function getAncestorIds()
    {
        return isset($this->AncestorIds) ? $this->AncestorIds : null;
    }
    /**
     * Set AncestorIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AncestorIds $ancestorIds
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setAncestorIds(\patest\StructType\AncestorIds $ancestorIds = null)
    {
        if (is_null($ancestorIds) || (is_array($ancestorIds) && empty($ancestorIds))) {
            unset($this->AncestorIds);
        } else {
            $this->AncestorIds = $ancestorIds;
        }
        return $this;
    }
    /**
     * Get Ancestors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAncestors()
    {
        return isset($this->Ancestors) ? $this->Ancestors : null;
    }
    /**
     * Set Ancestors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ancestors
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setAncestors($ancestors = null)
    {
        // validation for constraint: string
        if (!is_null($ancestors) && !is_string($ancestors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ancestors, true), gettype($ancestors)), __LINE__);
        }
        if (is_null($ancestors) || (is_array($ancestors) && empty($ancestors))) {
            unset($this->Ancestors);
        } else {
            $this->Ancestors = $ancestors;
        }
        return $this;
    }
    /**
     * Get CanHaveSubSellerBranches value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanHaveSubSellerBranches()
    {
        return isset($this->CanHaveSubSellerBranches) ? $this->CanHaveSubSellerBranches : null;
    }
    /**
     * Set CanHaveSubSellerBranches value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canHaveSubSellerBranches
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setCanHaveSubSellerBranches($canHaveSubSellerBranches = null)
    {
        // validation for constraint: boolean
        if (!is_null($canHaveSubSellerBranches) && !is_bool($canHaveSubSellerBranches)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canHaveSubSellerBranches, true), gettype($canHaveSubSellerBranches)), __LINE__);
        }
        if (is_null($canHaveSubSellerBranches) || (is_array($canHaveSubSellerBranches) && empty($canHaveSubSellerBranches))) {
            unset($this->CanHaveSubSellerBranches);
        } else {
            $this->CanHaveSubSellerBranches = $canHaveSubSellerBranches;
        }
        return $this;
    }
    /**
     * Get CanHaveSubSellers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanHaveSubSellers()
    {
        return isset($this->CanHaveSubSellers) ? $this->CanHaveSubSellers : null;
    }
    /**
     * Set CanHaveSubSellers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canHaveSubSellers
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setCanHaveSubSellers($canHaveSubSellers = null)
    {
        // validation for constraint: boolean
        if (!is_null($canHaveSubSellers) && !is_bool($canHaveSubSellers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canHaveSubSellers, true), gettype($canHaveSubSellers)), __LINE__);
        }
        if (is_null($canHaveSubSellers) || (is_array($canHaveSubSellers) && empty($canHaveSubSellers))) {
            unset($this->CanHaveSubSellers);
        } else {
            $this->CanHaveSubSellers = $canHaveSubSellers;
        }
        return $this;
    }
    /**
     * Get CanHaveSubSupplierBranches value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanHaveSubSupplierBranches()
    {
        return isset($this->CanHaveSubSupplierBranches) ? $this->CanHaveSubSupplierBranches : null;
    }
    /**
     * Set CanHaveSubSupplierBranches value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canHaveSubSupplierBranches
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setCanHaveSubSupplierBranches($canHaveSubSupplierBranches = null)
    {
        // validation for constraint: boolean
        if (!is_null($canHaveSubSupplierBranches) && !is_bool($canHaveSubSupplierBranches)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canHaveSubSupplierBranches, true), gettype($canHaveSubSupplierBranches)), __LINE__);
        }
        if (is_null($canHaveSubSupplierBranches) || (is_array($canHaveSubSupplierBranches) && empty($canHaveSubSupplierBranches))) {
            unset($this->CanHaveSubSupplierBranches);
        } else {
            $this->CanHaveSubSupplierBranches = $canHaveSubSupplierBranches;
        }
        return $this;
    }
    /**
     * Get CanHaveSubSuppliers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanHaveSubSuppliers()
    {
        return isset($this->CanHaveSubSuppliers) ? $this->CanHaveSubSuppliers : null;
    }
    /**
     * Set CanHaveSubSuppliers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canHaveSubSuppliers
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setCanHaveSubSuppliers($canHaveSubSuppliers = null)
    {
        // validation for constraint: boolean
        if (!is_null($canHaveSubSuppliers) && !is_bool($canHaveSubSuppliers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canHaveSubSuppliers, true), gettype($canHaveSubSuppliers)), __LINE__);
        }
        if (is_null($canHaveSubSuppliers) || (is_array($canHaveSubSuppliers) && empty($canHaveSubSuppliers))) {
            unset($this->CanHaveSubSuppliers);
        } else {
            $this->CanHaveSubSuppliers = $canHaveSubSuppliers;
        }
        return $this;
    }
    /**
     * Get CanSellParentSupplierProductsOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanSellParentSupplierProductsOnly()
    {
        return isset($this->CanSellParentSupplierProductsOnly) ? $this->CanSellParentSupplierProductsOnly : null;
    }
    /**
     * Set CanSellParentSupplierProductsOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canSellParentSupplierProductsOnly
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setCanSellParentSupplierProductsOnly($canSellParentSupplierProductsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($canSellParentSupplierProductsOnly) && !is_bool($canSellParentSupplierProductsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canSellParentSupplierProductsOnly, true), gettype($canSellParentSupplierProductsOnly)), __LINE__);
        }
        if (is_null($canSellParentSupplierProductsOnly) || (is_array($canSellParentSupplierProductsOnly) && empty($canSellParentSupplierProductsOnly))) {
            unset($this->CanSellParentSupplierProductsOnly);
        } else {
            $this->CanSellParentSupplierProductsOnly = $canSellParentSupplierProductsOnly;
        }
        return $this;
    }
    /**
     * Get ContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactId()
    {
        return isset($this->ContactId) ? $this->ContactId : null;
    }
    /**
     * Set ContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contactId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contactId, true)), __LINE__);
        }
        if (is_null($contactId) || (is_array($contactId) && empty($contactId))) {
            unset($this->ContactId);
        } else {
            $this->ContactId = $contactId;
        }
        return $this;
    }
    /**
     * Get DescendantIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DescendantIds|null
     */
    public function getDescendantIds()
    {
        return isset($this->DescendantIds) ? $this->DescendantIds : null;
    }
    /**
     * Set DescendantIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DescendantIds $descendantIds
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setDescendantIds(\patest\StructType\DescendantIds $descendantIds = null)
    {
        if (is_null($descendantIds) || (is_array($descendantIds) && empty($descendantIds))) {
            unset($this->DescendantIds);
        } else {
            $this->DescendantIds = $descendantIds;
        }
        return $this;
    }
    /**
     * Get DistributionPartnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDistributionPartnerId()
    {
        return isset($this->DistributionPartnerId) ? $this->DistributionPartnerId : null;
    }
    /**
     * Set DistributionPartnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $distributionPartnerId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setDistributionPartnerId($distributionPartnerId = null)
    {
        // validation for constraint: int
        if (!is_null($distributionPartnerId) && !(is_int($distributionPartnerId) || ctype_digit($distributionPartnerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distributionPartnerId, true), gettype($distributionPartnerId)), __LINE__);
        }
        if (is_null($distributionPartnerId) || (is_array($distributionPartnerId) && empty($distributionPartnerId))) {
            unset($this->DistributionPartnerId);
        } else {
            $this->DistributionPartnerId = $distributionPartnerId;
        }
        return $this;
    }
    /**
     * Get DomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDomainId()
    {
        return isset($this->DomainId) ? $this->DomainId : null;
    }
    /**
     * Set DomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $domainId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setDomainId($domainId = null)
    {
        // validation for constraint: int
        if (!is_null($domainId) && !(is_int($domainId) || ctype_digit($domainId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($domainId, true), gettype($domainId)), __LINE__);
        }
        if (is_null($domainId) || (is_array($domainId) && empty($domainId))) {
            unset($this->DomainId);
        } else {
            $this->DomainId = $domainId;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get HasPrivateCompanyParams value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasPrivateCompanyParams()
    {
        return isset($this->HasPrivateCompanyParams) ? $this->HasPrivateCompanyParams : null;
    }
    /**
     * Set HasPrivateCompanyParams value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasPrivateCompanyParams
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setHasPrivateCompanyParams($hasPrivateCompanyParams = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPrivateCompanyParams) && !is_bool($hasPrivateCompanyParams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPrivateCompanyParams, true), gettype($hasPrivateCompanyParams)), __LINE__);
        }
        if (is_null($hasPrivateCompanyParams) || (is_array($hasPrivateCompanyParams) && empty($hasPrivateCompanyParams))) {
            unset($this->HasPrivateCompanyParams);
        } else {
            $this->HasPrivateCompanyParams = $hasPrivateCompanyParams;
        }
        return $this;
    }
    /**
     * Get HasPrivateSeatAttributesDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasPrivateSeatAttributesDisplay()
    {
        return isset($this->HasPrivateSeatAttributesDisplay) ? $this->HasPrivateSeatAttributesDisplay : null;
    }
    /**
     * Set HasPrivateSeatAttributesDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasPrivateSeatAttributesDisplay
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setHasPrivateSeatAttributesDisplay($hasPrivateSeatAttributesDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPrivateSeatAttributesDisplay) && !is_bool($hasPrivateSeatAttributesDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPrivateSeatAttributesDisplay, true), gettype($hasPrivateSeatAttributesDisplay)), __LINE__);
        }
        if (is_null($hasPrivateSeatAttributesDisplay) || (is_array($hasPrivateSeatAttributesDisplay) && empty($hasPrivateSeatAttributesDisplay))) {
            unset($this->HasPrivateSeatAttributesDisplay);
        } else {
            $this->HasPrivateSeatAttributesDisplay = $hasPrivateSeatAttributesDisplay;
        }
        return $this;
    }
    /**
     * Get HasUnlimitedAccessToSeatingInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasUnlimitedAccessToSeatingInfo()
    {
        return isset($this->HasUnlimitedAccessToSeatingInfo) ? $this->HasUnlimitedAccessToSeatingInfo : null;
    }
    /**
     * Set HasUnlimitedAccessToSeatingInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasUnlimitedAccessToSeatingInfo
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setHasUnlimitedAccessToSeatingInfo($hasUnlimitedAccessToSeatingInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasUnlimitedAccessToSeatingInfo) && !is_bool($hasUnlimitedAccessToSeatingInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasUnlimitedAccessToSeatingInfo, true), gettype($hasUnlimitedAccessToSeatingInfo)), __LINE__);
        }
        if (is_null($hasUnlimitedAccessToSeatingInfo) || (is_array($hasUnlimitedAccessToSeatingInfo) && empty($hasUnlimitedAccessToSeatingInfo))) {
            unset($this->HasUnlimitedAccessToSeatingInfo);
        } else {
            $this->HasUnlimitedAccessToSeatingInfo = $hasUnlimitedAccessToSeatingInfo;
        }
        return $this;
    }
    /**
     * Get HierarchyLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHierarchyLevel()
    {
        return isset($this->HierarchyLevel) ? $this->HierarchyLevel : null;
    }
    /**
     * Set HierarchyLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hierarchyLevel
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setHierarchyLevel($hierarchyLevel = null)
    {
        // validation for constraint: int
        if (!is_null($hierarchyLevel) && !(is_int($hierarchyLevel) || ctype_digit($hierarchyLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hierarchyLevel, true), gettype($hierarchyLevel)), __LINE__);
        }
        if (is_null($hierarchyLevel) || (is_array($hierarchyLevel) && empty($hierarchyLevel))) {
            unset($this->HierarchyLevel);
        } else {
            $this->HierarchyLevel = $hierarchyLevel;
        }
        return $this;
    }
    /**
     * Get InternalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalInfo()
    {
        return isset($this->InternalInfo) ? $this->InternalInfo : null;
    }
    /**
     * Set InternalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalInfo
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setInternalInfo($internalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($internalInfo) && !is_string($internalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalInfo, true), gettype($internalInfo)), __LINE__);
        }
        if (is_null($internalInfo) || (is_array($internalInfo) && empty($internalInfo))) {
            unset($this->InternalInfo);
        } else {
            $this->InternalInfo = $internalInfo;
        }
        return $this;
    }
    /**
     * Get InternalNodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInternalNodeId()
    {
        return isset($this->InternalNodeId) ? $this->InternalNodeId : null;
    }
    /**
     * Set InternalNodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $internalNodeId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setInternalNodeId($internalNodeId = null)
    {
        // validation for constraint: int
        if (!is_null($internalNodeId) && !(is_int($internalNodeId) || ctype_digit($internalNodeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internalNodeId, true), gettype($internalNodeId)), __LINE__);
        }
        if (is_null($internalNodeId) || (is_array($internalNodeId) && empty($internalNodeId))) {
            unset($this->InternalNodeId);
        } else {
            $this->InternalNodeId = $internalNodeId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBranch()
    {
        return isset($this->IsBranch) ? $this->IsBranch : null;
    }
    /**
     * Set IsBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBranch
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setIsBranch($isBranch = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBranch) && !is_bool($isBranch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBranch, true), gettype($isBranch)), __LINE__);
        }
        if (is_null($isBranch) || (is_array($isBranch) && empty($isBranch))) {
            unset($this->IsBranch);
        } else {
            $this->IsBranch = $isBranch;
        }
        return $this;
    }
    /**
     * Get IsInternal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInternal()
    {
        return isset($this->IsInternal) ? $this->IsInternal : null;
    }
    /**
     * Set IsInternal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInternal
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setIsInternal($isInternal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInternal) && !is_bool($isInternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInternal, true), gettype($isInternal)), __LINE__);
        }
        if (is_null($isInternal) || (is_array($isInternal) && empty($isInternal))) {
            unset($this->IsInternal);
        } else {
            $this->IsInternal = $isInternal;
        }
        return $this;
    }
    /**
     * Get IsMaster value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMaster()
    {
        return isset($this->IsMaster) ? $this->IsMaster : null;
    }
    /**
     * Set IsMaster value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMaster
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setIsMaster($isMaster = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMaster) && !is_bool($isMaster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMaster, true), gettype($isMaster)), __LINE__);
        }
        if (is_null($isMaster) || (is_array($isMaster) && empty($isMaster))) {
            unset($this->IsMaster);
        } else {
            $this->IsMaster = $isMaster;
        }
        return $this;
    }
    /**
     * Get IsSeller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSeller()
    {
        return isset($this->IsSeller) ? $this->IsSeller : null;
    }
    /**
     * Set IsSeller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSeller
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setIsSeller($isSeller = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeller) && !is_bool($isSeller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeller, true), gettype($isSeller)), __LINE__);
        }
        if (is_null($isSeller) || (is_array($isSeller) && empty($isSeller))) {
            unset($this->IsSeller);
        } else {
            $this->IsSeller = $isSeller;
        }
        return $this;
    }
    /**
     * Get IsSupplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSupplier()
    {
        return isset($this->IsSupplier) ? $this->IsSupplier : null;
    }
    /**
     * Set IsSupplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSupplier
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setIsSupplier($isSupplier = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupplier) && !is_bool($isSupplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupplier, true), gettype($isSupplier)), __LINE__);
        }
        if (is_null($isSupplier) || (is_array($isSupplier) && empty($isSupplier))) {
            unset($this->IsSupplier);
        } else {
            $this->IsSupplier = $isSupplier;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get MainNodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMainNodeId()
    {
        return isset($this->MainNodeId) ? $this->MainNodeId : null;
    }
    /**
     * Set MainNodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mainNodeId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setMainNodeId($mainNodeId = null)
    {
        // validation for constraint: string
        if (!is_null($mainNodeId) && !is_string($mainNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainNodeId, true), gettype($mainNodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mainNodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mainNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mainNodeId, true)), __LINE__);
        }
        if (is_null($mainNodeId) || (is_array($mainNodeId) && empty($mainNodeId))) {
            unset($this->MainNodeId);
        } else {
            $this->MainNodeId = $mainNodeId;
        }
        return $this;
    }
    /**
     * Get MasterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterId()
    {
        return isset($this->MasterId) ? $this->MasterId : null;
    }
    /**
     * Set MasterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setMasterId($masterId = null)
    {
        // validation for constraint: string
        if (!is_null($masterId) && !is_string($masterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterId, true), gettype($masterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($masterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $masterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($masterId, true)), __LINE__);
        }
        if (is_null($masterId) || (is_array($masterId) && empty($masterId))) {
            unset($this->MasterId);
        } else {
            $this->MasterId = $masterId;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get PrivateSlug value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivateSlug()
    {
        return isset($this->PrivateSlug) ? $this->PrivateSlug : null;
    }
    /**
     * Set PrivateSlug value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $privateSlug
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setPrivateSlug($privateSlug = null)
    {
        // validation for constraint: string
        if (!is_null($privateSlug) && !is_string($privateSlug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privateSlug, true), gettype($privateSlug)), __LINE__);
        }
        if (is_null($privateSlug) || (is_array($privateSlug) && empty($privateSlug))) {
            unset($this->PrivateSlug);
        } else {
            $this->PrivateSlug = $privateSlug;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OrganizationUnitStatus::valueIsValid()
     * @uses \patest\EnumType\OrganizationUnitStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrganizationUnitStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrganizationUnitStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\OrganizationUnitStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get UseCompanyIdForPA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseCompanyIdForPA()
    {
        return isset($this->UseCompanyIdForPA) ? $this->UseCompanyIdForPA : null;
    }
    /**
     * Set UseCompanyIdForPA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useCompanyIdForPA
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setUseCompanyIdForPA($useCompanyIdForPA = null)
    {
        // validation for constraint: boolean
        if (!is_null($useCompanyIdForPA) && !is_bool($useCompanyIdForPA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useCompanyIdForPA, true), gettype($useCompanyIdForPA)), __LINE__);
        }
        if (is_null($useCompanyIdForPA) || (is_array($useCompanyIdForPA) && empty($useCompanyIdForPA))) {
            unset($this->UseCompanyIdForPA);
        } else {
            $this->UseCompanyIdForPA = $useCompanyIdForPA;
        }
        return $this;
    }
    /**
     * Get XmlContainer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlContainer()
    {
        return isset($this->XmlContainer) ? $this->XmlContainer : null;
    }
    /**
     * Set XmlContainer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlContainer
     * @return \patest\StructType\Security_OrganizationUnit
     */
    public function setXmlContainer($xmlContainer = null)
    {
        // validation for constraint: string
        if (!is_null($xmlContainer) && !is_string($xmlContainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlContainer, true), gettype($xmlContainer)), __LINE__);
        }
        if (is_null($xmlContainer) || (is_array($xmlContainer) && empty($xmlContainer))) {
            unset($this->XmlContainer);
        } else {
            $this->XmlContainer = $xmlContainer;
        }
        return $this;
    }
}
