<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.NativeUser StructType
 * @subpackage Structs
 */
class Security_NativeUser extends Security_User
{
    /**
     * The UserTypeFlag
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserTypeFlag;
    /**
     * Constructor method for Security.NativeUser
     * @uses Security_NativeUser::setUserTypeFlag()
     * @param string $userTypeFlag
     */
    public function __construct($userTypeFlag = null)
    {
        $this
            ->setUserTypeFlag($userTypeFlag);
    }
    /**
     * Get UserTypeFlag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserTypeFlag()
    {
        return isset($this->UserTypeFlag) ? $this->UserTypeFlag : null;
    }
    /**
     * Set UserTypeFlag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\UserType::valueIsValid()
     * @uses \patest\EnumType\UserType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userTypeFlag
     * @return \patest\StructType\Security_NativeUser
     */
    public function setUserTypeFlag($userTypeFlag = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\UserType::valueIsValid($userTypeFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UserType', is_array($userTypeFlag) ? implode(', ', $userTypeFlag) : var_export($userTypeFlag, true), implode(', ', \patest\EnumType\UserType::getValidValues())), __LINE__);
        }
        if (is_null($userTypeFlag) || (is_array($userTypeFlag) && empty($userTypeFlag))) {
            unset($this->UserTypeFlag);
        } else {
            $this->UserTypeFlag = $userTypeFlag;
        }
        return $this;
    }
}
