<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.HttpApiParameters StructType
 * @subpackage Structs
 */
class Security_HttpApiParameters extends Security_CompanyParameterBase
{
    /**
     * The PasswordExpirationDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PasswordExpirationDays;
    /**
     * The Secret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Secret;
    /**
     * The SecretPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecretPassword;
    /**
     * The TokenExpirationHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TokenExpirationHours;
    /**
     * Constructor method for Security.HttpApiParameters
     * @uses Security_HttpApiParameters::setPasswordExpirationDays()
     * @uses Security_HttpApiParameters::setSecret()
     * @uses Security_HttpApiParameters::setSecretPassword()
     * @uses Security_HttpApiParameters::setTokenExpirationHours()
     * @param int $passwordExpirationDays
     * @param string $secret
     * @param string $secretPassword
     * @param int $tokenExpirationHours
     */
    public function __construct($passwordExpirationDays = null, $secret = null, $secretPassword = null, $tokenExpirationHours = null)
    {
        $this
            ->setPasswordExpirationDays($passwordExpirationDays)
            ->setSecret($secret)
            ->setSecretPassword($secretPassword)
            ->setTokenExpirationHours($tokenExpirationHours);
    }
    /**
     * Get PasswordExpirationDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPasswordExpirationDays()
    {
        return isset($this->PasswordExpirationDays) ? $this->PasswordExpirationDays : null;
    }
    /**
     * Set PasswordExpirationDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $passwordExpirationDays
     * @return \patest\StructType\Security_HttpApiParameters
     */
    public function setPasswordExpirationDays($passwordExpirationDays = null)
    {
        // validation for constraint: int
        if (!is_null($passwordExpirationDays) && !(is_int($passwordExpirationDays) || ctype_digit($passwordExpirationDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passwordExpirationDays, true), gettype($passwordExpirationDays)), __LINE__);
        }
        if (is_null($passwordExpirationDays) || (is_array($passwordExpirationDays) && empty($passwordExpirationDays))) {
            unset($this->PasswordExpirationDays);
        } else {
            $this->PasswordExpirationDays = $passwordExpirationDays;
        }
        return $this;
    }
    /**
     * Get Secret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecret()
    {
        return isset($this->Secret) ? $this->Secret : null;
    }
    /**
     * Set Secret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secret
     * @return \patest\StructType\Security_HttpApiParameters
     */
    public function setSecret($secret = null)
    {
        // validation for constraint: string
        if (!is_null($secret) && !is_string($secret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secret, true), gettype($secret)), __LINE__);
        }
        if (is_null($secret) || (is_array($secret) && empty($secret))) {
            unset($this->Secret);
        } else {
            $this->Secret = $secret;
        }
        return $this;
    }
    /**
     * Get SecretPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecretPassword()
    {
        return isset($this->SecretPassword) ? $this->SecretPassword : null;
    }
    /**
     * Set SecretPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secretPassword
     * @return \patest\StructType\Security_HttpApiParameters
     */
    public function setSecretPassword($secretPassword = null)
    {
        // validation for constraint: string
        if (!is_null($secretPassword) && !is_string($secretPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secretPassword, true), gettype($secretPassword)), __LINE__);
        }
        if (is_null($secretPassword) || (is_array($secretPassword) && empty($secretPassword))) {
            unset($this->SecretPassword);
        } else {
            $this->SecretPassword = $secretPassword;
        }
        return $this;
    }
    /**
     * Get TokenExpirationHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTokenExpirationHours()
    {
        return isset($this->TokenExpirationHours) ? $this->TokenExpirationHours : null;
    }
    /**
     * Set TokenExpirationHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tokenExpirationHours
     * @return \patest\StructType\Security_HttpApiParameters
     */
    public function setTokenExpirationHours($tokenExpirationHours = null)
    {
        // validation for constraint: int
        if (!is_null($tokenExpirationHours) && !(is_int($tokenExpirationHours) || ctype_digit($tokenExpirationHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tokenExpirationHours, true), gettype($tokenExpirationHours)), __LINE__);
        }
        if (is_null($tokenExpirationHours) || (is_array($tokenExpirationHours) && empty($tokenExpirationHours))) {
            unset($this->TokenExpirationHours);
        } else {
            $this->TokenExpirationHours = $tokenExpirationHours;
        }
        return $this;
    }
}
