<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.GroupSalesCompanyParameters StructType
 * @subpackage Structs
 */
class Security_GroupSalesCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AllocationColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationColor;
    /**
     * The AllowChangeGroupContentAfterBilling
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowChangeGroupContentAfterBilling;
    /**
     * The AllowChangeGroupContentAfterBooking
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowChangeGroupContentAfterBooking;
    /**
     * The AllowChangeVisitPricingAfterBilling
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowChangeVisitPricingAfterBilling;
    /**
     * The AssignGuidesAtBooking
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AssignGuidesAtBooking;
    /**
     * The BookingColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingColor;
    /**
     * The CalendarHourResolution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CalendarHourResolution;
    /**
     * The DailyViewStartHour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DailyViewStartHour;
    /**
     * The DefaultBookingTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultBookingTime;
    /**
     * The DefaultCalendarView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultCalendarView;
    /**
     * The DefaultPriceTypeForPrivateOrder
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultPriceTypeForPrivateOrder;
    /**
     * The DefaultPriceTypeForSchoolOrder
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultPriceTypeForSchoolOrder;
    /**
     * The DisplayEventsAndHallsInCalendar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayEventsAndHallsInCalendar;
    /**
     * The EventColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventColor;
    /**
     * The GroupPriceTypeForEvent
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupPriceTypeForEvent;
    /**
     * The IntermissionBetweenActivities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IntermissionBetweenActivities;
    /**
     * The LatestOrderVisitBookingTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LatestOrderVisitBookingTime;
    /**
     * The MaxIntermissionOffset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxIntermissionOffset;
    /**
     * The MaxOrderVisitsPerDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxOrderVisitsPerDay;
    /**
     * The OffsetBetweenParallelActivities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OffsetBetweenParallelActivities;
    /**
     * The PreventBookingIfGuideAssignmentFailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreventBookingIfGuideAssignmentFailed;
    /**
     * The ProposalExpiresInDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProposalExpiresInDays;
    /**
     * The SchoolYearStartMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SchoolYearStartMonth;
    /**
     * The UnavailableColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnavailableColor;
    /**
     * Constructor method for Security.GroupSalesCompanyParameters
     * @uses Security_GroupSalesCompanyParameters::setAllocationColor()
     * @uses Security_GroupSalesCompanyParameters::setAllowChangeGroupContentAfterBilling()
     * @uses Security_GroupSalesCompanyParameters::setAllowChangeGroupContentAfterBooking()
     * @uses Security_GroupSalesCompanyParameters::setAllowChangeVisitPricingAfterBilling()
     * @uses Security_GroupSalesCompanyParameters::setAssignGuidesAtBooking()
     * @uses Security_GroupSalesCompanyParameters::setBookingColor()
     * @uses Security_GroupSalesCompanyParameters::setCalendarHourResolution()
     * @uses Security_GroupSalesCompanyParameters::setDailyViewStartHour()
     * @uses Security_GroupSalesCompanyParameters::setDefaultBookingTime()
     * @uses Security_GroupSalesCompanyParameters::setDefaultCalendarView()
     * @uses Security_GroupSalesCompanyParameters::setDefaultPriceTypeForPrivateOrder()
     * @uses Security_GroupSalesCompanyParameters::setDefaultPriceTypeForSchoolOrder()
     * @uses Security_GroupSalesCompanyParameters::setDisplayEventsAndHallsInCalendar()
     * @uses Security_GroupSalesCompanyParameters::setEventColor()
     * @uses Security_GroupSalesCompanyParameters::setGroupPriceTypeForEvent()
     * @uses Security_GroupSalesCompanyParameters::setIntermissionBetweenActivities()
     * @uses Security_GroupSalesCompanyParameters::setLatestOrderVisitBookingTime()
     * @uses Security_GroupSalesCompanyParameters::setMaxIntermissionOffset()
     * @uses Security_GroupSalesCompanyParameters::setMaxOrderVisitsPerDay()
     * @uses Security_GroupSalesCompanyParameters::setOffsetBetweenParallelActivities()
     * @uses Security_GroupSalesCompanyParameters::setPreventBookingIfGuideAssignmentFailed()
     * @uses Security_GroupSalesCompanyParameters::setProposalExpiresInDays()
     * @uses Security_GroupSalesCompanyParameters::setSchoolYearStartMonth()
     * @uses Security_GroupSalesCompanyParameters::setUnavailableColor()
     * @param string $allocationColor
     * @param bool $allowChangeGroupContentAfterBilling
     * @param bool $allowChangeGroupContentAfterBooking
     * @param bool $allowChangeVisitPricingAfterBilling
     * @param bool $assignGuidesAtBooking
     * @param string $bookingColor
     * @param string $calendarHourResolution
     * @param string $dailyViewStartHour
     * @param string $defaultBookingTime
     * @param string $defaultCalendarView
     * @param string $defaultPriceTypeForPrivateOrder
     * @param string $defaultPriceTypeForSchoolOrder
     * @param bool $displayEventsAndHallsInCalendar
     * @param string $eventColor
     * @param string $groupPriceTypeForEvent
     * @param int $intermissionBetweenActivities
     * @param string $latestOrderVisitBookingTime
     * @param int $maxIntermissionOffset
     * @param int $maxOrderVisitsPerDay
     * @param int $offsetBetweenParallelActivities
     * @param bool $preventBookingIfGuideAssignmentFailed
     * @param int $proposalExpiresInDays
     * @param string $schoolYearStartMonth
     * @param string $unavailableColor
     */
    public function __construct($allocationColor = null, $allowChangeGroupContentAfterBilling = null, $allowChangeGroupContentAfterBooking = null, $allowChangeVisitPricingAfterBilling = null, $assignGuidesAtBooking = null, $bookingColor = null, $calendarHourResolution = null, $dailyViewStartHour = null, $defaultBookingTime = null, $defaultCalendarView = null, $defaultPriceTypeForPrivateOrder = null, $defaultPriceTypeForSchoolOrder = null, $displayEventsAndHallsInCalendar = null, $eventColor = null, $groupPriceTypeForEvent = null, $intermissionBetweenActivities = null, $latestOrderVisitBookingTime = null, $maxIntermissionOffset = null, $maxOrderVisitsPerDay = null, $offsetBetweenParallelActivities = null, $preventBookingIfGuideAssignmentFailed = null, $proposalExpiresInDays = null, $schoolYearStartMonth = null, $unavailableColor = null)
    {
        $this
            ->setAllocationColor($allocationColor)
            ->setAllowChangeGroupContentAfterBilling($allowChangeGroupContentAfterBilling)
            ->setAllowChangeGroupContentAfterBooking($allowChangeGroupContentAfterBooking)
            ->setAllowChangeVisitPricingAfterBilling($allowChangeVisitPricingAfterBilling)
            ->setAssignGuidesAtBooking($assignGuidesAtBooking)
            ->setBookingColor($bookingColor)
            ->setCalendarHourResolution($calendarHourResolution)
            ->setDailyViewStartHour($dailyViewStartHour)
            ->setDefaultBookingTime($defaultBookingTime)
            ->setDefaultCalendarView($defaultCalendarView)
            ->setDefaultPriceTypeForPrivateOrder($defaultPriceTypeForPrivateOrder)
            ->setDefaultPriceTypeForSchoolOrder($defaultPriceTypeForSchoolOrder)
            ->setDisplayEventsAndHallsInCalendar($displayEventsAndHallsInCalendar)
            ->setEventColor($eventColor)
            ->setGroupPriceTypeForEvent($groupPriceTypeForEvent)
            ->setIntermissionBetweenActivities($intermissionBetweenActivities)
            ->setLatestOrderVisitBookingTime($latestOrderVisitBookingTime)
            ->setMaxIntermissionOffset($maxIntermissionOffset)
            ->setMaxOrderVisitsPerDay($maxOrderVisitsPerDay)
            ->setOffsetBetweenParallelActivities($offsetBetweenParallelActivities)
            ->setPreventBookingIfGuideAssignmentFailed($preventBookingIfGuideAssignmentFailed)
            ->setProposalExpiresInDays($proposalExpiresInDays)
            ->setSchoolYearStartMonth($schoolYearStartMonth)
            ->setUnavailableColor($unavailableColor);
    }
    /**
     * Get AllocationColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationColor()
    {
        return isset($this->AllocationColor) ? $this->AllocationColor : null;
    }
    /**
     * Set AllocationColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationColor
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setAllocationColor($allocationColor = null)
    {
        // validation for constraint: string
        if (!is_null($allocationColor) && !is_string($allocationColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationColor, true), gettype($allocationColor)), __LINE__);
        }
        if (is_null($allocationColor) || (is_array($allocationColor) && empty($allocationColor))) {
            unset($this->AllocationColor);
        } else {
            $this->AllocationColor = $allocationColor;
        }
        return $this;
    }
    /**
     * Get AllowChangeGroupContentAfterBilling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowChangeGroupContentAfterBilling()
    {
        return isset($this->AllowChangeGroupContentAfterBilling) ? $this->AllowChangeGroupContentAfterBilling : null;
    }
    /**
     * Set AllowChangeGroupContentAfterBilling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowChangeGroupContentAfterBilling
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setAllowChangeGroupContentAfterBilling($allowChangeGroupContentAfterBilling = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowChangeGroupContentAfterBilling) && !is_bool($allowChangeGroupContentAfterBilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowChangeGroupContentAfterBilling, true), gettype($allowChangeGroupContentAfterBilling)), __LINE__);
        }
        if (is_null($allowChangeGroupContentAfterBilling) || (is_array($allowChangeGroupContentAfterBilling) && empty($allowChangeGroupContentAfterBilling))) {
            unset($this->AllowChangeGroupContentAfterBilling);
        } else {
            $this->AllowChangeGroupContentAfterBilling = $allowChangeGroupContentAfterBilling;
        }
        return $this;
    }
    /**
     * Get AllowChangeGroupContentAfterBooking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowChangeGroupContentAfterBooking()
    {
        return isset($this->AllowChangeGroupContentAfterBooking) ? $this->AllowChangeGroupContentAfterBooking : null;
    }
    /**
     * Set AllowChangeGroupContentAfterBooking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowChangeGroupContentAfterBooking
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setAllowChangeGroupContentAfterBooking($allowChangeGroupContentAfterBooking = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowChangeGroupContentAfterBooking) && !is_bool($allowChangeGroupContentAfterBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowChangeGroupContentAfterBooking, true), gettype($allowChangeGroupContentAfterBooking)), __LINE__);
        }
        if (is_null($allowChangeGroupContentAfterBooking) || (is_array($allowChangeGroupContentAfterBooking) && empty($allowChangeGroupContentAfterBooking))) {
            unset($this->AllowChangeGroupContentAfterBooking);
        } else {
            $this->AllowChangeGroupContentAfterBooking = $allowChangeGroupContentAfterBooking;
        }
        return $this;
    }
    /**
     * Get AllowChangeVisitPricingAfterBilling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowChangeVisitPricingAfterBilling()
    {
        return isset($this->AllowChangeVisitPricingAfterBilling) ? $this->AllowChangeVisitPricingAfterBilling : null;
    }
    /**
     * Set AllowChangeVisitPricingAfterBilling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowChangeVisitPricingAfterBilling
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setAllowChangeVisitPricingAfterBilling($allowChangeVisitPricingAfterBilling = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowChangeVisitPricingAfterBilling) && !is_bool($allowChangeVisitPricingAfterBilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowChangeVisitPricingAfterBilling, true), gettype($allowChangeVisitPricingAfterBilling)), __LINE__);
        }
        if (is_null($allowChangeVisitPricingAfterBilling) || (is_array($allowChangeVisitPricingAfterBilling) && empty($allowChangeVisitPricingAfterBilling))) {
            unset($this->AllowChangeVisitPricingAfterBilling);
        } else {
            $this->AllowChangeVisitPricingAfterBilling = $allowChangeVisitPricingAfterBilling;
        }
        return $this;
    }
    /**
     * Get AssignGuidesAtBooking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAssignGuidesAtBooking()
    {
        return isset($this->AssignGuidesAtBooking) ? $this->AssignGuidesAtBooking : null;
    }
    /**
     * Set AssignGuidesAtBooking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $assignGuidesAtBooking
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setAssignGuidesAtBooking($assignGuidesAtBooking = null)
    {
        // validation for constraint: boolean
        if (!is_null($assignGuidesAtBooking) && !is_bool($assignGuidesAtBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($assignGuidesAtBooking, true), gettype($assignGuidesAtBooking)), __LINE__);
        }
        if (is_null($assignGuidesAtBooking) || (is_array($assignGuidesAtBooking) && empty($assignGuidesAtBooking))) {
            unset($this->AssignGuidesAtBooking);
        } else {
            $this->AssignGuidesAtBooking = $assignGuidesAtBooking;
        }
        return $this;
    }
    /**
     * Get BookingColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingColor()
    {
        return isset($this->BookingColor) ? $this->BookingColor : null;
    }
    /**
     * Set BookingColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingColor
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setBookingColor($bookingColor = null)
    {
        // validation for constraint: string
        if (!is_null($bookingColor) && !is_string($bookingColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingColor, true), gettype($bookingColor)), __LINE__);
        }
        if (is_null($bookingColor) || (is_array($bookingColor) && empty($bookingColor))) {
            unset($this->BookingColor);
        } else {
            $this->BookingColor = $bookingColor;
        }
        return $this;
    }
    /**
     * Get CalendarHourResolution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalendarHourResolution()
    {
        return isset($this->CalendarHourResolution) ? $this->CalendarHourResolution : null;
    }
    /**
     * Set CalendarHourResolution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CalendarHourResolution::valueIsValid()
     * @uses \patest\EnumType\CalendarHourResolution::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calendarHourResolution
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setCalendarHourResolution($calendarHourResolution = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CalendarHourResolution::valueIsValid($calendarHourResolution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CalendarHourResolution', is_array($calendarHourResolution) ? implode(', ', $calendarHourResolution) : var_export($calendarHourResolution, true), implode(', ', \patest\EnumType\CalendarHourResolution::getValidValues())), __LINE__);
        }
        if (is_null($calendarHourResolution) || (is_array($calendarHourResolution) && empty($calendarHourResolution))) {
            unset($this->CalendarHourResolution);
        } else {
            $this->CalendarHourResolution = $calendarHourResolution;
        }
        return $this;
    }
    /**
     * Get DailyViewStartHour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDailyViewStartHour()
    {
        return isset($this->DailyViewStartHour) ? $this->DailyViewStartHour : null;
    }
    /**
     * Set DailyViewStartHour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CalendarDayHour::valueIsValid()
     * @uses \patest\EnumType\CalendarDayHour::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dailyViewStartHour
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setDailyViewStartHour($dailyViewStartHour = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CalendarDayHour::valueIsValid($dailyViewStartHour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CalendarDayHour', is_array($dailyViewStartHour) ? implode(', ', $dailyViewStartHour) : var_export($dailyViewStartHour, true), implode(', ', \patest\EnumType\CalendarDayHour::getValidValues())), __LINE__);
        }
        if (is_null($dailyViewStartHour) || (is_array($dailyViewStartHour) && empty($dailyViewStartHour))) {
            unset($this->DailyViewStartHour);
        } else {
            $this->DailyViewStartHour = $dailyViewStartHour;
        }
        return $this;
    }
    /**
     * Get DefaultBookingTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultBookingTime()
    {
        return isset($this->DefaultBookingTime) ? $this->DefaultBookingTime : null;
    }
    /**
     * Set DefaultBookingTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultBookingTime
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setDefaultBookingTime($defaultBookingTime = null)
    {
        // validation for constraint: string
        if (!is_null($defaultBookingTime) && !is_string($defaultBookingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultBookingTime, true), gettype($defaultBookingTime)), __LINE__);
        }
        if (is_null($defaultBookingTime) || (is_array($defaultBookingTime) && empty($defaultBookingTime))) {
            unset($this->DefaultBookingTime);
        } else {
            $this->DefaultBookingTime = $defaultBookingTime;
        }
        return $this;
    }
    /**
     * Get DefaultCalendarView value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultCalendarView()
    {
        return isset($this->DefaultCalendarView) ? $this->DefaultCalendarView : null;
    }
    /**
     * Set DefaultCalendarView value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RecurringFrequency::valueIsValid()
     * @uses \patest\EnumType\RecurringFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultCalendarView
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setDefaultCalendarView($defaultCalendarView = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RecurringFrequency::valueIsValid($defaultCalendarView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RecurringFrequency', is_array($defaultCalendarView) ? implode(', ', $defaultCalendarView) : var_export($defaultCalendarView, true), implode(', ', \patest\EnumType\RecurringFrequency::getValidValues())), __LINE__);
        }
        if (is_null($defaultCalendarView) || (is_array($defaultCalendarView) && empty($defaultCalendarView))) {
            unset($this->DefaultCalendarView);
        } else {
            $this->DefaultCalendarView = $defaultCalendarView;
        }
        return $this;
    }
    /**
     * Get DefaultPriceTypeForPrivateOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultPriceTypeForPrivateOrder()
    {
        return isset($this->DefaultPriceTypeForPrivateOrder) ? $this->DefaultPriceTypeForPrivateOrder : null;
    }
    /**
     * Set DefaultPriceTypeForPrivateOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultPriceTypeForPrivateOrder
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setDefaultPriceTypeForPrivateOrder($defaultPriceTypeForPrivateOrder = null)
    {
        // validation for constraint: string
        if (!is_null($defaultPriceTypeForPrivateOrder) && !is_string($defaultPriceTypeForPrivateOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultPriceTypeForPrivateOrder, true), gettype($defaultPriceTypeForPrivateOrder)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultPriceTypeForPrivateOrder) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultPriceTypeForPrivateOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultPriceTypeForPrivateOrder, true)), __LINE__);
        }
        if (is_null($defaultPriceTypeForPrivateOrder) || (is_array($defaultPriceTypeForPrivateOrder) && empty($defaultPriceTypeForPrivateOrder))) {
            unset($this->DefaultPriceTypeForPrivateOrder);
        } else {
            $this->DefaultPriceTypeForPrivateOrder = $defaultPriceTypeForPrivateOrder;
        }
        return $this;
    }
    /**
     * Get DefaultPriceTypeForSchoolOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultPriceTypeForSchoolOrder()
    {
        return isset($this->DefaultPriceTypeForSchoolOrder) ? $this->DefaultPriceTypeForSchoolOrder : null;
    }
    /**
     * Set DefaultPriceTypeForSchoolOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultPriceTypeForSchoolOrder
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setDefaultPriceTypeForSchoolOrder($defaultPriceTypeForSchoolOrder = null)
    {
        // validation for constraint: string
        if (!is_null($defaultPriceTypeForSchoolOrder) && !is_string($defaultPriceTypeForSchoolOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultPriceTypeForSchoolOrder, true), gettype($defaultPriceTypeForSchoolOrder)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultPriceTypeForSchoolOrder) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultPriceTypeForSchoolOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultPriceTypeForSchoolOrder, true)), __LINE__);
        }
        if (is_null($defaultPriceTypeForSchoolOrder) || (is_array($defaultPriceTypeForSchoolOrder) && empty($defaultPriceTypeForSchoolOrder))) {
            unset($this->DefaultPriceTypeForSchoolOrder);
        } else {
            $this->DefaultPriceTypeForSchoolOrder = $defaultPriceTypeForSchoolOrder;
        }
        return $this;
    }
    /**
     * Get DisplayEventsAndHallsInCalendar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayEventsAndHallsInCalendar()
    {
        return isset($this->DisplayEventsAndHallsInCalendar) ? $this->DisplayEventsAndHallsInCalendar : null;
    }
    /**
     * Set DisplayEventsAndHallsInCalendar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayEventsAndHallsInCalendar
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setDisplayEventsAndHallsInCalendar($displayEventsAndHallsInCalendar = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayEventsAndHallsInCalendar) && !is_bool($displayEventsAndHallsInCalendar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayEventsAndHallsInCalendar, true), gettype($displayEventsAndHallsInCalendar)), __LINE__);
        }
        if (is_null($displayEventsAndHallsInCalendar) || (is_array($displayEventsAndHallsInCalendar) && empty($displayEventsAndHallsInCalendar))) {
            unset($this->DisplayEventsAndHallsInCalendar);
        } else {
            $this->DisplayEventsAndHallsInCalendar = $displayEventsAndHallsInCalendar;
        }
        return $this;
    }
    /**
     * Get EventColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventColor()
    {
        return isset($this->EventColor) ? $this->EventColor : null;
    }
    /**
     * Set EventColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventColor
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setEventColor($eventColor = null)
    {
        // validation for constraint: string
        if (!is_null($eventColor) && !is_string($eventColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventColor, true), gettype($eventColor)), __LINE__);
        }
        if (is_null($eventColor) || (is_array($eventColor) && empty($eventColor))) {
            unset($this->EventColor);
        } else {
            $this->EventColor = $eventColor;
        }
        return $this;
    }
    /**
     * Get GroupPriceTypeForEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupPriceTypeForEvent()
    {
        return isset($this->GroupPriceTypeForEvent) ? $this->GroupPriceTypeForEvent : null;
    }
    /**
     * Set GroupPriceTypeForEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupPriceTypeForEvent
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setGroupPriceTypeForEvent($groupPriceTypeForEvent = null)
    {
        // validation for constraint: string
        if (!is_null($groupPriceTypeForEvent) && !is_string($groupPriceTypeForEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupPriceTypeForEvent, true), gettype($groupPriceTypeForEvent)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupPriceTypeForEvent) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupPriceTypeForEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupPriceTypeForEvent, true)), __LINE__);
        }
        if (is_null($groupPriceTypeForEvent) || (is_array($groupPriceTypeForEvent) && empty($groupPriceTypeForEvent))) {
            unset($this->GroupPriceTypeForEvent);
        } else {
            $this->GroupPriceTypeForEvent = $groupPriceTypeForEvent;
        }
        return $this;
    }
    /**
     * Get IntermissionBetweenActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntermissionBetweenActivities()
    {
        return isset($this->IntermissionBetweenActivities) ? $this->IntermissionBetweenActivities : null;
    }
    /**
     * Set IntermissionBetweenActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $intermissionBetweenActivities
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setIntermissionBetweenActivities($intermissionBetweenActivities = null)
    {
        // validation for constraint: int
        if (!is_null($intermissionBetweenActivities) && !(is_int($intermissionBetweenActivities) || ctype_digit($intermissionBetweenActivities))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intermissionBetweenActivities, true), gettype($intermissionBetweenActivities)), __LINE__);
        }
        if (is_null($intermissionBetweenActivities) || (is_array($intermissionBetweenActivities) && empty($intermissionBetweenActivities))) {
            unset($this->IntermissionBetweenActivities);
        } else {
            $this->IntermissionBetweenActivities = $intermissionBetweenActivities;
        }
        return $this;
    }
    /**
     * Get LatestOrderVisitBookingTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLatestOrderVisitBookingTime()
    {
        return isset($this->LatestOrderVisitBookingTime) ? $this->LatestOrderVisitBookingTime : null;
    }
    /**
     * Set LatestOrderVisitBookingTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $latestOrderVisitBookingTime
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setLatestOrderVisitBookingTime($latestOrderVisitBookingTime = null)
    {
        // validation for constraint: string
        if (!is_null($latestOrderVisitBookingTime) && !is_string($latestOrderVisitBookingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestOrderVisitBookingTime, true), gettype($latestOrderVisitBookingTime)), __LINE__);
        }
        if (is_null($latestOrderVisitBookingTime) || (is_array($latestOrderVisitBookingTime) && empty($latestOrderVisitBookingTime))) {
            unset($this->LatestOrderVisitBookingTime);
        } else {
            $this->LatestOrderVisitBookingTime = $latestOrderVisitBookingTime;
        }
        return $this;
    }
    /**
     * Get MaxIntermissionOffset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxIntermissionOffset()
    {
        return isset($this->MaxIntermissionOffset) ? $this->MaxIntermissionOffset : null;
    }
    /**
     * Set MaxIntermissionOffset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxIntermissionOffset
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setMaxIntermissionOffset($maxIntermissionOffset = null)
    {
        // validation for constraint: int
        if (!is_null($maxIntermissionOffset) && !(is_int($maxIntermissionOffset) || ctype_digit($maxIntermissionOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxIntermissionOffset, true), gettype($maxIntermissionOffset)), __LINE__);
        }
        if (is_null($maxIntermissionOffset) || (is_array($maxIntermissionOffset) && empty($maxIntermissionOffset))) {
            unset($this->MaxIntermissionOffset);
        } else {
            $this->MaxIntermissionOffset = $maxIntermissionOffset;
        }
        return $this;
    }
    /**
     * Get MaxOrderVisitsPerDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxOrderVisitsPerDay()
    {
        return isset($this->MaxOrderVisitsPerDay) ? $this->MaxOrderVisitsPerDay : null;
    }
    /**
     * Set MaxOrderVisitsPerDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxOrderVisitsPerDay
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setMaxOrderVisitsPerDay($maxOrderVisitsPerDay = null)
    {
        // validation for constraint: int
        if (!is_null($maxOrderVisitsPerDay) && !(is_int($maxOrderVisitsPerDay) || ctype_digit($maxOrderVisitsPerDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOrderVisitsPerDay, true), gettype($maxOrderVisitsPerDay)), __LINE__);
        }
        if (is_null($maxOrderVisitsPerDay) || (is_array($maxOrderVisitsPerDay) && empty($maxOrderVisitsPerDay))) {
            unset($this->MaxOrderVisitsPerDay);
        } else {
            $this->MaxOrderVisitsPerDay = $maxOrderVisitsPerDay;
        }
        return $this;
    }
    /**
     * Get OffsetBetweenParallelActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOffsetBetweenParallelActivities()
    {
        return isset($this->OffsetBetweenParallelActivities) ? $this->OffsetBetweenParallelActivities : null;
    }
    /**
     * Set OffsetBetweenParallelActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $offsetBetweenParallelActivities
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setOffsetBetweenParallelActivities($offsetBetweenParallelActivities = null)
    {
        // validation for constraint: int
        if (!is_null($offsetBetweenParallelActivities) && !(is_int($offsetBetweenParallelActivities) || ctype_digit($offsetBetweenParallelActivities))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offsetBetweenParallelActivities, true), gettype($offsetBetweenParallelActivities)), __LINE__);
        }
        if (is_null($offsetBetweenParallelActivities) || (is_array($offsetBetweenParallelActivities) && empty($offsetBetweenParallelActivities))) {
            unset($this->OffsetBetweenParallelActivities);
        } else {
            $this->OffsetBetweenParallelActivities = $offsetBetweenParallelActivities;
        }
        return $this;
    }
    /**
     * Get PreventBookingIfGuideAssignmentFailed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreventBookingIfGuideAssignmentFailed()
    {
        return isset($this->PreventBookingIfGuideAssignmentFailed) ? $this->PreventBookingIfGuideAssignmentFailed : null;
    }
    /**
     * Set PreventBookingIfGuideAssignmentFailed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preventBookingIfGuideAssignmentFailed
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setPreventBookingIfGuideAssignmentFailed($preventBookingIfGuideAssignmentFailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($preventBookingIfGuideAssignmentFailed) && !is_bool($preventBookingIfGuideAssignmentFailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preventBookingIfGuideAssignmentFailed, true), gettype($preventBookingIfGuideAssignmentFailed)), __LINE__);
        }
        if (is_null($preventBookingIfGuideAssignmentFailed) || (is_array($preventBookingIfGuideAssignmentFailed) && empty($preventBookingIfGuideAssignmentFailed))) {
            unset($this->PreventBookingIfGuideAssignmentFailed);
        } else {
            $this->PreventBookingIfGuideAssignmentFailed = $preventBookingIfGuideAssignmentFailed;
        }
        return $this;
    }
    /**
     * Get ProposalExpiresInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProposalExpiresInDays()
    {
        return isset($this->ProposalExpiresInDays) ? $this->ProposalExpiresInDays : null;
    }
    /**
     * Set ProposalExpiresInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $proposalExpiresInDays
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setProposalExpiresInDays($proposalExpiresInDays = null)
    {
        // validation for constraint: int
        if (!is_null($proposalExpiresInDays) && !(is_int($proposalExpiresInDays) || ctype_digit($proposalExpiresInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($proposalExpiresInDays, true), gettype($proposalExpiresInDays)), __LINE__);
        }
        if (is_null($proposalExpiresInDays) || (is_array($proposalExpiresInDays) && empty($proposalExpiresInDays))) {
            unset($this->ProposalExpiresInDays);
        } else {
            $this->ProposalExpiresInDays = $proposalExpiresInDays;
        }
        return $this;
    }
    /**
     * Get SchoolYearStartMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchoolYearStartMonth()
    {
        return isset($this->SchoolYearStartMonth) ? $this->SchoolYearStartMonth : null;
    }
    /**
     * Set SchoolYearStartMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SchoolYearStartMonth::valueIsValid()
     * @uses \patest\EnumType\SchoolYearStartMonth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schoolYearStartMonth
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setSchoolYearStartMonth($schoolYearStartMonth = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SchoolYearStartMonth::valueIsValid($schoolYearStartMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SchoolYearStartMonth', is_array($schoolYearStartMonth) ? implode(', ', $schoolYearStartMonth) : var_export($schoolYearStartMonth, true), implode(', ', \patest\EnumType\SchoolYearStartMonth::getValidValues())), __LINE__);
        }
        if (is_null($schoolYearStartMonth) || (is_array($schoolYearStartMonth) && empty($schoolYearStartMonth))) {
            unset($this->SchoolYearStartMonth);
        } else {
            $this->SchoolYearStartMonth = $schoolYearStartMonth;
        }
        return $this;
    }
    /**
     * Get UnavailableColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnavailableColor()
    {
        return isset($this->UnavailableColor) ? $this->UnavailableColor : null;
    }
    /**
     * Set UnavailableColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unavailableColor
     * @return \patest\StructType\Security_GroupSalesCompanyParameters
     */
    public function setUnavailableColor($unavailableColor = null)
    {
        // validation for constraint: string
        if (!is_null($unavailableColor) && !is_string($unavailableColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unavailableColor, true), gettype($unavailableColor)), __LINE__);
        }
        if (is_null($unavailableColor) || (is_array($unavailableColor) && empty($unavailableColor))) {
            unset($this->UnavailableColor);
        } else {
            $this->UnavailableColor = $unavailableColor;
        }
        return $this;
    }
}
