<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.GeneralCompanyParameters StructType
 * @subpackage Structs
 */
class Security_GeneralCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AccessCardMagneticStripeDataType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessCardMagneticStripeDataType;
    /**
     * The AffiliateAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AffiliateAccountId;
    /**
     * The CardReaderPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardReaderPrefix;
    /**
     * The CardReaderSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardReaderSuffix;
    /**
     * The CatalystTestBranchName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CatalystTestBranchName;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DefaultTimeZoneId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultTimeZoneId;
    /**
     * The DelayBetweenKeepAliveRequestsOnNetworkError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DelayBetweenKeepAliveRequestsOnNetworkError;
    /**
     * The EnvironmentColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnvironmentColor;
    /**
     * The EnvironmentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnvironmentName;
    /**
     * The IBANCountry
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IBANCountry;
    /**
     * The IsNonProductionEnvironment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsNonProductionEnvironment;
    /**
     * The KeepAllJournalsForDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KeepAllJournalsForDays;
    /**
     * The KeepApiTraceDataForDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KeepApiTraceDataForDays;
    /**
     * The KeepPrintingJournalsForDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KeepPrintingJournalsForDays;
    /**
     * The KeepScheduledQueryExecutions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KeepScheduledQueryExecutions;
    /**
     * The KeepTraceAndMonitoringForDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KeepTraceAndMonitoringForDays;
    /**
     * The KeepUserJournalsForDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KeepUserJournalsForDays;
    /**
     * The MaxImageResolution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxImageResolution;
    /**
     * The MaxImageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxImageSize;
    /**
     * The MaxRetriesOn502Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxRetriesOn502Error;
    /**
     * The MaxRetriesOnNetworkError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxRetriesOnNetworkError;
    /**
     * The MaxSuccessfulRetriesOnNetworkError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSuccessfulRetriesOnNetworkError;
    /**
     * The MembershipCardMagneticStripeDataType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipCardMagneticStripeDataType;
    /**
     * The SubscriptionCardMagneticStripeDataType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionCardMagneticStripeDataType;
    /**
     * Constructor method for Security.GeneralCompanyParameters
     * @uses Security_GeneralCompanyParameters::setAccessCardMagneticStripeDataType()
     * @uses Security_GeneralCompanyParameters::setAffiliateAccountId()
     * @uses Security_GeneralCompanyParameters::setCardReaderPrefix()
     * @uses Security_GeneralCompanyParameters::setCardReaderSuffix()
     * @uses Security_GeneralCompanyParameters::setCatalystTestBranchName()
     * @uses Security_GeneralCompanyParameters::setCultureId()
     * @uses Security_GeneralCompanyParameters::setCurrencyCode()
     * @uses Security_GeneralCompanyParameters::setDefaultTimeZoneId()
     * @uses Security_GeneralCompanyParameters::setDelayBetweenKeepAliveRequestsOnNetworkError()
     * @uses Security_GeneralCompanyParameters::setEnvironmentColor()
     * @uses Security_GeneralCompanyParameters::setEnvironmentName()
     * @uses Security_GeneralCompanyParameters::setIBANCountry()
     * @uses Security_GeneralCompanyParameters::setIsNonProductionEnvironment()
     * @uses Security_GeneralCompanyParameters::setKeepAllJournalsForDays()
     * @uses Security_GeneralCompanyParameters::setKeepApiTraceDataForDays()
     * @uses Security_GeneralCompanyParameters::setKeepPrintingJournalsForDays()
     * @uses Security_GeneralCompanyParameters::setKeepScheduledQueryExecutions()
     * @uses Security_GeneralCompanyParameters::setKeepTraceAndMonitoringForDays()
     * @uses Security_GeneralCompanyParameters::setKeepUserJournalsForDays()
     * @uses Security_GeneralCompanyParameters::setMaxImageResolution()
     * @uses Security_GeneralCompanyParameters::setMaxImageSize()
     * @uses Security_GeneralCompanyParameters::setMaxRetriesOn502Error()
     * @uses Security_GeneralCompanyParameters::setMaxRetriesOnNetworkError()
     * @uses Security_GeneralCompanyParameters::setMaxSuccessfulRetriesOnNetworkError()
     * @uses Security_GeneralCompanyParameters::setMembershipCardMagneticStripeDataType()
     * @uses Security_GeneralCompanyParameters::setSubscriptionCardMagneticStripeDataType()
     * @param string $accessCardMagneticStripeDataType
     * @param string $affiliateAccountId
     * @param string $cardReaderPrefix
     * @param string $cardReaderSuffix
     * @param string $catalystTestBranchName
     * @param int $cultureId
     * @param string $currencyCode
     * @param string $defaultTimeZoneId
     * @param int $delayBetweenKeepAliveRequestsOnNetworkError
     * @param string $environmentColor
     * @param string $environmentName
     * @param string $iBANCountry
     * @param bool $isNonProductionEnvironment
     * @param int $keepAllJournalsForDays
     * @param int $keepApiTraceDataForDays
     * @param int $keepPrintingJournalsForDays
     * @param int $keepScheduledQueryExecutions
     * @param int $keepTraceAndMonitoringForDays
     * @param int $keepUserJournalsForDays
     * @param int $maxImageResolution
     * @param int $maxImageSize
     * @param int $maxRetriesOn502Error
     * @param int $maxRetriesOnNetworkError
     * @param int $maxSuccessfulRetriesOnNetworkError
     * @param string $membershipCardMagneticStripeDataType
     * @param string $subscriptionCardMagneticStripeDataType
     */
    public function __construct($accessCardMagneticStripeDataType = null, $affiliateAccountId = null, $cardReaderPrefix = null, $cardReaderSuffix = null, $catalystTestBranchName = null, $cultureId = null, $currencyCode = null, $defaultTimeZoneId = null, $delayBetweenKeepAliveRequestsOnNetworkError = null, $environmentColor = null, $environmentName = null, $iBANCountry = null, $isNonProductionEnvironment = null, $keepAllJournalsForDays = null, $keepApiTraceDataForDays = null, $keepPrintingJournalsForDays = null, $keepScheduledQueryExecutions = null, $keepTraceAndMonitoringForDays = null, $keepUserJournalsForDays = null, $maxImageResolution = null, $maxImageSize = null, $maxRetriesOn502Error = null, $maxRetriesOnNetworkError = null, $maxSuccessfulRetriesOnNetworkError = null, $membershipCardMagneticStripeDataType = null, $subscriptionCardMagneticStripeDataType = null)
    {
        $this
            ->setAccessCardMagneticStripeDataType($accessCardMagneticStripeDataType)
            ->setAffiliateAccountId($affiliateAccountId)
            ->setCardReaderPrefix($cardReaderPrefix)
            ->setCardReaderSuffix($cardReaderSuffix)
            ->setCatalystTestBranchName($catalystTestBranchName)
            ->setCultureId($cultureId)
            ->setCurrencyCode($currencyCode)
            ->setDefaultTimeZoneId($defaultTimeZoneId)
            ->setDelayBetweenKeepAliveRequestsOnNetworkError($delayBetweenKeepAliveRequestsOnNetworkError)
            ->setEnvironmentColor($environmentColor)
            ->setEnvironmentName($environmentName)
            ->setIBANCountry($iBANCountry)
            ->setIsNonProductionEnvironment($isNonProductionEnvironment)
            ->setKeepAllJournalsForDays($keepAllJournalsForDays)
            ->setKeepApiTraceDataForDays($keepApiTraceDataForDays)
            ->setKeepPrintingJournalsForDays($keepPrintingJournalsForDays)
            ->setKeepScheduledQueryExecutions($keepScheduledQueryExecutions)
            ->setKeepTraceAndMonitoringForDays($keepTraceAndMonitoringForDays)
            ->setKeepUserJournalsForDays($keepUserJournalsForDays)
            ->setMaxImageResolution($maxImageResolution)
            ->setMaxImageSize($maxImageSize)
            ->setMaxRetriesOn502Error($maxRetriesOn502Error)
            ->setMaxRetriesOnNetworkError($maxRetriesOnNetworkError)
            ->setMaxSuccessfulRetriesOnNetworkError($maxSuccessfulRetriesOnNetworkError)
            ->setMembershipCardMagneticStripeDataType($membershipCardMagneticStripeDataType)
            ->setSubscriptionCardMagneticStripeDataType($subscriptionCardMagneticStripeDataType);
    }
    /**
     * Get AccessCardMagneticStripeDataType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardMagneticStripeDataType()
    {
        return isset($this->AccessCardMagneticStripeDataType) ? $this->AccessCardMagneticStripeDataType : null;
    }
    /**
     * Set AccessCardMagneticStripeDataType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessCardMagneticStripeDataType::valueIsValid()
     * @uses \patest\EnumType\AccessCardMagneticStripeDataType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessCardMagneticStripeDataType
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setAccessCardMagneticStripeDataType($accessCardMagneticStripeDataType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessCardMagneticStripeDataType::valueIsValid($accessCardMagneticStripeDataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCardMagneticStripeDataType', is_array($accessCardMagneticStripeDataType) ? implode(', ', $accessCardMagneticStripeDataType) : var_export($accessCardMagneticStripeDataType, true), implode(', ', \patest\EnumType\AccessCardMagneticStripeDataType::getValidValues())), __LINE__);
        }
        if (is_null($accessCardMagneticStripeDataType) || (is_array($accessCardMagneticStripeDataType) && empty($accessCardMagneticStripeDataType))) {
            unset($this->AccessCardMagneticStripeDataType);
        } else {
            $this->AccessCardMagneticStripeDataType = $accessCardMagneticStripeDataType;
        }
        return $this;
    }
    /**
     * Get AffiliateAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAffiliateAccountId()
    {
        return isset($this->AffiliateAccountId) ? $this->AffiliateAccountId : null;
    }
    /**
     * Set AffiliateAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $affiliateAccountId
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setAffiliateAccountId($affiliateAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateAccountId) && !is_string($affiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateAccountId, true), gettype($affiliateAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($affiliateAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $affiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($affiliateAccountId, true)), __LINE__);
        }
        if (is_null($affiliateAccountId) || (is_array($affiliateAccountId) && empty($affiliateAccountId))) {
            unset($this->AffiliateAccountId);
        } else {
            $this->AffiliateAccountId = $affiliateAccountId;
        }
        return $this;
    }
    /**
     * Get CardReaderPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardReaderPrefix()
    {
        return isset($this->CardReaderPrefix) ? $this->CardReaderPrefix : null;
    }
    /**
     * Set CardReaderPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardReaderPrefix
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setCardReaderPrefix($cardReaderPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($cardReaderPrefix) && !is_string($cardReaderPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardReaderPrefix, true), gettype($cardReaderPrefix)), __LINE__);
        }
        if (is_null($cardReaderPrefix) || (is_array($cardReaderPrefix) && empty($cardReaderPrefix))) {
            unset($this->CardReaderPrefix);
        } else {
            $this->CardReaderPrefix = $cardReaderPrefix;
        }
        return $this;
    }
    /**
     * Get CardReaderSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardReaderSuffix()
    {
        return isset($this->CardReaderSuffix) ? $this->CardReaderSuffix : null;
    }
    /**
     * Set CardReaderSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardReaderSuffix
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setCardReaderSuffix($cardReaderSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($cardReaderSuffix) && !is_string($cardReaderSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardReaderSuffix, true), gettype($cardReaderSuffix)), __LINE__);
        }
        if (is_null($cardReaderSuffix) || (is_array($cardReaderSuffix) && empty($cardReaderSuffix))) {
            unset($this->CardReaderSuffix);
        } else {
            $this->CardReaderSuffix = $cardReaderSuffix;
        }
        return $this;
    }
    /**
     * Get CatalystTestBranchName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCatalystTestBranchName()
    {
        return isset($this->CatalystTestBranchName) ? $this->CatalystTestBranchName : null;
    }
    /**
     * Set CatalystTestBranchName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $catalystTestBranchName
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setCatalystTestBranchName($catalystTestBranchName = null)
    {
        // validation for constraint: string
        if (!is_null($catalystTestBranchName) && !is_string($catalystTestBranchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalystTestBranchName, true), gettype($catalystTestBranchName)), __LINE__);
        }
        if (is_null($catalystTestBranchName) || (is_array($catalystTestBranchName) && empty($catalystTestBranchName))) {
            unset($this->CatalystTestBranchName);
        } else {
            $this->CatalystTestBranchName = $catalystTestBranchName;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get DefaultTimeZoneId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultTimeZoneId()
    {
        return isset($this->DefaultTimeZoneId) ? $this->DefaultTimeZoneId : null;
    }
    /**
     * Set DefaultTimeZoneId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultTimeZoneId
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setDefaultTimeZoneId($defaultTimeZoneId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTimeZoneId) && !is_string($defaultTimeZoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTimeZoneId, true), gettype($defaultTimeZoneId)), __LINE__);
        }
        if (is_null($defaultTimeZoneId) || (is_array($defaultTimeZoneId) && empty($defaultTimeZoneId))) {
            unset($this->DefaultTimeZoneId);
        } else {
            $this->DefaultTimeZoneId = $defaultTimeZoneId;
        }
        return $this;
    }
    /**
     * Get DelayBetweenKeepAliveRequestsOnNetworkError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDelayBetweenKeepAliveRequestsOnNetworkError()
    {
        return isset($this->DelayBetweenKeepAliveRequestsOnNetworkError) ? $this->DelayBetweenKeepAliveRequestsOnNetworkError : null;
    }
    /**
     * Set DelayBetweenKeepAliveRequestsOnNetworkError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $delayBetweenKeepAliveRequestsOnNetworkError
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setDelayBetweenKeepAliveRequestsOnNetworkError($delayBetweenKeepAliveRequestsOnNetworkError = null)
    {
        // validation for constraint: int
        if (!is_null($delayBetweenKeepAliveRequestsOnNetworkError) && !(is_int($delayBetweenKeepAliveRequestsOnNetworkError) || ctype_digit($delayBetweenKeepAliveRequestsOnNetworkError))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($delayBetweenKeepAliveRequestsOnNetworkError, true), gettype($delayBetweenKeepAliveRequestsOnNetworkError)), __LINE__);
        }
        if (is_null($delayBetweenKeepAliveRequestsOnNetworkError) || (is_array($delayBetweenKeepAliveRequestsOnNetworkError) && empty($delayBetweenKeepAliveRequestsOnNetworkError))) {
            unset($this->DelayBetweenKeepAliveRequestsOnNetworkError);
        } else {
            $this->DelayBetweenKeepAliveRequestsOnNetworkError = $delayBetweenKeepAliveRequestsOnNetworkError;
        }
        return $this;
    }
    /**
     * Get EnvironmentColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvironmentColor()
    {
        return isset($this->EnvironmentColor) ? $this->EnvironmentColor : null;
    }
    /**
     * Set EnvironmentColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $environmentColor
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setEnvironmentColor($environmentColor = null)
    {
        // validation for constraint: string
        if (!is_null($environmentColor) && !is_string($environmentColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($environmentColor, true), gettype($environmentColor)), __LINE__);
        }
        if (is_null($environmentColor) || (is_array($environmentColor) && empty($environmentColor))) {
            unset($this->EnvironmentColor);
        } else {
            $this->EnvironmentColor = $environmentColor;
        }
        return $this;
    }
    /**
     * Get EnvironmentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvironmentName()
    {
        return isset($this->EnvironmentName) ? $this->EnvironmentName : null;
    }
    /**
     * Set EnvironmentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $environmentName
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setEnvironmentName($environmentName = null)
    {
        // validation for constraint: string
        if (!is_null($environmentName) && !is_string($environmentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($environmentName, true), gettype($environmentName)), __LINE__);
        }
        if (is_null($environmentName) || (is_array($environmentName) && empty($environmentName))) {
            unset($this->EnvironmentName);
        } else {
            $this->EnvironmentName = $environmentName;
        }
        return $this;
    }
    /**
     * Get IBANCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIBANCountry()
    {
        return isset($this->IBANCountry) ? $this->IBANCountry : null;
    }
    /**
     * Set IBANCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iBANCountry
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setIBANCountry($iBANCountry = null)
    {
        // validation for constraint: string
        if (!is_null($iBANCountry) && !is_string($iBANCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBANCountry, true), gettype($iBANCountry)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($iBANCountry) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iBANCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($iBANCountry, true)), __LINE__);
        }
        if (is_null($iBANCountry) || (is_array($iBANCountry) && empty($iBANCountry))) {
            unset($this->IBANCountry);
        } else {
            $this->IBANCountry = $iBANCountry;
        }
        return $this;
    }
    /**
     * Get IsNonProductionEnvironment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNonProductionEnvironment()
    {
        return isset($this->IsNonProductionEnvironment) ? $this->IsNonProductionEnvironment : null;
    }
    /**
     * Set IsNonProductionEnvironment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNonProductionEnvironment
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setIsNonProductionEnvironment($isNonProductionEnvironment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNonProductionEnvironment) && !is_bool($isNonProductionEnvironment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNonProductionEnvironment, true), gettype($isNonProductionEnvironment)), __LINE__);
        }
        if (is_null($isNonProductionEnvironment) || (is_array($isNonProductionEnvironment) && empty($isNonProductionEnvironment))) {
            unset($this->IsNonProductionEnvironment);
        } else {
            $this->IsNonProductionEnvironment = $isNonProductionEnvironment;
        }
        return $this;
    }
    /**
     * Get KeepAllJournalsForDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKeepAllJournalsForDays()
    {
        return isset($this->KeepAllJournalsForDays) ? $this->KeepAllJournalsForDays : null;
    }
    /**
     * Set KeepAllJournalsForDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $keepAllJournalsForDays
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setKeepAllJournalsForDays($keepAllJournalsForDays = null)
    {
        // validation for constraint: int
        if (!is_null($keepAllJournalsForDays) && !(is_int($keepAllJournalsForDays) || ctype_digit($keepAllJournalsForDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keepAllJournalsForDays, true), gettype($keepAllJournalsForDays)), __LINE__);
        }
        if (is_null($keepAllJournalsForDays) || (is_array($keepAllJournalsForDays) && empty($keepAllJournalsForDays))) {
            unset($this->KeepAllJournalsForDays);
        } else {
            $this->KeepAllJournalsForDays = $keepAllJournalsForDays;
        }
        return $this;
    }
    /**
     * Get KeepApiTraceDataForDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKeepApiTraceDataForDays()
    {
        return isset($this->KeepApiTraceDataForDays) ? $this->KeepApiTraceDataForDays : null;
    }
    /**
     * Set KeepApiTraceDataForDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $keepApiTraceDataForDays
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setKeepApiTraceDataForDays($keepApiTraceDataForDays = null)
    {
        // validation for constraint: int
        if (!is_null($keepApiTraceDataForDays) && !(is_int($keepApiTraceDataForDays) || ctype_digit($keepApiTraceDataForDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keepApiTraceDataForDays, true), gettype($keepApiTraceDataForDays)), __LINE__);
        }
        if (is_null($keepApiTraceDataForDays) || (is_array($keepApiTraceDataForDays) && empty($keepApiTraceDataForDays))) {
            unset($this->KeepApiTraceDataForDays);
        } else {
            $this->KeepApiTraceDataForDays = $keepApiTraceDataForDays;
        }
        return $this;
    }
    /**
     * Get KeepPrintingJournalsForDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKeepPrintingJournalsForDays()
    {
        return isset($this->KeepPrintingJournalsForDays) ? $this->KeepPrintingJournalsForDays : null;
    }
    /**
     * Set KeepPrintingJournalsForDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $keepPrintingJournalsForDays
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setKeepPrintingJournalsForDays($keepPrintingJournalsForDays = null)
    {
        // validation for constraint: int
        if (!is_null($keepPrintingJournalsForDays) && !(is_int($keepPrintingJournalsForDays) || ctype_digit($keepPrintingJournalsForDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keepPrintingJournalsForDays, true), gettype($keepPrintingJournalsForDays)), __LINE__);
        }
        if (is_null($keepPrintingJournalsForDays) || (is_array($keepPrintingJournalsForDays) && empty($keepPrintingJournalsForDays))) {
            unset($this->KeepPrintingJournalsForDays);
        } else {
            $this->KeepPrintingJournalsForDays = $keepPrintingJournalsForDays;
        }
        return $this;
    }
    /**
     * Get KeepScheduledQueryExecutions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKeepScheduledQueryExecutions()
    {
        return isset($this->KeepScheduledQueryExecutions) ? $this->KeepScheduledQueryExecutions : null;
    }
    /**
     * Set KeepScheduledQueryExecutions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $keepScheduledQueryExecutions
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setKeepScheduledQueryExecutions($keepScheduledQueryExecutions = null)
    {
        // validation for constraint: int
        if (!is_null($keepScheduledQueryExecutions) && !(is_int($keepScheduledQueryExecutions) || ctype_digit($keepScheduledQueryExecutions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keepScheduledQueryExecutions, true), gettype($keepScheduledQueryExecutions)), __LINE__);
        }
        if (is_null($keepScheduledQueryExecutions) || (is_array($keepScheduledQueryExecutions) && empty($keepScheduledQueryExecutions))) {
            unset($this->KeepScheduledQueryExecutions);
        } else {
            $this->KeepScheduledQueryExecutions = $keepScheduledQueryExecutions;
        }
        return $this;
    }
    /**
     * Get KeepTraceAndMonitoringForDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKeepTraceAndMonitoringForDays()
    {
        return isset($this->KeepTraceAndMonitoringForDays) ? $this->KeepTraceAndMonitoringForDays : null;
    }
    /**
     * Set KeepTraceAndMonitoringForDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $keepTraceAndMonitoringForDays
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setKeepTraceAndMonitoringForDays($keepTraceAndMonitoringForDays = null)
    {
        // validation for constraint: int
        if (!is_null($keepTraceAndMonitoringForDays) && !(is_int($keepTraceAndMonitoringForDays) || ctype_digit($keepTraceAndMonitoringForDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keepTraceAndMonitoringForDays, true), gettype($keepTraceAndMonitoringForDays)), __LINE__);
        }
        if (is_null($keepTraceAndMonitoringForDays) || (is_array($keepTraceAndMonitoringForDays) && empty($keepTraceAndMonitoringForDays))) {
            unset($this->KeepTraceAndMonitoringForDays);
        } else {
            $this->KeepTraceAndMonitoringForDays = $keepTraceAndMonitoringForDays;
        }
        return $this;
    }
    /**
     * Get KeepUserJournalsForDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKeepUserJournalsForDays()
    {
        return isset($this->KeepUserJournalsForDays) ? $this->KeepUserJournalsForDays : null;
    }
    /**
     * Set KeepUserJournalsForDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $keepUserJournalsForDays
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setKeepUserJournalsForDays($keepUserJournalsForDays = null)
    {
        // validation for constraint: int
        if (!is_null($keepUserJournalsForDays) && !(is_int($keepUserJournalsForDays) || ctype_digit($keepUserJournalsForDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keepUserJournalsForDays, true), gettype($keepUserJournalsForDays)), __LINE__);
        }
        if (is_null($keepUserJournalsForDays) || (is_array($keepUserJournalsForDays) && empty($keepUserJournalsForDays))) {
            unset($this->KeepUserJournalsForDays);
        } else {
            $this->KeepUserJournalsForDays = $keepUserJournalsForDays;
        }
        return $this;
    }
    /**
     * Get MaxImageResolution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxImageResolution()
    {
        return isset($this->MaxImageResolution) ? $this->MaxImageResolution : null;
    }
    /**
     * Set MaxImageResolution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxImageResolution
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setMaxImageResolution($maxImageResolution = null)
    {
        // validation for constraint: int
        if (!is_null($maxImageResolution) && !(is_int($maxImageResolution) || ctype_digit($maxImageResolution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxImageResolution, true), gettype($maxImageResolution)), __LINE__);
        }
        if (is_null($maxImageResolution) || (is_array($maxImageResolution) && empty($maxImageResolution))) {
            unset($this->MaxImageResolution);
        } else {
            $this->MaxImageResolution = $maxImageResolution;
        }
        return $this;
    }
    /**
     * Get MaxImageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxImageSize()
    {
        return isset($this->MaxImageSize) ? $this->MaxImageSize : null;
    }
    /**
     * Set MaxImageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxImageSize
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setMaxImageSize($maxImageSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxImageSize) && !(is_int($maxImageSize) || ctype_digit($maxImageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxImageSize, true), gettype($maxImageSize)), __LINE__);
        }
        if (is_null($maxImageSize) || (is_array($maxImageSize) && empty($maxImageSize))) {
            unset($this->MaxImageSize);
        } else {
            $this->MaxImageSize = $maxImageSize;
        }
        return $this;
    }
    /**
     * Get MaxRetriesOn502Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxRetriesOn502Error()
    {
        return isset($this->MaxRetriesOn502Error) ? $this->MaxRetriesOn502Error : null;
    }
    /**
     * Set MaxRetriesOn502Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxRetriesOn502Error
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setMaxRetriesOn502Error($maxRetriesOn502Error = null)
    {
        // validation for constraint: int
        if (!is_null($maxRetriesOn502Error) && !(is_int($maxRetriesOn502Error) || ctype_digit($maxRetriesOn502Error))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRetriesOn502Error, true), gettype($maxRetriesOn502Error)), __LINE__);
        }
        if (is_null($maxRetriesOn502Error) || (is_array($maxRetriesOn502Error) && empty($maxRetriesOn502Error))) {
            unset($this->MaxRetriesOn502Error);
        } else {
            $this->MaxRetriesOn502Error = $maxRetriesOn502Error;
        }
        return $this;
    }
    /**
     * Get MaxRetriesOnNetworkError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxRetriesOnNetworkError()
    {
        return isset($this->MaxRetriesOnNetworkError) ? $this->MaxRetriesOnNetworkError : null;
    }
    /**
     * Set MaxRetriesOnNetworkError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxRetriesOnNetworkError
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setMaxRetriesOnNetworkError($maxRetriesOnNetworkError = null)
    {
        // validation for constraint: int
        if (!is_null($maxRetriesOnNetworkError) && !(is_int($maxRetriesOnNetworkError) || ctype_digit($maxRetriesOnNetworkError))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRetriesOnNetworkError, true), gettype($maxRetriesOnNetworkError)), __LINE__);
        }
        if (is_null($maxRetriesOnNetworkError) || (is_array($maxRetriesOnNetworkError) && empty($maxRetriesOnNetworkError))) {
            unset($this->MaxRetriesOnNetworkError);
        } else {
            $this->MaxRetriesOnNetworkError = $maxRetriesOnNetworkError;
        }
        return $this;
    }
    /**
     * Get MaxSuccessfulRetriesOnNetworkError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSuccessfulRetriesOnNetworkError()
    {
        return isset($this->MaxSuccessfulRetriesOnNetworkError) ? $this->MaxSuccessfulRetriesOnNetworkError : null;
    }
    /**
     * Set MaxSuccessfulRetriesOnNetworkError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSuccessfulRetriesOnNetworkError
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setMaxSuccessfulRetriesOnNetworkError($maxSuccessfulRetriesOnNetworkError = null)
    {
        // validation for constraint: int
        if (!is_null($maxSuccessfulRetriesOnNetworkError) && !(is_int($maxSuccessfulRetriesOnNetworkError) || ctype_digit($maxSuccessfulRetriesOnNetworkError))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSuccessfulRetriesOnNetworkError, true), gettype($maxSuccessfulRetriesOnNetworkError)), __LINE__);
        }
        if (is_null($maxSuccessfulRetriesOnNetworkError) || (is_array($maxSuccessfulRetriesOnNetworkError) && empty($maxSuccessfulRetriesOnNetworkError))) {
            unset($this->MaxSuccessfulRetriesOnNetworkError);
        } else {
            $this->MaxSuccessfulRetriesOnNetworkError = $maxSuccessfulRetriesOnNetworkError;
        }
        return $this;
    }
    /**
     * Get MembershipCardMagneticStripeDataType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipCardMagneticStripeDataType()
    {
        return isset($this->MembershipCardMagneticStripeDataType) ? $this->MembershipCardMagneticStripeDataType : null;
    }
    /**
     * Set MembershipCardMagneticStripeDataType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipCardMagneticStripeDataType::valueIsValid()
     * @uses \patest\EnumType\MembershipCardMagneticStripeDataType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $membershipCardMagneticStripeDataType
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setMembershipCardMagneticStripeDataType($membershipCardMagneticStripeDataType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipCardMagneticStripeDataType::valueIsValid($membershipCardMagneticStripeDataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipCardMagneticStripeDataType', is_array($membershipCardMagneticStripeDataType) ? implode(', ', $membershipCardMagneticStripeDataType) : var_export($membershipCardMagneticStripeDataType, true), implode(', ', \patest\EnumType\MembershipCardMagneticStripeDataType::getValidValues())), __LINE__);
        }
        if (is_null($membershipCardMagneticStripeDataType) || (is_array($membershipCardMagneticStripeDataType) && empty($membershipCardMagneticStripeDataType))) {
            unset($this->MembershipCardMagneticStripeDataType);
        } else {
            $this->MembershipCardMagneticStripeDataType = $membershipCardMagneticStripeDataType;
        }
        return $this;
    }
    /**
     * Get SubscriptionCardMagneticStripeDataType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionCardMagneticStripeDataType()
    {
        return isset($this->SubscriptionCardMagneticStripeDataType) ? $this->SubscriptionCardMagneticStripeDataType : null;
    }
    /**
     * Set SubscriptionCardMagneticStripeDataType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionCardMagneticStripeDataType::valueIsValid()
     * @uses \patest\EnumType\SubscriptionCardMagneticStripeDataType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionCardMagneticStripeDataType
     * @return \patest\StructType\Security_GeneralCompanyParameters
     */
    public function setSubscriptionCardMagneticStripeDataType($subscriptionCardMagneticStripeDataType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionCardMagneticStripeDataType::valueIsValid($subscriptionCardMagneticStripeDataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionCardMagneticStripeDataType', is_array($subscriptionCardMagneticStripeDataType) ? implode(', ', $subscriptionCardMagneticStripeDataType) : var_export($subscriptionCardMagneticStripeDataType, true), implode(', ', \patest\EnumType\SubscriptionCardMagneticStripeDataType::getValidValues())), __LINE__);
        }
        if (is_null($subscriptionCardMagneticStripeDataType) || (is_array($subscriptionCardMagneticStripeDataType) && empty($subscriptionCardMagneticStripeDataType))) {
            unset($this->SubscriptionCardMagneticStripeDataType);
        } else {
            $this->SubscriptionCardMagneticStripeDataType = $subscriptionCardMagneticStripeDataType;
        }
        return $this;
    }
}
