<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.DataAccessRule StructType
 * @subpackage Structs
 */
class Security_DataAccessRule extends VolatileEntity
{
    /**
     * The BusinessFlow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessFlow;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The IsAccessAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccessAllowed;
    /**
     * The SecurityTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecurityTokenId;
    /**
     * Constructor method for Security.DataAccessRule
     * @uses Security_DataAccessRule::setBusinessFlow()
     * @uses Security_DataAccessRule::setEntityName()
     * @uses Security_DataAccessRule::setIsAccessAllowed()
     * @uses Security_DataAccessRule::setSecurityTokenId()
     * @param string $businessFlow
     * @param string $entityName
     * @param bool $isAccessAllowed
     * @param string $securityTokenId
     */
    public function __construct($businessFlow = null, $entityName = null, $isAccessAllowed = null, $securityTokenId = null)
    {
        $this
            ->setBusinessFlow($businessFlow)
            ->setEntityName($entityName)
            ->setIsAccessAllowed($isAccessAllowed)
            ->setSecurityTokenId($securityTokenId);
    }
    /**
     * Get BusinessFlow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessFlow()
    {
        return isset($this->BusinessFlow) ? $this->BusinessFlow : null;
    }
    /**
     * Set BusinessFlow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessFlow
     * @return \patest\StructType\Security_DataAccessRule
     */
    public function setBusinessFlow($businessFlow = null)
    {
        // validation for constraint: string
        if (!is_null($businessFlow) && !is_string($businessFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessFlow, true), gettype($businessFlow)), __LINE__);
        }
        if (is_null($businessFlow) || (is_array($businessFlow) && empty($businessFlow))) {
            unset($this->BusinessFlow);
        } else {
            $this->BusinessFlow = $businessFlow;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\Security_DataAccessRule
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get IsAccessAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccessAllowed()
    {
        return isset($this->IsAccessAllowed) ? $this->IsAccessAllowed : null;
    }
    /**
     * Set IsAccessAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccessAllowed
     * @return \patest\StructType\Security_DataAccessRule
     */
    public function setIsAccessAllowed($isAccessAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccessAllowed) && !is_bool($isAccessAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccessAllowed, true), gettype($isAccessAllowed)), __LINE__);
        }
        if (is_null($isAccessAllowed) || (is_array($isAccessAllowed) && empty($isAccessAllowed))) {
            unset($this->IsAccessAllowed);
        } else {
            $this->IsAccessAllowed = $isAccessAllowed;
        }
        return $this;
    }
    /**
     * Get SecurityTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenId()
    {
        return isset($this->SecurityTokenId) ? $this->SecurityTokenId : null;
    }
    /**
     * Set SecurityTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenId
     * @return \patest\StructType\Security_DataAccessRule
     */
    public function setSecurityTokenId($securityTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenId) && !is_string($securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenId, true), gettype($securityTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($securityTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($securityTokenId, true)), __LINE__);
        }
        if (is_null($securityTokenId) || (is_array($securityTokenId) && empty($securityTokenId))) {
            unset($this->SecurityTokenId);
        } else {
            $this->SecurityTokenId = $securityTokenId;
        }
        return $this;
    }
}
