<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.CrmCompanyParameters StructType
 * @subpackage Structs
 */
class Security_CrmCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AccountDefaultFullNameFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountDefaultFullNameFormat;
    /**
     * The AccountDefaultMarketingFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountDefaultMarketingFormat;
    /**
     * The AccountDefaultPrintingFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountDefaultPrintingFormat;
    /**
     * The AccountDefaultReportingFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountDefaultReportingFormat;
    /**
     * The AccountDefaultReportingSortableFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountDefaultReportingSortableFormat;
    /**
     * The AccountDefaultSortableNameFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountDefaultSortableNameFormat;
    /**
     * The AddressPropertiesAddedShouldBeApproved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AddressPropertiesAddedShouldBeApproved;
    /**
     * The AllowAuthenticateByCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowAuthenticateByCrmId;
    /**
     * The AutoDisplayCrmAdvancedSearchDialog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutoDisplayCrmAdvancedSearchDialog;
    /**
     * The AutoGenerateClientCredentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutoGenerateClientCredentials;
    /**
     * The AutoReturnToCRMAfterSales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutoReturnToCRMAfterSales;
    /**
     * The CalculateTotalsStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CalculateTotalsStartDate;
    /**
     * The ClientAnswerExpiresAfterMonth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClientAnswerExpiresAfterMonth;
    /**
     * The ClientImageTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientImageTypes;
    /**
     * The CustomClientBalance1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomClientBalance1;
    /**
     * The CustomClientBalance2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomClientBalance2;
    /**
     * The CustomClientBalance3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomClientBalance3;
    /**
     * The CustomerDefaultFullNameFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerDefaultFullNameFormat;
    /**
     * The CustomerDefaultMarketingFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerDefaultMarketingFormat;
    /**
     * The CustomerDefaultPrintingFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerDefaultPrintingFormat;
    /**
     * The CustomerDefaultReportingFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerDefaultReportingFormat;
    /**
     * The CustomerDefaultReportingSortableFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerDefaultReportingSortableFormat;
    /**
     * The CustomerDefaultSortableNameFormat
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerDefaultSortableNameFormat;
    /**
     * The DefaultAddressValidationProvider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultAddressValidationProvider;
    /**
     * The DefaultDateFilterInMonthsForClientProducts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultDateFilterInMonthsForClientProducts;
    /**
     * The DefaultDuplicatedClientRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultDuplicatedClientRecords;
    /**
     * The DefaultSearchSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultSearchSubject;
    /**
     * The DisplayAlsoNotInCustodyItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayAlsoNotInCustodyItems;
    /**
     * The DisplayAlsoObsoleteItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayAlsoObsoleteItems;
    /**
     * The DisplayAlsoReturnedItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayAlsoReturnedItems;
    /**
     * The DisplayAlsoSoftCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayAlsoSoftCredit;
    /**
     * The DisplayAlsoSubscriptionTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayAlsoSubscriptionTickets;
    /**
     * The DisplayMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayMode;
    /**
     * The EmailValidationPackageName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailValidationPackageName;
    /**
     * The EnforceMaxNonStrongRelationshipViaApplications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnforceMaxNonStrongRelationshipViaApplications;
    /**
     * The ExternalValidationRecoveryInMins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExternalValidationRecoveryInMins;
    /**
     * The ExternalValidationTimeoutInSecs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExternalValidationTimeoutInSecs;
    /**
     * The GroupsBatchSizeForCrmGrids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupsBatchSizeForCrmGrids;
    /**
     * The IncludeCustomersWithSpecifiedRelationshipsInReservedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeCustomersWithSpecifiedRelationshipsInReservedSeats;
    /**
     * The LoqateAddressCaptureDefaultCountryCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoqateAddressCaptureDefaultCountryCodes;
    /**
     * The LoqateAddressCaptureFindApiUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoqateAddressCaptureFindApiUrl;
    /**
     * The LoqateAddressCaptureKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoqateAddressCaptureKey;
    /**
     * The LoqateAddressCaptureResultsLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LoqateAddressCaptureResultsLimit;
    /**
     * The LoqateAddressCaptureRetrieveApiUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoqateAddressCaptureRetrieveApiUrl;
    /**
     * The LoqateAddressCaptureSaveHouseNumberInAddressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LoqateAddressCaptureSaveHouseNumberInAddressLine2;
    /**
     * The MaxClientImageFileSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxClientImageFileSize;
    /**
     * The MaxClientImageHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxClientImageHeight;
    /**
     * The MaxClientImageWidth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxClientImageWidth;
    /**
     * The MaxItemsToProcessInCrmGrids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxItemsToProcessInCrmGrids;
    /**
     * The MinClientImageHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinClientImageHeight;
    /**
     * The MinClientImageWidth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinClientImageWidth;
    /**
     * The MultiOrgUnitClientsAccessibleByCreatorOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MultiOrgUnitClientsAccessibleByCreatorOnly;
    /**
     * The PhoneValidationPackageName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneValidationPackageName;
    /**
     * The RelationshipsApprovalViaApplications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationshipsApprovalViaApplications;
    /**
     * The RelationshipTypesToRecommend
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationshipTypesToRecommend;
    /**
     * The ResetCrmUserParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ResetCrmUserParameters;
    /**
     * The SendEmailForClientCreatedViaAplications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SendEmailForClientCreatedViaAplications;
    /**
     * The SgoOpenSroApiTicketsPreviewUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SgoOpenSroApiTicketsPreviewUrl;
    /**
     * The UseAddressSearchAndValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseAddressSearchAndValidation;
    /**
     * The UseEmailValidationProvider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseEmailValidationProvider;
    /**
     * The UsePhoneValidationProvider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsePhoneValidationProvider;
    /**
     * Constructor method for Security.CrmCompanyParameters
     * @uses Security_CrmCompanyParameters::setAccountDefaultFullNameFormat()
     * @uses Security_CrmCompanyParameters::setAccountDefaultMarketingFormat()
     * @uses Security_CrmCompanyParameters::setAccountDefaultPrintingFormat()
     * @uses Security_CrmCompanyParameters::setAccountDefaultReportingFormat()
     * @uses Security_CrmCompanyParameters::setAccountDefaultReportingSortableFormat()
     * @uses Security_CrmCompanyParameters::setAccountDefaultSortableNameFormat()
     * @uses Security_CrmCompanyParameters::setAddressPropertiesAddedShouldBeApproved()
     * @uses Security_CrmCompanyParameters::setAllowAuthenticateByCrmId()
     * @uses Security_CrmCompanyParameters::setAutoDisplayCrmAdvancedSearchDialog()
     * @uses Security_CrmCompanyParameters::setAutoGenerateClientCredentials()
     * @uses Security_CrmCompanyParameters::setAutoReturnToCRMAfterSales()
     * @uses Security_CrmCompanyParameters::setCalculateTotalsStartDate()
     * @uses Security_CrmCompanyParameters::setClientAnswerExpiresAfterMonth()
     * @uses Security_CrmCompanyParameters::setClientImageTypes()
     * @uses Security_CrmCompanyParameters::setCustomClientBalance1()
     * @uses Security_CrmCompanyParameters::setCustomClientBalance2()
     * @uses Security_CrmCompanyParameters::setCustomClientBalance3()
     * @uses Security_CrmCompanyParameters::setCustomerDefaultFullNameFormat()
     * @uses Security_CrmCompanyParameters::setCustomerDefaultMarketingFormat()
     * @uses Security_CrmCompanyParameters::setCustomerDefaultPrintingFormat()
     * @uses Security_CrmCompanyParameters::setCustomerDefaultReportingFormat()
     * @uses Security_CrmCompanyParameters::setCustomerDefaultReportingSortableFormat()
     * @uses Security_CrmCompanyParameters::setCustomerDefaultSortableNameFormat()
     * @uses Security_CrmCompanyParameters::setDefaultAddressValidationProvider()
     * @uses Security_CrmCompanyParameters::setDefaultDateFilterInMonthsForClientProducts()
     * @uses Security_CrmCompanyParameters::setDefaultDuplicatedClientRecords()
     * @uses Security_CrmCompanyParameters::setDefaultSearchSubject()
     * @uses Security_CrmCompanyParameters::setDisplayAlsoNotInCustodyItems()
     * @uses Security_CrmCompanyParameters::setDisplayAlsoObsoleteItems()
     * @uses Security_CrmCompanyParameters::setDisplayAlsoReturnedItems()
     * @uses Security_CrmCompanyParameters::setDisplayAlsoSoftCredit()
     * @uses Security_CrmCompanyParameters::setDisplayAlsoSubscriptionTickets()
     * @uses Security_CrmCompanyParameters::setDisplayMode()
     * @uses Security_CrmCompanyParameters::setEmailValidationPackageName()
     * @uses Security_CrmCompanyParameters::setEnforceMaxNonStrongRelationshipViaApplications()
     * @uses Security_CrmCompanyParameters::setExternalValidationRecoveryInMins()
     * @uses Security_CrmCompanyParameters::setExternalValidationTimeoutInSecs()
     * @uses Security_CrmCompanyParameters::setGroupsBatchSizeForCrmGrids()
     * @uses Security_CrmCompanyParameters::setIncludeCustomersWithSpecifiedRelationshipsInReservedSeats()
     * @uses Security_CrmCompanyParameters::setLoqateAddressCaptureDefaultCountryCodes()
     * @uses Security_CrmCompanyParameters::setLoqateAddressCaptureFindApiUrl()
     * @uses Security_CrmCompanyParameters::setLoqateAddressCaptureKey()
     * @uses Security_CrmCompanyParameters::setLoqateAddressCaptureResultsLimit()
     * @uses Security_CrmCompanyParameters::setLoqateAddressCaptureRetrieveApiUrl()
     * @uses Security_CrmCompanyParameters::setLoqateAddressCaptureSaveHouseNumberInAddressLine2()
     * @uses Security_CrmCompanyParameters::setMaxClientImageFileSize()
     * @uses Security_CrmCompanyParameters::setMaxClientImageHeight()
     * @uses Security_CrmCompanyParameters::setMaxClientImageWidth()
     * @uses Security_CrmCompanyParameters::setMaxItemsToProcessInCrmGrids()
     * @uses Security_CrmCompanyParameters::setMinClientImageHeight()
     * @uses Security_CrmCompanyParameters::setMinClientImageWidth()
     * @uses Security_CrmCompanyParameters::setMultiOrgUnitClientsAccessibleByCreatorOnly()
     * @uses Security_CrmCompanyParameters::setPhoneValidationPackageName()
     * @uses Security_CrmCompanyParameters::setRelationshipsApprovalViaApplications()
     * @uses Security_CrmCompanyParameters::setRelationshipTypesToRecommend()
     * @uses Security_CrmCompanyParameters::setResetCrmUserParameters()
     * @uses Security_CrmCompanyParameters::setSendEmailForClientCreatedViaAplications()
     * @uses Security_CrmCompanyParameters::setSgoOpenSroApiTicketsPreviewUrl()
     * @uses Security_CrmCompanyParameters::setUseAddressSearchAndValidation()
     * @uses Security_CrmCompanyParameters::setUseEmailValidationProvider()
     * @uses Security_CrmCompanyParameters::setUsePhoneValidationProvider()
     * @param string $accountDefaultFullNameFormat
     * @param string $accountDefaultMarketingFormat
     * @param string $accountDefaultPrintingFormat
     * @param string $accountDefaultReportingFormat
     * @param string $accountDefaultReportingSortableFormat
     * @param string $accountDefaultSortableNameFormat
     * @param bool $addressPropertiesAddedShouldBeApproved
     * @param bool $allowAuthenticateByCrmId
     * @param bool $autoDisplayCrmAdvancedSearchDialog
     * @param bool $autoGenerateClientCredentials
     * @param bool $autoReturnToCRMAfterSales
     * @param string $calculateTotalsStartDate
     * @param int $clientAnswerExpiresAfterMonth
     * @param string $clientImageTypes
     * @param string $customClientBalance1
     * @param string $customClientBalance2
     * @param string $customClientBalance3
     * @param string $customerDefaultFullNameFormat
     * @param string $customerDefaultMarketingFormat
     * @param string $customerDefaultPrintingFormat
     * @param string $customerDefaultReportingFormat
     * @param string $customerDefaultReportingSortableFormat
     * @param string $customerDefaultSortableNameFormat
     * @param string $defaultAddressValidationProvider
     * @param int $defaultDateFilterInMonthsForClientProducts
     * @param int $defaultDuplicatedClientRecords
     * @param string $defaultSearchSubject
     * @param bool $displayAlsoNotInCustodyItems
     * @param bool $displayAlsoObsoleteItems
     * @param bool $displayAlsoReturnedItems
     * @param bool $displayAlsoSoftCredit
     * @param bool $displayAlsoSubscriptionTickets
     * @param string $displayMode
     * @param string $emailValidationPackageName
     * @param string $enforceMaxNonStrongRelationshipViaApplications
     * @param int $externalValidationRecoveryInMins
     * @param int $externalValidationTimeoutInSecs
     * @param int $groupsBatchSizeForCrmGrids
     * @param bool $includeCustomersWithSpecifiedRelationshipsInReservedSeats
     * @param string $loqateAddressCaptureDefaultCountryCodes
     * @param string $loqateAddressCaptureFindApiUrl
     * @param string $loqateAddressCaptureKey
     * @param int $loqateAddressCaptureResultsLimit
     * @param string $loqateAddressCaptureRetrieveApiUrl
     * @param bool $loqateAddressCaptureSaveHouseNumberInAddressLine2
     * @param int $maxClientImageFileSize
     * @param int $maxClientImageHeight
     * @param int $maxClientImageWidth
     * @param int $maxItemsToProcessInCrmGrids
     * @param int $minClientImageHeight
     * @param int $minClientImageWidth
     * @param bool $multiOrgUnitClientsAccessibleByCreatorOnly
     * @param string $phoneValidationPackageName
     * @param string $relationshipsApprovalViaApplications
     * @param string $relationshipTypesToRecommend
     * @param bool $resetCrmUserParameters
     * @param string $sendEmailForClientCreatedViaAplications
     * @param string $sgoOpenSroApiTicketsPreviewUrl
     * @param bool $useAddressSearchAndValidation
     * @param bool $useEmailValidationProvider
     * @param bool $usePhoneValidationProvider
     */
    public function __construct($accountDefaultFullNameFormat = null, $accountDefaultMarketingFormat = null, $accountDefaultPrintingFormat = null, $accountDefaultReportingFormat = null, $accountDefaultReportingSortableFormat = null, $accountDefaultSortableNameFormat = null, $addressPropertiesAddedShouldBeApproved = null, $allowAuthenticateByCrmId = null, $autoDisplayCrmAdvancedSearchDialog = null, $autoGenerateClientCredentials = null, $autoReturnToCRMAfterSales = null, $calculateTotalsStartDate = null, $clientAnswerExpiresAfterMonth = null, $clientImageTypes = null, $customClientBalance1 = null, $customClientBalance2 = null, $customClientBalance3 = null, $customerDefaultFullNameFormat = null, $customerDefaultMarketingFormat = null, $customerDefaultPrintingFormat = null, $customerDefaultReportingFormat = null, $customerDefaultReportingSortableFormat = null, $customerDefaultSortableNameFormat = null, $defaultAddressValidationProvider = null, $defaultDateFilterInMonthsForClientProducts = null, $defaultDuplicatedClientRecords = null, $defaultSearchSubject = null, $displayAlsoNotInCustodyItems = null, $displayAlsoObsoleteItems = null, $displayAlsoReturnedItems = null, $displayAlsoSoftCredit = null, $displayAlsoSubscriptionTickets = null, $displayMode = null, $emailValidationPackageName = null, $enforceMaxNonStrongRelationshipViaApplications = null, $externalValidationRecoveryInMins = null, $externalValidationTimeoutInSecs = null, $groupsBatchSizeForCrmGrids = null, $includeCustomersWithSpecifiedRelationshipsInReservedSeats = null, $loqateAddressCaptureDefaultCountryCodes = null, $loqateAddressCaptureFindApiUrl = null, $loqateAddressCaptureKey = null, $loqateAddressCaptureResultsLimit = null, $loqateAddressCaptureRetrieveApiUrl = null, $loqateAddressCaptureSaveHouseNumberInAddressLine2 = null, $maxClientImageFileSize = null, $maxClientImageHeight = null, $maxClientImageWidth = null, $maxItemsToProcessInCrmGrids = null, $minClientImageHeight = null, $minClientImageWidth = null, $multiOrgUnitClientsAccessibleByCreatorOnly = null, $phoneValidationPackageName = null, $relationshipsApprovalViaApplications = null, $relationshipTypesToRecommend = null, $resetCrmUserParameters = null, $sendEmailForClientCreatedViaAplications = null, $sgoOpenSroApiTicketsPreviewUrl = null, $useAddressSearchAndValidation = null, $useEmailValidationProvider = null, $usePhoneValidationProvider = null)
    {
        $this
            ->setAccountDefaultFullNameFormat($accountDefaultFullNameFormat)
            ->setAccountDefaultMarketingFormat($accountDefaultMarketingFormat)
            ->setAccountDefaultPrintingFormat($accountDefaultPrintingFormat)
            ->setAccountDefaultReportingFormat($accountDefaultReportingFormat)
            ->setAccountDefaultReportingSortableFormat($accountDefaultReportingSortableFormat)
            ->setAccountDefaultSortableNameFormat($accountDefaultSortableNameFormat)
            ->setAddressPropertiesAddedShouldBeApproved($addressPropertiesAddedShouldBeApproved)
            ->setAllowAuthenticateByCrmId($allowAuthenticateByCrmId)
            ->setAutoDisplayCrmAdvancedSearchDialog($autoDisplayCrmAdvancedSearchDialog)
            ->setAutoGenerateClientCredentials($autoGenerateClientCredentials)
            ->setAutoReturnToCRMAfterSales($autoReturnToCRMAfterSales)
            ->setCalculateTotalsStartDate($calculateTotalsStartDate)
            ->setClientAnswerExpiresAfterMonth($clientAnswerExpiresAfterMonth)
            ->setClientImageTypes($clientImageTypes)
            ->setCustomClientBalance1($customClientBalance1)
            ->setCustomClientBalance2($customClientBalance2)
            ->setCustomClientBalance3($customClientBalance3)
            ->setCustomerDefaultFullNameFormat($customerDefaultFullNameFormat)
            ->setCustomerDefaultMarketingFormat($customerDefaultMarketingFormat)
            ->setCustomerDefaultPrintingFormat($customerDefaultPrintingFormat)
            ->setCustomerDefaultReportingFormat($customerDefaultReportingFormat)
            ->setCustomerDefaultReportingSortableFormat($customerDefaultReportingSortableFormat)
            ->setCustomerDefaultSortableNameFormat($customerDefaultSortableNameFormat)
            ->setDefaultAddressValidationProvider($defaultAddressValidationProvider)
            ->setDefaultDateFilterInMonthsForClientProducts($defaultDateFilterInMonthsForClientProducts)
            ->setDefaultDuplicatedClientRecords($defaultDuplicatedClientRecords)
            ->setDefaultSearchSubject($defaultSearchSubject)
            ->setDisplayAlsoNotInCustodyItems($displayAlsoNotInCustodyItems)
            ->setDisplayAlsoObsoleteItems($displayAlsoObsoleteItems)
            ->setDisplayAlsoReturnedItems($displayAlsoReturnedItems)
            ->setDisplayAlsoSoftCredit($displayAlsoSoftCredit)
            ->setDisplayAlsoSubscriptionTickets($displayAlsoSubscriptionTickets)
            ->setDisplayMode($displayMode)
            ->setEmailValidationPackageName($emailValidationPackageName)
            ->setEnforceMaxNonStrongRelationshipViaApplications($enforceMaxNonStrongRelationshipViaApplications)
            ->setExternalValidationRecoveryInMins($externalValidationRecoveryInMins)
            ->setExternalValidationTimeoutInSecs($externalValidationTimeoutInSecs)
            ->setGroupsBatchSizeForCrmGrids($groupsBatchSizeForCrmGrids)
            ->setIncludeCustomersWithSpecifiedRelationshipsInReservedSeats($includeCustomersWithSpecifiedRelationshipsInReservedSeats)
            ->setLoqateAddressCaptureDefaultCountryCodes($loqateAddressCaptureDefaultCountryCodes)
            ->setLoqateAddressCaptureFindApiUrl($loqateAddressCaptureFindApiUrl)
            ->setLoqateAddressCaptureKey($loqateAddressCaptureKey)
            ->setLoqateAddressCaptureResultsLimit($loqateAddressCaptureResultsLimit)
            ->setLoqateAddressCaptureRetrieveApiUrl($loqateAddressCaptureRetrieveApiUrl)
            ->setLoqateAddressCaptureSaveHouseNumberInAddressLine2($loqateAddressCaptureSaveHouseNumberInAddressLine2)
            ->setMaxClientImageFileSize($maxClientImageFileSize)
            ->setMaxClientImageHeight($maxClientImageHeight)
            ->setMaxClientImageWidth($maxClientImageWidth)
            ->setMaxItemsToProcessInCrmGrids($maxItemsToProcessInCrmGrids)
            ->setMinClientImageHeight($minClientImageHeight)
            ->setMinClientImageWidth($minClientImageWidth)
            ->setMultiOrgUnitClientsAccessibleByCreatorOnly($multiOrgUnitClientsAccessibleByCreatorOnly)
            ->setPhoneValidationPackageName($phoneValidationPackageName)
            ->setRelationshipsApprovalViaApplications($relationshipsApprovalViaApplications)
            ->setRelationshipTypesToRecommend($relationshipTypesToRecommend)
            ->setResetCrmUserParameters($resetCrmUserParameters)
            ->setSendEmailForClientCreatedViaAplications($sendEmailForClientCreatedViaAplications)
            ->setSgoOpenSroApiTicketsPreviewUrl($sgoOpenSroApiTicketsPreviewUrl)
            ->setUseAddressSearchAndValidation($useAddressSearchAndValidation)
            ->setUseEmailValidationProvider($useEmailValidationProvider)
            ->setUsePhoneValidationProvider($usePhoneValidationProvider);
    }
    /**
     * Get AccountDefaultFullNameFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountDefaultFullNameFormat()
    {
        return isset($this->AccountDefaultFullNameFormat) ? $this->AccountDefaultFullNameFormat : null;
    }
    /**
     * Set AccountDefaultFullNameFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountDefaultFullNameFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAccountDefaultFullNameFormat($accountDefaultFullNameFormat = null)
    {
        // validation for constraint: string
        if (!is_null($accountDefaultFullNameFormat) && !is_string($accountDefaultFullNameFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountDefaultFullNameFormat, true), gettype($accountDefaultFullNameFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountDefaultFullNameFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountDefaultFullNameFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountDefaultFullNameFormat, true)), __LINE__);
        }
        if (is_null($accountDefaultFullNameFormat) || (is_array($accountDefaultFullNameFormat) && empty($accountDefaultFullNameFormat))) {
            unset($this->AccountDefaultFullNameFormat);
        } else {
            $this->AccountDefaultFullNameFormat = $accountDefaultFullNameFormat;
        }
        return $this;
    }
    /**
     * Get AccountDefaultMarketingFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountDefaultMarketingFormat()
    {
        return isset($this->AccountDefaultMarketingFormat) ? $this->AccountDefaultMarketingFormat : null;
    }
    /**
     * Set AccountDefaultMarketingFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountDefaultMarketingFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAccountDefaultMarketingFormat($accountDefaultMarketingFormat = null)
    {
        // validation for constraint: string
        if (!is_null($accountDefaultMarketingFormat) && !is_string($accountDefaultMarketingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountDefaultMarketingFormat, true), gettype($accountDefaultMarketingFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountDefaultMarketingFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountDefaultMarketingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountDefaultMarketingFormat, true)), __LINE__);
        }
        if (is_null($accountDefaultMarketingFormat) || (is_array($accountDefaultMarketingFormat) && empty($accountDefaultMarketingFormat))) {
            unset($this->AccountDefaultMarketingFormat);
        } else {
            $this->AccountDefaultMarketingFormat = $accountDefaultMarketingFormat;
        }
        return $this;
    }
    /**
     * Get AccountDefaultPrintingFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountDefaultPrintingFormat()
    {
        return isset($this->AccountDefaultPrintingFormat) ? $this->AccountDefaultPrintingFormat : null;
    }
    /**
     * Set AccountDefaultPrintingFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountDefaultPrintingFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAccountDefaultPrintingFormat($accountDefaultPrintingFormat = null)
    {
        // validation for constraint: string
        if (!is_null($accountDefaultPrintingFormat) && !is_string($accountDefaultPrintingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountDefaultPrintingFormat, true), gettype($accountDefaultPrintingFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountDefaultPrintingFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountDefaultPrintingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountDefaultPrintingFormat, true)), __LINE__);
        }
        if (is_null($accountDefaultPrintingFormat) || (is_array($accountDefaultPrintingFormat) && empty($accountDefaultPrintingFormat))) {
            unset($this->AccountDefaultPrintingFormat);
        } else {
            $this->AccountDefaultPrintingFormat = $accountDefaultPrintingFormat;
        }
        return $this;
    }
    /**
     * Get AccountDefaultReportingFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountDefaultReportingFormat()
    {
        return isset($this->AccountDefaultReportingFormat) ? $this->AccountDefaultReportingFormat : null;
    }
    /**
     * Set AccountDefaultReportingFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountDefaultReportingFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAccountDefaultReportingFormat($accountDefaultReportingFormat = null)
    {
        // validation for constraint: string
        if (!is_null($accountDefaultReportingFormat) && !is_string($accountDefaultReportingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountDefaultReportingFormat, true), gettype($accountDefaultReportingFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountDefaultReportingFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountDefaultReportingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountDefaultReportingFormat, true)), __LINE__);
        }
        if (is_null($accountDefaultReportingFormat) || (is_array($accountDefaultReportingFormat) && empty($accountDefaultReportingFormat))) {
            unset($this->AccountDefaultReportingFormat);
        } else {
            $this->AccountDefaultReportingFormat = $accountDefaultReportingFormat;
        }
        return $this;
    }
    /**
     * Get AccountDefaultReportingSortableFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountDefaultReportingSortableFormat()
    {
        return isset($this->AccountDefaultReportingSortableFormat) ? $this->AccountDefaultReportingSortableFormat : null;
    }
    /**
     * Set AccountDefaultReportingSortableFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountDefaultReportingSortableFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAccountDefaultReportingSortableFormat($accountDefaultReportingSortableFormat = null)
    {
        // validation for constraint: string
        if (!is_null($accountDefaultReportingSortableFormat) && !is_string($accountDefaultReportingSortableFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountDefaultReportingSortableFormat, true), gettype($accountDefaultReportingSortableFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountDefaultReportingSortableFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountDefaultReportingSortableFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountDefaultReportingSortableFormat, true)), __LINE__);
        }
        if (is_null($accountDefaultReportingSortableFormat) || (is_array($accountDefaultReportingSortableFormat) && empty($accountDefaultReportingSortableFormat))) {
            unset($this->AccountDefaultReportingSortableFormat);
        } else {
            $this->AccountDefaultReportingSortableFormat = $accountDefaultReportingSortableFormat;
        }
        return $this;
    }
    /**
     * Get AccountDefaultSortableNameFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountDefaultSortableNameFormat()
    {
        return isset($this->AccountDefaultSortableNameFormat) ? $this->AccountDefaultSortableNameFormat : null;
    }
    /**
     * Set AccountDefaultSortableNameFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountDefaultSortableNameFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAccountDefaultSortableNameFormat($accountDefaultSortableNameFormat = null)
    {
        // validation for constraint: string
        if (!is_null($accountDefaultSortableNameFormat) && !is_string($accountDefaultSortableNameFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountDefaultSortableNameFormat, true), gettype($accountDefaultSortableNameFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountDefaultSortableNameFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountDefaultSortableNameFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountDefaultSortableNameFormat, true)), __LINE__);
        }
        if (is_null($accountDefaultSortableNameFormat) || (is_array($accountDefaultSortableNameFormat) && empty($accountDefaultSortableNameFormat))) {
            unset($this->AccountDefaultSortableNameFormat);
        } else {
            $this->AccountDefaultSortableNameFormat = $accountDefaultSortableNameFormat;
        }
        return $this;
    }
    /**
     * Get AddressPropertiesAddedShouldBeApproved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAddressPropertiesAddedShouldBeApproved()
    {
        return isset($this->AddressPropertiesAddedShouldBeApproved) ? $this->AddressPropertiesAddedShouldBeApproved : null;
    }
    /**
     * Set AddressPropertiesAddedShouldBeApproved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $addressPropertiesAddedShouldBeApproved
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAddressPropertiesAddedShouldBeApproved($addressPropertiesAddedShouldBeApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressPropertiesAddedShouldBeApproved) && !is_bool($addressPropertiesAddedShouldBeApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressPropertiesAddedShouldBeApproved, true), gettype($addressPropertiesAddedShouldBeApproved)), __LINE__);
        }
        if (is_null($addressPropertiesAddedShouldBeApproved) || (is_array($addressPropertiesAddedShouldBeApproved) && empty($addressPropertiesAddedShouldBeApproved))) {
            unset($this->AddressPropertiesAddedShouldBeApproved);
        } else {
            $this->AddressPropertiesAddedShouldBeApproved = $addressPropertiesAddedShouldBeApproved;
        }
        return $this;
    }
    /**
     * Get AllowAuthenticateByCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowAuthenticateByCrmId()
    {
        return isset($this->AllowAuthenticateByCrmId) ? $this->AllowAuthenticateByCrmId : null;
    }
    /**
     * Set AllowAuthenticateByCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowAuthenticateByCrmId
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAllowAuthenticateByCrmId($allowAuthenticateByCrmId = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAuthenticateByCrmId) && !is_bool($allowAuthenticateByCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowAuthenticateByCrmId, true), gettype($allowAuthenticateByCrmId)), __LINE__);
        }
        if (is_null($allowAuthenticateByCrmId) || (is_array($allowAuthenticateByCrmId) && empty($allowAuthenticateByCrmId))) {
            unset($this->AllowAuthenticateByCrmId);
        } else {
            $this->AllowAuthenticateByCrmId = $allowAuthenticateByCrmId;
        }
        return $this;
    }
    /**
     * Get AutoDisplayCrmAdvancedSearchDialog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutoDisplayCrmAdvancedSearchDialog()
    {
        return isset($this->AutoDisplayCrmAdvancedSearchDialog) ? $this->AutoDisplayCrmAdvancedSearchDialog : null;
    }
    /**
     * Set AutoDisplayCrmAdvancedSearchDialog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $autoDisplayCrmAdvancedSearchDialog
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAutoDisplayCrmAdvancedSearchDialog($autoDisplayCrmAdvancedSearchDialog = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoDisplayCrmAdvancedSearchDialog) && !is_bool($autoDisplayCrmAdvancedSearchDialog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoDisplayCrmAdvancedSearchDialog, true), gettype($autoDisplayCrmAdvancedSearchDialog)), __LINE__);
        }
        if (is_null($autoDisplayCrmAdvancedSearchDialog) || (is_array($autoDisplayCrmAdvancedSearchDialog) && empty($autoDisplayCrmAdvancedSearchDialog))) {
            unset($this->AutoDisplayCrmAdvancedSearchDialog);
        } else {
            $this->AutoDisplayCrmAdvancedSearchDialog = $autoDisplayCrmAdvancedSearchDialog;
        }
        return $this;
    }
    /**
     * Get AutoGenerateClientCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutoGenerateClientCredentials()
    {
        return isset($this->AutoGenerateClientCredentials) ? $this->AutoGenerateClientCredentials : null;
    }
    /**
     * Set AutoGenerateClientCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $autoGenerateClientCredentials
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAutoGenerateClientCredentials($autoGenerateClientCredentials = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoGenerateClientCredentials) && !is_bool($autoGenerateClientCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoGenerateClientCredentials, true), gettype($autoGenerateClientCredentials)), __LINE__);
        }
        if (is_null($autoGenerateClientCredentials) || (is_array($autoGenerateClientCredentials) && empty($autoGenerateClientCredentials))) {
            unset($this->AutoGenerateClientCredentials);
        } else {
            $this->AutoGenerateClientCredentials = $autoGenerateClientCredentials;
        }
        return $this;
    }
    /**
     * Get AutoReturnToCRMAfterSales value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutoReturnToCRMAfterSales()
    {
        return isset($this->AutoReturnToCRMAfterSales) ? $this->AutoReturnToCRMAfterSales : null;
    }
    /**
     * Set AutoReturnToCRMAfterSales value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $autoReturnToCRMAfterSales
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setAutoReturnToCRMAfterSales($autoReturnToCRMAfterSales = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoReturnToCRMAfterSales) && !is_bool($autoReturnToCRMAfterSales)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoReturnToCRMAfterSales, true), gettype($autoReturnToCRMAfterSales)), __LINE__);
        }
        if (is_null($autoReturnToCRMAfterSales) || (is_array($autoReturnToCRMAfterSales) && empty($autoReturnToCRMAfterSales))) {
            unset($this->AutoReturnToCRMAfterSales);
        } else {
            $this->AutoReturnToCRMAfterSales = $autoReturnToCRMAfterSales;
        }
        return $this;
    }
    /**
     * Get CalculateTotalsStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalculateTotalsStartDate()
    {
        return isset($this->CalculateTotalsStartDate) ? $this->CalculateTotalsStartDate : null;
    }
    /**
     * Set CalculateTotalsStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calculateTotalsStartDate
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setCalculateTotalsStartDate($calculateTotalsStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($calculateTotalsStartDate) && !is_string($calculateTotalsStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calculateTotalsStartDate, true), gettype($calculateTotalsStartDate)), __LINE__);
        }
        if (is_null($calculateTotalsStartDate) || (is_array($calculateTotalsStartDate) && empty($calculateTotalsStartDate))) {
            unset($this->CalculateTotalsStartDate);
        } else {
            $this->CalculateTotalsStartDate = $calculateTotalsStartDate;
        }
        return $this;
    }
    /**
     * Get ClientAnswerExpiresAfterMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClientAnswerExpiresAfterMonth()
    {
        return isset($this->ClientAnswerExpiresAfterMonth) ? $this->ClientAnswerExpiresAfterMonth : null;
    }
    /**
     * Set ClientAnswerExpiresAfterMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clientAnswerExpiresAfterMonth
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setClientAnswerExpiresAfterMonth($clientAnswerExpiresAfterMonth = null)
    {
        // validation for constraint: int
        if (!is_null($clientAnswerExpiresAfterMonth) && !(is_int($clientAnswerExpiresAfterMonth) || ctype_digit($clientAnswerExpiresAfterMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientAnswerExpiresAfterMonth, true), gettype($clientAnswerExpiresAfterMonth)), __LINE__);
        }
        if (is_null($clientAnswerExpiresAfterMonth) || (is_array($clientAnswerExpiresAfterMonth) && empty($clientAnswerExpiresAfterMonth))) {
            unset($this->ClientAnswerExpiresAfterMonth);
        } else {
            $this->ClientAnswerExpiresAfterMonth = $clientAnswerExpiresAfterMonth;
        }
        return $this;
    }
    /**
     * Get ClientImageTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientImageTypes()
    {
        return isset($this->ClientImageTypes) ? $this->ClientImageTypes : null;
    }
    /**
     * Set ClientImageTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientImageTypes
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setClientImageTypes($clientImageTypes = null)
    {
        // validation for constraint: string
        if (!is_null($clientImageTypes) && !is_string($clientImageTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientImageTypes, true), gettype($clientImageTypes)), __LINE__);
        }
        if (is_null($clientImageTypes) || (is_array($clientImageTypes) && empty($clientImageTypes))) {
            unset($this->ClientImageTypes);
        } else {
            $this->ClientImageTypes = $clientImageTypes;
        }
        return $this;
    }
    /**
     * Get CustomClientBalance1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomClientBalance1()
    {
        return isset($this->CustomClientBalance1) ? $this->CustomClientBalance1 : null;
    }
    /**
     * Set CustomClientBalance1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customClientBalance1
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setCustomClientBalance1($customClientBalance1 = null)
    {
        // validation for constraint: string
        if (!is_null($customClientBalance1) && !is_string($customClientBalance1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customClientBalance1, true), gettype($customClientBalance1)), __LINE__);
        }
        if (is_null($customClientBalance1) || (is_array($customClientBalance1) && empty($customClientBalance1))) {
            unset($this->CustomClientBalance1);
        } else {
            $this->CustomClientBalance1 = $customClientBalance1;
        }
        return $this;
    }
    /**
     * Get CustomClientBalance2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomClientBalance2()
    {
        return isset($this->CustomClientBalance2) ? $this->CustomClientBalance2 : null;
    }
    /**
     * Set CustomClientBalance2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customClientBalance2
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setCustomClientBalance2($customClientBalance2 = null)
    {
        // validation for constraint: string
        if (!is_null($customClientBalance2) && !is_string($customClientBalance2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customClientBalance2, true), gettype($customClientBalance2)), __LINE__);
        }
        if (is_null($customClientBalance2) || (is_array($customClientBalance2) && empty($customClientBalance2))) {
            unset($this->CustomClientBalance2);
        } else {
            $this->CustomClientBalance2 = $customClientBalance2;
        }
        return $this;
    }
    /**
     * Get CustomClientBalance3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomClientBalance3()
    {
        return isset($this->CustomClientBalance3) ? $this->CustomClientBalance3 : null;
    }
    /**
     * Set CustomClientBalance3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customClientBalance3
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setCustomClientBalance3($customClientBalance3 = null)
    {
        // validation for constraint: string
        if (!is_null($customClientBalance3) && !is_string($customClientBalance3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customClientBalance3, true), gettype($customClientBalance3)), __LINE__);
        }
        if (is_null($customClientBalance3) || (is_array($customClientBalance3) && empty($customClientBalance3))) {
            unset($this->CustomClientBalance3);
        } else {
            $this->CustomClientBalance3 = $customClientBalance3;
        }
        return $this;
    }
    /**
     * Get CustomerDefaultFullNameFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerDefaultFullNameFormat()
    {
        return isset($this->CustomerDefaultFullNameFormat) ? $this->CustomerDefaultFullNameFormat : null;
    }
    /**
     * Set CustomerDefaultFullNameFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerDefaultFullNameFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setCustomerDefaultFullNameFormat($customerDefaultFullNameFormat = null)
    {
        // validation for constraint: string
        if (!is_null($customerDefaultFullNameFormat) && !is_string($customerDefaultFullNameFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDefaultFullNameFormat, true), gettype($customerDefaultFullNameFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerDefaultFullNameFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerDefaultFullNameFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerDefaultFullNameFormat, true)), __LINE__);
        }
        if (is_null($customerDefaultFullNameFormat) || (is_array($customerDefaultFullNameFormat) && empty($customerDefaultFullNameFormat))) {
            unset($this->CustomerDefaultFullNameFormat);
        } else {
            $this->CustomerDefaultFullNameFormat = $customerDefaultFullNameFormat;
        }
        return $this;
    }
    /**
     * Get CustomerDefaultMarketingFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerDefaultMarketingFormat()
    {
        return isset($this->CustomerDefaultMarketingFormat) ? $this->CustomerDefaultMarketingFormat : null;
    }
    /**
     * Set CustomerDefaultMarketingFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerDefaultMarketingFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setCustomerDefaultMarketingFormat($customerDefaultMarketingFormat = null)
    {
        // validation for constraint: string
        if (!is_null($customerDefaultMarketingFormat) && !is_string($customerDefaultMarketingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDefaultMarketingFormat, true), gettype($customerDefaultMarketingFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerDefaultMarketingFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerDefaultMarketingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerDefaultMarketingFormat, true)), __LINE__);
        }
        if (is_null($customerDefaultMarketingFormat) || (is_array($customerDefaultMarketingFormat) && empty($customerDefaultMarketingFormat))) {
            unset($this->CustomerDefaultMarketingFormat);
        } else {
            $this->CustomerDefaultMarketingFormat = $customerDefaultMarketingFormat;
        }
        return $this;
    }
    /**
     * Get CustomerDefaultPrintingFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerDefaultPrintingFormat()
    {
        return isset($this->CustomerDefaultPrintingFormat) ? $this->CustomerDefaultPrintingFormat : null;
    }
    /**
     * Set CustomerDefaultPrintingFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerDefaultPrintingFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setCustomerDefaultPrintingFormat($customerDefaultPrintingFormat = null)
    {
        // validation for constraint: string
        if (!is_null($customerDefaultPrintingFormat) && !is_string($customerDefaultPrintingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDefaultPrintingFormat, true), gettype($customerDefaultPrintingFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerDefaultPrintingFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerDefaultPrintingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerDefaultPrintingFormat, true)), __LINE__);
        }
        if (is_null($customerDefaultPrintingFormat) || (is_array($customerDefaultPrintingFormat) && empty($customerDefaultPrintingFormat))) {
            unset($this->CustomerDefaultPrintingFormat);
        } else {
            $this->CustomerDefaultPrintingFormat = $customerDefaultPrintingFormat;
        }
        return $this;
    }
    /**
     * Get CustomerDefaultReportingFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerDefaultReportingFormat()
    {
        return isset($this->CustomerDefaultReportingFormat) ? $this->CustomerDefaultReportingFormat : null;
    }
    /**
     * Set CustomerDefaultReportingFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerDefaultReportingFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setCustomerDefaultReportingFormat($customerDefaultReportingFormat = null)
    {
        // validation for constraint: string
        if (!is_null($customerDefaultReportingFormat) && !is_string($customerDefaultReportingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDefaultReportingFormat, true), gettype($customerDefaultReportingFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerDefaultReportingFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerDefaultReportingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerDefaultReportingFormat, true)), __LINE__);
        }
        if (is_null($customerDefaultReportingFormat) || (is_array($customerDefaultReportingFormat) && empty($customerDefaultReportingFormat))) {
            unset($this->CustomerDefaultReportingFormat);
        } else {
            $this->CustomerDefaultReportingFormat = $customerDefaultReportingFormat;
        }
        return $this;
    }
    /**
     * Get CustomerDefaultReportingSortableFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerDefaultReportingSortableFormat()
    {
        return isset($this->CustomerDefaultReportingSortableFormat) ? $this->CustomerDefaultReportingSortableFormat : null;
    }
    /**
     * Set CustomerDefaultReportingSortableFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerDefaultReportingSortableFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setCustomerDefaultReportingSortableFormat($customerDefaultReportingSortableFormat = null)
    {
        // validation for constraint: string
        if (!is_null($customerDefaultReportingSortableFormat) && !is_string($customerDefaultReportingSortableFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDefaultReportingSortableFormat, true), gettype($customerDefaultReportingSortableFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerDefaultReportingSortableFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerDefaultReportingSortableFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerDefaultReportingSortableFormat, true)), __LINE__);
        }
        if (is_null($customerDefaultReportingSortableFormat) || (is_array($customerDefaultReportingSortableFormat) && empty($customerDefaultReportingSortableFormat))) {
            unset($this->CustomerDefaultReportingSortableFormat);
        } else {
            $this->CustomerDefaultReportingSortableFormat = $customerDefaultReportingSortableFormat;
        }
        return $this;
    }
    /**
     * Get CustomerDefaultSortableNameFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerDefaultSortableNameFormat()
    {
        return isset($this->CustomerDefaultSortableNameFormat) ? $this->CustomerDefaultSortableNameFormat : null;
    }
    /**
     * Set CustomerDefaultSortableNameFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerDefaultSortableNameFormat
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setCustomerDefaultSortableNameFormat($customerDefaultSortableNameFormat = null)
    {
        // validation for constraint: string
        if (!is_null($customerDefaultSortableNameFormat) && !is_string($customerDefaultSortableNameFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDefaultSortableNameFormat, true), gettype($customerDefaultSortableNameFormat)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerDefaultSortableNameFormat) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerDefaultSortableNameFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerDefaultSortableNameFormat, true)), __LINE__);
        }
        if (is_null($customerDefaultSortableNameFormat) || (is_array($customerDefaultSortableNameFormat) && empty($customerDefaultSortableNameFormat))) {
            unset($this->CustomerDefaultSortableNameFormat);
        } else {
            $this->CustomerDefaultSortableNameFormat = $customerDefaultSortableNameFormat;
        }
        return $this;
    }
    /**
     * Get DefaultAddressValidationProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultAddressValidationProvider()
    {
        return isset($this->DefaultAddressValidationProvider) ? $this->DefaultAddressValidationProvider : null;
    }
    /**
     * Set DefaultAddressValidationProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultAddressValidationProvider
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setDefaultAddressValidationProvider($defaultAddressValidationProvider = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAddressValidationProvider) && !is_string($defaultAddressValidationProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAddressValidationProvider, true), gettype($defaultAddressValidationProvider)), __LINE__);
        }
        if (is_null($defaultAddressValidationProvider) || (is_array($defaultAddressValidationProvider) && empty($defaultAddressValidationProvider))) {
            unset($this->DefaultAddressValidationProvider);
        } else {
            $this->DefaultAddressValidationProvider = $defaultAddressValidationProvider;
        }
        return $this;
    }
    /**
     * Get DefaultDateFilterInMonthsForClientProducts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultDateFilterInMonthsForClientProducts()
    {
        return isset($this->DefaultDateFilterInMonthsForClientProducts) ? $this->DefaultDateFilterInMonthsForClientProducts : null;
    }
    /**
     * Set DefaultDateFilterInMonthsForClientProducts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultDateFilterInMonthsForClientProducts
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setDefaultDateFilterInMonthsForClientProducts($defaultDateFilterInMonthsForClientProducts = null)
    {
        // validation for constraint: int
        if (!is_null($defaultDateFilterInMonthsForClientProducts) && !(is_int($defaultDateFilterInMonthsForClientProducts) || ctype_digit($defaultDateFilterInMonthsForClientProducts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultDateFilterInMonthsForClientProducts, true), gettype($defaultDateFilterInMonthsForClientProducts)), __LINE__);
        }
        if (is_null($defaultDateFilterInMonthsForClientProducts) || (is_array($defaultDateFilterInMonthsForClientProducts) && empty($defaultDateFilterInMonthsForClientProducts))) {
            unset($this->DefaultDateFilterInMonthsForClientProducts);
        } else {
            $this->DefaultDateFilterInMonthsForClientProducts = $defaultDateFilterInMonthsForClientProducts;
        }
        return $this;
    }
    /**
     * Get DefaultDuplicatedClientRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultDuplicatedClientRecords()
    {
        return isset($this->DefaultDuplicatedClientRecords) ? $this->DefaultDuplicatedClientRecords : null;
    }
    /**
     * Set DefaultDuplicatedClientRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultDuplicatedClientRecords
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setDefaultDuplicatedClientRecords($defaultDuplicatedClientRecords = null)
    {
        // validation for constraint: int
        if (!is_null($defaultDuplicatedClientRecords) && !(is_int($defaultDuplicatedClientRecords) || ctype_digit($defaultDuplicatedClientRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultDuplicatedClientRecords, true), gettype($defaultDuplicatedClientRecords)), __LINE__);
        }
        if (is_null($defaultDuplicatedClientRecords) || (is_array($defaultDuplicatedClientRecords) && empty($defaultDuplicatedClientRecords))) {
            unset($this->DefaultDuplicatedClientRecords);
        } else {
            $this->DefaultDuplicatedClientRecords = $defaultDuplicatedClientRecords;
        }
        return $this;
    }
    /**
     * Get DefaultSearchSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSearchSubject()
    {
        return isset($this->DefaultSearchSubject) ? $this->DefaultSearchSubject : null;
    }
    /**
     * Set DefaultSearchSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSearchSubject
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setDefaultSearchSubject($defaultSearchSubject = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSearchSubject) && !is_string($defaultSearchSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSearchSubject, true), gettype($defaultSearchSubject)), __LINE__);
        }
        if (is_null($defaultSearchSubject) || (is_array($defaultSearchSubject) && empty($defaultSearchSubject))) {
            unset($this->DefaultSearchSubject);
        } else {
            $this->DefaultSearchSubject = $defaultSearchSubject;
        }
        return $this;
    }
    /**
     * Get DisplayAlsoNotInCustodyItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayAlsoNotInCustodyItems()
    {
        return isset($this->DisplayAlsoNotInCustodyItems) ? $this->DisplayAlsoNotInCustodyItems : null;
    }
    /**
     * Set DisplayAlsoNotInCustodyItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayAlsoNotInCustodyItems
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setDisplayAlsoNotInCustodyItems($displayAlsoNotInCustodyItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayAlsoNotInCustodyItems) && !is_bool($displayAlsoNotInCustodyItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayAlsoNotInCustodyItems, true), gettype($displayAlsoNotInCustodyItems)), __LINE__);
        }
        if (is_null($displayAlsoNotInCustodyItems) || (is_array($displayAlsoNotInCustodyItems) && empty($displayAlsoNotInCustodyItems))) {
            unset($this->DisplayAlsoNotInCustodyItems);
        } else {
            $this->DisplayAlsoNotInCustodyItems = $displayAlsoNotInCustodyItems;
        }
        return $this;
    }
    /**
     * Get DisplayAlsoObsoleteItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayAlsoObsoleteItems()
    {
        return isset($this->DisplayAlsoObsoleteItems) ? $this->DisplayAlsoObsoleteItems : null;
    }
    /**
     * Set DisplayAlsoObsoleteItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayAlsoObsoleteItems
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setDisplayAlsoObsoleteItems($displayAlsoObsoleteItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayAlsoObsoleteItems) && !is_bool($displayAlsoObsoleteItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayAlsoObsoleteItems, true), gettype($displayAlsoObsoleteItems)), __LINE__);
        }
        if (is_null($displayAlsoObsoleteItems) || (is_array($displayAlsoObsoleteItems) && empty($displayAlsoObsoleteItems))) {
            unset($this->DisplayAlsoObsoleteItems);
        } else {
            $this->DisplayAlsoObsoleteItems = $displayAlsoObsoleteItems;
        }
        return $this;
    }
    /**
     * Get DisplayAlsoReturnedItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayAlsoReturnedItems()
    {
        return isset($this->DisplayAlsoReturnedItems) ? $this->DisplayAlsoReturnedItems : null;
    }
    /**
     * Set DisplayAlsoReturnedItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayAlsoReturnedItems
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setDisplayAlsoReturnedItems($displayAlsoReturnedItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayAlsoReturnedItems) && !is_bool($displayAlsoReturnedItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayAlsoReturnedItems, true), gettype($displayAlsoReturnedItems)), __LINE__);
        }
        if (is_null($displayAlsoReturnedItems) || (is_array($displayAlsoReturnedItems) && empty($displayAlsoReturnedItems))) {
            unset($this->DisplayAlsoReturnedItems);
        } else {
            $this->DisplayAlsoReturnedItems = $displayAlsoReturnedItems;
        }
        return $this;
    }
    /**
     * Get DisplayAlsoSoftCredit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayAlsoSoftCredit()
    {
        return isset($this->DisplayAlsoSoftCredit) ? $this->DisplayAlsoSoftCredit : null;
    }
    /**
     * Set DisplayAlsoSoftCredit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayAlsoSoftCredit
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setDisplayAlsoSoftCredit($displayAlsoSoftCredit = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayAlsoSoftCredit) && !is_bool($displayAlsoSoftCredit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayAlsoSoftCredit, true), gettype($displayAlsoSoftCredit)), __LINE__);
        }
        if (is_null($displayAlsoSoftCredit) || (is_array($displayAlsoSoftCredit) && empty($displayAlsoSoftCredit))) {
            unset($this->DisplayAlsoSoftCredit);
        } else {
            $this->DisplayAlsoSoftCredit = $displayAlsoSoftCredit;
        }
        return $this;
    }
    /**
     * Get DisplayAlsoSubscriptionTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayAlsoSubscriptionTickets()
    {
        return isset($this->DisplayAlsoSubscriptionTickets) ? $this->DisplayAlsoSubscriptionTickets : null;
    }
    /**
     * Set DisplayAlsoSubscriptionTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayAlsoSubscriptionTickets
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setDisplayAlsoSubscriptionTickets($displayAlsoSubscriptionTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayAlsoSubscriptionTickets) && !is_bool($displayAlsoSubscriptionTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayAlsoSubscriptionTickets, true), gettype($displayAlsoSubscriptionTickets)), __LINE__);
        }
        if (is_null($displayAlsoSubscriptionTickets) || (is_array($displayAlsoSubscriptionTickets) && empty($displayAlsoSubscriptionTickets))) {
            unset($this->DisplayAlsoSubscriptionTickets);
        } else {
            $this->DisplayAlsoSubscriptionTickets = $displayAlsoSubscriptionTickets;
        }
        return $this;
    }
    /**
     * Get DisplayMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayMode()
    {
        return isset($this->DisplayMode) ? $this->DisplayMode : null;
    }
    /**
     * Set DisplayMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RelatedClientViewMode::valueIsValid()
     * @uses \patest\EnumType\RelatedClientViewMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $displayMode
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setDisplayMode($displayMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RelatedClientViewMode::valueIsValid($displayMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RelatedClientViewMode', is_array($displayMode) ? implode(', ', $displayMode) : var_export($displayMode, true), implode(', ', \patest\EnumType\RelatedClientViewMode::getValidValues())), __LINE__);
        }
        if (is_null($displayMode) || (is_array($displayMode) && empty($displayMode))) {
            unset($this->DisplayMode);
        } else {
            $this->DisplayMode = $displayMode;
        }
        return $this;
    }
    /**
     * Get EmailValidationPackageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailValidationPackageName()
    {
        return isset($this->EmailValidationPackageName) ? $this->EmailValidationPackageName : null;
    }
    /**
     * Set EmailValidationPackageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailValidationPackageName
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setEmailValidationPackageName($emailValidationPackageName = null)
    {
        // validation for constraint: string
        if (!is_null($emailValidationPackageName) && !is_string($emailValidationPackageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailValidationPackageName, true), gettype($emailValidationPackageName)), __LINE__);
        }
        if (is_null($emailValidationPackageName) || (is_array($emailValidationPackageName) && empty($emailValidationPackageName))) {
            unset($this->EmailValidationPackageName);
        } else {
            $this->EmailValidationPackageName = $emailValidationPackageName;
        }
        return $this;
    }
    /**
     * Get EnforceMaxNonStrongRelationshipViaApplications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnforceMaxNonStrongRelationshipViaApplications()
    {
        return isset($this->EnforceMaxNonStrongRelationshipViaApplications) ? $this->EnforceMaxNonStrongRelationshipViaApplications : null;
    }
    /**
     * Set EnforceMaxNonStrongRelationshipViaApplications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enforceMaxNonStrongRelationshipViaApplications
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setEnforceMaxNonStrongRelationshipViaApplications($enforceMaxNonStrongRelationshipViaApplications = null)
    {
        // validation for constraint: string
        if (!is_null($enforceMaxNonStrongRelationshipViaApplications) && !is_string($enforceMaxNonStrongRelationshipViaApplications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enforceMaxNonStrongRelationshipViaApplications, true), gettype($enforceMaxNonStrongRelationshipViaApplications)), __LINE__);
        }
        if (is_null($enforceMaxNonStrongRelationshipViaApplications) || (is_array($enforceMaxNonStrongRelationshipViaApplications) && empty($enforceMaxNonStrongRelationshipViaApplications))) {
            unset($this->EnforceMaxNonStrongRelationshipViaApplications);
        } else {
            $this->EnforceMaxNonStrongRelationshipViaApplications = $enforceMaxNonStrongRelationshipViaApplications;
        }
        return $this;
    }
    /**
     * Get ExternalValidationRecoveryInMins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExternalValidationRecoveryInMins()
    {
        return isset($this->ExternalValidationRecoveryInMins) ? $this->ExternalValidationRecoveryInMins : null;
    }
    /**
     * Set ExternalValidationRecoveryInMins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $externalValidationRecoveryInMins
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setExternalValidationRecoveryInMins($externalValidationRecoveryInMins = null)
    {
        // validation for constraint: int
        if (!is_null($externalValidationRecoveryInMins) && !(is_int($externalValidationRecoveryInMins) || ctype_digit($externalValidationRecoveryInMins))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalValidationRecoveryInMins, true), gettype($externalValidationRecoveryInMins)), __LINE__);
        }
        if (is_null($externalValidationRecoveryInMins) || (is_array($externalValidationRecoveryInMins) && empty($externalValidationRecoveryInMins))) {
            unset($this->ExternalValidationRecoveryInMins);
        } else {
            $this->ExternalValidationRecoveryInMins = $externalValidationRecoveryInMins;
        }
        return $this;
    }
    /**
     * Get ExternalValidationTimeoutInSecs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExternalValidationTimeoutInSecs()
    {
        return isset($this->ExternalValidationTimeoutInSecs) ? $this->ExternalValidationTimeoutInSecs : null;
    }
    /**
     * Set ExternalValidationTimeoutInSecs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $externalValidationTimeoutInSecs
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setExternalValidationTimeoutInSecs($externalValidationTimeoutInSecs = null)
    {
        // validation for constraint: int
        if (!is_null($externalValidationTimeoutInSecs) && !(is_int($externalValidationTimeoutInSecs) || ctype_digit($externalValidationTimeoutInSecs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalValidationTimeoutInSecs, true), gettype($externalValidationTimeoutInSecs)), __LINE__);
        }
        if (is_null($externalValidationTimeoutInSecs) || (is_array($externalValidationTimeoutInSecs) && empty($externalValidationTimeoutInSecs))) {
            unset($this->ExternalValidationTimeoutInSecs);
        } else {
            $this->ExternalValidationTimeoutInSecs = $externalValidationTimeoutInSecs;
        }
        return $this;
    }
    /**
     * Get GroupsBatchSizeForCrmGrids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupsBatchSizeForCrmGrids()
    {
        return isset($this->GroupsBatchSizeForCrmGrids) ? $this->GroupsBatchSizeForCrmGrids : null;
    }
    /**
     * Set GroupsBatchSizeForCrmGrids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupsBatchSizeForCrmGrids
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setGroupsBatchSizeForCrmGrids($groupsBatchSizeForCrmGrids = null)
    {
        // validation for constraint: int
        if (!is_null($groupsBatchSizeForCrmGrids) && !(is_int($groupsBatchSizeForCrmGrids) || ctype_digit($groupsBatchSizeForCrmGrids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupsBatchSizeForCrmGrids, true), gettype($groupsBatchSizeForCrmGrids)), __LINE__);
        }
        if (is_null($groupsBatchSizeForCrmGrids) || (is_array($groupsBatchSizeForCrmGrids) && empty($groupsBatchSizeForCrmGrids))) {
            unset($this->GroupsBatchSizeForCrmGrids);
        } else {
            $this->GroupsBatchSizeForCrmGrids = $groupsBatchSizeForCrmGrids;
        }
        return $this;
    }
    /**
     * Get IncludeCustomersWithSpecifiedRelationshipsInReservedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeCustomersWithSpecifiedRelationshipsInReservedSeats()
    {
        return isset($this->IncludeCustomersWithSpecifiedRelationshipsInReservedSeats) ? $this->IncludeCustomersWithSpecifiedRelationshipsInReservedSeats : null;
    }
    /**
     * Set IncludeCustomersWithSpecifiedRelationshipsInReservedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeCustomersWithSpecifiedRelationshipsInReservedSeats
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setIncludeCustomersWithSpecifiedRelationshipsInReservedSeats($includeCustomersWithSpecifiedRelationshipsInReservedSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCustomersWithSpecifiedRelationshipsInReservedSeats) && !is_bool($includeCustomersWithSpecifiedRelationshipsInReservedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCustomersWithSpecifiedRelationshipsInReservedSeats, true), gettype($includeCustomersWithSpecifiedRelationshipsInReservedSeats)), __LINE__);
        }
        if (is_null($includeCustomersWithSpecifiedRelationshipsInReservedSeats) || (is_array($includeCustomersWithSpecifiedRelationshipsInReservedSeats) && empty($includeCustomersWithSpecifiedRelationshipsInReservedSeats))) {
            unset($this->IncludeCustomersWithSpecifiedRelationshipsInReservedSeats);
        } else {
            $this->IncludeCustomersWithSpecifiedRelationshipsInReservedSeats = $includeCustomersWithSpecifiedRelationshipsInReservedSeats;
        }
        return $this;
    }
    /**
     * Get LoqateAddressCaptureDefaultCountryCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoqateAddressCaptureDefaultCountryCodes()
    {
        return isset($this->LoqateAddressCaptureDefaultCountryCodes) ? $this->LoqateAddressCaptureDefaultCountryCodes : null;
    }
    /**
     * Set LoqateAddressCaptureDefaultCountryCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loqateAddressCaptureDefaultCountryCodes
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setLoqateAddressCaptureDefaultCountryCodes($loqateAddressCaptureDefaultCountryCodes = null)
    {
        // validation for constraint: string
        if (!is_null($loqateAddressCaptureDefaultCountryCodes) && !is_string($loqateAddressCaptureDefaultCountryCodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loqateAddressCaptureDefaultCountryCodes, true), gettype($loqateAddressCaptureDefaultCountryCodes)), __LINE__);
        }
        if (is_null($loqateAddressCaptureDefaultCountryCodes) || (is_array($loqateAddressCaptureDefaultCountryCodes) && empty($loqateAddressCaptureDefaultCountryCodes))) {
            unset($this->LoqateAddressCaptureDefaultCountryCodes);
        } else {
            $this->LoqateAddressCaptureDefaultCountryCodes = $loqateAddressCaptureDefaultCountryCodes;
        }
        return $this;
    }
    /**
     * Get LoqateAddressCaptureFindApiUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoqateAddressCaptureFindApiUrl()
    {
        return isset($this->LoqateAddressCaptureFindApiUrl) ? $this->LoqateAddressCaptureFindApiUrl : null;
    }
    /**
     * Set LoqateAddressCaptureFindApiUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loqateAddressCaptureFindApiUrl
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setLoqateAddressCaptureFindApiUrl($loqateAddressCaptureFindApiUrl = null)
    {
        // validation for constraint: string
        if (!is_null($loqateAddressCaptureFindApiUrl) && !is_string($loqateAddressCaptureFindApiUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loqateAddressCaptureFindApiUrl, true), gettype($loqateAddressCaptureFindApiUrl)), __LINE__);
        }
        if (is_null($loqateAddressCaptureFindApiUrl) || (is_array($loqateAddressCaptureFindApiUrl) && empty($loqateAddressCaptureFindApiUrl))) {
            unset($this->LoqateAddressCaptureFindApiUrl);
        } else {
            $this->LoqateAddressCaptureFindApiUrl = $loqateAddressCaptureFindApiUrl;
        }
        return $this;
    }
    /**
     * Get LoqateAddressCaptureKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoqateAddressCaptureKey()
    {
        return isset($this->LoqateAddressCaptureKey) ? $this->LoqateAddressCaptureKey : null;
    }
    /**
     * Set LoqateAddressCaptureKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loqateAddressCaptureKey
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setLoqateAddressCaptureKey($loqateAddressCaptureKey = null)
    {
        // validation for constraint: string
        if (!is_null($loqateAddressCaptureKey) && !is_string($loqateAddressCaptureKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loqateAddressCaptureKey, true), gettype($loqateAddressCaptureKey)), __LINE__);
        }
        if (is_null($loqateAddressCaptureKey) || (is_array($loqateAddressCaptureKey) && empty($loqateAddressCaptureKey))) {
            unset($this->LoqateAddressCaptureKey);
        } else {
            $this->LoqateAddressCaptureKey = $loqateAddressCaptureKey;
        }
        return $this;
    }
    /**
     * Get LoqateAddressCaptureResultsLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLoqateAddressCaptureResultsLimit()
    {
        return isset($this->LoqateAddressCaptureResultsLimit) ? $this->LoqateAddressCaptureResultsLimit : null;
    }
    /**
     * Set LoqateAddressCaptureResultsLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $loqateAddressCaptureResultsLimit
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setLoqateAddressCaptureResultsLimit($loqateAddressCaptureResultsLimit = null)
    {
        // validation for constraint: int
        if (!is_null($loqateAddressCaptureResultsLimit) && !(is_int($loqateAddressCaptureResultsLimit) || ctype_digit($loqateAddressCaptureResultsLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loqateAddressCaptureResultsLimit, true), gettype($loqateAddressCaptureResultsLimit)), __LINE__);
        }
        if (is_null($loqateAddressCaptureResultsLimit) || (is_array($loqateAddressCaptureResultsLimit) && empty($loqateAddressCaptureResultsLimit))) {
            unset($this->LoqateAddressCaptureResultsLimit);
        } else {
            $this->LoqateAddressCaptureResultsLimit = $loqateAddressCaptureResultsLimit;
        }
        return $this;
    }
    /**
     * Get LoqateAddressCaptureRetrieveApiUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoqateAddressCaptureRetrieveApiUrl()
    {
        return isset($this->LoqateAddressCaptureRetrieveApiUrl) ? $this->LoqateAddressCaptureRetrieveApiUrl : null;
    }
    /**
     * Set LoqateAddressCaptureRetrieveApiUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loqateAddressCaptureRetrieveApiUrl
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setLoqateAddressCaptureRetrieveApiUrl($loqateAddressCaptureRetrieveApiUrl = null)
    {
        // validation for constraint: string
        if (!is_null($loqateAddressCaptureRetrieveApiUrl) && !is_string($loqateAddressCaptureRetrieveApiUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loqateAddressCaptureRetrieveApiUrl, true), gettype($loqateAddressCaptureRetrieveApiUrl)), __LINE__);
        }
        if (is_null($loqateAddressCaptureRetrieveApiUrl) || (is_array($loqateAddressCaptureRetrieveApiUrl) && empty($loqateAddressCaptureRetrieveApiUrl))) {
            unset($this->LoqateAddressCaptureRetrieveApiUrl);
        } else {
            $this->LoqateAddressCaptureRetrieveApiUrl = $loqateAddressCaptureRetrieveApiUrl;
        }
        return $this;
    }
    /**
     * Get LoqateAddressCaptureSaveHouseNumberInAddressLine2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLoqateAddressCaptureSaveHouseNumberInAddressLine2()
    {
        return isset($this->LoqateAddressCaptureSaveHouseNumberInAddressLine2) ? $this->LoqateAddressCaptureSaveHouseNumberInAddressLine2 : null;
    }
    /**
     * Set LoqateAddressCaptureSaveHouseNumberInAddressLine2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $loqateAddressCaptureSaveHouseNumberInAddressLine2
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setLoqateAddressCaptureSaveHouseNumberInAddressLine2($loqateAddressCaptureSaveHouseNumberInAddressLine2 = null)
    {
        // validation for constraint: boolean
        if (!is_null($loqateAddressCaptureSaveHouseNumberInAddressLine2) && !is_bool($loqateAddressCaptureSaveHouseNumberInAddressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loqateAddressCaptureSaveHouseNumberInAddressLine2, true), gettype($loqateAddressCaptureSaveHouseNumberInAddressLine2)), __LINE__);
        }
        if (is_null($loqateAddressCaptureSaveHouseNumberInAddressLine2) || (is_array($loqateAddressCaptureSaveHouseNumberInAddressLine2) && empty($loqateAddressCaptureSaveHouseNumberInAddressLine2))) {
            unset($this->LoqateAddressCaptureSaveHouseNumberInAddressLine2);
        } else {
            $this->LoqateAddressCaptureSaveHouseNumberInAddressLine2 = $loqateAddressCaptureSaveHouseNumberInAddressLine2;
        }
        return $this;
    }
    /**
     * Get MaxClientImageFileSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxClientImageFileSize()
    {
        return isset($this->MaxClientImageFileSize) ? $this->MaxClientImageFileSize : null;
    }
    /**
     * Set MaxClientImageFileSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxClientImageFileSize
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setMaxClientImageFileSize($maxClientImageFileSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxClientImageFileSize) && !(is_int($maxClientImageFileSize) || ctype_digit($maxClientImageFileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxClientImageFileSize, true), gettype($maxClientImageFileSize)), __LINE__);
        }
        if (is_null($maxClientImageFileSize) || (is_array($maxClientImageFileSize) && empty($maxClientImageFileSize))) {
            unset($this->MaxClientImageFileSize);
        } else {
            $this->MaxClientImageFileSize = $maxClientImageFileSize;
        }
        return $this;
    }
    /**
     * Get MaxClientImageHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxClientImageHeight()
    {
        return isset($this->MaxClientImageHeight) ? $this->MaxClientImageHeight : null;
    }
    /**
     * Set MaxClientImageHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxClientImageHeight
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setMaxClientImageHeight($maxClientImageHeight = null)
    {
        // validation for constraint: int
        if (!is_null($maxClientImageHeight) && !(is_int($maxClientImageHeight) || ctype_digit($maxClientImageHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxClientImageHeight, true), gettype($maxClientImageHeight)), __LINE__);
        }
        if (is_null($maxClientImageHeight) || (is_array($maxClientImageHeight) && empty($maxClientImageHeight))) {
            unset($this->MaxClientImageHeight);
        } else {
            $this->MaxClientImageHeight = $maxClientImageHeight;
        }
        return $this;
    }
    /**
     * Get MaxClientImageWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxClientImageWidth()
    {
        return isset($this->MaxClientImageWidth) ? $this->MaxClientImageWidth : null;
    }
    /**
     * Set MaxClientImageWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxClientImageWidth
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setMaxClientImageWidth($maxClientImageWidth = null)
    {
        // validation for constraint: int
        if (!is_null($maxClientImageWidth) && !(is_int($maxClientImageWidth) || ctype_digit($maxClientImageWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxClientImageWidth, true), gettype($maxClientImageWidth)), __LINE__);
        }
        if (is_null($maxClientImageWidth) || (is_array($maxClientImageWidth) && empty($maxClientImageWidth))) {
            unset($this->MaxClientImageWidth);
        } else {
            $this->MaxClientImageWidth = $maxClientImageWidth;
        }
        return $this;
    }
    /**
     * Get MaxItemsToProcessInCrmGrids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxItemsToProcessInCrmGrids()
    {
        return isset($this->MaxItemsToProcessInCrmGrids) ? $this->MaxItemsToProcessInCrmGrids : null;
    }
    /**
     * Set MaxItemsToProcessInCrmGrids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxItemsToProcessInCrmGrids
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setMaxItemsToProcessInCrmGrids($maxItemsToProcessInCrmGrids = null)
    {
        // validation for constraint: int
        if (!is_null($maxItemsToProcessInCrmGrids) && !(is_int($maxItemsToProcessInCrmGrids) || ctype_digit($maxItemsToProcessInCrmGrids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxItemsToProcessInCrmGrids, true), gettype($maxItemsToProcessInCrmGrids)), __LINE__);
        }
        if (is_null($maxItemsToProcessInCrmGrids) || (is_array($maxItemsToProcessInCrmGrids) && empty($maxItemsToProcessInCrmGrids))) {
            unset($this->MaxItemsToProcessInCrmGrids);
        } else {
            $this->MaxItemsToProcessInCrmGrids = $maxItemsToProcessInCrmGrids;
        }
        return $this;
    }
    /**
     * Get MinClientImageHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinClientImageHeight()
    {
        return isset($this->MinClientImageHeight) ? $this->MinClientImageHeight : null;
    }
    /**
     * Set MinClientImageHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minClientImageHeight
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setMinClientImageHeight($minClientImageHeight = null)
    {
        // validation for constraint: int
        if (!is_null($minClientImageHeight) && !(is_int($minClientImageHeight) || ctype_digit($minClientImageHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minClientImageHeight, true), gettype($minClientImageHeight)), __LINE__);
        }
        if (is_null($minClientImageHeight) || (is_array($minClientImageHeight) && empty($minClientImageHeight))) {
            unset($this->MinClientImageHeight);
        } else {
            $this->MinClientImageHeight = $minClientImageHeight;
        }
        return $this;
    }
    /**
     * Get MinClientImageWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinClientImageWidth()
    {
        return isset($this->MinClientImageWidth) ? $this->MinClientImageWidth : null;
    }
    /**
     * Set MinClientImageWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minClientImageWidth
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setMinClientImageWidth($minClientImageWidth = null)
    {
        // validation for constraint: int
        if (!is_null($minClientImageWidth) && !(is_int($minClientImageWidth) || ctype_digit($minClientImageWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minClientImageWidth, true), gettype($minClientImageWidth)), __LINE__);
        }
        if (is_null($minClientImageWidth) || (is_array($minClientImageWidth) && empty($minClientImageWidth))) {
            unset($this->MinClientImageWidth);
        } else {
            $this->MinClientImageWidth = $minClientImageWidth;
        }
        return $this;
    }
    /**
     * Get MultiOrgUnitClientsAccessibleByCreatorOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMultiOrgUnitClientsAccessibleByCreatorOnly()
    {
        return isset($this->MultiOrgUnitClientsAccessibleByCreatorOnly) ? $this->MultiOrgUnitClientsAccessibleByCreatorOnly : null;
    }
    /**
     * Set MultiOrgUnitClientsAccessibleByCreatorOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $multiOrgUnitClientsAccessibleByCreatorOnly
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setMultiOrgUnitClientsAccessibleByCreatorOnly($multiOrgUnitClientsAccessibleByCreatorOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiOrgUnitClientsAccessibleByCreatorOnly) && !is_bool($multiOrgUnitClientsAccessibleByCreatorOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiOrgUnitClientsAccessibleByCreatorOnly, true), gettype($multiOrgUnitClientsAccessibleByCreatorOnly)), __LINE__);
        }
        if (is_null($multiOrgUnitClientsAccessibleByCreatorOnly) || (is_array($multiOrgUnitClientsAccessibleByCreatorOnly) && empty($multiOrgUnitClientsAccessibleByCreatorOnly))) {
            unset($this->MultiOrgUnitClientsAccessibleByCreatorOnly);
        } else {
            $this->MultiOrgUnitClientsAccessibleByCreatorOnly = $multiOrgUnitClientsAccessibleByCreatorOnly;
        }
        return $this;
    }
    /**
     * Get PhoneValidationPackageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneValidationPackageName()
    {
        return isset($this->PhoneValidationPackageName) ? $this->PhoneValidationPackageName : null;
    }
    /**
     * Set PhoneValidationPackageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneValidationPackageName
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setPhoneValidationPackageName($phoneValidationPackageName = null)
    {
        // validation for constraint: string
        if (!is_null($phoneValidationPackageName) && !is_string($phoneValidationPackageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneValidationPackageName, true), gettype($phoneValidationPackageName)), __LINE__);
        }
        if (is_null($phoneValidationPackageName) || (is_array($phoneValidationPackageName) && empty($phoneValidationPackageName))) {
            unset($this->PhoneValidationPackageName);
        } else {
            $this->PhoneValidationPackageName = $phoneValidationPackageName;
        }
        return $this;
    }
    /**
     * Get RelationshipsApprovalViaApplications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipsApprovalViaApplications()
    {
        return isset($this->RelationshipsApprovalViaApplications) ? $this->RelationshipsApprovalViaApplications : null;
    }
    /**
     * Set RelationshipsApprovalViaApplications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipsApprovalViaApplications
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setRelationshipsApprovalViaApplications($relationshipsApprovalViaApplications = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipsApprovalViaApplications) && !is_string($relationshipsApprovalViaApplications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipsApprovalViaApplications, true), gettype($relationshipsApprovalViaApplications)), __LINE__);
        }
        if (is_null($relationshipsApprovalViaApplications) || (is_array($relationshipsApprovalViaApplications) && empty($relationshipsApprovalViaApplications))) {
            unset($this->RelationshipsApprovalViaApplications);
        } else {
            $this->RelationshipsApprovalViaApplications = $relationshipsApprovalViaApplications;
        }
        return $this;
    }
    /**
     * Get RelationshipTypesToRecommend value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipTypesToRecommend()
    {
        return isset($this->RelationshipTypesToRecommend) ? $this->RelationshipTypesToRecommend : null;
    }
    /**
     * Set RelationshipTypesToRecommend value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipTypesToRecommend
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setRelationshipTypesToRecommend($relationshipTypesToRecommend = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipTypesToRecommend) && !is_string($relationshipTypesToRecommend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipTypesToRecommend, true), gettype($relationshipTypesToRecommend)), __LINE__);
        }
        if (is_null($relationshipTypesToRecommend) || (is_array($relationshipTypesToRecommend) && empty($relationshipTypesToRecommend))) {
            unset($this->RelationshipTypesToRecommend);
        } else {
            $this->RelationshipTypesToRecommend = $relationshipTypesToRecommend;
        }
        return $this;
    }
    /**
     * Get ResetCrmUserParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getResetCrmUserParameters()
    {
        return isset($this->ResetCrmUserParameters) ? $this->ResetCrmUserParameters : null;
    }
    /**
     * Set ResetCrmUserParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $resetCrmUserParameters
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setResetCrmUserParameters($resetCrmUserParameters = null)
    {
        // validation for constraint: boolean
        if (!is_null($resetCrmUserParameters) && !is_bool($resetCrmUserParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resetCrmUserParameters, true), gettype($resetCrmUserParameters)), __LINE__);
        }
        if (is_null($resetCrmUserParameters) || (is_array($resetCrmUserParameters) && empty($resetCrmUserParameters))) {
            unset($this->ResetCrmUserParameters);
        } else {
            $this->ResetCrmUserParameters = $resetCrmUserParameters;
        }
        return $this;
    }
    /**
     * Get SendEmailForClientCreatedViaAplications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSendEmailForClientCreatedViaAplications()
    {
        return isset($this->SendEmailForClientCreatedViaAplications) ? $this->SendEmailForClientCreatedViaAplications : null;
    }
    /**
     * Set SendEmailForClientCreatedViaAplications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sendEmailForClientCreatedViaAplications
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setSendEmailForClientCreatedViaAplications($sendEmailForClientCreatedViaAplications = null)
    {
        // validation for constraint: string
        if (!is_null($sendEmailForClientCreatedViaAplications) && !is_string($sendEmailForClientCreatedViaAplications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendEmailForClientCreatedViaAplications, true), gettype($sendEmailForClientCreatedViaAplications)), __LINE__);
        }
        if (is_null($sendEmailForClientCreatedViaAplications) || (is_array($sendEmailForClientCreatedViaAplications) && empty($sendEmailForClientCreatedViaAplications))) {
            unset($this->SendEmailForClientCreatedViaAplications);
        } else {
            $this->SendEmailForClientCreatedViaAplications = $sendEmailForClientCreatedViaAplications;
        }
        return $this;
    }
    /**
     * Get SgoOpenSroApiTicketsPreviewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSgoOpenSroApiTicketsPreviewUrl()
    {
        return isset($this->SgoOpenSroApiTicketsPreviewUrl) ? $this->SgoOpenSroApiTicketsPreviewUrl : null;
    }
    /**
     * Set SgoOpenSroApiTicketsPreviewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sgoOpenSroApiTicketsPreviewUrl
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setSgoOpenSroApiTicketsPreviewUrl($sgoOpenSroApiTicketsPreviewUrl = null)
    {
        // validation for constraint: string
        if (!is_null($sgoOpenSroApiTicketsPreviewUrl) && !is_string($sgoOpenSroApiTicketsPreviewUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sgoOpenSroApiTicketsPreviewUrl, true), gettype($sgoOpenSroApiTicketsPreviewUrl)), __LINE__);
        }
        if (is_null($sgoOpenSroApiTicketsPreviewUrl) || (is_array($sgoOpenSroApiTicketsPreviewUrl) && empty($sgoOpenSroApiTicketsPreviewUrl))) {
            unset($this->SgoOpenSroApiTicketsPreviewUrl);
        } else {
            $this->SgoOpenSroApiTicketsPreviewUrl = $sgoOpenSroApiTicketsPreviewUrl;
        }
        return $this;
    }
    /**
     * Get UseAddressSearchAndValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseAddressSearchAndValidation()
    {
        return isset($this->UseAddressSearchAndValidation) ? $this->UseAddressSearchAndValidation : null;
    }
    /**
     * Set UseAddressSearchAndValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useAddressSearchAndValidation
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setUseAddressSearchAndValidation($useAddressSearchAndValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAddressSearchAndValidation) && !is_bool($useAddressSearchAndValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAddressSearchAndValidation, true), gettype($useAddressSearchAndValidation)), __LINE__);
        }
        if (is_null($useAddressSearchAndValidation) || (is_array($useAddressSearchAndValidation) && empty($useAddressSearchAndValidation))) {
            unset($this->UseAddressSearchAndValidation);
        } else {
            $this->UseAddressSearchAndValidation = $useAddressSearchAndValidation;
        }
        return $this;
    }
    /**
     * Get UseEmailValidationProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseEmailValidationProvider()
    {
        return isset($this->UseEmailValidationProvider) ? $this->UseEmailValidationProvider : null;
    }
    /**
     * Set UseEmailValidationProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useEmailValidationProvider
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setUseEmailValidationProvider($useEmailValidationProvider = null)
    {
        // validation for constraint: boolean
        if (!is_null($useEmailValidationProvider) && !is_bool($useEmailValidationProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useEmailValidationProvider, true), gettype($useEmailValidationProvider)), __LINE__);
        }
        if (is_null($useEmailValidationProvider) || (is_array($useEmailValidationProvider) && empty($useEmailValidationProvider))) {
            unset($this->UseEmailValidationProvider);
        } else {
            $this->UseEmailValidationProvider = $useEmailValidationProvider;
        }
        return $this;
    }
    /**
     * Get UsePhoneValidationProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsePhoneValidationProvider()
    {
        return isset($this->UsePhoneValidationProvider) ? $this->UsePhoneValidationProvider : null;
    }
    /**
     * Set UsePhoneValidationProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usePhoneValidationProvider
     * @return \patest\StructType\Security_CrmCompanyParameters
     */
    public function setUsePhoneValidationProvider($usePhoneValidationProvider = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePhoneValidationProvider) && !is_bool($usePhoneValidationProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePhoneValidationProvider, true), gettype($usePhoneValidationProvider)), __LINE__);
        }
        if (is_null($usePhoneValidationProvider) || (is_array($usePhoneValidationProvider) && empty($usePhoneValidationProvider))) {
            unset($this->UsePhoneValidationProvider);
        } else {
            $this->UsePhoneValidationProvider = $usePhoneValidationProvider;
        }
        return $this;
    }
}
