<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.CashDrawerGenericSerialPortParameters StructType
 * @subpackage Structs
 */
class Security_CashDrawerGenericSerialPortParameters extends Security_SalePointPeripheralSerialPortParametersBase
{
    /**
     * The OpenDrawerCommand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpenDrawerCommand;
    /**
     * Constructor method for Security.CashDrawerGenericSerialPortParameters
     * @uses Security_CashDrawerGenericSerialPortParameters::setOpenDrawerCommand()
     * @param string $openDrawerCommand
     */
    public function __construct($openDrawerCommand = null)
    {
        $this
            ->setOpenDrawerCommand($openDrawerCommand);
    }
    /**
     * Get OpenDrawerCommand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpenDrawerCommand()
    {
        return isset($this->OpenDrawerCommand) ? $this->OpenDrawerCommand : null;
    }
    /**
     * Set OpenDrawerCommand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $openDrawerCommand
     * @return \patest\StructType\Security_CashDrawerGenericSerialPortParameters
     */
    public function setOpenDrawerCommand($openDrawerCommand = null)
    {
        // validation for constraint: string
        if (!is_null($openDrawerCommand) && !is_string($openDrawerCommand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openDrawerCommand, true), gettype($openDrawerCommand)), __LINE__);
        }
        if (is_null($openDrawerCommand) || (is_array($openDrawerCommand) && empty($openDrawerCommand))) {
            unset($this->OpenDrawerCommand);
        } else {
            $this->OpenDrawerCommand = $openDrawerCommand;
        }
        return $this;
    }
}
