<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.ApplicationChannelParameters StructType
 * @subpackage Structs
 */
class Security_ApplicationChannelParameters extends AnyEntity
{
    /**
     * The AllowSroPluginForAllUsers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowSroPluginForAllUsers;
    /**
     * The AlwaysSuggestOwnersAssignment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AlwaysSuggestOwnersAssignment;
    /**
     * The ContextExpirationMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ContextExpirationMinutes;
    /**
     * The DisplayViewFromSeatInSeatTooltip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayViewFromSeatInSeatTooltip;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The UseAddressSearchAndValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseAddressSearchAndValidation;
    /**
     * Constructor method for Security.ApplicationChannelParameters
     * @uses Security_ApplicationChannelParameters::setAllowSroPluginForAllUsers()
     * @uses Security_ApplicationChannelParameters::setAlwaysSuggestOwnersAssignment()
     * @uses Security_ApplicationChannelParameters::setContextExpirationMinutes()
     * @uses Security_ApplicationChannelParameters::setDisplayViewFromSeatInSeatTooltip()
     * @uses Security_ApplicationChannelParameters::setId()
     * @uses Security_ApplicationChannelParameters::setUseAddressSearchAndValidation()
     * @param bool $allowSroPluginForAllUsers
     * @param bool $alwaysSuggestOwnersAssignment
     * @param int $contextExpirationMinutes
     * @param bool $displayViewFromSeatInSeatTooltip
     * @param string $id
     * @param bool $useAddressSearchAndValidation
     */
    public function __construct($allowSroPluginForAllUsers = null, $alwaysSuggestOwnersAssignment = null, $contextExpirationMinutes = null, $displayViewFromSeatInSeatTooltip = null, $id = null, $useAddressSearchAndValidation = null)
    {
        $this
            ->setAllowSroPluginForAllUsers($allowSroPluginForAllUsers)
            ->setAlwaysSuggestOwnersAssignment($alwaysSuggestOwnersAssignment)
            ->setContextExpirationMinutes($contextExpirationMinutes)
            ->setDisplayViewFromSeatInSeatTooltip($displayViewFromSeatInSeatTooltip)
            ->setId($id)
            ->setUseAddressSearchAndValidation($useAddressSearchAndValidation);
    }
    /**
     * Get AllowSroPluginForAllUsers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowSroPluginForAllUsers()
    {
        return isset($this->AllowSroPluginForAllUsers) ? $this->AllowSroPluginForAllUsers : null;
    }
    /**
     * Set AllowSroPluginForAllUsers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowSroPluginForAllUsers
     * @return \patest\StructType\Security_ApplicationChannelParameters
     */
    public function setAllowSroPluginForAllUsers($allowSroPluginForAllUsers = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSroPluginForAllUsers) && !is_bool($allowSroPluginForAllUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowSroPluginForAllUsers, true), gettype($allowSroPluginForAllUsers)), __LINE__);
        }
        if (is_null($allowSroPluginForAllUsers) || (is_array($allowSroPluginForAllUsers) && empty($allowSroPluginForAllUsers))) {
            unset($this->AllowSroPluginForAllUsers);
        } else {
            $this->AllowSroPluginForAllUsers = $allowSroPluginForAllUsers;
        }
        return $this;
    }
    /**
     * Get AlwaysSuggestOwnersAssignment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAlwaysSuggestOwnersAssignment()
    {
        return isset($this->AlwaysSuggestOwnersAssignment) ? $this->AlwaysSuggestOwnersAssignment : null;
    }
    /**
     * Set AlwaysSuggestOwnersAssignment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $alwaysSuggestOwnersAssignment
     * @return \patest\StructType\Security_ApplicationChannelParameters
     */
    public function setAlwaysSuggestOwnersAssignment($alwaysSuggestOwnersAssignment = null)
    {
        // validation for constraint: boolean
        if (!is_null($alwaysSuggestOwnersAssignment) && !is_bool($alwaysSuggestOwnersAssignment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alwaysSuggestOwnersAssignment, true), gettype($alwaysSuggestOwnersAssignment)), __LINE__);
        }
        if (is_null($alwaysSuggestOwnersAssignment) || (is_array($alwaysSuggestOwnersAssignment) && empty($alwaysSuggestOwnersAssignment))) {
            unset($this->AlwaysSuggestOwnersAssignment);
        } else {
            $this->AlwaysSuggestOwnersAssignment = $alwaysSuggestOwnersAssignment;
        }
        return $this;
    }
    /**
     * Get ContextExpirationMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getContextExpirationMinutes()
    {
        return isset($this->ContextExpirationMinutes) ? $this->ContextExpirationMinutes : null;
    }
    /**
     * Set ContextExpirationMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $contextExpirationMinutes
     * @return \patest\StructType\Security_ApplicationChannelParameters
     */
    public function setContextExpirationMinutes($contextExpirationMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($contextExpirationMinutes) && !(is_int($contextExpirationMinutes) || ctype_digit($contextExpirationMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contextExpirationMinutes, true), gettype($contextExpirationMinutes)), __LINE__);
        }
        if (is_null($contextExpirationMinutes) || (is_array($contextExpirationMinutes) && empty($contextExpirationMinutes))) {
            unset($this->ContextExpirationMinutes);
        } else {
            $this->ContextExpirationMinutes = $contextExpirationMinutes;
        }
        return $this;
    }
    /**
     * Get DisplayViewFromSeatInSeatTooltip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayViewFromSeatInSeatTooltip()
    {
        return isset($this->DisplayViewFromSeatInSeatTooltip) ? $this->DisplayViewFromSeatInSeatTooltip : null;
    }
    /**
     * Set DisplayViewFromSeatInSeatTooltip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayViewFromSeatInSeatTooltip
     * @return \patest\StructType\Security_ApplicationChannelParameters
     */
    public function setDisplayViewFromSeatInSeatTooltip($displayViewFromSeatInSeatTooltip = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayViewFromSeatInSeatTooltip) && !is_bool($displayViewFromSeatInSeatTooltip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayViewFromSeatInSeatTooltip, true), gettype($displayViewFromSeatInSeatTooltip)), __LINE__);
        }
        if (is_null($displayViewFromSeatInSeatTooltip) || (is_array($displayViewFromSeatInSeatTooltip) && empty($displayViewFromSeatInSeatTooltip))) {
            unset($this->DisplayViewFromSeatInSeatTooltip);
        } else {
            $this->DisplayViewFromSeatInSeatTooltip = $displayViewFromSeatInSeatTooltip;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Security_ApplicationChannelParameters
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get UseAddressSearchAndValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseAddressSearchAndValidation()
    {
        return isset($this->UseAddressSearchAndValidation) ? $this->UseAddressSearchAndValidation : null;
    }
    /**
     * Set UseAddressSearchAndValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useAddressSearchAndValidation
     * @return \patest\StructType\Security_ApplicationChannelParameters
     */
    public function setUseAddressSearchAndValidation($useAddressSearchAndValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAddressSearchAndValidation) && !is_bool($useAddressSearchAndValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAddressSearchAndValidation, true), gettype($useAddressSearchAndValidation)), __LINE__);
        }
        if (is_null($useAddressSearchAndValidation) || (is_array($useAddressSearchAndValidation) && empty($useAddressSearchAndValidation))) {
            unset($this->UseAddressSearchAndValidation);
        } else {
            $this->UseAddressSearchAndValidation = $useAddressSearchAndValidation;
        }
        return $this;
    }
}
