<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.AccessControlCompanyParameters StructType
 * @subpackage Structs
 */
class Security_AccessControlCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AccessControlEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AccessControlEnabled;
    /**
     * The AllowAccessToSameShowEventsDaysAfter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllowAccessToSameShowEventsDaysAfter;
    /**
     * The AllowAccessToSameShowEventsDaysBefore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllowAccessToSameShowEventsDaysBefore;
    /**
     * The AllowedEntriesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllowedEntriesCount;
    /**
     * The AllowPrintMultipleAccessCards
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowPrintMultipleAccessCards;
    /**
     * The AllowResetEventScanData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowResetEventScanData;
    /**
     * The AuthoritativeSystemWeblinkUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthoritativeSystemWeblinkUrl;
    /**
     * The BarcodeEntryPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeEntryPolicy;
    /**
     * The CardsAllowAccessToSamePriceTypeOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CardsAllowAccessToSamePriceTypeOnly;
    /**
     * The DayEndTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DayEndTime;
    /**
     * The DayStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DayStartTime;
    /**
     * The EndScanningMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EndScanningMinutes;
    /**
     * The EndScanningPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndScanningPolicy;
    /**
     * The GenerateNewTicketBarcodeOnReprint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GenerateNewTicketBarcodeOnReprint;
    /**
     * The GenerateNewTicketBarcodeOnReprintExceptionReasonCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GenerateNewTicketBarcodeOnReprintExceptionReasonCodes;
    /**
     * The IdentifyCustomerForAccessControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IdentifyCustomerForAccessControl;
    /**
     * The IsExternalScanning
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExternalScanning;
    /**
     * The MaxAllowedEntriesPerDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAllowedEntriesPerDay;
    /**
     * The MaxScanningWindow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxScanningWindow;
    /**
     * The OfflineScanningRetrieveCrmEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OfflineScanningRetrieveCrmEmail;
    /**
     * The OfflineScanningRetrieveCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OfflineScanningRetrieveCrmId;
    /**
     * The OfflineScanningRetrieveCrmMobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OfflineScanningRetrieveCrmMobile;
    /**
     * The OtpHexadecimalValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtpHexadecimalValue;
    /**
     * The OtpIntervalInSeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OtpIntervalInSeconds;
    /**
     * The PolicyToReturnScannedTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PolicyToReturnScannedTickets;
    /**
     * The ScanResultColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScanResultColor;
    /**
     * The ScanResultSoundFileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScanResultSoundFileName;
    /**
     * The ShowCustomerPictureOnScan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowCustomerPictureOnScan;
    /**
     * The StartScanningMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StartScanningMinutes;
    /**
     * The StartScanningPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartScanningPolicy;
    /**
     * The StoreBarcodeUsagesSynchronously
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $StoreBarcodeUsagesSynchronously;
    /**
     * The SupportAccessToSameShowEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SupportAccessToSameShowEvents;
    /**
     * The SupportsNamedScan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SupportsNamedScan;
    /**
     * The TurnstilesForSpecialClientTypesOverridePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TurnstilesForSpecialClientTypesOverridePolicy;
    /**
     * Constructor method for Security.AccessControlCompanyParameters
     * @uses Security_AccessControlCompanyParameters::setAccessControlEnabled()
     * @uses Security_AccessControlCompanyParameters::setAllowAccessToSameShowEventsDaysAfter()
     * @uses Security_AccessControlCompanyParameters::setAllowAccessToSameShowEventsDaysBefore()
     * @uses Security_AccessControlCompanyParameters::setAllowedEntriesCount()
     * @uses Security_AccessControlCompanyParameters::setAllowPrintMultipleAccessCards()
     * @uses Security_AccessControlCompanyParameters::setAllowResetEventScanData()
     * @uses Security_AccessControlCompanyParameters::setAuthoritativeSystemWeblinkUrl()
     * @uses Security_AccessControlCompanyParameters::setBarcodeEntryPolicy()
     * @uses Security_AccessControlCompanyParameters::setCardsAllowAccessToSamePriceTypeOnly()
     * @uses Security_AccessControlCompanyParameters::setDayEndTime()
     * @uses Security_AccessControlCompanyParameters::setDayStartTime()
     * @uses Security_AccessControlCompanyParameters::setEndScanningMinutes()
     * @uses Security_AccessControlCompanyParameters::setEndScanningPolicy()
     * @uses Security_AccessControlCompanyParameters::setGenerateNewTicketBarcodeOnReprint()
     * @uses Security_AccessControlCompanyParameters::setGenerateNewTicketBarcodeOnReprintExceptionReasonCodes()
     * @uses Security_AccessControlCompanyParameters::setIdentifyCustomerForAccessControl()
     * @uses Security_AccessControlCompanyParameters::setIsExternalScanning()
     * @uses Security_AccessControlCompanyParameters::setMaxAllowedEntriesPerDay()
     * @uses Security_AccessControlCompanyParameters::setMaxScanningWindow()
     * @uses Security_AccessControlCompanyParameters::setOfflineScanningRetrieveCrmEmail()
     * @uses Security_AccessControlCompanyParameters::setOfflineScanningRetrieveCrmId()
     * @uses Security_AccessControlCompanyParameters::setOfflineScanningRetrieveCrmMobile()
     * @uses Security_AccessControlCompanyParameters::setOtpHexadecimalValue()
     * @uses Security_AccessControlCompanyParameters::setOtpIntervalInSeconds()
     * @uses Security_AccessControlCompanyParameters::setPolicyToReturnScannedTickets()
     * @uses Security_AccessControlCompanyParameters::setScanResultColor()
     * @uses Security_AccessControlCompanyParameters::setScanResultSoundFileName()
     * @uses Security_AccessControlCompanyParameters::setShowCustomerPictureOnScan()
     * @uses Security_AccessControlCompanyParameters::setStartScanningMinutes()
     * @uses Security_AccessControlCompanyParameters::setStartScanningPolicy()
     * @uses Security_AccessControlCompanyParameters::setStoreBarcodeUsagesSynchronously()
     * @uses Security_AccessControlCompanyParameters::setSupportAccessToSameShowEvents()
     * @uses Security_AccessControlCompanyParameters::setSupportsNamedScan()
     * @uses Security_AccessControlCompanyParameters::setTurnstilesForSpecialClientTypesOverridePolicy()
     * @param bool $accessControlEnabled
     * @param int $allowAccessToSameShowEventsDaysAfter
     * @param int $allowAccessToSameShowEventsDaysBefore
     * @param int $allowedEntriesCount
     * @param bool $allowPrintMultipleAccessCards
     * @param bool $allowResetEventScanData
     * @param string $authoritativeSystemWeblinkUrl
     * @param string $barcodeEntryPolicy
     * @param bool $cardsAllowAccessToSamePriceTypeOnly
     * @param string $dayEndTime
     * @param string $dayStartTime
     * @param int $endScanningMinutes
     * @param string $endScanningPolicy
     * @param string $generateNewTicketBarcodeOnReprint
     * @param string $generateNewTicketBarcodeOnReprintExceptionReasonCodes
     * @param bool $identifyCustomerForAccessControl
     * @param bool $isExternalScanning
     * @param int $maxAllowedEntriesPerDay
     * @param int $maxScanningWindow
     * @param bool $offlineScanningRetrieveCrmEmail
     * @param bool $offlineScanningRetrieveCrmId
     * @param bool $offlineScanningRetrieveCrmMobile
     * @param string $otpHexadecimalValue
     * @param int $otpIntervalInSeconds
     * @param string $policyToReturnScannedTickets
     * @param string $scanResultColor
     * @param string $scanResultSoundFileName
     * @param bool $showCustomerPictureOnScan
     * @param int $startScanningMinutes
     * @param string $startScanningPolicy
     * @param bool $storeBarcodeUsagesSynchronously
     * @param bool $supportAccessToSameShowEvents
     * @param bool $supportsNamedScan
     * @param string $turnstilesForSpecialClientTypesOverridePolicy
     */
    public function __construct($accessControlEnabled = null, $allowAccessToSameShowEventsDaysAfter = null, $allowAccessToSameShowEventsDaysBefore = null, $allowedEntriesCount = null, $allowPrintMultipleAccessCards = null, $allowResetEventScanData = null, $authoritativeSystemWeblinkUrl = null, $barcodeEntryPolicy = null, $cardsAllowAccessToSamePriceTypeOnly = null, $dayEndTime = null, $dayStartTime = null, $endScanningMinutes = null, $endScanningPolicy = null, $generateNewTicketBarcodeOnReprint = null, $generateNewTicketBarcodeOnReprintExceptionReasonCodes = null, $identifyCustomerForAccessControl = null, $isExternalScanning = null, $maxAllowedEntriesPerDay = null, $maxScanningWindow = null, $offlineScanningRetrieveCrmEmail = null, $offlineScanningRetrieveCrmId = null, $offlineScanningRetrieveCrmMobile = null, $otpHexadecimalValue = null, $otpIntervalInSeconds = null, $policyToReturnScannedTickets = null, $scanResultColor = null, $scanResultSoundFileName = null, $showCustomerPictureOnScan = null, $startScanningMinutes = null, $startScanningPolicy = null, $storeBarcodeUsagesSynchronously = null, $supportAccessToSameShowEvents = null, $supportsNamedScan = null, $turnstilesForSpecialClientTypesOverridePolicy = null)
    {
        $this
            ->setAccessControlEnabled($accessControlEnabled)
            ->setAllowAccessToSameShowEventsDaysAfter($allowAccessToSameShowEventsDaysAfter)
            ->setAllowAccessToSameShowEventsDaysBefore($allowAccessToSameShowEventsDaysBefore)
            ->setAllowedEntriesCount($allowedEntriesCount)
            ->setAllowPrintMultipleAccessCards($allowPrintMultipleAccessCards)
            ->setAllowResetEventScanData($allowResetEventScanData)
            ->setAuthoritativeSystemWeblinkUrl($authoritativeSystemWeblinkUrl)
            ->setBarcodeEntryPolicy($barcodeEntryPolicy)
            ->setCardsAllowAccessToSamePriceTypeOnly($cardsAllowAccessToSamePriceTypeOnly)
            ->setDayEndTime($dayEndTime)
            ->setDayStartTime($dayStartTime)
            ->setEndScanningMinutes($endScanningMinutes)
            ->setEndScanningPolicy($endScanningPolicy)
            ->setGenerateNewTicketBarcodeOnReprint($generateNewTicketBarcodeOnReprint)
            ->setGenerateNewTicketBarcodeOnReprintExceptionReasonCodes($generateNewTicketBarcodeOnReprintExceptionReasonCodes)
            ->setIdentifyCustomerForAccessControl($identifyCustomerForAccessControl)
            ->setIsExternalScanning($isExternalScanning)
            ->setMaxAllowedEntriesPerDay($maxAllowedEntriesPerDay)
            ->setMaxScanningWindow($maxScanningWindow)
            ->setOfflineScanningRetrieveCrmEmail($offlineScanningRetrieveCrmEmail)
            ->setOfflineScanningRetrieveCrmId($offlineScanningRetrieveCrmId)
            ->setOfflineScanningRetrieveCrmMobile($offlineScanningRetrieveCrmMobile)
            ->setOtpHexadecimalValue($otpHexadecimalValue)
            ->setOtpIntervalInSeconds($otpIntervalInSeconds)
            ->setPolicyToReturnScannedTickets($policyToReturnScannedTickets)
            ->setScanResultColor($scanResultColor)
            ->setScanResultSoundFileName($scanResultSoundFileName)
            ->setShowCustomerPictureOnScan($showCustomerPictureOnScan)
            ->setStartScanningMinutes($startScanningMinutes)
            ->setStartScanningPolicy($startScanningPolicy)
            ->setStoreBarcodeUsagesSynchronously($storeBarcodeUsagesSynchronously)
            ->setSupportAccessToSameShowEvents($supportAccessToSameShowEvents)
            ->setSupportsNamedScan($supportsNamedScan)
            ->setTurnstilesForSpecialClientTypesOverridePolicy($turnstilesForSpecialClientTypesOverridePolicy);
    }
    /**
     * Get AccessControlEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAccessControlEnabled()
    {
        return isset($this->AccessControlEnabled) ? $this->AccessControlEnabled : null;
    }
    /**
     * Set AccessControlEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $accessControlEnabled
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setAccessControlEnabled($accessControlEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($accessControlEnabled) && !is_bool($accessControlEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accessControlEnabled, true), gettype($accessControlEnabled)), __LINE__);
        }
        if (is_null($accessControlEnabled) || (is_array($accessControlEnabled) && empty($accessControlEnabled))) {
            unset($this->AccessControlEnabled);
        } else {
            $this->AccessControlEnabled = $accessControlEnabled;
        }
        return $this;
    }
    /**
     * Get AllowAccessToSameShowEventsDaysAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllowAccessToSameShowEventsDaysAfter()
    {
        return isset($this->AllowAccessToSameShowEventsDaysAfter) ? $this->AllowAccessToSameShowEventsDaysAfter : null;
    }
    /**
     * Set AllowAccessToSameShowEventsDaysAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allowAccessToSameShowEventsDaysAfter
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setAllowAccessToSameShowEventsDaysAfter($allowAccessToSameShowEventsDaysAfter = null)
    {
        // validation for constraint: int
        if (!is_null($allowAccessToSameShowEventsDaysAfter) && !(is_int($allowAccessToSameShowEventsDaysAfter) || ctype_digit($allowAccessToSameShowEventsDaysAfter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allowAccessToSameShowEventsDaysAfter, true), gettype($allowAccessToSameShowEventsDaysAfter)), __LINE__);
        }
        if (is_null($allowAccessToSameShowEventsDaysAfter) || (is_array($allowAccessToSameShowEventsDaysAfter) && empty($allowAccessToSameShowEventsDaysAfter))) {
            unset($this->AllowAccessToSameShowEventsDaysAfter);
        } else {
            $this->AllowAccessToSameShowEventsDaysAfter = $allowAccessToSameShowEventsDaysAfter;
        }
        return $this;
    }
    /**
     * Get AllowAccessToSameShowEventsDaysBefore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllowAccessToSameShowEventsDaysBefore()
    {
        return isset($this->AllowAccessToSameShowEventsDaysBefore) ? $this->AllowAccessToSameShowEventsDaysBefore : null;
    }
    /**
     * Set AllowAccessToSameShowEventsDaysBefore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allowAccessToSameShowEventsDaysBefore
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setAllowAccessToSameShowEventsDaysBefore($allowAccessToSameShowEventsDaysBefore = null)
    {
        // validation for constraint: int
        if (!is_null($allowAccessToSameShowEventsDaysBefore) && !(is_int($allowAccessToSameShowEventsDaysBefore) || ctype_digit($allowAccessToSameShowEventsDaysBefore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allowAccessToSameShowEventsDaysBefore, true), gettype($allowAccessToSameShowEventsDaysBefore)), __LINE__);
        }
        if (is_null($allowAccessToSameShowEventsDaysBefore) || (is_array($allowAccessToSameShowEventsDaysBefore) && empty($allowAccessToSameShowEventsDaysBefore))) {
            unset($this->AllowAccessToSameShowEventsDaysBefore);
        } else {
            $this->AllowAccessToSameShowEventsDaysBefore = $allowAccessToSameShowEventsDaysBefore;
        }
        return $this;
    }
    /**
     * Get AllowedEntriesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllowedEntriesCount()
    {
        return isset($this->AllowedEntriesCount) ? $this->AllowedEntriesCount : null;
    }
    /**
     * Set AllowedEntriesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allowedEntriesCount
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setAllowedEntriesCount($allowedEntriesCount = null)
    {
        // validation for constraint: int
        if (!is_null($allowedEntriesCount) && !(is_int($allowedEntriesCount) || ctype_digit($allowedEntriesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allowedEntriesCount, true), gettype($allowedEntriesCount)), __LINE__);
        }
        if (is_null($allowedEntriesCount) || (is_array($allowedEntriesCount) && empty($allowedEntriesCount))) {
            unset($this->AllowedEntriesCount);
        } else {
            $this->AllowedEntriesCount = $allowedEntriesCount;
        }
        return $this;
    }
    /**
     * Get AllowPrintMultipleAccessCards value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowPrintMultipleAccessCards()
    {
        return isset($this->AllowPrintMultipleAccessCards) ? $this->AllowPrintMultipleAccessCards : null;
    }
    /**
     * Set AllowPrintMultipleAccessCards value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowPrintMultipleAccessCards
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setAllowPrintMultipleAccessCards($allowPrintMultipleAccessCards = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPrintMultipleAccessCards) && !is_bool($allowPrintMultipleAccessCards)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPrintMultipleAccessCards, true), gettype($allowPrintMultipleAccessCards)), __LINE__);
        }
        if (is_null($allowPrintMultipleAccessCards) || (is_array($allowPrintMultipleAccessCards) && empty($allowPrintMultipleAccessCards))) {
            unset($this->AllowPrintMultipleAccessCards);
        } else {
            $this->AllowPrintMultipleAccessCards = $allowPrintMultipleAccessCards;
        }
        return $this;
    }
    /**
     * Get AllowResetEventScanData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowResetEventScanData()
    {
        return isset($this->AllowResetEventScanData) ? $this->AllowResetEventScanData : null;
    }
    /**
     * Set AllowResetEventScanData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowResetEventScanData
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setAllowResetEventScanData($allowResetEventScanData = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowResetEventScanData) && !is_bool($allowResetEventScanData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowResetEventScanData, true), gettype($allowResetEventScanData)), __LINE__);
        }
        if (is_null($allowResetEventScanData) || (is_array($allowResetEventScanData) && empty($allowResetEventScanData))) {
            unset($this->AllowResetEventScanData);
        } else {
            $this->AllowResetEventScanData = $allowResetEventScanData;
        }
        return $this;
    }
    /**
     * Get AuthoritativeSystemWeblinkUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthoritativeSystemWeblinkUrl()
    {
        return isset($this->AuthoritativeSystemWeblinkUrl) ? $this->AuthoritativeSystemWeblinkUrl : null;
    }
    /**
     * Set AuthoritativeSystemWeblinkUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authoritativeSystemWeblinkUrl
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setAuthoritativeSystemWeblinkUrl($authoritativeSystemWeblinkUrl = null)
    {
        // validation for constraint: string
        if (!is_null($authoritativeSystemWeblinkUrl) && !is_string($authoritativeSystemWeblinkUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authoritativeSystemWeblinkUrl, true), gettype($authoritativeSystemWeblinkUrl)), __LINE__);
        }
        if (is_null($authoritativeSystemWeblinkUrl) || (is_array($authoritativeSystemWeblinkUrl) && empty($authoritativeSystemWeblinkUrl))) {
            unset($this->AuthoritativeSystemWeblinkUrl);
        } else {
            $this->AuthoritativeSystemWeblinkUrl = $authoritativeSystemWeblinkUrl;
        }
        return $this;
    }
    /**
     * Get BarcodeEntryPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeEntryPolicy()
    {
        return isset($this->BarcodeEntryPolicy) ? $this->BarcodeEntryPolicy : null;
    }
    /**
     * Set BarcodeEntryPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BarcodeEntryPolicy::valueIsValid()
     * @uses \patest\EnumType\BarcodeEntryPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $barcodeEntryPolicy
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setBarcodeEntryPolicy($barcodeEntryPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BarcodeEntryPolicy::valueIsValid($barcodeEntryPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BarcodeEntryPolicy', is_array($barcodeEntryPolicy) ? implode(', ', $barcodeEntryPolicy) : var_export($barcodeEntryPolicy, true), implode(', ', \patest\EnumType\BarcodeEntryPolicy::getValidValues())), __LINE__);
        }
        if (is_null($barcodeEntryPolicy) || (is_array($barcodeEntryPolicy) && empty($barcodeEntryPolicy))) {
            unset($this->BarcodeEntryPolicy);
        } else {
            $this->BarcodeEntryPolicy = $barcodeEntryPolicy;
        }
        return $this;
    }
    /**
     * Get CardsAllowAccessToSamePriceTypeOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCardsAllowAccessToSamePriceTypeOnly()
    {
        return isset($this->CardsAllowAccessToSamePriceTypeOnly) ? $this->CardsAllowAccessToSamePriceTypeOnly : null;
    }
    /**
     * Set CardsAllowAccessToSamePriceTypeOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $cardsAllowAccessToSamePriceTypeOnly
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setCardsAllowAccessToSamePriceTypeOnly($cardsAllowAccessToSamePriceTypeOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($cardsAllowAccessToSamePriceTypeOnly) && !is_bool($cardsAllowAccessToSamePriceTypeOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cardsAllowAccessToSamePriceTypeOnly, true), gettype($cardsAllowAccessToSamePriceTypeOnly)), __LINE__);
        }
        if (is_null($cardsAllowAccessToSamePriceTypeOnly) || (is_array($cardsAllowAccessToSamePriceTypeOnly) && empty($cardsAllowAccessToSamePriceTypeOnly))) {
            unset($this->CardsAllowAccessToSamePriceTypeOnly);
        } else {
            $this->CardsAllowAccessToSamePriceTypeOnly = $cardsAllowAccessToSamePriceTypeOnly;
        }
        return $this;
    }
    /**
     * Get DayEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDayEndTime()
    {
        return isset($this->DayEndTime) ? $this->DayEndTime : null;
    }
    /**
     * Set DayEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dayEndTime
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setDayEndTime($dayEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($dayEndTime) && !is_string($dayEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dayEndTime, true), gettype($dayEndTime)), __LINE__);
        }
        if (is_null($dayEndTime) || (is_array($dayEndTime) && empty($dayEndTime))) {
            unset($this->DayEndTime);
        } else {
            $this->DayEndTime = $dayEndTime;
        }
        return $this;
    }
    /**
     * Get DayStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDayStartTime()
    {
        return isset($this->DayStartTime) ? $this->DayStartTime : null;
    }
    /**
     * Set DayStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dayStartTime
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setDayStartTime($dayStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($dayStartTime) && !is_string($dayStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dayStartTime, true), gettype($dayStartTime)), __LINE__);
        }
        if (is_null($dayStartTime) || (is_array($dayStartTime) && empty($dayStartTime))) {
            unset($this->DayStartTime);
        } else {
            $this->DayStartTime = $dayStartTime;
        }
        return $this;
    }
    /**
     * Get EndScanningMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEndScanningMinutes()
    {
        return isset($this->EndScanningMinutes) ? $this->EndScanningMinutes : null;
    }
    /**
     * Set EndScanningMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $endScanningMinutes
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setEndScanningMinutes($endScanningMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($endScanningMinutes) && !(is_int($endScanningMinutes) || ctype_digit($endScanningMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endScanningMinutes, true), gettype($endScanningMinutes)), __LINE__);
        }
        if (is_null($endScanningMinutes) || (is_array($endScanningMinutes) && empty($endScanningMinutes))) {
            unset($this->EndScanningMinutes);
        } else {
            $this->EndScanningMinutes = $endScanningMinutes;
        }
        return $this;
    }
    /**
     * Get EndScanningPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndScanningPolicy()
    {
        return isset($this->EndScanningPolicy) ? $this->EndScanningPolicy : null;
    }
    /**
     * Set EndScanningPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BarcodeEndScanPolicy::valueIsValid()
     * @uses \patest\EnumType\BarcodeEndScanPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endScanningPolicy
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setEndScanningPolicy($endScanningPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BarcodeEndScanPolicy::valueIsValid($endScanningPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BarcodeEndScanPolicy', is_array($endScanningPolicy) ? implode(', ', $endScanningPolicy) : var_export($endScanningPolicy, true), implode(', ', \patest\EnumType\BarcodeEndScanPolicy::getValidValues())), __LINE__);
        }
        if (is_null($endScanningPolicy) || (is_array($endScanningPolicy) && empty($endScanningPolicy))) {
            unset($this->EndScanningPolicy);
        } else {
            $this->EndScanningPolicy = $endScanningPolicy;
        }
        return $this;
    }
    /**
     * Get GenerateNewTicketBarcodeOnReprint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenerateNewTicketBarcodeOnReprint()
    {
        return isset($this->GenerateNewTicketBarcodeOnReprint) ? $this->GenerateNewTicketBarcodeOnReprint : null;
    }
    /**
     * Set GenerateNewTicketBarcodeOnReprint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GenerateNewTicketBarcodeOnReprintPolicy::valueIsValid()
     * @uses \patest\EnumType\GenerateNewTicketBarcodeOnReprintPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $generateNewTicketBarcodeOnReprint
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setGenerateNewTicketBarcodeOnReprint($generateNewTicketBarcodeOnReprint = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GenerateNewTicketBarcodeOnReprintPolicy::valueIsValid($generateNewTicketBarcodeOnReprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GenerateNewTicketBarcodeOnReprintPolicy', is_array($generateNewTicketBarcodeOnReprint) ? implode(', ', $generateNewTicketBarcodeOnReprint) : var_export($generateNewTicketBarcodeOnReprint, true), implode(', ', \patest\EnumType\GenerateNewTicketBarcodeOnReprintPolicy::getValidValues())), __LINE__);
        }
        if (is_null($generateNewTicketBarcodeOnReprint) || (is_array($generateNewTicketBarcodeOnReprint) && empty($generateNewTicketBarcodeOnReprint))) {
            unset($this->GenerateNewTicketBarcodeOnReprint);
        } else {
            $this->GenerateNewTicketBarcodeOnReprint = $generateNewTicketBarcodeOnReprint;
        }
        return $this;
    }
    /**
     * Get GenerateNewTicketBarcodeOnReprintExceptionReasonCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenerateNewTicketBarcodeOnReprintExceptionReasonCodes()
    {
        return isset($this->GenerateNewTicketBarcodeOnReprintExceptionReasonCodes) ? $this->GenerateNewTicketBarcodeOnReprintExceptionReasonCodes : null;
    }
    /**
     * Set GenerateNewTicketBarcodeOnReprintExceptionReasonCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generateNewTicketBarcodeOnReprintExceptionReasonCodes
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setGenerateNewTicketBarcodeOnReprintExceptionReasonCodes($generateNewTicketBarcodeOnReprintExceptionReasonCodes = null)
    {
        // validation for constraint: string
        if (!is_null($generateNewTicketBarcodeOnReprintExceptionReasonCodes) && !is_string($generateNewTicketBarcodeOnReprintExceptionReasonCodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generateNewTicketBarcodeOnReprintExceptionReasonCodes, true), gettype($generateNewTicketBarcodeOnReprintExceptionReasonCodes)), __LINE__);
        }
        if (is_null($generateNewTicketBarcodeOnReprintExceptionReasonCodes) || (is_array($generateNewTicketBarcodeOnReprintExceptionReasonCodes) && empty($generateNewTicketBarcodeOnReprintExceptionReasonCodes))) {
            unset($this->GenerateNewTicketBarcodeOnReprintExceptionReasonCodes);
        } else {
            $this->GenerateNewTicketBarcodeOnReprintExceptionReasonCodes = $generateNewTicketBarcodeOnReprintExceptionReasonCodes;
        }
        return $this;
    }
    /**
     * Get IdentifyCustomerForAccessControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIdentifyCustomerForAccessControl()
    {
        return isset($this->IdentifyCustomerForAccessControl) ? $this->IdentifyCustomerForAccessControl : null;
    }
    /**
     * Set IdentifyCustomerForAccessControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $identifyCustomerForAccessControl
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setIdentifyCustomerForAccessControl($identifyCustomerForAccessControl = null)
    {
        // validation for constraint: boolean
        if (!is_null($identifyCustomerForAccessControl) && !is_bool($identifyCustomerForAccessControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($identifyCustomerForAccessControl, true), gettype($identifyCustomerForAccessControl)), __LINE__);
        }
        if (is_null($identifyCustomerForAccessControl) || (is_array($identifyCustomerForAccessControl) && empty($identifyCustomerForAccessControl))) {
            unset($this->IdentifyCustomerForAccessControl);
        } else {
            $this->IdentifyCustomerForAccessControl = $identifyCustomerForAccessControl;
        }
        return $this;
    }
    /**
     * Get IsExternalScanning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExternalScanning()
    {
        return isset($this->IsExternalScanning) ? $this->IsExternalScanning : null;
    }
    /**
     * Set IsExternalScanning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExternalScanning
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setIsExternalScanning($isExternalScanning = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExternalScanning) && !is_bool($isExternalScanning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExternalScanning, true), gettype($isExternalScanning)), __LINE__);
        }
        if (is_null($isExternalScanning) || (is_array($isExternalScanning) && empty($isExternalScanning))) {
            unset($this->IsExternalScanning);
        } else {
            $this->IsExternalScanning = $isExternalScanning;
        }
        return $this;
    }
    /**
     * Get MaxAllowedEntriesPerDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAllowedEntriesPerDay()
    {
        return isset($this->MaxAllowedEntriesPerDay) ? $this->MaxAllowedEntriesPerDay : null;
    }
    /**
     * Set MaxAllowedEntriesPerDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAllowedEntriesPerDay
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setMaxAllowedEntriesPerDay($maxAllowedEntriesPerDay = null)
    {
        // validation for constraint: int
        if (!is_null($maxAllowedEntriesPerDay) && !(is_int($maxAllowedEntriesPerDay) || ctype_digit($maxAllowedEntriesPerDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAllowedEntriesPerDay, true), gettype($maxAllowedEntriesPerDay)), __LINE__);
        }
        if (is_null($maxAllowedEntriesPerDay) || (is_array($maxAllowedEntriesPerDay) && empty($maxAllowedEntriesPerDay))) {
            unset($this->MaxAllowedEntriesPerDay);
        } else {
            $this->MaxAllowedEntriesPerDay = $maxAllowedEntriesPerDay;
        }
        return $this;
    }
    /**
     * Get MaxScanningWindow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxScanningWindow()
    {
        return isset($this->MaxScanningWindow) ? $this->MaxScanningWindow : null;
    }
    /**
     * Set MaxScanningWindow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxScanningWindow
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setMaxScanningWindow($maxScanningWindow = null)
    {
        // validation for constraint: int
        if (!is_null($maxScanningWindow) && !(is_int($maxScanningWindow) || ctype_digit($maxScanningWindow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxScanningWindow, true), gettype($maxScanningWindow)), __LINE__);
        }
        if (is_null($maxScanningWindow) || (is_array($maxScanningWindow) && empty($maxScanningWindow))) {
            unset($this->MaxScanningWindow);
        } else {
            $this->MaxScanningWindow = $maxScanningWindow;
        }
        return $this;
    }
    /**
     * Get OfflineScanningRetrieveCrmEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOfflineScanningRetrieveCrmEmail()
    {
        return isset($this->OfflineScanningRetrieveCrmEmail) ? $this->OfflineScanningRetrieveCrmEmail : null;
    }
    /**
     * Set OfflineScanningRetrieveCrmEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $offlineScanningRetrieveCrmEmail
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setOfflineScanningRetrieveCrmEmail($offlineScanningRetrieveCrmEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($offlineScanningRetrieveCrmEmail) && !is_bool($offlineScanningRetrieveCrmEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offlineScanningRetrieveCrmEmail, true), gettype($offlineScanningRetrieveCrmEmail)), __LINE__);
        }
        if (is_null($offlineScanningRetrieveCrmEmail) || (is_array($offlineScanningRetrieveCrmEmail) && empty($offlineScanningRetrieveCrmEmail))) {
            unset($this->OfflineScanningRetrieveCrmEmail);
        } else {
            $this->OfflineScanningRetrieveCrmEmail = $offlineScanningRetrieveCrmEmail;
        }
        return $this;
    }
    /**
     * Get OfflineScanningRetrieveCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOfflineScanningRetrieveCrmId()
    {
        return isset($this->OfflineScanningRetrieveCrmId) ? $this->OfflineScanningRetrieveCrmId : null;
    }
    /**
     * Set OfflineScanningRetrieveCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $offlineScanningRetrieveCrmId
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setOfflineScanningRetrieveCrmId($offlineScanningRetrieveCrmId = null)
    {
        // validation for constraint: boolean
        if (!is_null($offlineScanningRetrieveCrmId) && !is_bool($offlineScanningRetrieveCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offlineScanningRetrieveCrmId, true), gettype($offlineScanningRetrieveCrmId)), __LINE__);
        }
        if (is_null($offlineScanningRetrieveCrmId) || (is_array($offlineScanningRetrieveCrmId) && empty($offlineScanningRetrieveCrmId))) {
            unset($this->OfflineScanningRetrieveCrmId);
        } else {
            $this->OfflineScanningRetrieveCrmId = $offlineScanningRetrieveCrmId;
        }
        return $this;
    }
    /**
     * Get OfflineScanningRetrieveCrmMobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOfflineScanningRetrieveCrmMobile()
    {
        return isset($this->OfflineScanningRetrieveCrmMobile) ? $this->OfflineScanningRetrieveCrmMobile : null;
    }
    /**
     * Set OfflineScanningRetrieveCrmMobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $offlineScanningRetrieveCrmMobile
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setOfflineScanningRetrieveCrmMobile($offlineScanningRetrieveCrmMobile = null)
    {
        // validation for constraint: boolean
        if (!is_null($offlineScanningRetrieveCrmMobile) && !is_bool($offlineScanningRetrieveCrmMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offlineScanningRetrieveCrmMobile, true), gettype($offlineScanningRetrieveCrmMobile)), __LINE__);
        }
        if (is_null($offlineScanningRetrieveCrmMobile) || (is_array($offlineScanningRetrieveCrmMobile) && empty($offlineScanningRetrieveCrmMobile))) {
            unset($this->OfflineScanningRetrieveCrmMobile);
        } else {
            $this->OfflineScanningRetrieveCrmMobile = $offlineScanningRetrieveCrmMobile;
        }
        return $this;
    }
    /**
     * Get OtpHexadecimalValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtpHexadecimalValue()
    {
        return isset($this->OtpHexadecimalValue) ? $this->OtpHexadecimalValue : null;
    }
    /**
     * Set OtpHexadecimalValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otpHexadecimalValue
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setOtpHexadecimalValue($otpHexadecimalValue = null)
    {
        // validation for constraint: string
        if (!is_null($otpHexadecimalValue) && !is_string($otpHexadecimalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otpHexadecimalValue, true), gettype($otpHexadecimalValue)), __LINE__);
        }
        if (is_null($otpHexadecimalValue) || (is_array($otpHexadecimalValue) && empty($otpHexadecimalValue))) {
            unset($this->OtpHexadecimalValue);
        } else {
            $this->OtpHexadecimalValue = $otpHexadecimalValue;
        }
        return $this;
    }
    /**
     * Get OtpIntervalInSeconds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOtpIntervalInSeconds()
    {
        return isset($this->OtpIntervalInSeconds) ? $this->OtpIntervalInSeconds : null;
    }
    /**
     * Set OtpIntervalInSeconds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $otpIntervalInSeconds
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setOtpIntervalInSeconds($otpIntervalInSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($otpIntervalInSeconds) && !(is_int($otpIntervalInSeconds) || ctype_digit($otpIntervalInSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($otpIntervalInSeconds, true), gettype($otpIntervalInSeconds)), __LINE__);
        }
        if (is_null($otpIntervalInSeconds) || (is_array($otpIntervalInSeconds) && empty($otpIntervalInSeconds))) {
            unset($this->OtpIntervalInSeconds);
        } else {
            $this->OtpIntervalInSeconds = $otpIntervalInSeconds;
        }
        return $this;
    }
    /**
     * Get PolicyToReturnScannedTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPolicyToReturnScannedTickets()
    {
        return isset($this->PolicyToReturnScannedTickets) ? $this->PolicyToReturnScannedTickets : null;
    }
    /**
     * Set PolicyToReturnScannedTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PolicyToReturnScannedTickets::valueIsValid()
     * @uses \patest\EnumType\PolicyToReturnScannedTickets::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policyToReturnScannedTickets
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setPolicyToReturnScannedTickets($policyToReturnScannedTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PolicyToReturnScannedTickets::valueIsValid($policyToReturnScannedTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PolicyToReturnScannedTickets', is_array($policyToReturnScannedTickets) ? implode(', ', $policyToReturnScannedTickets) : var_export($policyToReturnScannedTickets, true), implode(', ', \patest\EnumType\PolicyToReturnScannedTickets::getValidValues())), __LINE__);
        }
        if (is_null($policyToReturnScannedTickets) || (is_array($policyToReturnScannedTickets) && empty($policyToReturnScannedTickets))) {
            unset($this->PolicyToReturnScannedTickets);
        } else {
            $this->PolicyToReturnScannedTickets = $policyToReturnScannedTickets;
        }
        return $this;
    }
    /**
     * Get ScanResultColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanResultColor()
    {
        return isset($this->ScanResultColor) ? $this->ScanResultColor : null;
    }
    /**
     * Set ScanResultColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scanResultColor
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setScanResultColor($scanResultColor = null)
    {
        // validation for constraint: string
        if (!is_null($scanResultColor) && !is_string($scanResultColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanResultColor, true), gettype($scanResultColor)), __LINE__);
        }
        if (is_null($scanResultColor) || (is_array($scanResultColor) && empty($scanResultColor))) {
            unset($this->ScanResultColor);
        } else {
            $this->ScanResultColor = $scanResultColor;
        }
        return $this;
    }
    /**
     * Get ScanResultSoundFileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanResultSoundFileName()
    {
        return isset($this->ScanResultSoundFileName) ? $this->ScanResultSoundFileName : null;
    }
    /**
     * Set ScanResultSoundFileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scanResultSoundFileName
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setScanResultSoundFileName($scanResultSoundFileName = null)
    {
        // validation for constraint: string
        if (!is_null($scanResultSoundFileName) && !is_string($scanResultSoundFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanResultSoundFileName, true), gettype($scanResultSoundFileName)), __LINE__);
        }
        if (is_null($scanResultSoundFileName) || (is_array($scanResultSoundFileName) && empty($scanResultSoundFileName))) {
            unset($this->ScanResultSoundFileName);
        } else {
            $this->ScanResultSoundFileName = $scanResultSoundFileName;
        }
        return $this;
    }
    /**
     * Get ShowCustomerPictureOnScan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowCustomerPictureOnScan()
    {
        return isset($this->ShowCustomerPictureOnScan) ? $this->ShowCustomerPictureOnScan : null;
    }
    /**
     * Set ShowCustomerPictureOnScan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showCustomerPictureOnScan
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setShowCustomerPictureOnScan($showCustomerPictureOnScan = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCustomerPictureOnScan) && !is_bool($showCustomerPictureOnScan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCustomerPictureOnScan, true), gettype($showCustomerPictureOnScan)), __LINE__);
        }
        if (is_null($showCustomerPictureOnScan) || (is_array($showCustomerPictureOnScan) && empty($showCustomerPictureOnScan))) {
            unset($this->ShowCustomerPictureOnScan);
        } else {
            $this->ShowCustomerPictureOnScan = $showCustomerPictureOnScan;
        }
        return $this;
    }
    /**
     * Get StartScanningMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStartScanningMinutes()
    {
        return isset($this->StartScanningMinutes) ? $this->StartScanningMinutes : null;
    }
    /**
     * Set StartScanningMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $startScanningMinutes
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setStartScanningMinutes($startScanningMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($startScanningMinutes) && !(is_int($startScanningMinutes) || ctype_digit($startScanningMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startScanningMinutes, true), gettype($startScanningMinutes)), __LINE__);
        }
        if (is_null($startScanningMinutes) || (is_array($startScanningMinutes) && empty($startScanningMinutes))) {
            unset($this->StartScanningMinutes);
        } else {
            $this->StartScanningMinutes = $startScanningMinutes;
        }
        return $this;
    }
    /**
     * Get StartScanningPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartScanningPolicy()
    {
        return isset($this->StartScanningPolicy) ? $this->StartScanningPolicy : null;
    }
    /**
     * Set StartScanningPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BarcodeStartScanPolicy::valueIsValid()
     * @uses \patest\EnumType\BarcodeStartScanPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startScanningPolicy
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setStartScanningPolicy($startScanningPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BarcodeStartScanPolicy::valueIsValid($startScanningPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BarcodeStartScanPolicy', is_array($startScanningPolicy) ? implode(', ', $startScanningPolicy) : var_export($startScanningPolicy, true), implode(', ', \patest\EnumType\BarcodeStartScanPolicy::getValidValues())), __LINE__);
        }
        if (is_null($startScanningPolicy) || (is_array($startScanningPolicy) && empty($startScanningPolicy))) {
            unset($this->StartScanningPolicy);
        } else {
            $this->StartScanningPolicy = $startScanningPolicy;
        }
        return $this;
    }
    /**
     * Get StoreBarcodeUsagesSynchronously value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getStoreBarcodeUsagesSynchronously()
    {
        return isset($this->StoreBarcodeUsagesSynchronously) ? $this->StoreBarcodeUsagesSynchronously : null;
    }
    /**
     * Set StoreBarcodeUsagesSynchronously value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $storeBarcodeUsagesSynchronously
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setStoreBarcodeUsagesSynchronously($storeBarcodeUsagesSynchronously = null)
    {
        // validation for constraint: boolean
        if (!is_null($storeBarcodeUsagesSynchronously) && !is_bool($storeBarcodeUsagesSynchronously)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($storeBarcodeUsagesSynchronously, true), gettype($storeBarcodeUsagesSynchronously)), __LINE__);
        }
        if (is_null($storeBarcodeUsagesSynchronously) || (is_array($storeBarcodeUsagesSynchronously) && empty($storeBarcodeUsagesSynchronously))) {
            unset($this->StoreBarcodeUsagesSynchronously);
        } else {
            $this->StoreBarcodeUsagesSynchronously = $storeBarcodeUsagesSynchronously;
        }
        return $this;
    }
    /**
     * Get SupportAccessToSameShowEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSupportAccessToSameShowEvents()
    {
        return isset($this->SupportAccessToSameShowEvents) ? $this->SupportAccessToSameShowEvents : null;
    }
    /**
     * Set SupportAccessToSameShowEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $supportAccessToSameShowEvents
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setSupportAccessToSameShowEvents($supportAccessToSameShowEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportAccessToSameShowEvents) && !is_bool($supportAccessToSameShowEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supportAccessToSameShowEvents, true), gettype($supportAccessToSameShowEvents)), __LINE__);
        }
        if (is_null($supportAccessToSameShowEvents) || (is_array($supportAccessToSameShowEvents) && empty($supportAccessToSameShowEvents))) {
            unset($this->SupportAccessToSameShowEvents);
        } else {
            $this->SupportAccessToSameShowEvents = $supportAccessToSameShowEvents;
        }
        return $this;
    }
    /**
     * Get SupportsNamedScan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSupportsNamedScan()
    {
        return isset($this->SupportsNamedScan) ? $this->SupportsNamedScan : null;
    }
    /**
     * Set SupportsNamedScan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $supportsNamedScan
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setSupportsNamedScan($supportsNamedScan = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportsNamedScan) && !is_bool($supportsNamedScan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supportsNamedScan, true), gettype($supportsNamedScan)), __LINE__);
        }
        if (is_null($supportsNamedScan) || (is_array($supportsNamedScan) && empty($supportsNamedScan))) {
            unset($this->SupportsNamedScan);
        } else {
            $this->SupportsNamedScan = $supportsNamedScan;
        }
        return $this;
    }
    /**
     * Get TurnstilesForSpecialClientTypesOverridePolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstilesForSpecialClientTypesOverridePolicy()
    {
        return isset($this->TurnstilesForSpecialClientTypesOverridePolicy) ? $this->TurnstilesForSpecialClientTypesOverridePolicy : null;
    }
    /**
     * Set TurnstilesForSpecialClientTypesOverridePolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TurnstilesForSpecialClientTypesOverridePolicy::valueIsValid()
     * @uses \patest\EnumType\TurnstilesForSpecialClientTypesOverridePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $turnstilesForSpecialClientTypesOverridePolicy
     * @return \patest\StructType\Security_AccessControlCompanyParameters
     */
    public function setTurnstilesForSpecialClientTypesOverridePolicy($turnstilesForSpecialClientTypesOverridePolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TurnstilesForSpecialClientTypesOverridePolicy::valueIsValid($turnstilesForSpecialClientTypesOverridePolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TurnstilesForSpecialClientTypesOverridePolicy', is_array($turnstilesForSpecialClientTypesOverridePolicy) ? implode(', ', $turnstilesForSpecialClientTypesOverridePolicy) : var_export($turnstilesForSpecialClientTypesOverridePolicy, true), implode(', ', \patest\EnumType\TurnstilesForSpecialClientTypesOverridePolicy::getValidValues())), __LINE__);
        }
        if (is_null($turnstilesForSpecialClientTypesOverridePolicy) || (is_array($turnstilesForSpecialClientTypesOverridePolicy) && empty($turnstilesForSpecialClientTypesOverridePolicy))) {
            unset($this->TurnstilesForSpecialClientTypesOverridePolicy);
        } else {
            $this->TurnstilesForSpecialClientTypesOverridePolicy = $turnstilesForSpecialClientTypesOverridePolicy;
        }
        return $this;
    }
}
