<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatsPriceOverrideData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatsPriceOverrideData
 * @subpackage Structs
 */
class SeatsPriceOverrideData extends AbstractStructBase
{
    /**
     * The OverriddenPriceInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\InventoryPricingEntry
     */
    public $OverriddenPriceInfo;
    /**
     * The OverriddenSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSeatsInArea
     */
    public $OverriddenSeats;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * Constructor method for SeatsPriceOverrideData
     * @uses SeatsPriceOverrideData::setOverriddenPriceInfo()
     * @uses SeatsPriceOverrideData::setOverriddenSeats()
     * @uses SeatsPriceOverrideData::setPriceTypeId()
     * @param \patest\StructType\InventoryPricingEntry $overriddenPriceInfo
     * @param \patest\ArrayType\ArrayOfSeatsInArea $overriddenSeats
     * @param string $priceTypeId
     */
    public function __construct(\patest\StructType\InventoryPricingEntry $overriddenPriceInfo = null, \patest\ArrayType\ArrayOfSeatsInArea $overriddenSeats = null, $priceTypeId = null)
    {
        $this
            ->setOverriddenPriceInfo($overriddenPriceInfo)
            ->setOverriddenSeats($overriddenSeats)
            ->setPriceTypeId($priceTypeId);
    }
    /**
     * Get OverriddenPriceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\InventoryPricingEntry|null
     */
    public function getOverriddenPriceInfo()
    {
        return isset($this->OverriddenPriceInfo) ? $this->OverriddenPriceInfo : null;
    }
    /**
     * Set OverriddenPriceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\InventoryPricingEntry $overriddenPriceInfo
     * @return \patest\StructType\SeatsPriceOverrideData
     */
    public function setOverriddenPriceInfo(\patest\StructType\InventoryPricingEntry $overriddenPriceInfo = null)
    {
        if (is_null($overriddenPriceInfo) || (is_array($overriddenPriceInfo) && empty($overriddenPriceInfo))) {
            unset($this->OverriddenPriceInfo);
        } else {
            $this->OverriddenPriceInfo = $overriddenPriceInfo;
        }
        return $this;
    }
    /**
     * Get OverriddenSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSeatsInArea|null
     */
    public function getOverriddenSeats()
    {
        return isset($this->OverriddenSeats) ? $this->OverriddenSeats : null;
    }
    /**
     * Set OverriddenSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSeatsInArea $overriddenSeats
     * @return \patest\StructType\SeatsPriceOverrideData
     */
    public function setOverriddenSeats(\patest\ArrayType\ArrayOfSeatsInArea $overriddenSeats = null)
    {
        if (is_null($overriddenSeats) || (is_array($overriddenSeats) && empty($overriddenSeats))) {
            unset($this->OverriddenSeats);
        } else {
            $this->OverriddenSeats = $overriddenSeats;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return $this->PriceTypeId;
    }
    /**
     * Set PriceTypeId value
     * @param string $priceTypeId
     * @return \patest\StructType\SeatsPriceOverrideData
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        $this->PriceTypeId = $priceTypeId;
        return $this;
    }
}
