<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatingPlanAccessContext StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatingPlanAccessContext
 * @subpackage Structs
 */
class SeatingPlanAccessContext extends AbstractStructBase
{
    /**
     * The SubscriptionInstanceIdsBeingRenewed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $SubscriptionInstanceIdsBeingRenewed;
    /**
     * The RelatedOwnedSubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $RelatedOwnedSubscriptionInstanceIds;
    /**
     * The IsSupportingMarketDrivenResalePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSupportingMarketDrivenResalePolicy;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The RelatedToSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedToSeriesId;
    /**
     * The WorkflowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkflowType;
    /**
     * Constructor method for SeatingPlanAccessContext
     * @uses SeatingPlanAccessContext::setSubscriptionInstanceIdsBeingRenewed()
     * @uses SeatingPlanAccessContext::setRelatedOwnedSubscriptionInstanceIds()
     * @uses SeatingPlanAccessContext::setIsSupportingMarketDrivenResalePolicy()
     * @uses SeatingPlanAccessContext::setClientId()
     * @uses SeatingPlanAccessContext::setRelatedToSeriesId()
     * @uses SeatingPlanAccessContext::setWorkflowType()
     * @param \patest\ArrayType\ArrayOfguid $subscriptionInstanceIdsBeingRenewed
     * @param \patest\ArrayType\ArrayOfguid $relatedOwnedSubscriptionInstanceIds
     * @param bool $isSupportingMarketDrivenResalePolicy
     * @param string $clientId
     * @param string $relatedToSeriesId
     * @param string $workflowType
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $subscriptionInstanceIdsBeingRenewed = null, \patest\ArrayType\ArrayOfguid $relatedOwnedSubscriptionInstanceIds = null, $isSupportingMarketDrivenResalePolicy = null, $clientId = null, $relatedToSeriesId = null, $workflowType = null)
    {
        $this
            ->setSubscriptionInstanceIdsBeingRenewed($subscriptionInstanceIdsBeingRenewed)
            ->setRelatedOwnedSubscriptionInstanceIds($relatedOwnedSubscriptionInstanceIds)
            ->setIsSupportingMarketDrivenResalePolicy($isSupportingMarketDrivenResalePolicy)
            ->setClientId($clientId)
            ->setRelatedToSeriesId($relatedToSeriesId)
            ->setWorkflowType($workflowType);
    }
    /**
     * Get SubscriptionInstanceIdsBeingRenewed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getSubscriptionInstanceIdsBeingRenewed()
    {
        return isset($this->SubscriptionInstanceIdsBeingRenewed) ? $this->SubscriptionInstanceIdsBeingRenewed : null;
    }
    /**
     * Set SubscriptionInstanceIdsBeingRenewed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $subscriptionInstanceIdsBeingRenewed
     * @return \patest\StructType\SeatingPlanAccessContext
     */
    public function setSubscriptionInstanceIdsBeingRenewed(\patest\ArrayType\ArrayOfguid $subscriptionInstanceIdsBeingRenewed = null)
    {
        if (is_null($subscriptionInstanceIdsBeingRenewed) || (is_array($subscriptionInstanceIdsBeingRenewed) && empty($subscriptionInstanceIdsBeingRenewed))) {
            unset($this->SubscriptionInstanceIdsBeingRenewed);
        } else {
            $this->SubscriptionInstanceIdsBeingRenewed = $subscriptionInstanceIdsBeingRenewed;
        }
        return $this;
    }
    /**
     * Get RelatedOwnedSubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getRelatedOwnedSubscriptionInstanceIds()
    {
        return isset($this->RelatedOwnedSubscriptionInstanceIds) ? $this->RelatedOwnedSubscriptionInstanceIds : null;
    }
    /**
     * Set RelatedOwnedSubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $relatedOwnedSubscriptionInstanceIds
     * @return \patest\StructType\SeatingPlanAccessContext
     */
    public function setRelatedOwnedSubscriptionInstanceIds(\patest\ArrayType\ArrayOfguid $relatedOwnedSubscriptionInstanceIds = null)
    {
        if (is_null($relatedOwnedSubscriptionInstanceIds) || (is_array($relatedOwnedSubscriptionInstanceIds) && empty($relatedOwnedSubscriptionInstanceIds))) {
            unset($this->RelatedOwnedSubscriptionInstanceIds);
        } else {
            $this->RelatedOwnedSubscriptionInstanceIds = $relatedOwnedSubscriptionInstanceIds;
        }
        return $this;
    }
    /**
     * Get IsSupportingMarketDrivenResalePolicy value
     * @return bool|null
     */
    public function getIsSupportingMarketDrivenResalePolicy()
    {
        return $this->IsSupportingMarketDrivenResalePolicy;
    }
    /**
     * Set IsSupportingMarketDrivenResalePolicy value
     * @param bool $isSupportingMarketDrivenResalePolicy
     * @return \patest\StructType\SeatingPlanAccessContext
     */
    public function setIsSupportingMarketDrivenResalePolicy($isSupportingMarketDrivenResalePolicy = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupportingMarketDrivenResalePolicy) && !is_bool($isSupportingMarketDrivenResalePolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupportingMarketDrivenResalePolicy, true), gettype($isSupportingMarketDrivenResalePolicy)), __LINE__);
        }
        $this->IsSupportingMarketDrivenResalePolicy = $isSupportingMarketDrivenResalePolicy;
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\SeatingPlanAccessContext
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get RelatedToSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedToSeriesId()
    {
        return isset($this->RelatedToSeriesId) ? $this->RelatedToSeriesId : null;
    }
    /**
     * Set RelatedToSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedToSeriesId
     * @return \patest\StructType\SeatingPlanAccessContext
     */
    public function setRelatedToSeriesId($relatedToSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedToSeriesId) && !is_string($relatedToSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedToSeriesId, true), gettype($relatedToSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedToSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedToSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedToSeriesId, true)), __LINE__);
        }
        if (is_null($relatedToSeriesId) || (is_array($relatedToSeriesId) && empty($relatedToSeriesId))) {
            unset($this->RelatedToSeriesId);
        } else {
            $this->RelatedToSeriesId = $relatedToSeriesId;
        }
        return $this;
    }
    /**
     * Get WorkflowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkflowType()
    {
        return isset($this->WorkflowType) ? $this->WorkflowType : null;
    }
    /**
     * Set WorkflowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WorkflowType::valueIsValid()
     * @uses \patest\EnumType\WorkflowType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $workflowType
     * @return \patest\StructType\SeatingPlanAccessContext
     */
    public function setWorkflowType($workflowType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WorkflowType::valueIsValid($workflowType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WorkflowType', is_array($workflowType) ? implode(', ', $workflowType) : var_export($workflowType, true), implode(', ', \patest\EnumType\WorkflowType::getValidValues())), __LINE__);
        }
        if (is_null($workflowType) || (is_array($workflowType) && empty($workflowType))) {
            unset($this->WorkflowType);
        } else {
            $this->WorkflowType = $workflowType;
        }
        return $this;
    }
}
