<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatSetIdentity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatSetIdentity
 * @subpackage Structs
 */
class SeatSetIdentity extends AbstractStructBase
{
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The Restrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfRestrictionIdentity
     */
    public $Restrictions;
    /**
     * Constructor method for SeatSetIdentity
     * @uses SeatSetIdentity::setPriceLevelId()
     * @uses SeatSetIdentity::setRestrictions()
     * @param string $priceLevelId
     * @param \patest\ArrayType\ArrayOfRestrictionIdentity $restrictions
     */
    public function __construct($priceLevelId = null, \patest\ArrayType\ArrayOfRestrictionIdentity $restrictions = null)
    {
        $this
            ->setPriceLevelId($priceLevelId)
            ->setRestrictions($restrictions);
    }
    /**
     * Get PriceLevelId value
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return $this->PriceLevelId;
    }
    /**
     * Set PriceLevelId value
     * @param string $priceLevelId
     * @return \patest\StructType\SeatSetIdentity
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        $this->PriceLevelId = $priceLevelId;
        return $this;
    }
    /**
     * Get Restrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfRestrictionIdentity|null
     */
    public function getRestrictions()
    {
        return isset($this->Restrictions) ? $this->Restrictions : null;
    }
    /**
     * Set Restrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfRestrictionIdentity $restrictions
     * @return \patest\StructType\SeatSetIdentity
     */
    public function setRestrictions(\patest\ArrayType\ArrayOfRestrictionIdentity $restrictions = null)
    {
        if (is_null($restrictions) || (is_array($restrictions) && empty($restrictions))) {
            unset($this->Restrictions);
        } else {
            $this->Restrictions = $restrictions;
        }
        return $this;
    }
}
