<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatRestrictionsInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatRestrictionsInfo
 * @subpackage Structs
 */
class SeatRestrictionsInfo extends AbstractStructBase
{
    /**
     * The AllocationIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AllocationIds;
    /**
     * The LockId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockId;
    /**
     * Constructor method for SeatRestrictionsInfo
     * @uses SeatRestrictionsInfo::setAllocationIds()
     * @uses SeatRestrictionsInfo::setLockId()
     * @param \patest\ArrayType\ArrayOfguid $allocationIds
     * @param string $lockId
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $allocationIds = null, $lockId = null)
    {
        $this
            ->setAllocationIds($allocationIds)
            ->setLockId($lockId);
    }
    /**
     * Get AllocationIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAllocationIds()
    {
        return isset($this->AllocationIds) ? $this->AllocationIds : null;
    }
    /**
     * Set AllocationIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $allocationIds
     * @return \patest\StructType\SeatRestrictionsInfo
     */
    public function setAllocationIds(\patest\ArrayType\ArrayOfguid $allocationIds = null)
    {
        if (is_null($allocationIds) || (is_array($allocationIds) && empty($allocationIds))) {
            unset($this->AllocationIds);
        } else {
            $this->AllocationIds = $allocationIds;
        }
        return $this;
    }
    /**
     * Get LockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockId()
    {
        return isset($this->LockId) ? $this->LockId : null;
    }
    /**
     * Set LockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockId
     * @return \patest\StructType\SeatRestrictionsInfo
     */
    public function setLockId($lockId = null)
    {
        // validation for constraint: string
        if (!is_null($lockId) && !is_string($lockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockId, true), gettype($lockId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockId, true)), __LINE__);
        }
        if (is_null($lockId) || (is_array($lockId) && empty($lockId))) {
            unset($this->LockId);
        } else {
            $this->LockId = $lockId;
        }
        return $this;
    }
}
