<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatInventoryDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatInventoryDetails
 * @subpackage Structs
 */
class SeatInventoryDetails extends AbstractStructBase
{
    /**
     * The AddedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddedAt;
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Cost;
    /**
     * The InventoryNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InventoryNumber;
    /**
     * The InventoryProviderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InventoryProviderId;
    /**
     * The InventoryProviderName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InventoryProviderName;
    /**
     * The InventoryTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InventoryTypeId;
    /**
     * The InventoryTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InventoryTypeName;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceDate;
    /**
     * The IsPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPaid;
    /**
     * The LiabilityStatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LiabilityStatusId;
    /**
     * The LiabilityStatusName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LiabilityStatusName;
    /**
     * Constructor method for SeatInventoryDetails
     * @uses SeatInventoryDetails::setAddedAt()
     * @uses SeatInventoryDetails::setCost()
     * @uses SeatInventoryDetails::setInventoryNumber()
     * @uses SeatInventoryDetails::setInventoryProviderId()
     * @uses SeatInventoryDetails::setInventoryProviderName()
     * @uses SeatInventoryDetails::setInventoryTypeId()
     * @uses SeatInventoryDetails::setInventoryTypeName()
     * @uses SeatInventoryDetails::setInvoiceDate()
     * @uses SeatInventoryDetails::setIsPaid()
     * @uses SeatInventoryDetails::setLiabilityStatusId()
     * @uses SeatInventoryDetails::setLiabilityStatusName()
     * @param string $addedAt
     * @param \patest\StructType\Money $cost
     * @param int $inventoryNumber
     * @param string $inventoryProviderId
     * @param string $inventoryProviderName
     * @param string $inventoryTypeId
     * @param string $inventoryTypeName
     * @param string $invoiceDate
     * @param bool $isPaid
     * @param string $liabilityStatusId
     * @param string $liabilityStatusName
     */
    public function __construct($addedAt = null, \patest\StructType\Money $cost = null, $inventoryNumber = null, $inventoryProviderId = null, $inventoryProviderName = null, $inventoryTypeId = null, $inventoryTypeName = null, $invoiceDate = null, $isPaid = null, $liabilityStatusId = null, $liabilityStatusName = null)
    {
        $this
            ->setAddedAt($addedAt)
            ->setCost($cost)
            ->setInventoryNumber($inventoryNumber)
            ->setInventoryProviderId($inventoryProviderId)
            ->setInventoryProviderName($inventoryProviderName)
            ->setInventoryTypeId($inventoryTypeId)
            ->setInventoryTypeName($inventoryTypeName)
            ->setInvoiceDate($invoiceDate)
            ->setIsPaid($isPaid)
            ->setLiabilityStatusId($liabilityStatusId)
            ->setLiabilityStatusName($liabilityStatusName);
    }
    /**
     * Get AddedAt value
     * @return string|null
     */
    public function getAddedAt()
    {
        return $this->AddedAt;
    }
    /**
     * Set AddedAt value
     * @param string $addedAt
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setAddedAt($addedAt = null)
    {
        // validation for constraint: string
        if (!is_null($addedAt) && !is_string($addedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addedAt, true), gettype($addedAt)), __LINE__);
        }
        $this->AddedAt = $addedAt;
        return $this;
    }
    /**
     * Get Cost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCost()
    {
        return isset($this->Cost) ? $this->Cost : null;
    }
    /**
     * Set Cost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $cost
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setCost(\patest\StructType\Money $cost = null)
    {
        if (is_null($cost) || (is_array($cost) && empty($cost))) {
            unset($this->Cost);
        } else {
            $this->Cost = $cost;
        }
        return $this;
    }
    /**
     * Get InventoryNumber value
     * @return int|null
     */
    public function getInventoryNumber()
    {
        return $this->InventoryNumber;
    }
    /**
     * Set InventoryNumber value
     * @param int $inventoryNumber
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setInventoryNumber($inventoryNumber = null)
    {
        // validation for constraint: int
        if (!is_null($inventoryNumber) && !(is_int($inventoryNumber) || ctype_digit($inventoryNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inventoryNumber, true), gettype($inventoryNumber)), __LINE__);
        }
        $this->InventoryNumber = $inventoryNumber;
        return $this;
    }
    /**
     * Get InventoryProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryProviderId()
    {
        return isset($this->InventoryProviderId) ? $this->InventoryProviderId : null;
    }
    /**
     * Set InventoryProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryProviderId
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setInventoryProviderId($inventoryProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryProviderId) && !is_string($inventoryProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryProviderId, true), gettype($inventoryProviderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inventoryProviderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inventoryProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inventoryProviderId, true)), __LINE__);
        }
        if (is_null($inventoryProviderId) || (is_array($inventoryProviderId) && empty($inventoryProviderId))) {
            unset($this->InventoryProviderId);
        } else {
            $this->InventoryProviderId = $inventoryProviderId;
        }
        return $this;
    }
    /**
     * Get InventoryProviderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryProviderName()
    {
        return isset($this->InventoryProviderName) ? $this->InventoryProviderName : null;
    }
    /**
     * Set InventoryProviderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryProviderName
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setInventoryProviderName($inventoryProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryProviderName) && !is_string($inventoryProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryProviderName, true), gettype($inventoryProviderName)), __LINE__);
        }
        if (is_null($inventoryProviderName) || (is_array($inventoryProviderName) && empty($inventoryProviderName))) {
            unset($this->InventoryProviderName);
        } else {
            $this->InventoryProviderName = $inventoryProviderName;
        }
        return $this;
    }
    /**
     * Get InventoryTypeId value
     * @return string|null
     */
    public function getInventoryTypeId()
    {
        return $this->InventoryTypeId;
    }
    /**
     * Set InventoryTypeId value
     * @param string $inventoryTypeId
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setInventoryTypeId($inventoryTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryTypeId) && !is_string($inventoryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryTypeId, true), gettype($inventoryTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inventoryTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inventoryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inventoryTypeId, true)), __LINE__);
        }
        $this->InventoryTypeId = $inventoryTypeId;
        return $this;
    }
    /**
     * Get InventoryTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryTypeName()
    {
        return isset($this->InventoryTypeName) ? $this->InventoryTypeName : null;
    }
    /**
     * Set InventoryTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryTypeName
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setInventoryTypeName($inventoryTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryTypeName) && !is_string($inventoryTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryTypeName, true), gettype($inventoryTypeName)), __LINE__);
        }
        if (is_null($inventoryTypeName) || (is_array($inventoryTypeName) && empty($inventoryTypeName))) {
            unset($this->InventoryTypeName);
        } else {
            $this->InventoryTypeName = $inventoryTypeName;
        }
        return $this;
    }
    /**
     * Get InvoiceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return isset($this->InvoiceDate) ? $this->InvoiceDate : null;
    }
    /**
     * Set InvoiceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceDate
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        if (is_null($invoiceDate) || (is_array($invoiceDate) && empty($invoiceDate))) {
            unset($this->InvoiceDate);
        } else {
            $this->InvoiceDate = $invoiceDate;
        }
        return $this;
    }
    /**
     * Get IsPaid value
     * @return bool|null
     */
    public function getIsPaid()
    {
        return $this->IsPaid;
    }
    /**
     * Set IsPaid value
     * @param bool $isPaid
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setIsPaid($isPaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaid) && !is_bool($isPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPaid, true), gettype($isPaid)), __LINE__);
        }
        $this->IsPaid = $isPaid;
        return $this;
    }
    /**
     * Get LiabilityStatusId value
     * @return string|null
     */
    public function getLiabilityStatusId()
    {
        return $this->LiabilityStatusId;
    }
    /**
     * Set LiabilityStatusId value
     * @param string $liabilityStatusId
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setLiabilityStatusId($liabilityStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($liabilityStatusId) && !is_string($liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liabilityStatusId, true), gettype($liabilityStatusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($liabilityStatusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($liabilityStatusId, true)), __LINE__);
        }
        $this->LiabilityStatusId = $liabilityStatusId;
        return $this;
    }
    /**
     * Get LiabilityStatusName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiabilityStatusName()
    {
        return isset($this->LiabilityStatusName) ? $this->LiabilityStatusName : null;
    }
    /**
     * Set LiabilityStatusName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $liabilityStatusName
     * @return \patest\StructType\SeatInventoryDetails
     */
    public function setLiabilityStatusName($liabilityStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($liabilityStatusName) && !is_string($liabilityStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liabilityStatusName, true), gettype($liabilityStatusName)), __LINE__);
        }
        if (is_null($liabilityStatusName) || (is_array($liabilityStatusName) && empty($liabilityStatusName))) {
            unset($this->LiabilityStatusName);
        } else {
            $this->LiabilityStatusName = $liabilityStatusName;
        }
        return $this;
    }
}
