<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Search.CrossSearchServiceResultRecord StructType
 * @subpackage Structs
 */
class Search_CrossSearchServiceResultRecord extends AnyEntity
{
    /**
     * The ClientFullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientFullName;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientId;
    /**
     * The ComplimentaryState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComplimentaryState;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Expiry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Expiry;
    /**
     * The HasHistoryState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HasHistoryState;
    /**
     * The HasMembership
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HasMembership;
    /**
     * The HasUnConfirmedPayments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HasUnConfirmedPayments;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Item;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The PrintingState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingState;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Quantity;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The ReservationState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationState;
    /**
     * The ReturnItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturnItems;
    /**
     * The SaleChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleChannel;
    /**
     * The SaleCurrent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleCurrent;
    /**
     * The SaleOriginal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleOriginal;
    /**
     * The SaleReturns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleReturns;
    /**
     * The SGOrderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SGOrderId;
    /**
     * The StrikeSaleOriginal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $StrikeSaleOriginal;
    /**
     * The TotalActualPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalActualPayment;
    /**
     * The TotalTransactionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTransactionValue;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The WaitingListMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WaitingListMode;
    /**
     * Constructor method for Search.CrossSearchServiceResultRecord
     * @uses Search_CrossSearchServiceResultRecord::setClientFullName()
     * @uses Search_CrossSearchServiceResultRecord::setClientId()
     * @uses Search_CrossSearchServiceResultRecord::setComplimentaryState()
     * @uses Search_CrossSearchServiceResultRecord::setEmail()
     * @uses Search_CrossSearchServiceResultRecord::setExpiry()
     * @uses Search_CrossSearchServiceResultRecord::setHasHistoryState()
     * @uses Search_CrossSearchServiceResultRecord::setHasMembership()
     * @uses Search_CrossSearchServiceResultRecord::setHasUnConfirmedPayments()
     * @uses Search_CrossSearchServiceResultRecord::setId()
     * @uses Search_CrossSearchServiceResultRecord::setItem()
     * @uses Search_CrossSearchServiceResultRecord::setNotes()
     * @uses Search_CrossSearchServiceResultRecord::setPhone()
     * @uses Search_CrossSearchServiceResultRecord::setPrintingState()
     * @uses Search_CrossSearchServiceResultRecord::setQuantity()
     * @uses Search_CrossSearchServiceResultRecord::setReferenceNumber()
     * @uses Search_CrossSearchServiceResultRecord::setReservationState()
     * @uses Search_CrossSearchServiceResultRecord::setReturnItems()
     * @uses Search_CrossSearchServiceResultRecord::setSaleChannel()
     * @uses Search_CrossSearchServiceResultRecord::setSaleCurrent()
     * @uses Search_CrossSearchServiceResultRecord::setSaleOriginal()
     * @uses Search_CrossSearchServiceResultRecord::setSaleReturns()
     * @uses Search_CrossSearchServiceResultRecord::setSGOrderId()
     * @uses Search_CrossSearchServiceResultRecord::setStrikeSaleOriginal()
     * @uses Search_CrossSearchServiceResultRecord::setTotalActualPayment()
     * @uses Search_CrossSearchServiceResultRecord::setTotalTransactionValue()
     * @uses Search_CrossSearchServiceResultRecord::setTransactionDate()
     * @uses Search_CrossSearchServiceResultRecord::setTransactionNumber()
     * @uses Search_CrossSearchServiceResultRecord::setUserName()
     * @uses Search_CrossSearchServiceResultRecord::setWaitingListMode()
     * @param string $clientFullName
     * @param string $clientId
     * @param string $complimentaryState
     * @param string $email
     * @param string $expiry
     * @param string $hasHistoryState
     * @param string $hasMembership
     * @param string $hasUnConfirmedPayments
     * @param string $id
     * @param string $item
     * @param string $notes
     * @param string $phone
     * @param string $printingState
     * @param string $quantity
     * @param int $referenceNumber
     * @param string $reservationState
     * @param string $returnItems
     * @param string $saleChannel
     * @param string $saleCurrent
     * @param string $saleOriginal
     * @param string $saleReturns
     * @param string $sGOrderId
     * @param bool $strikeSaleOriginal
     * @param \patest\StructType\Money $totalActualPayment
     * @param \patest\StructType\Money $totalTransactionValue
     * @param string $transactionDate
     * @param int $transactionNumber
     * @param string $userName
     * @param string $waitingListMode
     */
    public function __construct($clientFullName = null, $clientId = null, $complimentaryState = null, $email = null, $expiry = null, $hasHistoryState = null, $hasMembership = null, $hasUnConfirmedPayments = null, $id = null, $item = null, $notes = null, $phone = null, $printingState = null, $quantity = null, $referenceNumber = null, $reservationState = null, $returnItems = null, $saleChannel = null, $saleCurrent = null, $saleOriginal = null, $saleReturns = null, $sGOrderId = null, $strikeSaleOriginal = null, \patest\StructType\Money $totalActualPayment = null, \patest\StructType\Money $totalTransactionValue = null, $transactionDate = null, $transactionNumber = null, $userName = null, $waitingListMode = null)
    {
        $this
            ->setClientFullName($clientFullName)
            ->setClientId($clientId)
            ->setComplimentaryState($complimentaryState)
            ->setEmail($email)
            ->setExpiry($expiry)
            ->setHasHistoryState($hasHistoryState)
            ->setHasMembership($hasMembership)
            ->setHasUnConfirmedPayments($hasUnConfirmedPayments)
            ->setId($id)
            ->setItem($item)
            ->setNotes($notes)
            ->setPhone($phone)
            ->setPrintingState($printingState)
            ->setQuantity($quantity)
            ->setReferenceNumber($referenceNumber)
            ->setReservationState($reservationState)
            ->setReturnItems($returnItems)
            ->setSaleChannel($saleChannel)
            ->setSaleCurrent($saleCurrent)
            ->setSaleOriginal($saleOriginal)
            ->setSaleReturns($saleReturns)
            ->setSGOrderId($sGOrderId)
            ->setStrikeSaleOriginal($strikeSaleOriginal)
            ->setTotalActualPayment($totalActualPayment)
            ->setTotalTransactionValue($totalTransactionValue)
            ->setTransactionDate($transactionDate)
            ->setTransactionNumber($transactionNumber)
            ->setUserName($userName)
            ->setWaitingListMode($waitingListMode);
    }
    /**
     * Get ClientFullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientFullName()
    {
        return isset($this->ClientFullName) ? $this->ClientFullName : null;
    }
    /**
     * Set ClientFullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientFullName
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setClientFullName($clientFullName = null)
    {
        // validation for constraint: string
        if (!is_null($clientFullName) && !is_string($clientFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientFullName, true), gettype($clientFullName)), __LINE__);
        }
        if (is_null($clientFullName) || (is_array($clientFullName) && empty($clientFullName))) {
            unset($this->ClientFullName);
        } else {
            $this->ClientFullName = $clientFullName;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ComplimentaryState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComplimentaryState()
    {
        return isset($this->ComplimentaryState) ? $this->ComplimentaryState : null;
    }
    /**
     * Set ComplimentaryState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ComplimentaryStatus::valueIsValid()
     * @uses \patest\EnumType\ComplimentaryStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $complimentaryState
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setComplimentaryState($complimentaryState = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ComplimentaryStatus::valueIsValid($complimentaryState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ComplimentaryStatus', is_array($complimentaryState) ? implode(', ', $complimentaryState) : var_export($complimentaryState, true), implode(', ', \patest\EnumType\ComplimentaryStatus::getValidValues())), __LINE__);
        }
        if (is_null($complimentaryState) || (is_array($complimentaryState) && empty($complimentaryState))) {
            unset($this->ComplimentaryState);
        } else {
            $this->ComplimentaryState = $complimentaryState;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Expiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiry()
    {
        return isset($this->Expiry) ? $this->Expiry : null;
    }
    /**
     * Set Expiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiry
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setExpiry($expiry = null)
    {
        // validation for constraint: string
        if (!is_null($expiry) && !is_string($expiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiry, true), gettype($expiry)), __LINE__);
        }
        if (is_null($expiry) || (is_array($expiry) && empty($expiry))) {
            unset($this->Expiry);
        } else {
            $this->Expiry = $expiry;
        }
        return $this;
    }
    /**
     * Get HasHistoryState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHasHistoryState()
    {
        return isset($this->HasHistoryState) ? $this->HasHistoryState : null;
    }
    /**
     * Set HasHistoryState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HasHistoryStatus::valueIsValid()
     * @uses \patest\EnumType\HasHistoryStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hasHistoryState
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setHasHistoryState($hasHistoryState = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HasHistoryStatus::valueIsValid($hasHistoryState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HasHistoryStatus', is_array($hasHistoryState) ? implode(', ', $hasHistoryState) : var_export($hasHistoryState, true), implode(', ', \patest\EnumType\HasHistoryStatus::getValidValues())), __LINE__);
        }
        if (is_null($hasHistoryState) || (is_array($hasHistoryState) && empty($hasHistoryState))) {
            unset($this->HasHistoryState);
        } else {
            $this->HasHistoryState = $hasHistoryState;
        }
        return $this;
    }
    /**
     * Get HasMembership value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHasMembership()
    {
        return isset($this->HasMembership) ? $this->HasMembership : null;
    }
    /**
     * Set HasMembership value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HasMembershipStatus::valueIsValid()
     * @uses \patest\EnumType\HasMembershipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hasMembership
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setHasMembership($hasMembership = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HasMembershipStatus::valueIsValid($hasMembership)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HasMembershipStatus', is_array($hasMembership) ? implode(', ', $hasMembership) : var_export($hasMembership, true), implode(', ', \patest\EnumType\HasMembershipStatus::getValidValues())), __LINE__);
        }
        if (is_null($hasMembership) || (is_array($hasMembership) && empty($hasMembership))) {
            unset($this->HasMembership);
        } else {
            $this->HasMembership = $hasMembership;
        }
        return $this;
    }
    /**
     * Get HasUnConfirmedPayments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHasUnConfirmedPayments()
    {
        return isset($this->HasUnConfirmedPayments) ? $this->HasUnConfirmedPayments : null;
    }
    /**
     * Set HasUnConfirmedPayments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\UnConfirmedPaymentStatus::valueIsValid()
     * @uses \patest\EnumType\UnConfirmedPaymentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hasUnConfirmedPayments
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setHasUnConfirmedPayments($hasUnConfirmedPayments = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\UnConfirmedPaymentStatus::valueIsValid($hasUnConfirmedPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UnConfirmedPaymentStatus', is_array($hasUnConfirmedPayments) ? implode(', ', $hasUnConfirmedPayments) : var_export($hasUnConfirmedPayments, true), implode(', ', \patest\EnumType\UnConfirmedPaymentStatus::getValidValues())), __LINE__);
        }
        if (is_null($hasUnConfirmedPayments) || (is_array($hasUnConfirmedPayments) && empty($hasUnConfirmedPayments))) {
            unset($this->HasUnConfirmedPayments);
        } else {
            $this->HasUnConfirmedPayments = $hasUnConfirmedPayments;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItem()
    {
        return isset($this->Item) ? $this->Item : null;
    }
    /**
     * Set Item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $item
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setItem($item = null)
    {
        // validation for constraint: string
        if (!is_null($item) && !is_string($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item, true), gettype($item)), __LINE__);
        }
        if (is_null($item) || (is_array($item) && empty($item))) {
            unset($this->Item);
        } else {
            $this->Item = $item;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get PrintingState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingState()
    {
        return isset($this->PrintingState) ? $this->PrintingState : null;
    }
    /**
     * Set PrintingState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PrintStatus::valueIsValid()
     * @uses \patest\EnumType\PrintStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printingState
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setPrintingState($printingState = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PrintStatus::valueIsValid($printingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PrintStatus', is_array($printingState) ? implode(', ', $printingState) : var_export($printingState, true), implode(', ', \patest\EnumType\PrintStatus::getValidValues())), __LINE__);
        }
        if (is_null($printingState) || (is_array($printingState) && empty($printingState))) {
            unset($this->PrintingState);
        } else {
            $this->PrintingState = $printingState;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $quantity
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $referenceNumber
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get ReservationState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationState()
    {
        return isset($this->ReservationState) ? $this->ReservationState : null;
    }
    /**
     * Set ReservationState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReservedStatus::valueIsValid()
     * @uses \patest\EnumType\ReservedStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationState
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setReservationState($reservationState = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReservedStatus::valueIsValid($reservationState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReservedStatus', is_array($reservationState) ? implode(', ', $reservationState) : var_export($reservationState, true), implode(', ', \patest\EnumType\ReservedStatus::getValidValues())), __LINE__);
        }
        if (is_null($reservationState) || (is_array($reservationState) && empty($reservationState))) {
            unset($this->ReservationState);
        } else {
            $this->ReservationState = $reservationState;
        }
        return $this;
    }
    /**
     * Get ReturnItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnItems()
    {
        return isset($this->ReturnItems) ? $this->ReturnItems : null;
    }
    /**
     * Set ReturnItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnItems
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setReturnItems($returnItems = null)
    {
        // validation for constraint: string
        if (!is_null($returnItems) && !is_string($returnItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnItems, true), gettype($returnItems)), __LINE__);
        }
        if (is_null($returnItems) || (is_array($returnItems) && empty($returnItems))) {
            unset($this->ReturnItems);
        } else {
            $this->ReturnItems = $returnItems;
        }
        return $this;
    }
    /**
     * Get SaleChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleChannel()
    {
        return isset($this->SaleChannel) ? $this->SaleChannel : null;
    }
    /**
     * Set SaleChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleChannel
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setSaleChannel($saleChannel = null)
    {
        // validation for constraint: string
        if (!is_null($saleChannel) && !is_string($saleChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleChannel, true), gettype($saleChannel)), __LINE__);
        }
        if (is_null($saleChannel) || (is_array($saleChannel) && empty($saleChannel))) {
            unset($this->SaleChannel);
        } else {
            $this->SaleChannel = $saleChannel;
        }
        return $this;
    }
    /**
     * Get SaleCurrent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleCurrent()
    {
        return isset($this->SaleCurrent) ? $this->SaleCurrent : null;
    }
    /**
     * Set SaleCurrent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleCurrent
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setSaleCurrent($saleCurrent = null)
    {
        // validation for constraint: string
        if (!is_null($saleCurrent) && !is_string($saleCurrent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCurrent, true), gettype($saleCurrent)), __LINE__);
        }
        if (is_null($saleCurrent) || (is_array($saleCurrent) && empty($saleCurrent))) {
            unset($this->SaleCurrent);
        } else {
            $this->SaleCurrent = $saleCurrent;
        }
        return $this;
    }
    /**
     * Get SaleOriginal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleOriginal()
    {
        return isset($this->SaleOriginal) ? $this->SaleOriginal : null;
    }
    /**
     * Set SaleOriginal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleOriginal
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setSaleOriginal($saleOriginal = null)
    {
        // validation for constraint: string
        if (!is_null($saleOriginal) && !is_string($saleOriginal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOriginal, true), gettype($saleOriginal)), __LINE__);
        }
        if (is_null($saleOriginal) || (is_array($saleOriginal) && empty($saleOriginal))) {
            unset($this->SaleOriginal);
        } else {
            $this->SaleOriginal = $saleOriginal;
        }
        return $this;
    }
    /**
     * Get SaleReturns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleReturns()
    {
        return isset($this->SaleReturns) ? $this->SaleReturns : null;
    }
    /**
     * Set SaleReturns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleReturns
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setSaleReturns($saleReturns = null)
    {
        // validation for constraint: string
        if (!is_null($saleReturns) && !is_string($saleReturns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleReturns, true), gettype($saleReturns)), __LINE__);
        }
        if (is_null($saleReturns) || (is_array($saleReturns) && empty($saleReturns))) {
            unset($this->SaleReturns);
        } else {
            $this->SaleReturns = $saleReturns;
        }
        return $this;
    }
    /**
     * Get SGOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSGOrderId()
    {
        return isset($this->SGOrderId) ? $this->SGOrderId : null;
    }
    /**
     * Set SGOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sGOrderId
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setSGOrderId($sGOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($sGOrderId) && !is_string($sGOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sGOrderId, true), gettype($sGOrderId)), __LINE__);
        }
        if (is_null($sGOrderId) || (is_array($sGOrderId) && empty($sGOrderId))) {
            unset($this->SGOrderId);
        } else {
            $this->SGOrderId = $sGOrderId;
        }
        return $this;
    }
    /**
     * Get StrikeSaleOriginal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getStrikeSaleOriginal()
    {
        return isset($this->StrikeSaleOriginal) ? $this->StrikeSaleOriginal : null;
    }
    /**
     * Set StrikeSaleOriginal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $strikeSaleOriginal
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setStrikeSaleOriginal($strikeSaleOriginal = null)
    {
        // validation for constraint: boolean
        if (!is_null($strikeSaleOriginal) && !is_bool($strikeSaleOriginal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($strikeSaleOriginal, true), gettype($strikeSaleOriginal)), __LINE__);
        }
        if (is_null($strikeSaleOriginal) || (is_array($strikeSaleOriginal) && empty($strikeSaleOriginal))) {
            unset($this->StrikeSaleOriginal);
        } else {
            $this->StrikeSaleOriginal = $strikeSaleOriginal;
        }
        return $this;
    }
    /**
     * Get TotalActualPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalActualPayment()
    {
        return isset($this->TotalActualPayment) ? $this->TotalActualPayment : null;
    }
    /**
     * Set TotalActualPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalActualPayment
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setTotalActualPayment(\patest\StructType\Money $totalActualPayment = null)
    {
        if (is_null($totalActualPayment) || (is_array($totalActualPayment) && empty($totalActualPayment))) {
            unset($this->TotalActualPayment);
        } else {
            $this->TotalActualPayment = $totalActualPayment;
        }
        return $this;
    }
    /**
     * Get TotalTransactionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTransactionValue()
    {
        return isset($this->TotalTransactionValue) ? $this->TotalTransactionValue : null;
    }
    /**
     * Set TotalTransactionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTransactionValue
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setTotalTransactionValue(\patest\StructType\Money $totalTransactionValue = null)
    {
        if (is_null($totalTransactionValue) || (is_array($totalTransactionValue) && empty($totalTransactionValue))) {
            unset($this->TotalTransactionValue);
        } else {
            $this->TotalTransactionValue = $totalTransactionValue;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get WaitingListMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWaitingListMode()
    {
        return isset($this->WaitingListMode) ? $this->WaitingListMode : null;
    }
    /**
     * Set WaitingListMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WaitingListMode::valueIsValid()
     * @uses \patest\EnumType\WaitingListMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waitingListMode
     * @return \patest\StructType\Search_CrossSearchServiceResultRecord
     */
    public function setWaitingListMode($waitingListMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WaitingListMode::valueIsValid($waitingListMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WaitingListMode', is_array($waitingListMode) ? implode(', ', $waitingListMode) : var_export($waitingListMode, true), implode(', ', \patest\EnumType\WaitingListMode::getValidValues())), __LINE__);
        }
        if (is_null($waitingListMode) || (is_array($waitingListMode) && empty($waitingListMode))) {
            unset($this->WaitingListMode);
        } else {
            $this->WaitingListMode = $waitingListMode;
        }
        return $this;
    }
}
