<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchReservationInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchReservationInfo
 * @subpackage Structs
 */
class SearchReservationInfo extends AbstractStructBase
{
    /**
     * The MinutesFromNow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinutesFromNow;
    /**
     * The ReservationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReservationType;
    /**
     * Constructor method for SearchReservationInfo
     * @uses SearchReservationInfo::setMinutesFromNow()
     * @uses SearchReservationInfo::setReservationType()
     * @param int $minutesFromNow
     * @param string $reservationType
     */
    public function __construct($minutesFromNow = null, $reservationType = null)
    {
        $this
            ->setMinutesFromNow($minutesFromNow)
            ->setReservationType($reservationType);
    }
    /**
     * Get MinutesFromNow value
     * @return int|null
     */
    public function getMinutesFromNow()
    {
        return $this->MinutesFromNow;
    }
    /**
     * Set MinutesFromNow value
     * @param int $minutesFromNow
     * @return \patest\StructType\SearchReservationInfo
     */
    public function setMinutesFromNow($minutesFromNow = null)
    {
        // validation for constraint: int
        if (!is_null($minutesFromNow) && !(is_int($minutesFromNow) || ctype_digit($minutesFromNow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minutesFromNow, true), gettype($minutesFromNow)), __LINE__);
        }
        $this->MinutesFromNow = $minutesFromNow;
        return $this;
    }
    /**
     * Get ReservationType value
     * @return string|null
     */
    public function getReservationType()
    {
        return $this->ReservationType;
    }
    /**
     * Set ReservationType value
     * @uses \patest\EnumType\ReservationSearchType::valueIsValid()
     * @uses \patest\EnumType\ReservationSearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationType
     * @return \patest\StructType\SearchReservationInfo
     */
    public function setReservationType($reservationType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReservationSearchType::valueIsValid($reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReservationSearchType', is_array($reservationType) ? implode(', ', $reservationType) : var_export($reservationType, true), implode(', ', \patest\EnumType\ReservationSearchType::getValidValues())), __LINE__);
        }
        $this->ReservationType = $reservationType;
        return $this;
    }
}
