<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchAccessCodes-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchAccessCodes-Request
 * @subpackage Structs
 */
class SearchAccessCodes_Request extends ExtensibleDataContract
{
    /**
     * The IncludeObsoletes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeObsoletes;
    /**
     * The Keyword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Keyword;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * Constructor method for SearchAccessCodes-Request
     * @uses SearchAccessCodes_Request::setIncludeObsoletes()
     * @uses SearchAccessCodes_Request::setKeyword()
     * @uses SearchAccessCodes_Request::setPresaleId()
     * @param bool $includeObsoletes
     * @param string $keyword
     * @param string $presaleId
     */
    public function __construct($includeObsoletes = null, $keyword = null, $presaleId = null)
    {
        $this
            ->setIncludeObsoletes($includeObsoletes)
            ->setKeyword($keyword)
            ->setPresaleId($presaleId);
    }
    /**
     * Get IncludeObsoletes value
     * @return bool|null
     */
    public function getIncludeObsoletes()
    {
        return $this->IncludeObsoletes;
    }
    /**
     * Set IncludeObsoletes value
     * @param bool $includeObsoletes
     * @return \patest\StructType\SearchAccessCodes_Request
     */
    public function setIncludeObsoletes($includeObsoletes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeObsoletes) && !is_bool($includeObsoletes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeObsoletes, true), gettype($includeObsoletes)), __LINE__);
        }
        $this->IncludeObsoletes = $includeObsoletes;
        return $this;
    }
    /**
     * Get Keyword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeyword()
    {
        return isset($this->Keyword) ? $this->Keyword : null;
    }
    /**
     * Set Keyword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keyword
     * @return \patest\StructType\SearchAccessCodes_Request
     */
    public function setKeyword($keyword = null)
    {
        // validation for constraint: string
        if (!is_null($keyword) && !is_string($keyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyword, true), gettype($keyword)), __LINE__);
        }
        if (is_null($keyword) || (is_array($keyword) && empty($keyword))) {
            unset($this->Keyword);
        } else {
            $this->Keyword = $keyword;
        }
        return $this;
    }
    /**
     * Get PresaleId value
     * @return string|null
     */
    public function getPresaleId()
    {
        return $this->PresaleId;
    }
    /**
     * Set PresaleId value
     * @param string $presaleId
     * @return \patest\StructType\SearchAccessCodes_Request
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        $this->PresaleId = $presaleId;
        return $this;
    }
}
