<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.TransactionByClientOrOwner StructType
 * @subpackage Structs
 */
class Sales_TransactionByClientOrOwner extends AnyEntity
{
    /**
     * The BuyerOrOwner
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BuyerOrOwner;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalId;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductId;
    /**
     * Constructor method for Sales.TransactionByClientOrOwner
     * @uses Sales_TransactionByClientOrOwner::setBuyerOrOwner()
     * @uses Sales_TransactionByClientOrOwner::setHolderCompanyId()
     * @uses Sales_TransactionByClientOrOwner::setLocalId()
     * @uses Sales_TransactionByClientOrOwner::setProductId()
     * @param string $buyerOrOwner
     * @param int $holderCompanyId
     * @param int $localId
     * @param string $productId
     */
    public function __construct($buyerOrOwner = null, $holderCompanyId = null, $localId = null, $productId = null)
    {
        $this
            ->setBuyerOrOwner($buyerOrOwner)
            ->setHolderCompanyId($holderCompanyId)
            ->setLocalId($localId)
            ->setProductId($productId);
    }
    /**
     * Get BuyerOrOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuyerOrOwner()
    {
        return isset($this->BuyerOrOwner) ? $this->BuyerOrOwner : null;
    }
    /**
     * Set BuyerOrOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buyerOrOwner
     * @return \patest\StructType\Sales_TransactionByClientOrOwner
     */
    public function setBuyerOrOwner($buyerOrOwner = null)
    {
        // validation for constraint: string
        if (!is_null($buyerOrOwner) && !is_string($buyerOrOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyerOrOwner, true), gettype($buyerOrOwner)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($buyerOrOwner) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $buyerOrOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($buyerOrOwner, true)), __LINE__);
        }
        if (is_null($buyerOrOwner) || (is_array($buyerOrOwner) && empty($buyerOrOwner))) {
            unset($this->BuyerOrOwner);
        } else {
            $this->BuyerOrOwner = $buyerOrOwner;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Sales_TransactionByClientOrOwner
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalId()
    {
        return isset($this->LocalId) ? $this->LocalId : null;
    }
    /**
     * Set LocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localId
     * @return \patest\StructType\Sales_TransactionByClientOrOwner
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        if (is_null($localId) || (is_array($localId) && empty($localId))) {
            unset($this->LocalId);
        } else {
            $this->LocalId = $localId;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\Sales_TransactionByClientOrOwner
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
}
